/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.adl.datamodels.Element;
import org.adl.util.debug.DebugIndicator;

public class DataModelValidator
implements Serializable {
    private static transient Hashtable vocabulary;

    public DataModelValidator() {
        vocabulary = new Hashtable();
        vocabulary.put("Mode", this.buildModeList());
        vocabulary.put("Status", this.buildStatusList());
        vocabulary.put("Exit", this.buildExitList());
        vocabulary.put("Credit", this.buildCreditList());
        vocabulary.put("Entry", this.buildEntryList());
        vocabulary.put("TimeLimitAction", this.buildTimeLimitActionList());
        vocabulary.put("Interaction", this.buildInteractionList());
        vocabulary.put("Result", this.buildResultList());
    }

    private String[] buildModeList() {
        int n = 3;
        String[] stringArray = new String[n];
        stringArray[0] = "normal";
        stringArray[1] = "review";
        stringArray[2] = "browse";
        return stringArray;
    }

    private String[] buildStatusList() {
        int n = 6;
        String[] stringArray = new String[n];
        stringArray[0] = "passed";
        stringArray[1] = "completed";
        stringArray[2] = "failed";
        stringArray[3] = "incomplete";
        stringArray[4] = "browsed";
        stringArray[5] = "not attempted";
        return stringArray;
    }

    private String[] buildExitList() {
        int n = 4;
        String[] stringArray = new String[n];
        stringArray[0] = "";
        stringArray[1] = "time-out";
        stringArray[2] = "suspend";
        stringArray[3] = "logout";
        return stringArray;
    }

    private String[] buildCreditList() {
        int n = 2;
        String[] stringArray = new String[n];
        stringArray[0] = "credit";
        stringArray[1] = "no-credit";
        return stringArray;
    }

    private String[] buildEntryList() {
        int n = 3;
        String[] stringArray = new String[n];
        stringArray[0] = "";
        stringArray[1] = "ab-initio";
        stringArray[2] = "resume";
        return stringArray;
    }

    private String[] buildTimeLimitActionList() {
        int n = 5;
        String[] stringArray = new String[n];
        stringArray[0] = "";
        stringArray[1] = "exit,message";
        stringArray[2] = "exit,no message";
        stringArray[3] = "continue,message";
        stringArray[4] = "continue,no message";
        return stringArray;
    }

    private String[] buildInteractionList() {
        int n = 8;
        String[] stringArray = new String[n];
        stringArray[0] = "true-false";
        stringArray[1] = "choice";
        stringArray[2] = "fill-in";
        stringArray[3] = "matching";
        stringArray[4] = "performance";
        stringArray[5] = "likert";
        stringArray[6] = "sequencing";
        stringArray[7] = "numeric";
        return stringArray;
    }

    private String[] buildResultList() {
        int n = 4;
        String[] stringArray = new String[n];
        stringArray[0] = "correct";
        stringArray[1] = "wrong";
        stringArray[2] = "unanticipated";
        stringArray[3] = "neutral";
        return stringArray;
    }

    public boolean checkBlank(Element element, String string) {
        boolean bl = false;
        if (string.length() == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean checkBoolean(Element element, String string) {
        boolean bl = false;
        if (string.equals("true") || string.equals("false")) {
            bl = true;
        }
        return bl;
    }

    public boolean checkFeedback(Element element, String string) {
        return true;
    }

    public boolean checkString255(Element element, String string) {
        boolean bl = false;
        if (string.length() <= 255) {
            bl = true;
        }
        return bl;
    }

    public boolean checkString4096(Element element, String string) {
        boolean bl = false;
        if (string.length() <= 4096) {
            bl = true;
        }
        return bl;
    }

    public boolean checkScoreDecimal(Element element, String string) {
        boolean bl;
        block7: {
            bl = false;
            Double d = new Double(0.0);
            Double d2 = new Double(100.0);
            if (!this.checkBlank(element, string)) {
                try {
                    Double d3 = new Double(string);
                    if (d3.compareTo(d) >= 0 && d3.compareTo(d2) <= 0) {
                        bl = true;
                    } else if (DebugIndicator.ON) {
                        System.out.println(string + " is not a normalized score");
                        System.out.println("0 <= " + string + " >= 100");
                    }
                    break block7;
                }
                catch (NumberFormatException numberFormatException) {
                    if (DebugIndicator.ON) {
                        System.out.println(string + " is not a valid CMIDecimal Type");
                    }
                    break block7;
                }
            }
            bl = true;
        }
        return bl;
    }

    public boolean checkDecimal(Element element, String string) {
        boolean bl = false;
        if (!this.checkBlank(element, string)) {
            try {
                Double d = new Double(string);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                if (DebugIndicator.ON) {
                    System.out.println(string + " is not a valid CMIDecimal Type ");
                }
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean checkVocabulary(Element element, String string) {
        boolean bl = false;
        String string2 = element.getVocabularyType();
        String[] stringArray = (String[])vocabulary.get(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (!string3.equals(string)) continue;
            bl = true;
            break;
        }
        if (string2.equals("Result") && !bl) {
            bl = this.checkDecimal(element, string);
        }
        if (!bl && DebugIndicator.ON) {
            System.out.println("[" + string + "] is not a valid vocabulary member ");
            System.out.println("for the " + string2 + " Vocabulary Type");
        }
        return bl;
    }

    public boolean checkIdentifier(Element element, String string) {
        boolean bl = false;
        if (string.length() <= 255 && string.indexOf(32) == -1 && !this.checkBlank(element, string)) {
            bl = true;
        }
        return bl;
    }

    public boolean checkInteger(Element element, String string) {
        boolean bl;
        block3: {
            bl = false;
            try {
                Integer n = new Integer(string);
                int n2 = n;
                if (n2 >= 0 && n2 <= 65536) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!DebugIndicator.ON) break block3;
                System.out.println(string + "  has invalid format for an Integer");
            }
        }
        return bl;
    }

    public boolean checkSInteger(Element element, String string) {
        boolean bl;
        block3: {
            bl = false;
            try {
                Integer n = new Integer(string);
                int n2 = n;
                if (n2 >= Short.MIN_VALUE && n2 <= 32768) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!DebugIndicator.ON) break block3;
                System.out.println(string + " has invalid format for a Signed Integer");
            }
        }
        return bl;
    }

    public boolean checkTime(Element element, String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        if (stringTokenizer.countTokens() == 3) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            if (string2.length() == 2 && string3.length() == 2 && string4.length() <= 5) {
                try {
                    Integer n = new Integer(string2);
                    Integer n2 = new Integer(string3);
                    if (n >= 0 && n <= 24 && n2 >= 0 && n2 <= 60) {
                        bl = true;
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ".", false);
                        int n3 = stringTokenizer2.countTokens();
                        String string5 = stringTokenizer2.nextToken();
                        if (DebugIndicator.ON) {
                            System.out.println("secondsPart: " + string5);
                        }
                        if (string5.length() == 2) {
                            Double d = new Double(string5);
                            bl = true;
                            if (DebugIndicator.ON) {
                                System.out.println("seconds part had 2 chars and a valid decimal");
                            }
                        } else {
                            bl = false;
                            if (DebugIndicator.ON) {
                                System.out.println("Seconds Part did not have 2 chars");
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (DebugIndicator.ON) {
                        System.out.println("Value could not be converted to a time");
                    }
                    bl = false;
                }
            }
        }
        if (!bl && DebugIndicator.ON) {
            System.out.println("Value being used for setting: " + string + " is not in Valid Time Format (HH:MM:SS.SS)");
        }
        return bl;
    }

    public boolean checkTimespan(Element element, String string) {
        boolean bl;
        block15: {
            bl = false;
            if (!this.checkBlank(element, string)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
                if (stringTokenizer.countTokens() == 3) {
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    if (string2.length() >= 2 && string2.length() <= 4 && string3.length() == 2 && string4.length() <= 5) {
                        try {
                            Object object;
                            Integer n = new Integer(string2);
                            Integer n2 = new Integer(string3);
                            if (n >= 0 && n <= 9999 && n2 >= 0 && n2 <= 99) {
                                bl = true;
                            }
                            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ".", false);
                            int n3 = stringTokenizer2.countTokens();
                            String string5 = stringTokenizer2.nextToken();
                            if (DebugIndicator.ON) {
                                System.out.println("secondsPart: " + string5);
                            }
                            if (string5.length() == 2) {
                                object = new Double(string5);
                                bl = true;
                                if (DebugIndicator.ON) {
                                    System.out.println("seconds part had 2 chars and a valid decimal");
                                }
                            } else {
                                bl = false;
                                if (DebugIndicator.ON) {
                                    System.out.println("Seconds Part did not have 2 chars");
                                }
                            }
                            if (n3 != 2 || !bl) break block15;
                            object = stringTokenizer2.nextToken();
                            if (((String)object).length() <= 2) {
                                Double d = new Double((String)object);
                                bl = true;
                                break block15;
                            }
                            bl = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (DebugIndicator.ON) {
                                System.out.println("Value could not be converted to a time");
                            }
                            bl = false;
                        }
                    }
                }
            } else {
                bl = true;
            }
        }
        if (!bl && DebugIndicator.ON) {
            System.out.println("Value being used for setting: " + string + " is not in Valid Time Format (HHHH:MM:SS.SS)");
        }
        return bl;
    }
}

