/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels;

import java.io.Serializable;
import org.adl.util.debug.DebugIndicator;

public class Element
implements Serializable {
    private String value;
    private String type;
    private boolean writeable;
    private boolean implemented;
    private boolean initialized;
    private boolean readable;
    private boolean mandatory;
    private String vocabularyType;

    public Element(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        this.value = string;
        this.type = string2;
        this.vocabularyType = string3;
        this.writeable = bl;
        this.readable = bl2;
        this.initialized = !string.equalsIgnoreCase("");
        this.mandatory = bl3;
        this.implemented = true;
    }

    public Element() {
        this.value = new String("");
        this.type = new String("");
        this.vocabularyType = new String("");
        this.writeable = false;
        this.readable = false;
        this.initialized = false;
        this.implemented = false;
        this.mandatory = false;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public boolean isImplemented() {
        return this.implemented;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public String getVocabularyType() {
        return this.vocabularyType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
        this.initialized = true;
    }

    public String getType() {
        return this.type;
    }

    protected void setElement(Element element) {
        this.type = element.getType();
        this.value = element.getValue();
        this.vocabularyType = element.getVocabularyType();
        this.implemented = element.isImplemented();
        this.initialized = element.isInitialized();
        this.mandatory = element.isMandatory();
        this.readable = element.isReadable();
        this.writeable = element.isWriteable();
    }

    public void showElement() {
        if (DebugIndicator.ON) {
            System.out.println("     Value         " + this.getValue());
            System.out.println("     Type          " + this.getType());
            System.out.println("     Vocab Type    " + this.getVocabularyType());
            System.out.println("     Writeable     " + this.isWriteable());
            System.out.println("     Readable      " + this.isReadable());
            System.out.println("     Mandatory     " + this.isMandatory());
            System.out.println("     Implemented   " + this.isImplemented());
            System.out.println("     Intialized    " + this.isInitialized());
        }
    }
}

