/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.adl.datamodels.cmi.CMIComments;
import org.adl.datamodels.cmi.CMICommentsFromLms;
import org.adl.datamodels.cmi.CMICore;
import org.adl.datamodels.cmi.CMIInteractions;
import org.adl.datamodels.cmi.CMILaunchData;
import org.adl.datamodels.cmi.CMIObjectives;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.CMIStudentData;
import org.adl.datamodels.cmi.CMIStudentPreference;
import org.adl.datamodels.cmi.CMISuspendData;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class SCODataManager
implements Serializable {
    public CMICore core = new CMICore();
    public CMISuspendData suspend_data = new CMISuspendData();
    public CMILaunchData launch_data = new CMILaunchData();
    public CMIComments comments = new CMIComments();
    public CMICommentsFromLms comments_from_lms = new CMICommentsFromLms();
    public CMIObjectives objectives = new CMIObjectives();
    public CMIInteractions interactions = new CMIInteractions();
    public CMIStudentData student_data = new CMIStudentData();
    public CMIStudentPreference student_preference = new CMIStudentPreference();
    private String workingBaseCategory;
    private static final String CMI_VERSION = "3.4";
    private static final String DM_CLASSNAME = "org.adl.datamodels.cmi.CMI";

    public CMICore getCore() {
        return this.core;
    }

    public CMISuspendData getSuspendData() {
        return this.suspend_data;
    }

    public CMILaunchData getLaunchData() {
        return this.launch_data;
    }

    public CMIComments getComments() {
        return this.comments;
    }

    public CMICommentsFromLms getCommentsFromLMS() {
        return this.comments_from_lms;
    }

    public CMIObjectives getObjectives() {
        return this.objectives;
    }

    public CMIInteractions getInteractions() {
        return this.interactions;
    }

    public CMIStudentData getStudentData() {
        return this.student_data;
    }

    public CMIStudentPreference getStudentPreference() {
        return this.student_preference;
    }

    public void setCore(CMICore cMICore) {
        this.core = cMICore;
    }

    public void setSuspendData(CMISuspendData cMISuspendData) {
        this.suspend_data = cMISuspendData;
    }

    public void setLaunchData(CMILaunchData cMILaunchData) {
        this.launch_data = cMILaunchData;
    }

    public void setComments(CMIComments cMIComments) {
        this.comments = cMIComments;
    }

    public void setCommentsFromLMS(CMICommentsFromLms cMICommentsFromLms) {
        this.comments_from_lms = cMICommentsFromLms;
    }

    public void setObjectives(CMIObjectives cMIObjectives) {
        this.objectives = cMIObjectives;
    }

    public void setInteractions(CMIInteractions cMIInteractions) {
        this.interactions = cMIInteractions;
    }

    public void setStudentData(CMIStudentData cMIStudentData) {
        this.student_data = cMIStudentData;
    }

    public void setStudentPreference(CMIStudentPreference cMIStudentPreference) {
        this.student_preference = cMIStudentPreference;
    }

    public String getValue(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        if (DebugIndicator.ON) {
            System.out.println("In SCODataManager::getValue");
        }
        this.workingBaseCategory = cMIRequest.getBaseCategory();
        String string = new String("");
        string = this.workingBaseCategory.equals("_version") ? CMI_VERSION : this.processRequest(cMIRequest, dMErrorManager);
        return string;
    }

    public void setValue(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        if (DebugIndicator.ON) {
            System.out.println("In SCODataManager::setValue");
        }
        this.workingBaseCategory = cMIRequest.getBaseCategory();
        String string = this.processRequest(cMIRequest, dMErrorManager);
    }

    private String processRequest(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        String string = new String("");
        String string2 = this.convertString(this.workingBaseCategory);
        String string3 = DM_CLASSNAME + string2;
        if (DebugIndicator.ON) {
            System.out.println("Class Name: " + string3);
            System.out.println("Working Base Cat: " + this.workingBaseCategory);
        }
        try {
            Class<?> clazz = Class.forName(string3);
            try {
                Field field = this.getClass().getField(this.workingBaseCategory);
                Class[] classArray = new Class[]{cMIRequest.getClass(), dMErrorManager.getClass()};
                Object[] objectArray = new Object[]{cMIRequest, dMErrorManager};
                try {
                    if (cMIRequest.isForASetRequest()) {
                        Method method = clazz.getMethod("performSet", classArray);
                        method.invoke(field.get(this), objectArray);
                    } else {
                        Method method = clazz.getMethod("performGet", classArray);
                        string = (String)method.invoke(field.get(this), objectArray);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.out.println(noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.out.println(invocationTargetException);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (DebugIndicator.ON) {
                    System.out.println(noSuchFieldException);
                    System.out.println("Error - Data Model Element not Implemented");
                }
                dMErrorManager.recNotImplementedError(cMIRequest);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (DebugIndicator.ON) {
                System.out.println(classNotFoundException);
                System.out.println("Error - Data Model Element not implemented");
            }
            dMErrorManager.recNotImplementedError(cMIRequest);
        }
        return string;
    }

    private String convertString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_", false);
        int n = stringTokenizer.countTokens();
        String string2 = new String("");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2.concat(this.fixWord(stringTokenizer.nextToken()));
        }
        return string2;
    }

    private String fixWord(String string) {
        String string2 = new String("");
        String string3 = string.substring(0, 1);
        String string4 = string.substring(1);
        String string5 = string3.toUpperCase();
        string2 = string5.concat(string4);
        return string2;
    }
}

