/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.CMIScore;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMICore
extends CMICategory
implements Serializable {
    public Element credit;
    public Element entry;
    public Element exit;
    public Element lesson_location;
    public Element lesson_mode;
    public Element lesson_status;
    public CMIScore score;
    public Element session_time;
    public Element student_id = new Element("", "checkIdentifier", "NULL", false, true, true);
    public Element student_name = new Element("", "checkString255", "NULL", false, true, true);
    public Element total_time;
    static int CMICORE_MIN_NUM_TOKENS = 3;

    public CMICore() {
        super(true);
        this.lesson_location = new Element("", "checkString255", "NULL", true, true, true);
        this.credit = new Element("", "checkVocabulary", "Credit", false, true, true);
        this.lesson_status = new Element("", "checkVocabulary", "Status", true, true, true);
        this.entry = new Element("", "checkVocabulary", "Entry", false, true, true);
        this.total_time = new Element("", "checkTimespan", "NULL", false, true, true);
        this.lesson_mode = new Element("", "checkVocabulary", "Mode", false, true, true);
        this.exit = new Element("", "checkVocabulary", "Exit", true, false, true);
        this.session_time = new Element("", "checkTimespan", "NULL", true, false, true);
        this.score = new CMIScore();
    }

    public Element getCredit() {
        return this.credit;
    }

    public Element getEntry() {
        return this.entry;
    }

    public Element getExit() {
        return this.exit;
    }

    public Element getLessonLocation() {
        return this.lesson_location;
    }

    public Element getLessonMode() {
        return this.lesson_mode;
    }

    public Element getLessonStatus() {
        return this.lesson_status;
    }

    public CMIScore getScore() {
        return this.score;
    }

    public Element getSessionTime() {
        return this.session_time;
    }

    public Element getStudentId() {
        return this.student_id;
    }

    public Element getStudentName() {
        return this.student_name;
    }

    public Element getTotalTime() {
        return this.total_time;
    }

    public void setCredit(String string) {
        this.credit.setValue(string);
    }

    public void setEntry(String string) {
        this.entry.setValue(string);
    }

    public void setExit(String string) {
        this.exit.setValue(string);
    }

    public void setLessonLocation(String string) {
        this.lesson_location.setValue(string);
    }

    public void setLessonMode(String string) {
        this.lesson_mode.setValue(string);
    }

    public void setLessonStatus(String string) {
        this.lesson_status.setValue(string);
    }

    public void setScore(CMIScore cMIScore) {
        this.score.getRaw().setValue(cMIScore.getRaw().getValue());
        this.score.getMin().setValue(cMIScore.getMin().getValue());
        this.score.getMax().setValue(cMIScore.getMax().getValue());
    }

    public void setSessionTime(String string) {
        this.session_time.setValue(string);
    }

    public void setStudentId(String string) {
        this.student_id.setValue(string);
    }

    public void setStudentName(String string) {
        this.student_name.setValue(string);
    }

    public void setTotalTime(String string) {
        this.total_time.setValue(string);
    }

    public String performGet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        String string = new String("");
        if (this.isValidCoreRequest(cMIRequest)) {
            String string2 = cMIRequest.getNextToken();
            string = cMIRequest.hasMoreTokensToProcess() ? this.processSubcategory(cMIRequest, string2, dMErrorManager) : (cMIRequest.isAChildrenRequest() ? this.getChildren() : this.determineElementValue(this, string2, dMErrorManager));
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Request being processed: " + cMIRequest.getRequest() + "\nis not a valid request for the CMI Core\n" + "Data Model Category");
            }
            dMErrorManager.recNotImplementedError(cMIRequest);
        }
        cMIRequest.done();
        return string;
    }

    public String getChildren() {
        String string = "student_id,student_name,lesson_location,credit,lesson_status,entry,score,total_time,lesson_mode,exit,session_time";
        return string;
    }

    public void performSet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        if (this.isValidCoreRequest(cMIRequest)) {
            String string = cMIRequest.getNextToken();
            if (cMIRequest.hasMoreTokensToProcess()) {
                String string2 = this.processSubcategory(cMIRequest, string, dMErrorManager);
            } else {
                String string3 = cMIRequest.getValue();
                if (cMIRequest.isAKeywordRequest()) {
                    dMErrorManager.recKeyWordError(string);
                } else if (string.equals("lesson_status")) {
                    if (string3.equals("not attempted")) {
                        dMErrorManager.SetCurrentErrorCode("405");
                    } else {
                        this.doSet(this, string, string3, dMErrorManager);
                    }
                } else {
                    this.doSet(this, string, string3, dMErrorManager);
                }
            }
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Request being processed: " + cMIRequest.getRequest() + "\nis not a valid request for the CMI Core\n" + "Data Model Category");
            }
            dMErrorManager.recNotImplementedError(cMIRequest);
        }
        cMIRequest.done();
    }

    private String processSubcategory(CMIRequest cMIRequest, String string, DMErrorManager dMErrorManager) {
        String string2 = new String("");
        try {
            Field field = this.getClass().getField(string);
            if (cMIRequest.isForASetRequest()) {
                if (cMIRequest.isAKeywordRequest()) {
                    dMErrorManager.recKeyWordError(cMIRequest.getElement());
                } else {
                    this.score.performSet(cMIRequest, dMErrorManager);
                }
            } else if (string.equals("score")) {
                string2 = this.score.performGet(cMIRequest, dMErrorManager);
            } else {
                dMErrorManager.recGetKeyWordError(cMIRequest.getElement());
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Element being processed: " + string + "is not a valid sub category of the CMI Core\n" + "Data Model Category");
            }
            dMErrorManager.SetCurrentErrorCode("401");
        }
        catch (SecurityException securityException) {
            if (DebugIndicator.ON) {
                System.out.println(securityException);
                System.out.println("Access to the information is denied");
            }
            dMErrorManager.SetCurrentErrorCode("101");
        }
        return string2;
    }

    private boolean isValidCoreRequest(CMIRequest cMIRequest) {
        boolean bl = false;
        if (cMIRequest.getTotalNumTokens() >= CMICORE_MIN_NUM_TOKENS) {
            bl = true;
        }
        return bl;
    }

    public void showData() {
        if (DebugIndicator.ON) {
            System.out.println("CMI Core Object:");
            System.out.println("\tstudent_id: " + this.getStudentId().getValue());
            System.out.println("\tstudent_name: " + this.getStudentName().getValue());
            System.out.println("\tlesson_location: " + this.getLessonLocation().getValue());
            System.out.println("\tcredit: " + this.getCredit().getValue());
            System.out.println("\tslesson_status: " + this.getLessonStatus().getValue());
            System.out.println("\tentry: " + this.getEntry().getValue());
            System.out.println("\texit: " + this.getExit().getValue());
            System.out.println("\tscore.raw: " + this.getScore().getRaw().getValue());
            System.out.println("\tscore.min: " + this.getScore().getMin().getValue());
            System.out.println("\tscore.max: " + this.getScore().getMax().getValue());
            System.out.println("\tsession_time: " + this.getSessionTime().getValue());
            System.out.println("\ttotal_time: " + this.getTotalTime().getValue());
            System.out.println("\tlesson_mode: " + this.getLessonMode().getValue());
        }
    }
}

