/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import java.util.Vector;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.CMIResponse;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMIInteractionData
extends CMICategory
implements Serializable {
    public Element id = new Element("", "checkIdentifier", "NULL", true, false, false);
    public Vector objectives;
    public Element time = new Element("", "checkTime", "NULL", true, false, false);
    public Element type = new Element("", "checkVocabulary", "Interaction", true, false, false);
    public Vector correct_responses;
    public Element weighting = new Element("", "checkDecimal", "NULL", true, false, false);
    public Element student_response = new Element("", "checkFeedback", "NULL", true, false, false);
    public Element result = new Element("", "checkVocabulary", "Result", true, false, false);
    public Element latency = new Element("", "checkTimespan", "NULL", true, false, false);
    private boolean initialized = false;

    public CMIInteractionData() {
        super(true);
        this.correct_responses = new Vector();
        this.objectives = new Vector();
    }

    public Element getID() {
        return this.id;
    }

    public Element getLatency() {
        return this.latency;
    }

    public Element getResult() {
        return this.result;
    }

    public Element getStudentResponse() {
        return this.student_response;
    }

    public Element getTime() {
        return this.time;
    }

    public Element getType() {
        return this.type;
    }

    public Element getWeighting() {
        return this.weighting;
    }

    public Vector getObjID() {
        return this.objectives;
    }

    public Vector getCorrectResponses() {
        return this.correct_responses;
    }

    public void setID(String string) {
        this.id.setValue(string);
        this.initialized = true;
    }

    public void setLatency(String string) {
        this.latency.setValue(string);
        this.initialized = true;
    }

    public void setResult(String string) {
        this.result.setValue(string);
        this.initialized = true;
    }

    public void setStudentResponse(String string) {
        this.student_response.setValue(string);
        this.initialized = true;
    }

    public void setTime(String string) {
        this.time.setValue(string);
        this.initialized = true;
    }

    public void setType(String string) {
        this.type.setValue(string);
        this.initialized = true;
    }

    public void setWeighting(String string) {
        this.weighting.setValue(string);
        this.initialized = true;
    }

    public void setObjID(String string, int n) {
        this.objectives.add(n, string);
    }

    public void setCorrectResponses(CMIResponse cMIResponse, int n) {
        this.correct_responses.add(n, cMIResponse);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void performSet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        if (DebugIndicator.ON) {
            System.out.println("\t\tInteractionData::performSet()");
        }
        String string = cMIRequest.getNextToken();
        if (DebugIndicator.ON) {
            System.out.println("\t\tProcessing next token: " + string);
        }
        if (cMIRequest.hasMoreTokensToProcess()) {
            if (string.equals("objectives")) {
                string = cMIRequest.getNextToken();
                if (DebugIndicator.ON) {
                    System.out.println("\t\tProcessing next token " + string);
                }
                this.performSetForObjID(string, cMIRequest, dMErrorManager);
            } else if (string.equals("correct_responses")) {
                string = cMIRequest.getNextToken();
                if (DebugIndicator.ON) {
                    System.out.println("\t\tProcessing next token " + string);
                }
                this.performSetForResponse(string, cMIRequest, dMErrorManager);
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("\t\tError - Data Model Element not implemented");
                    System.out.println("\t\tElement being processed: " + string + " is not a valid element of the CMI Interactions\n" + "Data Model Category");
                }
                dMErrorManager.recNotImplementedError(cMIRequest);
            }
        } else if (cMIRequest.isAKeywordRequest()) {
            dMErrorManager.recKeyWordError(cMIRequest.getElement());
        } else {
            if (DebugIndicator.ON) {
                System.out.println("\t\tPerforming set");
            }
            this.doSet(this, string, cMIRequest.getValue(), dMErrorManager);
            this.initialized = true;
        }
        if (DebugIndicator.ON) {
            System.out.println("\t\tExiting CMIInteractionData::peformSet()");
        }
    }

    private void performSetForObjID(String string, CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        if (DebugIndicator.ON) {
            System.out.println("\t\tCMIInteractionData::performSetForObjID()");
        }
        int n = this.getArrayIndex(string, cMIRequest, dMErrorManager);
        String string2 = cMIRequest.getValue();
        try {
            boolean bl;
            if (DebugIndicator.ON) {
                System.out.println("\t\tChecking to see if an element already exists");
                System.out.println("\t\tat array position " + n);
            }
            Element element = (Element)this.objectives.elementAt(n);
            if (DebugIndicator.ON) {
                System.out.println("\t\tElement already exists");
                System.out.println("\t\tVector size: " + this.objectives.size());
            }
            if (bl = this.validateType(this, element, "id", string2, dMErrorManager)) {
                element.setValue(string2);
                this.objectives.set(n, element);
                if (DebugIndicator.ON) {
                    System.out.println("\t\tVector size: " + this.objectives.size());
                }
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("***** INVALID LMSSetValue() CALL *****");
                    System.out.println("          Invalid Type                ");
                    System.out.println("Element was NOT set!");
                    System.out.println("");
                    System.out.println("\t\tVector size: " + this.objectives.size());
                }
                dMErrorManager.SetCurrentErrorCode("405");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (DebugIndicator.ON) {
                System.out.println("\t\tElement does not already exists");
            }
            if (n <= this.objectives.size()) {
                Element element = new Element(cMIRequest.getValue(), "checkIdentifier", "NULL", true, false, false);
                boolean bl = this.validateType(this, element, "id", cMIRequest.getValue(), dMErrorManager);
                if (bl) {
                    this.objectives.add(n, element);
                    if (DebugIndicator.ON) {
                        System.out.println("\t\tVector size: " + this.objectives.size());
                    }
                } else {
                    if (DebugIndicator.ON) {
                        System.out.println("***** INVALID LMSSetValue() CALL *****");
                        System.out.println("          Invalid Type                ");
                        System.out.println("Element was NOT set!");
                        System.out.println("");
                        System.out.println("\t\tVector size: " + this.objectives.size());
                    }
                    dMErrorManager.SetCurrentErrorCode("405");
                }
            }
            dMErrorManager.SetCurrentErrorCode("201");
        }
        if (DebugIndicator.ON) {
            System.out.println("\t\tExiting performSetForObjID()");
        }
    }

    private void performSetForResponse(String string, CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        if (DebugIndicator.ON) {
            System.out.println("\t\tCMIInteractionData::performSetForResponses()");
        }
        int n = this.getArrayIndex(string, cMIRequest, dMErrorManager);
        String string2 = cMIRequest.getValue();
        try {
            if (DebugIndicator.ON) {
                System.out.println("\t\tChecking to see if an element already exists");
                System.out.println("\t\tat array position " + n);
            }
            CMIResponse cMIResponse = (CMIResponse)this.correct_responses.elementAt(n);
            if (DebugIndicator.ON) {
                System.out.println("\t\tElement already exists");
                System.out.println("\t\tSet the value in the element and replace");
                System.out.println("\t\tVector size: " + this.correct_responses.size());
            }
            cMIResponse.performSet(cMIRequest, dMErrorManager);
            this.correct_responses.set(n, cMIResponse);
            if (DebugIndicator.ON) {
                System.out.println("\t\tVector size: " + this.correct_responses.size());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (DebugIndicator.ON) {
                System.out.println("\t\tElement does not already exists");
                System.out.println("\t\tVector size: " + this.correct_responses.size());
            }
            if (n <= this.correct_responses.size()) {
                CMIResponse cMIResponse = new CMIResponse();
                cMIResponse.performSet(cMIRequest, dMErrorManager);
                this.correct_responses.add(n, cMIResponse);
                if (DebugIndicator.ON) {
                    System.out.println("\t\tVector size: " + this.correct_responses.size());
                }
            }
            dMErrorManager.SetCurrentErrorCode("201");
        }
        if (DebugIndicator.ON) {
            System.out.println("\t\tExiting performSetForResponses()");
        }
    }

    private int getArrayIndex(String string, CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        int n = -1;
        try {
            Integer n2 = new Integer(string);
            n = n2;
        }
        catch (NumberFormatException numberFormatException) {
            if (DebugIndicator.ON) {
                System.out.println("\t\tError - Data Model Element not implemented");
                System.out.println("\t\tInvalid data model element: " + cMIRequest.getRequest());
                System.out.println("\t\tInvalid element " + string + ", Array index expected");
            }
            dMErrorManager.SetCurrentErrorCode("401");
        }
        return n;
    }

    public String getCount(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        if (DebugIndicator.ON) {
            System.out.println("\t\tCMIInteractionData::getCount()");
        }
        String string = new String("");
        String string2 = cMIRequest.getNextToken();
        if (DebugIndicator.ON) {
            System.out.println("\t\tProcessing next token: " + string2);
        }
        if (string2.equals("objectives")) {
            if (DebugIndicator.ON) {
                System.out.println("\t\tProcessing objectives._count");
            }
            int n = 0;
            n = this.objectives.size();
            if (DebugIndicator.ON) {
                System.out.println("\t\tNumber of objective ids: " + n);
            }
            Integer n2 = new Integer(n);
            string = n2.toString();
        } else if (string2.equals("correct_responses")) {
            if (DebugIndicator.ON) {
                System.out.println("\t\tInteractionData:correct_responses._count");
            }
            int n = 0;
            n = this.correct_responses.size();
            if (DebugIndicator.ON) {
                System.out.println("\t\tNumber of correct_responses: " + n);
            }
            Integer n3 = new Integer(n);
            string = n3.toString();
        } else {
            if (DebugIndicator.ON) {
                System.out.println("\t\tInvalid LMSGetValue() request: " + cMIRequest.getRequest());
                System.out.println("\t\tSCO is not permitted to call LMSGetValue() for cmi.interactions");
            }
            dMErrorManager.SetCurrentErrorCode("404");
        }
        if (DebugIndicator.ON) {
            System.out.println("\t\tReturning from getCount() count returning: " + string);
        }
        return string;
    }
}

