/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import java.util.Vector;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIInteractionData;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMIInteractions
extends CMICategory
implements Serializable {
    public Vector interactions = new Vector();

    public CMIInteractions() {
        super(false);
    }

    public Vector getInteractions() {
        return this.interactions;
    }

    public void setInteractions(CMIInteractionData cMIInteractionData, int n) {
        this.interactions.add(n, cMIInteractionData);
    }

    public String getChildren() {
        String string = "id,objectives,time,type,correct_responses,weighting,student_response,result,latency";
        return string;
    }

    public void performSet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        if (DebugIndicator.ON) {
            System.out.println("\tIn CMIInteractions::performSet()");
        }
        String string = cMIRequest.getNextToken();
        if (DebugIndicator.ON) {
            System.out.println("\tToken being processed: " + string);
        }
        if (cMIRequest.isAKeywordRequest()) {
            dMErrorManager.recKeyWordError(string);
        } else {
            int n = -1;
            try {
                Integer n2 = new Integer(string);
                n = n2;
                CMIInteractionData cMIInteractionData = (CMIInteractionData)this.interactions.elementAt(n);
                cMIInteractionData.performSet(cMIRequest, dMErrorManager);
                this.interactions.set(n, cMIInteractionData);
            }
            catch (NumberFormatException numberFormatException) {
                if (DebugIndicator.ON) {
                    System.out.println("\tError - Data Model Element not implemented");
                    System.out.println("\tInvalid data model element: " + cMIRequest.getRequest() + " passed to LMSSetValue()");
                }
                dMErrorManager.recNotImplementedError(cMIRequest);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (DebugIndicator.ON) {
                    System.out.println("\tFirst time setting the interaction data at the given index");
                }
                if (n <= this.interactions.size()) {
                    CMIInteractionData cMIInteractionData = new CMIInteractionData();
                    cMIInteractionData.performSet(cMIRequest, dMErrorManager);
                    this.interactions.add(n, cMIInteractionData);
                }
                dMErrorManager.SetCurrentErrorCode("201");
            }
        }
        cMIRequest.done();
        if (DebugIndicator.ON) {
            System.out.println("\tCMIInteractions - performSet() exit");
        }
    }

    public String performGet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        String string;
        block19: {
            string = new String("");
            int n = cMIRequest.getTotalNumTokens();
            if (DebugIndicator.ON) {
                System.out.println("\tCMIInteractions::performGet()");
            }
            if (n == 3 && cMIRequest.isAChildrenRequest()) {
                if (DebugIndicator.ON) {
                    System.out.println("\tProcessing a _children request");
                }
                string = this.getChildren();
            } else if (cMIRequest.isACountRequest()) {
                if (DebugIndicator.ON) {
                    System.out.println("\tProcessing a _count request");
                }
                if (n == 3) {
                    int n2 = this.howManyInteractions();
                    Integer n3 = new Integer(n2);
                    string = n3.toString();
                } else {
                    String string2 = cMIRequest.getNextToken();
                    if (DebugIndicator.ON) {
                        System.out.println("\tProcessing next token: " + string2);
                    }
                    try {
                        Integer n4 = new Integer(string2);
                        int n5 = n4;
                        CMIInteractionData cMIInteractionData = (CMIInteractionData)this.interactions.elementAt(n5);
                        if (cMIInteractionData.isInitialized()) {
                            string = cMIInteractionData.getCount(cMIRequest, dMErrorManager);
                            break block19;
                        }
                        String string3 = cMIRequest.getNextToken();
                        if (string3.equals("objectives") || string3.equals("correct_responses")) {
                            string = "0";
                            break block19;
                        }
                        dMErrorManager.recGetKeyWordError(cMIRequest.getElement());
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (DebugIndicator.ON) {
                            System.out.println("\tError - Invalid LMSGetValue() request");
                        }
                        dMErrorManager.recNotImplementedError(cMIRequest);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        String string4 = cMIRequest.getNextToken();
                        if (n == 5 && (string4.equals("objectives") || string4.equals("correct_responses"))) {
                            string = "0";
                            break block19;
                        }
                        dMErrorManager.recGetKeyWordError(cMIRequest.getElement());
                        string = "";
                    }
                }
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("\tInvalid LMSGetValue() request: " + cMIRequest.getRequest());
                    System.out.println("\tSCO is not permitted to call LMSGetValue() for cmi.interactions");
                }
                dMErrorManager.SetCurrentErrorCode("404");
            }
        }
        if (DebugIndicator.ON) {
            System.out.println("\tReturning: " + string + " from CMIInteractions");
            System.out.println("\tCMIInteractions::performGet() exit");
        }
        cMIRequest.done();
        return string;
    }

    private int howManyInteractions() {
        int n = 0;
        n = this.interactions.size();
        return n;
    }
}

