/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.CMIScore;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMIObjectiveData
extends CMICategory
implements Serializable {
    public Element id = new Element("", "checkIdentifier", "NULL", true, true, false);
    public CMIScore score = new CMIScore();
    public Element status = new Element("", "checkVocabulary", "Status", true, true, false);
    private boolean initialized;
    static int CMIOBJECTIVEDATA_MIN_NUM_TOKENS = 3;

    public CMIObjectiveData() {
        super(true);
    }

    public Element getStatus() {
        return this.status;
    }

    public CMIScore getScore() {
        return this.score;
    }

    public Element getId() {
        return this.id;
    }

    public void setStatus(String string) {
        this.status.setValue(string);
    }

    public void setScore(CMIScore cMIScore) {
        this.score.getRaw().setValue(cMIScore.getRaw().getValue());
        this.score.getMin().setValue(cMIScore.getMin().getValue());
        this.score.getMax().setValue(cMIScore.getMax().getValue());
    }

    public void setId(String string) {
        this.id.setValue(string);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String performGet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        if (DebugIndicator.ON) {
            System.out.println("CMIObjectiveData::performGet()");
        }
        String string = new String("");
        if (this.isValidObjectiveDataRequest(cMIRequest)) {
            String string2 = cMIRequest.getNextToken();
            if (DebugIndicator.ON) {
                System.out.println("Token: " + string2);
            }
            string = cMIRequest.hasMoreTokensToProcess() ? this.processSubcategory(cMIRequest, string2, dMErrorManager) : (cMIRequest.isAChildrenRequest() ? this.getChildren() : this.determineElementValue(this, string2, dMErrorManager));
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Request being processed: " + cMIRequest.getRequest() + "\nis not a valid request for the CMI Objective\n" + "Data Model Category");
            }
            dMErrorManager.recNotImplementedError(cMIRequest);
        }
        cMIRequest.done();
        return string;
    }

    public String getChildren() {
        String string = "id,status,score";
        return string;
    }

    public void performSet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        if (this.isValidObjectiveDataRequest(cMIRequest)) {
            String string = cMIRequest.getNextToken();
            if (cMIRequest.hasMoreTokensToProcess()) {
                String string2 = this.processSubcategory(cMIRequest, string, dMErrorManager);
            } else {
                String string3 = cMIRequest.getValue();
                if (cMIRequest.isAKeywordRequest()) {
                    dMErrorManager.recKeyWordError(string);
                } else {
                    this.doSet(this, string, string3, dMErrorManager);
                    this.initialized = true;
                }
            }
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Request being processed: " + cMIRequest.getRequest() + "\nis not a valid request for the CMI Objective\n" + "Data Model Category");
            }
            dMErrorManager.recNotImplementedError(cMIRequest);
        }
        cMIRequest.done();
    }

    private String processSubcategory(CMIRequest cMIRequest, String string, DMErrorManager dMErrorManager) {
        if (DebugIndicator.ON) {
            System.out.println("In CMIObjectiveData::processSubcategory()");
            System.out.println("The Element: " + string);
        }
        String string2 = new String("");
        try {
            Field field = this.getClass().getField(string);
            if (cMIRequest.isForASetRequest()) {
                if (cMIRequest.isAKeywordRequest()) {
                    dMErrorManager.recKeyWordError(cMIRequest.getElement());
                } else {
                    this.score.performSet(cMIRequest, dMErrorManager);
                }
            } else if (string.equals("score")) {
                string2 = this.score.performGet(cMIRequest, dMErrorManager);
            } else if (cMIRequest.isAKeywordRequest()) {
                dMErrorManager.recGetKeyWordError(cMIRequest.getElement());
            } else {
                dMErrorManager.recNotImplementedError(cMIRequest);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Element being processed: " + string + "is not a valid sub category of the CMI " + "Objectives\nData Model Category");
            }
            dMErrorManager.SetCurrentErrorCode("401");
        }
        catch (SecurityException securityException) {
            if (DebugIndicator.ON) {
                System.out.println(securityException);
                System.out.println("Access to the information is denied");
            }
            dMErrorManager.SetCurrentErrorCode("101");
        }
        return string2;
    }

    private boolean isValidObjectiveDataRequest(CMIRequest cMIRequest) {
        boolean bl = false;
        if (cMIRequest.getTotalNumTokens() >= CMIOBJECTIVEDATA_MIN_NUM_TOKENS) {
            bl = true;
        }
        return bl;
    }

    public String isValidRequest(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        boolean bl = false;
        String string = new String("");
        if (cMIRequest.getTotalNumTokens() <= 5) {
            String string2 = cMIRequest.getNextToken();
            if (DebugIndicator.ON) {
                System.out.println("token: " + string2);
            }
            if (string2.equals("id") || string2.equals("status")) {
                if (cMIRequest.hasMoreTokensToProcess()) {
                    bl = false;
                    dMErrorManager.recNotImplementedError(cMIRequest);
                } else {
                    dMErrorManager.SetCurrentErrorCode("0");
                }
            } else if (string2.equals("score")) {
                bl = this.score.isValidRequest(cMIRequest);
                if (cMIRequest.isAChildrenRequest()) {
                    string = this.score.getChildren();
                }
            }
        } else {
            dMErrorManager.recNotImplementedError(cMIRequest);
        }
        return string;
    }

    public void showData() {
        if (DebugIndicator.ON) {
            System.out.println("CMI Objective Data Object:");
            System.out.println("\tid: " + this.getId().getValue());
            System.out.println("\tstatus: " + this.getStatus().getValue());
            System.out.println("\tscore.raw: " + this.getScore().getRaw().getValue());
            System.out.println("\tscore.min: " + this.getScore().getMin().getValue());
            System.out.println("\tscore.max: " + this.getScore().getMax().getValue());
        }
    }
}

