/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import java.util.Vector;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIObjectiveData;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMIObjectives
extends CMICategory
implements Serializable {
    public Vector objectives = new Vector();
    static int CMIOBJ_MIN_NUM_TOKENS = 3;

    public CMIObjectives() {
        super(true);
    }

    public Vector getObjectives() {
        return this.objectives;
    }

    public void setObjectives(CMIObjectiveData cMIObjectiveData, int n) {
        this.objectives.add(n, cMIObjectiveData);
    }

    public String performGet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        if (DebugIndicator.ON) {
            System.out.println("CMIObjectives::performGet()");
        }
        String string = new String("");
        if (this.isValidObjRequest(cMIRequest)) {
            String string2 = cMIRequest.getNextToken();
            if (DebugIndicator.ON) {
                System.out.println("Token being processed: " + string2);
            }
            if (cMIRequest.hasMoreTokensToProcess()) {
                try {
                    Integer n = new Integer(string2);
                    int n2 = n;
                    try {
                        CMIObjectiveData cMIObjectiveData = (CMIObjectiveData)this.objectives.elementAt(n2);
                        string = cMIObjectiveData.performGet(cMIRequest, dMErrorManager);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        if (DebugIndicator.ON) {
                            System.out.println("Element does not exist at the given index");
                            System.out.println("Index: " + n2);
                        }
                        dMErrorManager.SetCurrentErrorCode("201");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (DebugIndicator.ON) {
                        System.out.println("Error - Data Model Element not implemented");
                        System.out.println("Invalid data model element: " + cMIRequest.getRequest() + " passed to LMSGetValue()");
                        System.out.println("Array index required");
                    }
                    dMErrorManager.SetCurrentErrorCode("401");
                }
            } else if (cMIRequest.isAChildrenRequest()) {
                string = this.getChildren();
            } else if (cMIRequest.isACountRequest()) {
                int n = 0;
                n = this.objectives.size();
                System.out.println("Count: " + n);
                Integer n3 = new Integer(n);
                string = n3.toString();
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Data Model Element not implemented");
                    System.out.println("Invalid request: " + cMIRequest.getRequest());
                }
                dMErrorManager.recNotImplementedError(cMIRequest);
            }
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Invalid request: " + cMIRequest.getRequest());
            }
            dMErrorManager.SetCurrentErrorCode("401");
        }
        cMIRequest.done();
        if (DebugIndicator.ON) {
            System.out.println("Returning from CMIObjectives::performGet()");
            System.out.println("Value returned: " + string);
        }
        return string;
    }

    public String getChildren() {
        String string = "id,score,status";
        return string;
    }

    public void performSet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        if (DebugIndicator.ON) {
            System.out.println("CMIObjectives::performSet()");
        }
        int n = -1;
        String string = cMIRequest.getNextToken();
        if (DebugIndicator.ON) {
            System.out.println("Token being processed: " + string);
        }
        try {
            Integer n2 = new Integer(string);
            n = n2;
            CMIObjectiveData cMIObjectiveData = (CMIObjectiveData)this.objectives.elementAt(n);
            cMIObjectiveData.performSet(cMIRequest, dMErrorManager);
            this.objectives.set(n, cMIObjectiveData);
        }
        catch (NumberFormatException numberFormatException) {
            if (cMIRequest.isAKeywordRequest()) {
                dMErrorManager.recKeyWordError(string);
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Data Model Element not implemented");
                    System.out.println("Invalid data model element: " + cMIRequest.getRequest() + " passed to LMSSetValue()");
                }
                dMErrorManager.recNotImplementedError(cMIRequest);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (DebugIndicator.ON) {
                System.out.println("First time setting the Objective Data");
            }
            if (n <= this.objectives.size()) {
                CMIObjectiveData cMIObjectiveData = new CMIObjectiveData();
                cMIObjectiveData.performSet(cMIRequest, dMErrorManager);
                this.objectives.add(n, cMIObjectiveData);
            }
            dMErrorManager.SetCurrentErrorCode("201");
        }
        cMIRequest.done();
    }

    private boolean isValidObjRequest(CMIRequest cMIRequest) {
        boolean bl = false;
        if (cMIRequest.getTotalNumTokens() >= CMIOBJ_MIN_NUM_TOKENS) {
            bl = true;
        }
        return bl;
    }
}

