/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.adl.util.debug.DebugIndicator;

public class CMIRequest
implements Serializable {
    private String request;
    private String model;
    private String baseCategory;
    private int numSub = 10;
    private String[] subcategory;
    private int numOfSubCategories = 0;
    private int numOfSubCatReturned = 0;
    private int numInd = 10;
    private Integer[] index;
    private int numOfInd = 0;
    private int numOfIndReturned = 0;
    private String element;
    private String setValue;
    private int totalNumberOfTokens = 0;
    private int tokensRequested = 1;
    private int tokensProcessed = 0;
    private boolean getRequest;
    private boolean setRequest;
    private int numPat = 10;
    private Integer[] pattern;
    private static int MODEL = 1;
    private static int BASE_CATEGORY = 2;
    private static int SUB_CATEGORY = 3;
    private static int ARRAY_INDEX = 4;
    private static int ELEMENT = 5;
    private static int VALUE = 6;
    static int pattern_counter = 2;

    static void incrementPatternCount() {
        ++pattern_counter;
    }

    static void resetPatternCounter() {
        pattern_counter = 2;
    }

    public CMIRequest(String string, boolean bl) {
        int n;
        if (DebugIndicator.ON) {
            if (bl) {
                System.out.println("Building CMIRequest for a LMSGetValue(" + string + ") ");
            } else {
                System.out.println("Building CMIRequest for a LMSSetValue(" + string + ") ");
            }
        }
        this.request = string;
        this.model = new String("");
        this.baseCategory = new String("");
        this.element = new String("");
        this.setValue = new String("");
        this.getRequest = bl;
        this.index = new Integer[this.numInd];
        for (n = 0; n < this.index.length; ++n) {
            this.index[n] = new Integer(-1);
        }
        this.pattern = new Integer[this.numPat];
        for (n = 0; n < this.pattern.length; ++n) {
            this.pattern[n] = new Integer(-1);
        }
        this.subcategory = new String[this.numSub];
        for (n = 0; n < this.subcategory.length; ++n) {
            this.subcategory[n] = new String("-1");
        }
        String string2 = new String("");
        String string3 = new String("");
        if (this.getRequest) {
            this.setRequest = false;
            this.parseGetRequest(string);
        } else {
            this.setRequest = true;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            int n2 = stringTokenizer.countTokens();
            int n3 = 0;
            string3 = stringTokenizer.nextToken();
            ++n3;
            if (DebugIndicator.ON) {
                System.out.println("Request: [" + string3 + "]");
            }
            if (n2 == 1) {
                string2 = new String("");
            } else {
                while (n3 < n2) {
                    string2 = string2 + stringTokenizer.nextToken();
                    if (++n3 == n2) continue;
                    string2 = string2 + ",";
                }
                if (DebugIndicator.ON) {
                    System.out.println("Set Value: [" + string2 + "]");
                }
            }
            ++this.totalNumberOfTokens;
            this.parseSetRequest(string3, string2);
        }
        if (DebugIndicator.ON) {
            this.showRequest();
        }
    }

    public String getModel() {
        return this.model;
    }

    public boolean isForASetRequest() {
        return this.setRequest;
    }

    public boolean isAKeywordRequest() {
        boolean bl = false;
        if (this.isAChildrenRequest() || this.isACountRequest() || this.isAVersionRequest()) {
            bl = true;
        }
        return bl;
    }

    public boolean isAChildrenRequest() {
        boolean bl = false;
        if (this.element.equals("_children")) {
            bl = true;
        }
        return bl;
    }

    public boolean isACountRequest() {
        boolean bl = false;
        if (this.element.equals("_count")) {
            bl = true;
        }
        return bl;
    }

    public boolean isAVersionRequest() {
        boolean bl = false;
        if (this.element.equals("_version")) {
            bl = true;
        }
        return bl;
    }

    public String getRequest() {
        return this.request;
    }

    public String getBaseCategory() {
        ++this.tokensRequested;
        return this.baseCategory;
    }

    public String getValue() {
        return this.setValue;
    }

    public String getElement() {
        return this.element;
    }

    public int getTotalNumTokens() {
        return this.totalNumberOfTokens;
    }

    public int getNumSubCat() {
        return this.numOfSubCategories;
    }

    public int getNumIndices() {
        return this.numOfInd;
    }

    public Integer getIndex(int n) {
        return this.index[n];
    }

    public String getSubCategory(int n) {
        String string = new String("-1");
        if (n >= 0 && n < 10) {
            string = this.subcategory[n];
        }
        return string;
    }

    private void parseGetRequest(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        this.totalNumberOfTokens += stringTokenizer.countTokens();
        this.model = stringTokenizer.nextToken();
        ++this.tokensProcessed;
        this.pattern[0] = new Integer(MODEL);
        this.baseCategory = stringTokenizer.nextToken();
        ++this.tokensProcessed;
        this.pattern[1] = new Integer(BASE_CATEGORY);
        if (stringTokenizer.hasMoreTokens()) {
            boolean bl = false;
            while (!bl) {
                if (this.onLastToken()) {
                    int n;
                    String string2 = stringTokenizer.nextToken();
                    try {
                        Integer n2 = new Integer(string2);
                        n = this.findNextIndexLoc();
                        this.index[n] = n2;
                        ++this.numOfInd;
                        int n3 = this.findNextPatternLoc();
                        this.pattern[n3] = new Integer(ARRAY_INDEX);
                        this.element = this.subcategory[this.numOfSubCategories - 1];
                        n3 = this.findNextPatternLoc();
                        this.pattern[n3] = new Integer(ELEMENT);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.element = string2;
                        n = this.findNextPatternLoc();
                        this.pattern[n] = new Integer(ELEMENT);
                    }
                    ++this.tokensProcessed;
                    bl = true;
                    continue;
                }
                this.determineNextToken(stringTokenizer);
            }
        } else {
            this.element = this.baseCategory;
        }
    }

    private void parseSetRequest(String string, String string2) {
        if (DebugIndicator.ON) {
            System.out.println("In CMIRequest::parseSetRequest");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        this.totalNumberOfTokens += stringTokenizer.countTokens();
        this.model = stringTokenizer.nextToken();
        ++this.tokensProcessed;
        this.pattern[0] = new Integer(MODEL);
        this.baseCategory = stringTokenizer.nextToken();
        ++this.tokensProcessed;
        this.pattern[1] = new Integer(BASE_CATEGORY);
        if (stringTokenizer.hasMoreTokens()) {
            boolean bl = false;
            while (!bl) {
                int n;
                if (this.onLastToken()) {
                    this.setValue = string2;
                    ++this.tokensProcessed;
                    n = this.findNextPatternLoc();
                    this.pattern[n] = new Integer(VALUE);
                    bl = true;
                    continue;
                }
                if (this.totalNumberOfTokens - this.tokensProcessed == 2) {
                    this.element = stringTokenizer.nextToken();
                    ++this.tokensProcessed;
                    n = this.findNextPatternLoc();
                    this.pattern[n] = new Integer(ELEMENT);
                    continue;
                }
                this.determineNextToken(stringTokenizer);
            }
        } else {
            this.setValue = string2;
            ++this.tokensProcessed;
            int n = this.findNextPatternLoc();
            this.pattern[n] = new Integer(VALUE);
        }
    }

    private void determineNextToken(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        ++this.tokensProcessed;
        try {
            Integer n = new Integer(string);
            int n2 = this.findNextIndexLoc();
            this.index[n2] = n;
            ++this.numOfInd;
            int n3 = this.findNextPatternLoc();
            this.pattern[n3] = new Integer(ARRAY_INDEX);
        }
        catch (NumberFormatException numberFormatException) {
            int n = this.findNextSubLoc();
            this.subcategory[n] = string;
            ++this.numOfSubCategories;
            int n4 = this.findNextPatternLoc();
            this.pattern[n4] = new Integer(SUB_CATEGORY);
        }
    }

    private boolean onLastToken() {
        boolean bl = false;
        if (this.totalNumberOfTokens - this.tokensProcessed == 1) {
            bl = true;
        }
        return bl;
    }

    public String getNextToken() {
        String string = new String("");
        try {
            Integer n = this.pattern[pattern_counter];
            int n2 = n;
            if (n2 == SUB_CATEGORY) {
                try {
                    string = this.subcategory[this.numOfSubCatReturned];
                    ++this.numOfSubCatReturned;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    System.out.println(indexOutOfBoundsException);
                }
            } else if (n2 == ARRAY_INDEX) {
                try {
                    Integer n3 = this.index[this.numOfIndReturned];
                    ++this.numOfIndReturned;
                    string = n3.toString();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    System.out.println(indexOutOfBoundsException);
                }
            } else if (n2 == ELEMENT) {
                string = this.element;
                CMIRequest.resetPatternCounter();
            } else if (n2 == VALUE) {
                string = this.setValue;
            }
            if (n2 != ELEMENT) {
                CMIRequest.incrementPatternCount();
            }
            ++this.tokensRequested;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println(indexOutOfBoundsException);
        }
        return string;
    }

    public boolean hasMoreTokensToProcess() {
        boolean bl = true;
        if (this.setRequest) {
            if (this.totalNumberOfTokens - 1 - this.tokensRequested == 0) {
                bl = false;
            }
        } else if (this.totalNumberOfTokens - this.tokensRequested == 0) {
            bl = false;
        }
        return bl;
    }

    public void done() {
        CMIRequest.resetPatternCounter();
        this.tokensRequested = 1;
        this.numOfSubCatReturned = 0;
        this.numOfIndReturned = 0;
    }

    private int findNextPatternLoc() {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i <= this.numPat; ++i) {
            if (n2 != this.pattern[i]) continue;
            n = i;
            break;
        }
        return n;
    }

    private int findNextIndexLoc() {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i <= this.numInd; ++i) {
            if (n2 != this.index[i]) continue;
            n = i;
            break;
        }
        return n;
    }

    private int findNextSubLoc() {
        int n = -1;
        String string = new String("-1");
        for (int i = 0; i <= this.numSub; ++i) {
            if (!this.subcategory[i].equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public void showRequest() {
        if (DebugIndicator.ON) {
            int n;
            System.out.println("Base Category: " + this.baseCategory);
            System.out.println("Element: " + this.element);
            System.out.println("Model: " + this.model);
            System.out.println("Number of Indices: " + this.numOfInd);
            System.out.println("Number of SubCategories: " + this.numOfSubCategories);
            for (n = 0; n < this.numOfSubCategories; ++n) {
                System.out.println("Subcategory[" + n + "]: " + this.subcategory[n]);
            }
            for (n = 0; n < this.numOfInd; ++n) {
                System.out.println("Index[" + n + "]: " + this.index[n]);
            }
            for (n = 0; n < this.numPat; ++n) {
                if (this.pattern[n] <= -1) continue;
                System.out.println("Pattern[" + n + "]: " + this.pattern[n]);
            }
            if (this.isForASetRequest()) {
                System.out.println("Set Value: " + this.setValue);
            }
        }
    }
}

