/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMIScore
extends CMICategory
implements Serializable {
    public Element raw = new Element("", "checkScoreDecimal", "NULL", true, true, true);
    public Element min = new Element("", "checkScoreDecimal", "NULL", true, true, true);
    public Element max = new Element("", "checkScoreDecimal", "NULL", true, true, true);

    public CMIScore() {
        super(true);
    }

    public Element getRaw() {
        return this.raw;
    }

    public Element getMin() {
        return this.min;
    }

    public Element getMax() {
        return this.max;
    }

    public void setRaw(String string) {
        this.raw.setValue(string);
    }

    public void setMin(String string) {
        this.min.setValue(string);
    }

    public void setMax(String string) {
        this.max.setValue(string);
    }

    public boolean isInitialized() {
        boolean bl = false;
        if (this.raw.isInitialized() || this.min.isInitialized() || this.max.isInitialized()) {
            bl = true;
        }
        return bl;
    }

    public boolean isValidRequest(CMIRequest cMIRequest) {
        boolean bl = false;
        String string = cMIRequest.getNextToken();
        if (string.equals("_children")) {
            bl = true;
        } else if (string.equals("raw") || string.equals("min") || string.equals("max")) {
            bl = true;
            if (cMIRequest.hasMoreTokensToProcess()) {
                bl = cMIRequest.isAChildrenRequest();
            }
        }
        return bl;
    }

    public String performGet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        String string = new String("");
        String string2 = cMIRequest.getNextToken();
        if (cMIRequest.hasMoreTokensToProcess()) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Element being processed: " + string2 + "is not a valid element of the CMI Score\n" + "Data Model Category");
            }
            if (cMIRequest.isAKeywordRequest()) {
                dMErrorManager.recGetKeyWordError(cMIRequest.getElement());
            } else {
                dMErrorManager.recNotImplementedError(cMIRequest);
            }
        } else if (cMIRequest.isAChildrenRequest()) {
            string = this.getChildren();
            dMErrorManager.SetCurrentErrorCode("0");
        } else {
            string = this.determineElementValue(this, string2, dMErrorManager);
        }
        return string;
    }

    public String getChildren() {
        String string = "raw,min,max";
        return string;
    }

    public void performSet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        String string = cMIRequest.getNextToken();
        if (cMIRequest.hasMoreTokensToProcess()) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Element being processed: " + string + "is not a valid element of the CMI Score\n" + "Data Model Category");
            }
            dMErrorManager.recNotImplementedError(cMIRequest);
        } else {
            String string2 = cMIRequest.getValue();
            if (!cMIRequest.isAKeywordRequest()) {
                this.doSet(this, string, string2, dMErrorManager);
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Cannot Set Data Model Element");
                    System.out.println("Element being processed: " + string + "cannot be set\n");
                }
                dMErrorManager.recKeyWordError(string);
            }
        }
    }
}

