/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMIStudentData
extends CMICategory
implements Serializable {
    public Element mastery_score = new Element("", "checkDecimal", "NULL", false, true, false);
    public Element max_time_allowed = new Element("", "checkTimespan", "NULL", false, true, false);
    public Element time_limit_action = new Element("", "checkVocabulary", "TimeLimitAction", false, true, false);
    private static int CMISTUD_DATA_MIN_NUM_TOKENS = 3;

    public CMIStudentData() {
        super(true);
    }

    public Element getMasteryScore() {
        return this.mastery_score;
    }

    public Element getMaxTimeAllowed() {
        return this.max_time_allowed;
    }

    public Element getTimeLimitAction() {
        return this.time_limit_action;
    }

    public void setMasteryScore(String string) {
        this.mastery_score.setValue(string);
    }

    public void setMaxTimeAllowed(String string) {
        this.max_time_allowed.setValue(string);
    }

    public void setTimeLimitAction(String string) {
        this.time_limit_action.setValue(string);
    }

    public String performGet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        String string = new String("");
        String string2 = cMIRequest.getNextToken();
        if (cMIRequest.hasMoreTokensToProcess()) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Element being processed: " + string2 + "is not a valid element of the CMI Student Data\n" + "Data Model Category");
            }
            if (cMIRequest.isAKeywordRequest()) {
                dMErrorManager.recGetKeyWordError(cMIRequest.getElement());
            } else {
                dMErrorManager.recNotImplementedError(cMIRequest);
            }
        } else {
            string = cMIRequest.isAChildrenRequest() ? this.getChildren() : this.determineElementValue(this, string2, dMErrorManager);
        }
        return string;
    }

    public String getChildren() {
        String string = "mastery_score,max_time_allowed,time_limit_action";
        return string;
    }

    public void performSet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        String string = cMIRequest.getNextToken();
        if (cMIRequest.hasMoreTokensToProcess()) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Element being processed: " + string + "is not a valid element of the CMI Score\n" + "Data Model Category");
            }
            dMErrorManager.recNotImplementedError(cMIRequest);
        } else {
            String string2 = cMIRequest.getValue();
            if (!cMIRequest.isAKeywordRequest()) {
                this.doSet(this, string, string2, dMErrorManager);
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Cannot Set Data Model Element");
                    System.out.println("Element being processed: " + string + "cannot be set\n");
                }
                dMErrorManager.recKeyWordError(string);
            }
        }
    }

    private boolean isValidStudDataRequest(CMIRequest cMIRequest) {
        boolean bl = false;
        if (cMIRequest.isForASetRequest()) {
            if (cMIRequest.getTotalNumTokens() - 1 >= CMISTUD_DATA_MIN_NUM_TOKENS) {
                bl = true;
            }
        } else if (cMIRequest.getTotalNumTokens() >= CMISTUD_DATA_MIN_NUM_TOKENS) {
            bl = true;
        }
        return bl;
    }
}

