/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMIStudentPreference
extends CMICategory
implements Serializable {
    public Element audio = new Element("", "checkSInteger", "NULL", true, true, true);
    public Element language = new Element("", "checkString255", "NULL", true, true, true);
    public Element speed = new Element("", "checkSInteger", "NULL", true, true, true);
    public Element text = new Element("", "checkSInteger", "NULL", true, true, true);
    static int CMISTPREF_MIN_NUM_TOKENS = 3;

    public CMIStudentPreference() {
        super(true);
    }

    public Element getAudio() {
        return this.audio;
    }

    public Element getLanguage() {
        return this.language;
    }

    public Element getSpeed() {
        return this.speed;
    }

    public Element getText() {
        return this.text;
    }

    public void setAudio(String string) {
        this.audio.setValue(string);
    }

    public void setLanguage(String string) {
        this.language.setValue(string);
    }

    public void setSpeed(String string) {
        this.speed.setValue(string);
    }

    public void setText(String string) {
        this.text.setValue(string);
    }

    public String performGet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        String string = new String("");
        if (this.isValidStPrefRequest(cMIRequest)) {
            String string2 = cMIRequest.getNextToken();
            if (cMIRequest.hasMoreTokensToProcess()) {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Data Model Element not implemented");
                    System.out.println("Invalid data model element: " + cMIRequest.getRequest() + " passed to interface");
                }
                if (cMIRequest.isAKeywordRequest()) {
                    dMErrorManager.recGetKeyWordError(cMIRequest.getElement());
                } else {
                    dMErrorManager.recNotImplementedError(cMIRequest);
                }
            } else {
                string = cMIRequest.isAChildrenRequest() ? this.getChildren() : this.determineElementValue(this, string2, dMErrorManager);
            }
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Invalid data model element: " + cMIRequest.getRequest() + " passed to interface");
            }
            dMErrorManager.recNotImplementedError(cMIRequest);
        }
        cMIRequest.done();
        return string;
    }

    public void performSet(CMIRequest cMIRequest, DMErrorManager dMErrorManager) {
        block14: {
            if (this.isValidStPrefRequest(cMIRequest)) {
                String string = cMIRequest.getNextToken();
                if (cMIRequest.hasMoreTokensToProcess()) {
                    if (DebugIndicator.ON) {
                        System.out.println("Error - Data Model Element not implemented");
                        System.out.println("Invalid data model element: " + cMIRequest.getRequest() + " passed to interface");
                    }
                    dMErrorManager.recNotImplementedError(cMIRequest);
                } else if (cMIRequest.isAChildrenRequest()) {
                    if (DebugIndicator.ON) {
                        System.out.println("Error - trying to set a keyword");
                    }
                    dMErrorManager.recKeyWordError(string);
                } else {
                    String string2 = cMIRequest.getValue();
                    if (string.equals("audio") || string.equals("speed") || string.equals("text")) {
                        try {
                            int n = Integer.parseInt(string2);
                            if (string.equals("audio") && n >= -1 && n <= 100 || string.equals("speed") && n >= -100 && n <= 100 || string.equals("text") && n >= -1 && n <= 1) {
                                this.doSet(this, string, string2, dMErrorManager);
                                break block14;
                            }
                            dMErrorManager.SetCurrentErrorCode("405");
                        }
                        catch (NumberFormatException numberFormatException) {
                            dMErrorManager.SetCurrentErrorCode("405");
                            if (DebugIndicator.ON) {
                                System.out.println("Error - Number Format Exception");
                            }
                            break block14;
                        }
                    }
                    this.doSet(this, string, string2, dMErrorManager);
                }
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Data Model Element not implemented");
                    System.out.println("Invalid data model element: " + cMIRequest.getRequest() + " passed to interface");
                }
                dMErrorManager.recNotImplementedError(cMIRequest);
            }
        }
        cMIRequest.done();
    }

    private boolean isValidStPrefRequest(CMIRequest cMIRequest) {
        boolean bl = false;
        if (cMIRequest.getTotalNumTokens() >= CMISTPREF_MIN_NUM_TOKENS) {
            bl = true;
        }
        return bl;
    }

    private String getChildren() {
        String string = new String("audio,language,speed,text,");
        return string;
    }
}

