/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import org.adl.datamodels.cmi.CMIRequest;
import org.adl.util.debug.DebugIndicator;

public class DMErrorManager {
    private static String currentErrorCode;
    private static String[][] errors;

    public DMErrorManager() {
        currentErrorCode = "0";
    }

    public void recNotImplementedError(CMIRequest cMIRequest) {
        if (cMIRequest.isAChildrenRequest()) {
            if (DebugIndicator.ON) {
                System.out.println("Trying to get/set an _children element.\n  This keyword is not permitted to be implemented on the given element");
            }
            this.SetCurrentErrorCode("401");
        } else if (cMIRequest.isACountRequest()) {
            if (DebugIndicator.ON) {
                System.out.println("Trying to get/set an _count element.\n  This keyword is not permitted to be implemented on the given element");
            }
            this.SetCurrentErrorCode("401");
        } else {
            this.SetCurrentErrorCode("401");
        }
    }

    public void recKeyWordError(String string) {
        if (string.equals("_children")) {
            if (DebugIndicator.ON) {
                System.out.println("Trying to set an _children element.  This action is not permitted!");
            }
            this.SetCurrentErrorCode("402");
        } else if (string.equals("_count")) {
            if (DebugIndicator.ON) {
                System.out.println("Trying to set an _count element.  This action is not permitted!");
            }
            this.SetCurrentErrorCode("402");
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Trying to set an _version element.  This action is not permitted!");
            }
            this.SetCurrentErrorCode("402");
        }
    }

    public void recGetKeyWordError(String string) {
        if (string.equals("_children")) {
            if (DebugIndicator.ON) {
                System.out.println("Trying to get an _children element.  This action is not permitted!");
            }
            this.SetCurrentErrorCode("202");
        } else if (string.equals("_count")) {
            if (DebugIndicator.ON) {
                System.out.println("Trying to get an _count element.  This action is not permitted!");
            }
            this.SetCurrentErrorCode("203");
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Trying to get an _version element.  This action is not permitted!");
            }
            this.SetCurrentErrorCode("401");
        }
    }

    public String GetCurrentErrorCode() {
        return currentErrorCode;
    }

    public void SetCurrentErrorCode(String string) {
        currentErrorCode = string;
    }

    public void ClearCurrentErrorCode() {
        currentErrorCode = errors[0][0];
    }

    public String GetErrorDescription(String string) {
        return this.GetErrorElement(string)[1];
    }

    public String GetErrorDiagnostic(String string) {
        return this.GetErrorElement(string)[2];
    }

    private String[] GetErrorElement(String string) {
        for (int i = 0; i < errors.length; ++i) {
            if (!errors[i][0].equalsIgnoreCase(string)) continue;
            return errors[i];
        }
        String[] stringArray = new String[]{"", "", ""};
        return stringArray;
    }

    public boolean isValidErrorCode(String string) {
        boolean bl = false;
        for (int i = 0; !bl && i < errors.length; ++i) {
            if (!errors[i][0].equalsIgnoreCase(string)) continue;
            bl = true;
        }
        return bl;
    }

    static {
        errors = new String[][]{{"0", "No Error", "The previous LMS API Function call completed successfully."}, {"101", "General Exception", "An unspecified, unexpected exception has occurred."}, {"201", "Invalid argument error", ""}, {"202", "Element cannot have children", ""}, {"203", "Element not an array - cannot have count", ""}, {"301", "Not initialized", "The LMS is not initialized."}, {"401", "Not implemented error", "The data model element in question was not implemented."}, {"402", "Invalid set value, element is a keyword", "Trying to set a reserved keyword in the data model.  Trying to set a keyword (_count, _children, or _version).  This is prohibited."}, {"403", "Element is read only", "Data Element is Read Only (Not Writeable).  Cannot call LMSSetValue() for the element in question."}, {"404", "Element is write only", "Data Element is Write Only (Not Readable).  Cannot call LMSGetValue() for the element in question."}, {"405", "Incorrect Data Type", "Invalid Type being used for setting element.  The type being used as the set value argument does not match that of the element being set."}};
    }
}

