/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.client;

import java.applet.Applet;
import java.net.URL;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import netscape.javascript.JSObject;
import org.adl.datamodels.DataModelInterface;
import org.adl.datamodels.SCODataManager;
import org.adl.datamodels.cmi.CMICore;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.CMITime;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.samplerte.client.LMSErrorManager;
import org.adl.samplerte.client.ServletProxy;
import org.adl.util.debug.DebugIndicator;

public class APIAdapterApplet
extends Applet {
    private static boolean _Debug = DebugIndicator.ON;
    private static LMSErrorManager lmsErrorManager;
    private static SCODataManager theSCOData;
    private DMErrorManager dmErrorManager;
    private static boolean isLMSInitialized;
    private static String cmiBooleanFalse;
    private static String cmiBooleanTrue;
    private URL servletURL;

    public void init() {
        if (_Debug) {
            System.out.println("In API::init()(the applet Init method)");
        }
        cmiBooleanFalse = new String("false");
        cmiBooleanTrue = new String("true");
        lmsErrorManager = new LMSErrorManager();
        this.dmErrorManager = new DMErrorManager();
        isLMSInitialized = false;
        URL codebase = this.getCodeBase();
        String host = codebase.getHost();
        String protocol = codebase.getProtocol();
        int port = codebase.getPort();
        if (_Debug) {
            System.out.println("codebase url is " + codebase.toString());
        }
        try {
            this.servletURL = new URL(String.valueOf(protocol) + "://" + host + ":" + port + "/gdgat/lmscmi");
            String session = this.getCookie("JSESSIONID");
            System.out.println("\u4f1a\u8bddID: " + session);
            if (_Debug) {
                System.out.println("servlet url is " + this.servletURL.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stop();
        }
    }

    public String getAppletInfo() {
        return "Title: Sample RTE API Implementation \nAuthor: R. Ball, CTC \nExample of one possible LMS API Implementation.";
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"None", "", "This applet requires no parameters."}};
        return info;
    }

    private boolean CheckInitialization() {
        if (!isLMSInitialized) {
            lmsErrorManager.SetCurrentErrorCode("301");
        }
        return isLMSInitialized;
    }

    public String LMSInitialize(String param) {
        if (_Debug) {
            System.out.println("*********************");
            System.out.println("In API::LMSInitialize");
            System.out.println("*********************");
            System.out.println("");
        }
        String result = cmiBooleanFalse;
        String tempParm = String.valueOf(param);
        if (!tempParm.equals("null") && !tempParm.equals("")) {
            lmsErrorManager.SetCurrentErrorCode("201");
            return result;
        }
        if (isLMSInitialized) {
            lmsErrorManager.SetCurrentErrorCode("101");
        } else {
            if (_Debug) {
                System.out.println("Trying to get SCO Data from servlet...");
            }
            String sessionid = this.getCookie("JSESSIONID");
            ServletProxy servletProxy = new ServletProxy(this.servletURL, sessionid);
            theSCOData = servletProxy.GetSCOData();
            if (_Debug) {
                System.out.println("The Core Data for the current SCO contains the following:");
                theSCOData.getCore().showData();
            }
            isLMSInitialized = true;
            lmsErrorManager.ClearCurrentErrorCode();
            result = cmiBooleanTrue;
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("*******************************");
            System.out.println("Done Processing LMSInitialize()");
            System.out.println("*******************************");
        }
        return result;
    }

    private String getCookie(String cookieName) {
        String cookie = null;
        try {
            cookie = this.getParameter("cookie");
            if (cookie == null) {
                JSObject window = JSObject.getWindow((Applet)this);
                JSObject document = (JSObject)window.getMember("document");
                cookie = (String)document.getMember("cookie");
                if (_Debug) {
                    System.out.println("Cookies found =" + cookie);
                }
            }
            if (cookie != null) {
                StringTokenizer tk = new StringTokenizer(cookie, ";");
                cookie = null;
                while (tk.hasMoreTokens()) {
                    String token = tk.nextToken();
                    if (token.indexOf(String.valueOf(cookieName) + "=") == -1) continue;
                    cookie = token.trim();
                    break;
                }
                if (cookie != null) {
                    cookie = URLDecoder.decode(cookie);
                }
            }
        }
        catch (Exception e) {
            if (_Debug) {
                System.out.println("Couldn't retrieve the cookie" + e);
            }
            e.printStackTrace();
        }
        return cookie;
    }

    public String LMSFinish(String param) {
        if (_Debug) {
            System.out.println("*****************");
            System.out.println("In API::LMSFinish");
            System.out.println("*****************");
            System.out.println("");
        }
        String result = cmiBooleanFalse;
        String tempParm = String.valueOf(param);
        if (tempParm.equals("null") || tempParm.equals("")) {
            if (this.CheckInitialization()) {
                CMICore lmsCore = theSCOData.getCore();
                CMITime totalTime = new CMITime(lmsCore.getTotalTime().getValue());
                if (_Debug) {
                    System.out.println("\tTotal time: " + totalTime.toString());
                }
                CMITime sessionTime = new CMITime(lmsCore.getSessionTime().getValue());
                if (_Debug) {
                    System.out.println("\tSession time: " + sessionTime.toString());
                }
                totalTime.add(sessionTime);
                lmsCore.setTotalTime(totalTime.toString());
                if (_Debug) {
                    System.out.println("\t\tTotal time: " + totalTime.toString());
                }
                if (lmsCore.getExit().getValue().equalsIgnoreCase("suspend")) {
                    lmsCore.setEntry("resume");
                } else {
                    lmsCore.setEntry("");
                }
                if (lmsCore.getLessonStatus().getValue().equalsIgnoreCase("not attempted")) {
                    lmsCore.setLessonStatus("incomplete");
                }
                theSCOData.setCore(lmsCore);
                result = this.LMSCommit("");
                if (result != cmiBooleanTrue) {
                    if (_Debug) {
                        System.out.println("LMSCommit failed causing LMSFinish to fail.");
                    }
                } else {
                    isLMSInitialized = false;
                    JSObject jsroot = JSObject.getWindow((Applet)this);
                    jsroot.eval("changeSCOContent()");
                    result = cmiBooleanTrue;
                }
            }
        } else {
            lmsErrorManager.SetCurrentErrorCode("201");
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("***************************");
            System.out.println("Done Processing LMSFinish()");
            System.out.println("***************************");
        }
        return result;
    }

    public String LMSGetValue(String element) {
        if (_Debug) {
            System.out.println("*******************");
            System.out.println("In API::LMSGetValue");
            System.out.println("*******************");
            System.out.println("");
        }
        if (!this.CheckInitialization()) {
            if (_Debug) {
                System.out.println("LMS Not Initialized");
            }
            String emptyString = new String("");
            return emptyString;
        }
        if (_Debug) {
            System.out.println("Request being processed: LMSGetValue(" + element + ")");
        }
        CMIRequest request = new CMIRequest(element, true);
        if (_Debug) {
            System.out.println("Looking for the element " + request.getRequest());
        }
        lmsErrorManager.ClearCurrentErrorCode();
        this.dmErrorManager.ClearCurrentErrorCode();
        String rtnVal = null;
        DataModelInterface dmInterface = new DataModelInterface();
        rtnVal = dmInterface.processGet(element, theSCOData, this.dmErrorManager);
        lmsErrorManager.SetCurrentErrorCode(this.dmErrorManager.GetCurrentErrorCode());
        if (rtnVal != null) {
            if (_Debug) {
                System.out.println("LMSGetValue() found!");
                System.out.println("Returning: " + rtnVal);
            }
        } else {
            if (_Debug) {
                System.out.println("Found the element, but the value was null");
            }
            rtnVal = new String("");
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("************************************");
            System.out.println("Processing done for API::LMSGetValue");
            System.out.println("************************************");
        }
        return rtnVal;
    }

    public String LMSSetValue(String element, String value) {
        String result = cmiBooleanFalse;
        if (_Debug) {
            System.out.println("*******************");
            System.out.println("In API::LMSSetValue");
            System.out.println("*******************");
            System.out.println("");
        }
        lmsErrorManager.ClearCurrentErrorCode();
        this.dmErrorManager.ClearCurrentErrorCode();
        if (!this.CheckInitialization()) {
            return result;
        }
        String tempValue = String.valueOf(value);
        String setValue = tempValue.equals("null") ? new String("") : tempValue;
        String theRequest = String.valueOf(element) + "," + setValue;
        if (_Debug) {
            System.out.println("Request being processed: LMSSetValue(" + theRequest + ")");
            System.out.println("Looking for the element " + element);
        }
        DataModelInterface dmInterface = new DataModelInterface();
        dmInterface.processSet(theRequest, theSCOData, this.dmErrorManager);
        lmsErrorManager.SetCurrentErrorCode(this.dmErrorManager.GetCurrentErrorCode());
        if (lmsErrorManager.GetCurrentErrorCode() == "0") {
            result = cmiBooleanTrue;
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("************************************");
            System.out.println("Processing done for API::LMSSetValue");
            System.out.println("************************************");
        }
        return result;
    }

    public String LMSCommit(String param) {
        if (_Debug) {
            System.out.println("*************************");
            System.out.println("Processing API::LMSCommit");
            System.out.println("*************************");
            System.out.println("");
        }
        String result = cmiBooleanFalse;
        String tempParm = String.valueOf(param);
        if (tempParm.equals("null") || tempParm.equals("")) {
            String sessionid;
            ServletProxy servletProxy;
            String servletResult;
            if (!this.CheckInitialization()) {
                return result;
            }
            if (_Debug) {
                System.out.println("Saving Data to the Server...");
                System.out.println("The SCO Data Manager for the current SCO contains the following:");
                theSCOData.getCore().showData();
            }
            if (!(servletResult = (servletProxy = new ServletProxy(this.servletURL, sessionid = this.getCookie("JSESSIONID"))).PutSCOData(theSCOData)).equals("OK")) {
                lmsErrorManager.SetCurrentErrorCode("101");
                if (_Debug) {
                    System.out.println("Put to Server was NOT successful!");
                }
            } else {
                lmsErrorManager.ClearCurrentErrorCode();
                result = cmiBooleanTrue;
                if (_Debug) {
                    System.out.println("Put to Server succeeded!");
                }
            }
        } else {
            lmsErrorManager.SetCurrentErrorCode("201");
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("**********************************");
            System.out.println("Processing done for API::LMSCommit");
            System.out.println("**********************************");
        }
        return result;
    }

    public String LMSGetLastError() {
        if (_Debug) {
            System.out.println("In API::LMSGetLastError()");
        }
        return lmsErrorManager.GetCurrentErrorCode();
    }

    public String LMSGetErrorString(String errorCode) {
        if (_Debug) {
            System.out.println("In API::LMSGetErrorString()");
        }
        return lmsErrorManager.GetErrorDescription(errorCode);
    }

    public String LMSGetDiagnostic(String errorCode) {
        if (_Debug) {
            System.out.println("In API::LMSGetDiagnostic()");
        }
        return lmsErrorManager.GetErrorDiagnostic(errorCode);
    }
}

