/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import org.adl.util.debug.DebugIndicator;

public class ServletWriter {
    private static boolean _Debug = DebugIndicator.ON;

    public static ObjectInputStream postObjects(URL uRL, Serializable[] serializableArray, String string) throws Exception {
        ObjectInputStream objectInputStream;
        ObjectOutputStream objectOutputStream;
        URLConnection uRLConnection;
        if (_Debug) {
            System.out.println("In ServletWriter::postObjects()");
        }
        try {
            if (_Debug) {
                System.out.println("Opening HTTP URL connection to servlet.");
            }
            uRLConnection = uRL.openConnection();
        }
        catch (Exception exception) {
            if (_Debug) {
                System.out.println("Exception caught In ServletWriter::postObjects()");
            }
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            throw exception;
        }
        if (_Debug) {
            System.out.println("HTTP connection to servlet is open");
            System.out.println("configuring HTTP connection properties");
        }
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Content-Type", "text/plain");
        uRLConnection.setAllowUserInteraction(false);
        uRLConnection.setRequestProperty("Cookie", string);
        try {
            if (_Debug) {
                System.out.println("Creating new http output stream");
            }
            objectOutputStream = new ObjectOutputStream(uRLConnection.getOutputStream());
            if (_Debug) {
                System.out.println("Created new http output stream.");
                System.out.println("Writing command and data to servlet...");
            }
            int n = serializableArray.length;
            if (_Debug) {
                System.out.println("Num objects: " + n);
            }
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeObject(serializableArray[i]);
                if (!_Debug) continue;
                System.out.println("just wrote a serialized object on output stream... " + serializableArray[i].getClass().getName());
            }
        }
        catch (Exception exception) {
            if (_Debug) {
                System.out.println("Exception caught In ServletWriter::postObjects()");
                System.out.println(exception.getMessage());
            }
            exception.printStackTrace();
            throw exception;
        }
        try {
            if (_Debug) {
                System.out.println("Flushing Object Output Stream.");
            }
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            if (_Debug) {
                System.out.println("Caught IOException when calling out.flush()");
            }
            iOException.printStackTrace();
            throw iOException;
        }
        catch (Exception exception) {
            if (_Debug) {
                System.out.println("Caught Exception when calling out.flush()");
            }
            exception.printStackTrace();
            throw exception;
        }
        try {
            if (_Debug) {
                System.out.println("Closing Object Output Stream.");
            }
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            if (_Debug) {
                System.out.println("Caught IOException when calling out.close()");
                System.out.println(iOException.getMessage());
            }
            iOException.printStackTrace();
            throw iOException;
        }
        catch (Exception exception) {
            if (_Debug) {
                System.out.println("Caught Exception when calling out.close()");
            }
            exception.printStackTrace();
            throw exception;
        }
        try {
            if (_Debug) {
                System.out.println("Creating new http input stream.");
            }
            objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
        }
        catch (Exception exception) {
            if (_Debug) {
                System.out.println("Exception caught In ServletWriter::postObjects()");
                System.out.println(exception.getMessage());
            }
            exception.printStackTrace();
            throw exception;
        }
        return objectInputStream;
    }
}

