/**
 * 确认支付方式
 * @returns {Boolean}
 */
function payment(){
	var pay_id=$(".payList .select .on").attr('value');
	if(pay_id ==null || pay_id =='' || typeof(pay_id) =='undefined'){
		alert('请选择您的支付方式');
		return false;
	}
	var retUrl =window.mjava.dynUrl +"/cart/check_out";
	$.ajax({
		type : "POST",
		url : window.mjava.dynUrl +'/cart/update_price?pay_id='+pay_id+'&retUrl='+retUrl,
		data : null,
		dataType : "json",
		success : function(data) {
			if ('toLogin' ==data){
				window.loction.href =window.mjava.dynUrl +'/user/login';
			}
			if (!data.success) {
				alert(data.err_msg);
				return;
			}
			window.location.href =window.mjava.dynUrl +'/cart/check_out?pay_id='+pay_id;
		},
		error : function() {
			alert('支付方式调用使用优惠时出现错误。。。');
		}
	});
	
}

/**
 * 发票(已存在于bill.jsp中)
 * @param platfrom
 * @returns {Boolean}
 */
function abill(platfrom){
	var inv_type=$(".bill.type .on").attr('value');
	var inv_payee=$(".bill.type input[name='company']").val();
	var inv_content=$(".bill.content .on").attr('value');	
	if(inv_type=='2'){
		if(inv_payee=='请输入单位名称' || inv_payee=='' || inv_payee==null){
			alert('发票抬头不能为空');
			return false;
		}
	}else{
		inv_type='1'; 
		inv_payee ='个人';
	}
	if(inv_content ==null || '' ==inv_content || typeof(inv_content) =='undefined'){
		inv_content ='酒水';
	}
	
	var retUrl =window.mjava.dynUrl +"/cart/check_out";
	$.ajax({
		type : "POST",
		url : window.mjava.dynUrl +'/cart/update_price?retUrl='+retUrl+'&platfrom='+platfrom,
		data : null,
		dataType : "json",
		success : function(data) {
			if ('toLogin' ==data){
				window.loction.href =window.mjava.dynUrl +'/user/login';
				return;
			}
			if (!data.success) {
				alert(data.err_msg);
				return;
			}
			window.location.href =window.mjava.dynUrl +'/cart/check_out?inv_type='+inv_type+'&inv_payee='+inv_payee+'&inv_content='+inv_content+'&platfrom='+platfrom;
		},
		error : function() {
			alert('发票调用使用优惠时出现错误。。。');
		}
	});
	
}

function forwardAddress(receiveInfoCount, platfrom) {
	if (receiveInfoCount > 0) {
		window.location.href = window.mjava.dynUrl + '/address/index';
	} else {
		editAddress(3, '', '${from}');
	}

}
/**
 * 修改/删除地址
 * @param opType 操作方式3：新增， 2：修改， 1：删除
 * @param address_id 地址id
 *  @param platfrom 平台 
 */
function editAddress(opType, address_id,from){
	if(3 ==opType){
		$.ajax({
    		type : "POST",
    		url : window.mjava.dynUrl +'/address/get_total',
    		data : null,
    		dataType : "json",
    		success : function(data) {
    			if (data != null) {
    				if(parseInt(data)>=20){
    					alert('最多添加20个收货地址');
    				}
    				else if(parseInt(data)>=0){
						window.location.href = window.mjava.dynUrl + "/address/add"+ "?from=" + from;
    				}
    			}
    		},
    		error : function() {
    			alert('调用获取地址列表总数时出现错误。。。');
    		}
    	});
	}else if(2 == opType){
		window.location.href = window.mjava.dynUrl +"/address/add?address_id="+address_id+"&from="+from;
	}else{
		if(confirm("确定删除该地址吗?"))
		 {
			window.location.href= window.mjava.dynUrl +"/address/delete?address_ids="+address_id+"&from="+from;
		 }
	}
}

/**
 * 选择省市县
 * @param obj
 */
function ntArea(obj) {
    if (obj == 'p') {
        var p = $('#p');
        $.ajax({
    		type : "POST",
    		url : window.mjava.dynUrl +'/address/getRegionList?province_id='+p.val(),
    		data : null,
    		dataType : "json",
    		success : function(data) {
    			if (data != null) {
    				var citysHtml ='<option value="0">请选择</option>';
    				$.each(data, function(i,value){ 
    					citysHtml +='<option value="'+value.area_id+'">'+value.area_name+'</option>';
    		          });
    				$('#c').html(citysHtml);
    				$('#r').html('<option value="0">请选择</option>');
    			}
    		},
    		error : function() {
    			alert('调用选择省市县出现错误。。。');
    		}
    	});
       
    }
     if (obj == 'c') {
        var p = $('#p');
        var c = $('#c');
        $.ajax({
    		type : "POST",
    		url : window.mjava.dynUrl +'/address/getRegionList?province_id='+p.val()+'&city_id='+c.val(),
    		data : null,
    		dataType : "json",
    		success : function(data) {
    			if (data != null) {
    				var regionsHtml ='<option value="0">请选择</option>';
    				$.each(data, function(i,value){ 
    					regionsHtml +='<option value="'+value.area_id+'">'+value.area_name+'</option>';  
    		          });
    				$('#r').html(regionsHtml);
    			}
    		},
    		error : function() {
    			alert('调用选择省市县出现错误。。。');
    		}
    	});
    }
}
/**
 * 验证收货地址
 * @returns {Boolean}
 */
function check_address(){
	var p=$('#p').val();
	var c=$('#c').val();
	var d=$('form[name="addressForm"] select[name=district]').val();
	var a=$('form[name="addressForm"] input[name=address]').val(); 
	var consignee=$('form[name="addressForm"] input[name=consignee]').val();
	var mobile=$('form[name="addressForm"] input[name=mobile]').val();
	if(p=='' || p==null || '0' ==p){
		alert('省份不能为空！');
		return false;
	}
	if(c=='' || c==null || '0'==c){
		alert('城市不能为空！');
		return false;
	}
	if(d=='' || d==null || '0'==d){
		alert('区县不能为空！');
		return false;
	}
	if(a=='' || a==null){
		alert('详细地址不能为空！');
		return false;
	}
	if(consignee=='' || consignee==null){
		alert('收货人不能为空！');
		return false;
	}
	if(mobile=='' || mobile==null){
		alert('手机号不能为空！');
		return false;
	}
	if(!(/^13[0-9]{1}[0-9]{8}$|15[0-9]{1}[0-9]{8}$|18[0-9]{1}[0-9]{8}$|14[0-9]{1}[0-9]{8}|17[0-9]{1}[0-9]{8}$/).test(mobile)){
		alert('请输入有效的手机号');
		return false;
	}
	
}

/**
 * 选择配送地址
 * @param address_id
 * @param province_id
 * @param obj
 * @param platfrom
 */
function selAddress(address_id, province_id, obj){
	$(obj).addClass('on');
    $(obj).parent().parent().siblings().find(".choose").removeClass('on');
    
    var retUrl =window.mjava.dynUrl +"/cart/check_out";
	$.ajax({
		type : "POST",
		url : window.mjava.dynUrl +'/cart/update_price?address_id='+address_id+'&retUrl='+retUrl,
		data : null,
		dataType : "json",
		success : function(data) {
			if ('toLogin' ==data){
				window.loction.href =window.mjava.dynUrl +'/user/login';
				return;
			}
			if (!data.success) {
				alert(data.err_msg);
				return;
			}
			window.location.href =window.mjava.dynUrl +'/cart/check_out?address_id='+address_id+'&province_id='+province_id;
		},
		error : function() {
			alert('选择配送地址调用使用优惠时出现错误。。。');
		}
	});
}
/**
 *  转向红包列表页
 * @param platfrom 平台来源
 */
function favourableBonus(){
	var bonusNum =$('#bonus_nums').val();
	if(bonusNum ==0){
		return;
	}
	var bonus_disable =$('#bonus_disable').val();
	if(bonus_disable =='1'){
		$('.mask').show();
		$('.alertTip').show();
		return;
	}
	window.location.href =window.mjava.dynUrl+'/order_inner/favourable';
}

/**
 * 优惠券翻页
 * @param pageNo
 * @param type
 */
function ajaxPagination (pageNo, type){
	window.location.href =window.mjava.dynUrl+'/order_inner/favourable?page_index='+pageNo;
}

/**
 * 选择使用红包（每个订单最多可使用一张优惠券）
 * @param platfrom
 */
function selUseBonus(platfrom){
	var bonus_id =$('.bonusList .on').attr('value');
	if(bonus_id ==null || '' ==bonus_id || typeof(bonus_id) =='undefined'){
		bonus_id =0;
		//history.back(-1);
		//window.location.href=window.mjava.dynUrl +"/cart/check_out?bonus_id="+bonus_id;	
	}
	$.ajax({
  		type : "POST",
  		url : window.mjava.dynUrl +'/cart/update_price?bonus_id='+bonus_id,
  		data : null,
  		dataType : "json",
  		success : function(data) {
  			if(data !=null && !data.success){
  				alert(data.err_msg);
  			}
  			else{
  				if(platfrom =='weixin'){
    				window.location.href =window.mjava.dynUrl +'/cart/paramsInfo?bonus_id='+bonus_id;
    			}else{
    				window.location.href=window.mjava.dynUrl +"/cart/check_out?bonus_id="+bonus_id;
    			}
  			}
  		},
  		error : function() {
  			alert('调用验证是否可结算时出现错误。。。');
  			return;
  		}
  	});
}

/**
 * 验证订单
 */
function check_order(){
		$("#checkbtn").removeAttr("onclick");
		$("#checkbtn").disabled="disabled";
		var address_id =$('.order input[name="address_id"]');
		var pay_id =$('.order.pay input[name="pay_id"]');
		var note = $(".order textarea[name='postscript']");
		var stockout_gifts = $("#stockout_gifts").val();
		if(null ==address_id.val() || typeof(address_id.val())=='undefined'){
			alert('收货地址不能为空');
			return;
		}
		if(null ==pay_id.val() || typeof(pay_id.val()) =='undefined'){
			alert('支付方式不能为空 ');
			return;
		}
		if(note.val().length>140){
			alert('订单备注最多不超过140字 ');
			return;
		}
		
		var use_cash_back =$('.order.discount .type_back li .sign.on').val();
		var use_cash_fund =$('.order.discount .type_fund li .sign.on').val();
		var back = $('#back').val();
		var fund = $('#fund').val();
		if((back == 1&&(null ==use_cash_back || typeof(use_cash_back) =='undefined'))
				||(fund == 1&&(null ==use_cash_fund || typeof(use_cash_fund) =='undefined'))){
			$('#inputPayPwd').show();
		}
		else
		{
			//$("#checkbtn").removeAttr("onclick");
			var retUrl =window.mjava.dynUrl +"/cart/check_out";
			$.ajax({
				type : "POST",
				url : window.mjava.dynUrl +'/cart/update_price?retUrl='+retUrl+"&stockout_gifts="+stockout_gifts,
				data : null,
				dataType : "json",
				success : function(data) {
					if ('toLogin' ==data){
						window.loction.href =window.mjava.dynUrl +'/user/login';
						return;
					}
					if (!data.success) {
						alert(data.err_msg);
						return;
					}
					$('#orderForm').submit();
				},
				error : function() {
					alert('提交订单调用使用优惠时出现错误。。。');
				}
			});
		}
}

/**
 * 验证支付密码
 */
function validePP(){
  var pwd =$('#order_pp').val().trim();
  if(null ==pwd|| "" ==pwd){
	  $('#order_pp').val('');
	  $('#order_payerr').html('请输入密码');
	  return;
  }
  else if(pwd.length>20)
  {
	  $('#order_pp').val('');
	  $('#order_payerr').html('支付密码有误');
	  return;
  }
  else
  {
	  $.ajax({
  		type : "POST",
  		url : window.mjava.dynUrl +'/user/check_pay_password?pay_password='+pwd,
  		data : null,
  		dataType : "json",
  		success : function(data) {
  			if(data !=null && !data.success){
  				$('#order_pp').val('');
  				$('#order_payerr').html(data.err_msg);
  				 return;
  			}
  			else{
  				 $("#orderForm").submit();
  				 $('.submitMask').hide();
  			}
  		},
  		error : function() {
  			alert('调用检查支付密码时出现错误。。。');
  			return;
  		}
  	});
  }
}

/**
 * 再次购买/立即支付/确认收货
 * @param opType
 * @param url
 */
function order_infOp(opType, url, obj, platfrom){
	if('再次购买' ==opType){
		$.ajax({
	  		type : "POST",
	  		url : url,
	  		data : null,
	  		dataType : "json",
	  		success : function(data) {
	  			if('toLogin' ==data){
	  				windwo.location.href =window.mjava.dynUrl +'/user/login';
	  			}
	  			else if(data !=null && data.success){
	  				window.location.href =window.mjava.dynUrl +'/cart/info/?platfrom='+platfrom;
	  			}
	  			if(!data.success){
	  				alert(data.err_msg);
	  			}
	  		},
	  		error : function() {
	  			alert('调用再次购买接口时出现错误。。。');
	  			return;
	  		}
	  	});
	}
	else if('立即支付' ==opType){
		window.location.href=url;
	}
	else if('确认收货' ==opType){
		$.ajax({
	  		type : "POST",
	  		url : url,
	  		data : null,
	  		dataType : "json",
	  		success : function(data) {
	  			if('/user/login' ==data){
	  				windwo.location.href =window.mjava.dynUrl +'/user/login';
	  			}
	  			else{
	  				$('#alert_orderinfo').html(data.err_msg);
	  				$(obj).next().show(1).delay(1500).hide(1);
	  				if(data.success){
	  					window.location.href =window.mjava.dynUrl+"/order/index/4?platfrom="+platfrom;
	  				}
	  			}
	  		},
	  		error : function() {
	  			alert('调用确认收货接口时出现错误。。。');
	  			return;
	  		}
	  	});
	}
	 
}

/**
 * 取消订单
 * @param orderId 订单id
 * @param orderStatus 订单状态:1:待付款 4:已完成 7:待发货 8：待收货
 */
function cancelOrder(orderId, orderStatus){
	$.ajax({
  		type : "POST",
  		url : window.mjava.dynUrl+"/order/cancel/"+orderId,
  		data : null,
  		dataType : "json",
  		success : function(data) {
  			if(data ==''){
  				window.location.href =window.mjava.dynUrl+"/order/index/"+orderStatus;
  			}
  			else
  			{
  			  alert(data);
  			}
  		},
  		error : function() {
  			alert('调用取消订单接口时出现错误。。。');
  			return;
  		}
  	});
}

/**
 * 更新订单支付明细
 * @param use_cash_money 是否使用优惠(保留之前)
 * @param use_cash_back 是否使用返现
 * @param use_cash_fund 是否使用余额
 * @param retUrl 返回地址
 * 
 */
function ajaxupdatePrice(use_cash_money, use_cash_back, use_cash_fund, retUrl,type){
	$.ajax({
		type : "POST",
		url : window.mjava.dynUrl +'/cart/update_price?use_cash_money='+use_cash_money+'&use_cash_back='+use_cash_back+'&use_cash_fund='+use_cash_fund+'&retUrl='+retUrl,
		data : null,
		dataType : "json",
		success : function(data) {
			if('toLogin' ==data){
				window.location.href =window.mjava.dynUrl+'/user/login';
			}else if(data.result.msg != null && 'notSetPayPwd' == data.result.msg){
//				if(window.confirm("抱歉您还未设置支付密码，请先设置密码以保障资金安全")){
//					window.location.href = window.mjava.dynUrl + '/usersafe/index';
//				}
				$('#gotoSetPayPwd').show();
			}
			else if (data !=null && !data.success) {
				alert(data.err_msg);
			}
			else
			{
				if(type == 1){
					if($('.order.discount .type a').hasClass('on')){
						$('.order.discount .type a').removeClass('on');
					}
					else{
						$('.order.discount .type a').addClass('on');
					}
				}
				
				if(type == 2){
					if($('.order.discount .type_back a').hasClass('on')){
						$('.order.discount .type_back a').removeClass('on');
					}else{
						$('.order.discount .type_back a').addClass('on');
					}
				}
				
				if(type == 3){
					if($('.order.discount .type_fund a').hasClass('on')){
						$('.order.discount .type_fund a').removeClass('on');
					}else{
						$('.order.discount .type_fund a').addClass('on');
					}
				}
				
				//提交前和提交后实付金额不一致
				$('.order.discount input[name="use_cash_money"]').val(use_cash_money);
				$('.order.discount input[name="use_cash_back"]').val(use_cash_back);
				$('.order.discount input[name="use_cash_fund"]').val(use_cash_fund);
				
				var result =data.result;
				var price_list =result.price_list;
				var settleAccountHtml = '<h2>商品结算<span class="actualPay">实付金额：<i>&yen;'
										+ result.total_price
										+ '</i></span></h2><ul><li class="first">商品总额：<i>&yen;'
				                        + result.goods_amount +'</i></li>';
				
				$.each(price_list, function(i,value){
					settleAccountHtml +='<li class="even">'+value['name']+':<i>&yen;'+value['value']+'</i></li>';
				});
	            settleAccountHtml +='</ul>';
	            $('.order.account').html(settleAccountHtml);
			}
		},
		error : function() {
			alert('调用使用优惠接口出现错误。。。');
		}
	});
}

/**
 * 微信支付
 * @param order_id
 * @param order_sn
 * @param total_price
 */
function weixinPay(order_id, order_sn, total_price) {
	if(null ==order_id || '' ==order_id || null ==order_sn || '' ==order_sn){
		return;
	}
	window.location.href =window.mjava.dynUrl +'/order/weixin/getWeixinPayParams?order_id='+order_id+"&order_sn="+order_sn+"&total_price="+total_price;
} 

$(function() {
	//支付
	 $('.payList .select li i').unbind('click').bind("click",function(){
         $(this).addClass('on');
         $(this).parent().siblings().find("i").removeClass('on');
     });
	 //发票
	 $('.bill .select li i').bind("click",function(){
         $(this).addClass('on');
         $(this).parent().siblings().find("i").removeClass('on');
     });
	 //红包
	 $('.bonusList .ticket i').bind("click", function() {
		 $(this).addClass('on');
		 $(this).parent().siblings().find("i").removeClass('on');
	 });
	 //余额返现
	/* $('.order.discount .type li .sign').toggle(
         function(){
             	$(this).removeClass('on');
             	$('.order.discount input[name="use_cash_money"]').val('1');
             	var retUrl =window.mjava.dynUrl +"/cart/check_out";
             	ajaxupdatePrice('1', retUrl);
             	},
         function(){
             	$(this).addClass('on');
             	$('.order.discount input[name="use_cash_money"]').val('0');
             	var retUrl =window.mjava.dynUrl +"/cart/check_out";
             	ajaxupdatePrice('0', retUrl);
             	}
     );*/
	 
     /*如果用户未设置支付密码， 若点击余额返现开关， 只提示，不打开*/
	 $('.order.discount .type a').bind('click', function() {
		var use_cash_fund =$('.order.discount input[name="use_cash_fund"]').val();
		var use_cash_back =$('.order.discount input[name="use_cash_back"]').val();
		var retUrl = window.mjava.dynUrl + "/cart/check_out";
		
		var isOn = $(this).hasClass("on");
		if (isOn) {
			ajaxupdatePrice('1', use_cash_back, use_cash_fund, retUrl, 1);
		} else {
			$('.order.discount input[name="use_cash_money"]').val('0');
			ajaxupdatePrice('0', use_cash_back, use_cash_fund, retUrl), 1;
		}
	});
	 
	//增加余额返现开关分别进行开启关闭
		$('.order.discount .type_fund a').bind('click', function() {
			var retUrl = window.mjava.dynUrl + "/cart/check_out";
			var use_cash_money =$('.order.discount input[name="use_cash_money"]').val();
			var use_cash_back =$('.order.discount input[name="use_cash_back"]').val();
			
			if(use_cash_back ==null || '' ==use_cash_back || typeof(use_cash_back) =='undefined'){
				use_cash_back = 0;
			}
			
			var isOn = $(this).hasClass("on");
			if (isOn) {
				ajaxupdatePrice(use_cash_money, use_cash_back, '1', retUrl, 3);
			} else {
				$('.order.discount input[name="use_cash_fund"]').val('0');
				ajaxupdatePrice(use_cash_money, use_cash_back, '0', retUrl, 3);
			}
		 });
		 
		$('.order.discount .type_back a').bind('click', function() {
			var retUrl = window.mjava.dynUrl + "/cart/check_out";
			var use_cash_money =$('.order.discount input[name="use_cash_money"]').val();
			var use_cash_fund =$('.order.discount input[name="use_cash_fund"]').val();
			
			if(use_cash_fund ==null || '' ==use_cash_fund || typeof(use_cash_fund) =='undefined'){
				use_cash_fund = 0;
			}
			
			var isOn = $(this).hasClass("on");
			if (isOn) {
				ajaxupdatePrice(use_cash_money, '1', use_cash_fund, retUrl, 2);
			} else {
				$('.order.discount input[name="use_cash_back"]').val('0');
				ajaxupdatePrice(use_cash_money, '0', use_cash_fund, retUrl, 2);
			}
	     });
	
     $('.submitMask .write span').bind('click',function(){
         $(this).prev().focus();
         $(this).hide();
     });
     $('.tipInput').focus();
});
