; (function($) {
    var _util = CS.util,
    _uiBinder = CS.uiBinder,
    _dialog = CS.dialog,
    _mask = CS.mask,
    _loginPopup = CS.loginPopup;
    var _params = {},
    _options = {},
    _objMask = null,
    _showTabList = ['recommend', 'reward', 'monthTicket'],
    _isSubmitingMonthTicket = 0,
    _isSubmitingRecommend = 0,
    _isSubmitingReward = 0,
    _popup_nodes = null,
    _showPopupCss = 'pop_show',
    _selectedTabCss = 'nav_current';
    var _tips = {
        'defaultRewardContent': '这本书太棒了！鼓励一下，希望后续更加精彩！'
    };
    var _popup_tpl = ['<div attr="inner:popup;" class="readerInteractPopup" style="display:none;">', '<div class="sakura">', '<h1>', '<a attr="click:closePopup;" class="close_btn_old close_btn2" href="javascript:"></a>', '《<%=bookName%>》读者互动', '</h1>', '<div attr="inner:tabList;" class="sakura_nav">', '<a attr="inner:recommendTab;click:switchTab;" interactiontype="recommend" href="javascript:;" style="display:none;">投推荐票</a>', '<a attr="inner:monthTicketTab;click:switchTab;" interactiontype="monthTicket" href="javascript:;" style="display:none;">月  票</a>', '<a attr="inner:rewardTab;click:switchTab;" interactiontype="reward" href="javascript:;" style="display:none;"><%=rewardDefaultText%></a>', '</div>', '<h2 class="topshadow"></h2>', '<div attr="inner:content;" class="pop_cont"></div>', '</div>', '</div>'].join('');
    function init(params, options) {
        _params = $.extend({
            'bookName': '',
            'novel_showid': '',
            'getInteractonContent_ajaxUrl': '',
            'submitReward_ajaxUrl': '',
            'submitRecommend_ajaxUrl': '',
            'submitMonthTicket_ajaxUrl': ''
        },
        params || {});
        _options = $.extend({
            'showMonthTicket': 0,
            'rewardDefaultText': '打  赏'
        },
        options || {});
    }
    function openPopup(type) {
        if (!_util.isLogin()) {
            _loginPopup.open();
            return false;
        }
        if (!_popup_nodes) {
            _popup_nodes = _uiBinder.appendHTML(document.body, _popup_tpl, {
                'bookName': _params.bookName,
                'rewardDefaultText': _options.rewardDefaultText
            },
            {
                'closePopup': function() {
                    _objMask.close();
                },
                'switchTab': _switchPopupTab
            });
            _objMask = new _mask(_popup_nodes.popup);
        }
        if (_popup_nodes) {
            var tabName = '';
            for (var i = 0,
            len = _showTabList.length; i < len; i++) {
                tabName = _showTabList[i];
                if (tabName === 'monthTicket' && !_options.showMonthTicket) {
                    continue;
                }
                $(_popup_nodes[tabName + 'Tab']).removeClass(_selectedTabCss).show();
            }
            $("a[interactiontype='" + type + "']", _popup_nodes.tabList).addClass(_selectedTabCss);
            _objMask.open();
            _renderInteractContent(type);
        }
        return false;
    }
    function _renderInteractContent(type) {
        if (!_params.getInteractonContent_ajaxUrl || !type) {
            return;
        }
        _util.request({
            url: _params.getInteractonContent_ajaxUrl,
            data: {
                'page': type,
                'showid': _params.novel_showid
            },
            type: 'get',
            dataType: "json",
            success: function(json) {
                _renderInteractContentCallback(type, json);
            }
        });
    }
    function _renderInteractContentCallback(type, tpl) {
        if (!_popup_nodes || !_popup_nodes['content']) {
            return;
        }
        var events = {};
        $(_popup_nodes['content']).html('');
        switch (type) {
        case 'reward':
            events = {
                'clearCommentDefaultText': _clearRewardCommentDefaultText,
                'setCommentDefaultText': _setRewardCommentDefaultText,
                'submitReward': _submitReward
            };
            break;
        case 'recommend':
            events = {
                'submitRecommend': _submitRecommend
            };
            break;
        case 'monthTicket':
            events = {
                'submitMonthTicket': _submitMonthTicket,
                'switchTab': function() {
                    $(_popup_nodes.rewardTab).trigger('click');
                }
            };
            break;
        default:
            break;
        }
        var nodes = _uiBinder.appendHTML(_popup_nodes['content'], tpl, {},
        events);
        if (nodes.commentInput) {
            _tips.defaultRewardContent = nodes.commentInput.value;
        }
        var $rewardTips = $("#TextareaTipsArr");
        if ($rewardTips.length > 0 && $rewardTips.html().length > 0) {
            var rewardCommentList = $.parseJSON($rewardTips.text());
            if (rewardCommentList) {
                _bindRewardGoldRadioEvent(nodes, rewardCommentList);
            }
        }
    }
    function _bindRewardGoldRadioEvent(nodes, rewardCommentList) {
        var $goldRadio = $(nodes.rewardContainer).find('input[type="radio"]');
        $goldRadio.change(function() {
            var tips = rewardCommentList[$goldRadio.index(this)];
            if (tips) {
                nodes.commentInput.value = _util.sim2tra(tips);
                _tips.defaultRewardContent = tips;
            }
        });
    }
    function _switchPopupTab(e, el, nodes) {
        $("a", nodes.tabList).each(function() {
            $(this).removeClass(_selectedTabCss);
        });
        $(el).addClass(_selectedTabCss);
        _renderInteractContent($(el).attr("interactiontype"));
        return false;
    }
    function _submitReward(e, el, nodes) {
        if (!_util.isLogin()) {
            $(".close_btn2").click();
            $(".btnpoplogin").click();
            return;
        }
        if (_isSubmitingReward) {
            return false;
        }
        var goldCount = $("input[type='radio']:checked", nodes.rewardContainer).val(),
        remainedGoldCount = $(el).attr('goldcount');
        remainedGoldCount = remainedGoldCount ? parseInt(remainedGoldCount, 10) : 0;
        if (!_params.submitReward_ajaxUrl || !_params.novel_showid) {
            _dialog.alert('提交地址或书id未获取到');
            return false;
        }
        if (!goldCount) {
            _dialog.alert("请选择书币数量");
            return false;
        }
        if (goldCount > remainedGoldCount) {
            _dialog.alert("余额不足，无法打赏");
            return false;
        }
        var commentLength = $.trim(nodes.commentInput.value).length;
        if (commentLength < 6) {
            _dialog.alert('请评论的更详细一点，至少6个字');
            return false;
        } else if (commentLength > 500) {
            _dialog.alert('您太能写了，不能超过500字！');
            return false;
        }
        var commentContent = $(nodes.commentInput).val(),
        commentHtml = $('<div />').text(commentContent).html();
        _isSubmitingReward = 1;
        _util.request({
            url: _params.submitReward_ajaxUrl,
            data: {
                'showid': _params.novel_showid,
                'amount': goldCount,
                'review': commentHtml
            },
            type: 'post',
            dataType: "json",
            success: function(json) {
                if (json.info) {
                    _dialog.alert(json.info);
                }
                if (json.status) {
                    $(".close_btn_oldsdo, .close_btn_old").click();
                }
            },
            error: function() {},
            complete: function() {
                _isSubmitingReward = 0;
            }
        });
        return false;
    }
    function _clearRewardCommentDefaultText(e, el, nodes) {
        if (nodes.commentInput && $.trim(nodes.commentInput.value) === _util.sim2tra(_tips.defaultRewardContent)) {
            nodes.commentInput.value = '';
        }
    }
    function _setRewardCommentDefaultText(e, el, nodes) {
        if (nodes.commentInput && $.trim(nodes.commentInput.value).length === 0) {
            nodes.commentInput.value = _util.sim2tra(_tips.defaultRewardContent);
        }
    }
    function _submitRecommend(e, el, nodes) {
        if (!_util.isLogin()) {
            $(".close_btn2").click();
            $(".btnpoplogin").click();
            return;
        }
        if (_isSubmitingRecommend) {
            return false;
        }
        var voteCount = $('input[name=recommend_num]:checked', nodes.recommendContainer).val(),
        remainedVoteCount = $(el).attr('votecount');
        remainedVoteCount = remainedVoteCount ? parseInt(remainedVoteCount, 10) : 0;
        if (!_params.submitRecommend_ajaxUrl || !_params.novel_showid) {
            _dialog.alert('提交地址或书id未获取到');
            return false;
        }
        if (!voteCount) {
            _dialog.alert("请选择推荐票数量!");
            return false;
        }
        if (voteCount > remainedVoteCount) {
            _dialog.alert("您今日推荐票已不足，请重新选择！");
            return false;
        }
        _isSubmitingRecommend = 1;
        _util.request({
            url: _params.submitRecommend_ajaxUrl,
            data: {
                'showid': _params.novel_showid,
                'Votenum': voteCount
            },
            type: 'post',
            dataType: "json",
            success: function(json) {
                if (json.info) {
                    _dialog.alert(json.info);
                }
                if (json.status) {
                    $(".close_btn_old").click();
                }
            },
            error: function() {},
            complete: function() {
                _isSubmitingRecommend = 0;
            }
        });
        return false;
    }
    function _submitMonthTicket(e, el, nodes) {
        if (!_util.isLogin()) {
            $(".close_btn2").click();
            $(".btnpoplogin").click();
            return;
        }
        if (_isSubmitingMonthTicket) {
            return false;
        }
        var ticketCount = $('input[name=Monthly_num]:checked', nodes.monthTicketContainer).val(),
        remainedTicketCount = $(el).attr('ticketcount');
        remainedTicketCount = remainedTicketCount ? parseInt(remainedTicketCount, 10) : 0;
        if (!_params.submitMonthTicket_ajaxUrl || !_params.novel_showid) {
            _dialog.alert('提交地址或书id未获取到');
            return false;
        }
        if (ticketCount === "Monthly_num_value") {
            ticketCount = nodes.ticketCountInput.value;
        }
        if (!ticketCount) {
            _dialog.alert("请选择月票数量!");
            return false;
        }
        if (ticketCount > remainedTicketCount) {
            _dialog.alert("您月票已不足,请重新选择!");
            return false;
        }
        _isSubmitingMonthTicket = 1;
        _util.request({
            url: _params.submitMonthTicket_ajaxUrl,
            data: {
                showid: _params.novel_showid,
                ticketCount: ticketCount
            },
            type: 'post',
            dataType: "json",
            success: function(json) {
                if (json.info) {
                    _dialog.alert(json.info);
                }
                if (json.status) {
                    $(".close_btn_old").click();
                }
            },
            error: function() {},
            complete: function() {
                _isSubmitingMonthTicket = 0;
            }
        });
        return false;
    }
    _util.initNameSpace("CS");
    CS.readerInteract = {
        'init': init,
        'openPopup': openPopup
    };
})(jQuery);; (function($) {
    var _util = CS.util,
    _dialog = CS.dialog,
    _bookshelf = CS.bookshelf;
    var _params = {};
    var _isLoading = 0,
    _notVipUserTips = "您好，本章节为VIP付费章节，您需要先点'充值'按钮，成为创世VIP会员，才能订阅观看本章节。",
    _subscribeConfirmTips = {
        '0': '将扣除您$price$书币， 您确定吗？',
        '1': '订阅全部章节将消耗您$price$书币，您确定吗？',
        '2': '订阅本章将消耗您$price$书币，您确定吗？',
        '3': '自动订阅本书——设置此功能后，系统将会订阅本书所有vip章节，并自动订阅后续更新vip章节，订阅当前所有vip章节共需$price$书币，您确定吗？',
        '4': '自动订阅新章节——设置此功能后，系统将会自动订阅本书后续更新vip章节。'
    };
    function init(isVipUser, novel_id, novel_showid, subscribeBook_ajaxUrl) {
        _params.isVipUser = parseInt(isVipUser, 10) || 0;
        _params.novel_id = novel_id || '0';
        _params.novel_showid = novel_showid || '0';
        _params.subscribeBook_ajaxUrl = subscribeBook_ajaxUrl || '';
    }
    function subscribeBook(cid, subscribe_type, isAutoSubscribe, total_price, chapter_price, remained_price) {
        if (!_util.isLogin()) {
            _dialog.alert("请先登录");
            return;
        }
        if (!_params.subscribeBook_ajaxUrl) {
            _dialog.alert('订阅地址未获取到');
            return;
        }
        var price = 0;
        if (subscribe_type == 1 || subscribe_type == 2 || subscribe_type == 3) {
            if (subscribe_type == 1 || subscribe_type == 3) {
                price = total_price;
            } else if (subscribe_type == 2) {
                price = chapter_price;
            }
            if (parseFloat(price, 10) > parseFloat(remained_price, 10)) {
                _dialog.alert("您的余额不足！");
                return;
            }
        }
        var confirmTips = _subscribeConfirmTips[subscribe_type];
        if (!confirmTips) {
            confirmTips = _subscribeConfirmTips[0];
        }
        confirmTips = _util.replaceTpl(confirmTips, {
            'price': price
        });
        _dialog.confirm(confirmTips,
        function() {
            if (_isLoading) {
                return;
            }
            _isLoading = 1;
            _util.request({
                type: "POST",
                dataType: 'json',
                url: _params.subscribeBook_ajaxUrl,
                data: {
                    'cid': cid,
                    'type': subscribe_type,
                    'isauto': isAutoSubscribe
                },
                success: function(json) {
                    if (!json || typeof json.code === 'undefined') {
                        _dialog.alert('服务器端异常，请稍候再试');
                        return;
                    }
                    switch (json.code) {
                    case 0:
                        _bookshelf.addToBookshelf(_params.novel_id, _params.novel_showid, {
                            'successCallback': function() {}
                        });
                        if ('data' in json && 'url' in json.data) {
                            _dialog.open({
                                'content': '订阅成功，正在<a style="color:blue;" href="' + json.data.url + '">跳转</a>'
                            });
                            setTimeout(function() {
                                window.location.href = json.data.url;
                            },
                            1000);
                        }
                        break;
                    case 3:
                        if ('data' in json && 'url' in json.data) {
                            window.location.href = json.data.url;
                        }
                        break;
                    case 1:
                        _dialog.alert("请先登录");
                        break;
                    case 6:
                        _dialog.alert(_notVipUserTips);
                        break;
                    default:
                        if (json.info) {
                            _dialog.alert(json.info);
                        }
                        break;
                    }
                },
                error: function(json, textStatus) {
                    _dialog.alert("网络异常，请稍后再试");
                },
                complete: function() {
                    _isLoading = 0;
                }
            });
        });
    }
    CS.util.initNameSpace("CS");
    CS.vip = {
        'init': init,
        'subscribeBook': subscribeBook
    };
})(jQuery);; (function($) {
    var _util = CS.util,
    _dialog = CS.dialog,
    _loginPopup = CS.loginPopup,
    _uiBinder = CS.uiBinder;
    var _chapterListTpl = ['<% each volumeList as volume i %>', '<h3>', '<a attr="click:foldVolume;" class="contract2" href="javascript:;" title="收起"></a>', '<%=volume.volumeTitle%>', '<% if isLogin %>', '<a attr="click:subscribeVolume;" volumeid="<%=volume.Volumeid%>" class="red2" href="javascript:;">【订阅本卷】</a>', '<% /if %>', '</h3>', '<div class="subscription_wrap" volumeid="<%=volume.Volumeid%>" >', '<p><i class="needgold">所需书币</i><span>章节字数</span> <b>VIP章节名称</b></p>', '<ul class="subscription_list">', '<% each volume.chapters as chapter j %>', '<li>', '<span><%= chapter.p %></span>', '<strong><%= chapter.w %></strong>', '<% if !chapter.isTaked && isLogin && chapter.p %>', '<input attr="click:selectChapter;" name="subscribeCheckbox" type="checkbox" cid="<%= chapter.CID %>" gold="<%= chapter.p %>" />', '<% /if %>', '<a href="<%= chapter.url %>"><%= CS.util.mb_cutstr(chapter.n, 60) %></a>', '</li>', '<% /each %>', '</ul>', '</div>', '<% /each %>'].join('');
    var _params = {},
    _chapterListNodes = null,
    _chapterTipsNodes = null,
    _subscribeBoxNodes = null;
    var _tips = {
        "subscribeSelectedConfirm": "本次订阅将消耗$payGold$书币，您确定吗？",
        "subscribeAllConfirm": "订阅全部章节将消耗$payGold$书币，您确定吗？",
        "subscribeVolumeConfirm": "订阅本卷将消耗$payGold$书币，您确定吗？",
        "noEnoughGold": "您的账户余额不足",
        "noSelectChapter": "请选择要订阅的章节",
        "hasSubscribedAllChapter": "您已经订阅过全部章节",
        "hasSubscribedVolume": "您已经订阅过该卷"
    };
    var _accountBalance = 0;
    function init(cid, nid, getVipChapterList_ajaxUrl, subscribeBook_ajaxUrl, readUrl) {
        _params.cid = cid || '0';
        _params.nid = nid || '0';
        _params.getVipChapterList_ajaxUrl = getVipChapterList_ajaxUrl || '';
        _params.subscribeBook_ajaxUrl = subscribeBook_ajaxUrl || '';
        _params.readUrl = readUrl || '';
    }
    function open() {
        if (!_subscribeBoxNodes) {
            _subscribeBoxNodes = _uiBinder.bindEvent("subscribeBox_submitBox", {
                "subscribeAll": _subscribeAll,
                "subscribeSelected": _subscribeSelected
            });
        }
        if (!_chapterListNodes) {
            _util.request({
                type: "POST",
                dataType: 'json',
                url: _params.getVipChapterList_ajaxUrl,
                data: {
                    "nid": _params.nid
                },
                success: function(json) {
                    if (!json || !json.data || typeof json.data.volume === "undefined" || typeof json.data.balance === "undefined") {
                        _dialog.alert("数据异常，请稍候再试");
                        return;
                    }
                    _accountBalance = json.data.balance;
                    _renderChapterList(json.data.volume);
                },
                error: function(json, textStatus) {
                    _dialog.alert("网络异常，请稍候再试");
                }
            });
        }
        if (!_chapterTipsNodes) {
            _chapterTipsNodes = _uiBinder.bindEvent("subscribeBox_chapterTips", {});
        }
    }
    function _renderChapterList(data) {
        if (!data || data.length === 0) {
            return;
        }
        var normValue = _util.getQueryByName("norm"),
        chapterUrlParams = normValue ? "?norm=" + normValue: '';
        $.each(data,
        function(i, volume) {
            if (volume.chapters) {
                $.each(volume.chapters,
                function(j, chapter) {
                    data[i].chapters[j].url = _getReadPageUrl(chapter.u, _params.readUrl) + chapterUrlParams;
                });
            }
        });
        _chapterListNodes = _uiBinder.appendHTML("subscribeBox_chapterList", _chapterListTpl, {
            "volumeList": data,
            "isLogin": _util.isLogin()
        },
        {
            "foldVolume": _foldVolume,
            "subscribeVolume": _subscribeVolume,
            "selectChapter": _selectChapter
        });
        _renderBottomBox();
    }
    function _renderBottomBox() {
        if (_util.isLogin()) {
            $(_subscribeBoxNodes.root).show();
        } else {
            $("#subscribeBox_loginBtn").click(function() {
                _loginPopup.open();
                return false;
            });
            $("#subscribeBox_nologin").show();
        }
    }
    function _selectChapter(e, el, nodes) {
        var chapterInfo = _getSelectedChapterInfo(nodes.root);
        $(_subscribeBoxNodes.chapterCount).html(chapterInfo.count);
        $(_subscribeBoxNodes.payGold).html(chapterInfo.gold);
        $(_chapterTipsNodes.chapterCount).html(chapterInfo.count);
        $(_chapterTipsNodes.payGold).html(chapterInfo.gold);
        $(_chapterTipsNodes.remainGold).html(_accountBalance);
        $(_chapterTipsNodes.root).appendTo(el.parentNode).end().show();
        var $rechargeTips = $(_subscribeBoxNodes.rechargeTips).add(_chapterTipsNodes.rechargeTips);
        if (_accountBalance < chapterInfo.gold) {
            $rechargeTips.show();
        } else {
            $rechargeTips.hide();
        }
        return true;
    }
    function _subscribeVolume(e, el, nodes) {
        if (!_util.isLogin()) {
            _dialog.alert("请登录后再操作",
            function() {
                _loginPopup.open();
            });
            return;
        }
        var volume_id = $(el).attr("volumeid");
        var chapterInfo = _getSelectedChapterInfo($(nodes.root).find('div[volumeid="' + volume_id + '"]'), true);
        if (chapterInfo.count === 0) {
            _dialog.alert(_tips.hasSubscribedVolume);
            return false;
        }
        if (_accountBalance < chapterInfo.gold) {
            _dialog.alert(_tips.noEnoughGold);
            return false;
        }
        var subscribeTips = _tips.subscribeVolumeConfirm.replace("$payGold$", chapterInfo.gold);
        _dialog.confirm(subscribeTips,
        function() {
            _util.request({
                type: "POST",
                dataType: 'json',
                url: _params.subscribeBook_ajaxUrl,
                data: {
                    "nid": _params.nid,
                    "vid": volume_id,
                    "type": 4
                },
                success: function(json) {
                    if (!json) {
                        _dialog.alert("数据异常，请稍候再试");
                        return;
                    }
                    if (json.status) {
                        _dialog.alert(json.info,
                        function() {
                            if ('data' in json && 'url' in json.data) {
                                window.location.href = json.data.url;
                            }
                        });
                    } else {
                        if (json.info) {
                            _dialog.alert(json.info);
                        }
                    }
                },
                error: function(json, textStatus) {
                    _dialog.alert("网络异常，请稍候再试");
                }
            });
        });
        return false;
    }
    function _subscribeAll(e, el, nodes) {
        var chapterInfo = _getSelectedChapterInfo(_chapterListNodes.root, true);
        if (chapterInfo.count === 0) {
            _dialog.alert(_tips.hasSubscribedAllChapter);
            return false;
        }
        if (_accountBalance < chapterInfo.gold) {
            _dialog.alert(_tips.noEnoughGold);
            return false;
        }
        var isAutoSubscribe = $(_subscribeBoxNodes.checkbox).prop("checked") ? 1 : 0,
        subscribeTips = _tips.subscribeAllConfirm.replace("$payGold$", chapterInfo.gold);
        _dialog.confirm(subscribeTips,
        function() {
            _util.request({
                type: "POST",
                dataType: 'json',
                url: _params.subscribeBook_ajaxUrl,
                data: {
                    "isauto": isAutoSubscribe,
                    "cid": _params.cid,
                    "type": 1
                },
                success: function(json) {
                    if (!json) {
                        _dialog.alert("数据异常，请稍候再试");
                        return;
                    }
                    if (json.status) {
                        _dialog.alert(json.info,
                        function() {
                            if ('data' in json && 'url' in json.data) {
                                window.location.href = json.data.url;
                            }
                        });
                    } else {
                        if (json.info) {
                            _dialog.alert(json.info);
                        }
                    }
                },
                error: function(json, textStatus) {
                    _dialog.alert("网络异常，请稍候再试");
                }
            });
        });
        return false;
    }
    function _subscribeSelected(e, el, nodes) {
        var chapterInfo = _getSelectedChapterInfo(_chapterListNodes.root);
        if (chapterInfo.count === 0) {
            _dialog.alert(_tips.noSelectChapter);
            return false;
        }
        if (_accountBalance < chapterInfo.gold) {
            _dialog.alert(_tips.noEnoughGold);
            return false;
        }
        var isAutoSubscribe = $(_subscribeBoxNodes.checkbox).prop("checked") ? 1 : 0,
        subscribeTips = _tips.subscribeSelectedConfirm.replace("$payGold$", chapterInfo.gold);
        _dialog.confirm(subscribeTips,
        function() {
            _util.request({
                type: "POST",
                dataType: 'json',
                url: _params.subscribeBook_ajaxUrl,
                data: {
                    "isauto": isAutoSubscribe,
                    "nid": _params.nid,
                    "cids": chapterInfo.cids,
                    "type": 3
                },
                success: function(json) {
                    if (!json) {
                        _dialog.alert("数据异常，请稍候再试");
                        return;
                    }
                    if (json.status) {
                        _dialog.alert(json.info,
                        function() {
                            if ('data' in json && 'url' in json.data) {
                                window.location.href = json.data.url;
                            }
                        });
                    } else {
                        if (json.info) {
                            _dialog.alert(json.info);
                        }
                    }
                },
                error: function(json, textStatus) {
                    _dialog.alert("网络异常，请稍候再试");
                }
            });
        });
        return false;
    }
    function _getSelectedChapterInfo(el, isAll) {
        var info = {
            "count": 0,
            "gold": 0,
            "cids": ''
        };
        if (!el) {
            return info;
        }
        var arrCids = [];
        $(el).find('input[type="checkbox"]').each(function() {
            var gold = parseInt($(this).attr("gold"), 10);
            if (isAll) {
                info.count++;
                info.gold += gold;
            } else if ($(this).prop("checked")) {
                info.count++;
                info.gold += gold;
                arrCids.push($(this).attr("cid"));
            }
        });
        if (arrCids.length > 0) {
            info.cids = arrCids.join(',');
        }
        return info;
    }
    function _foldVolume(e, el, nodes) {
        var $el = $(el);
        if ($el.hasClass('contract2')) {
            $el.attr('title', '展开');
            $el.addClass("develop2").removeClass("contract2");
            $el.parent().next("div").animate({
                height: 'toggle',
                opacity: 'toggle'
            },
            "fast");
        } else if ($el.hasClass('develop2')) {
            $el.attr('title', '收起');
            $el.addClass("contract2").removeClass("develop2");
            $el.parent().next("div").animate({
                height: 'toggle',
                opacity: 'toggle'
            },
            "fast");
        }
    }
    function _getReadPageUrl(uuid, readUrl) {
        if (!uuid) {
            return 'javascript:;';
        }
        return readUrl.replace(/(\d)+\.html/, uuid + '.html');
    }
    _util.initNameSpace("CS.page.bookReader");
    CS.page.bookReader.subscribePopup = {
        'init': init,
        'open': open
    };
})(jQuery);; (function($) {
    var _util = CS.util,
    _loginPopup = CS.loginPopup,
    _topTool = null,
    _sideBar = null,
    _vip = null;
    var _params = {},
    _nodes = {},
    _is_loading = 0,
    _chapterList = null;
    var _readChapterNumCookieName = 'readChapterNum';
    function init(novel_idx, arrVolumechapter, content_url, end_url) {
        _params.novel_idx = novel_idx || 0;
        _params.arrVolumechapter = arrVolumechapter || null;
        _params.content_url = content_url || '';
        _params.end_url = end_url || '';
        _topTool = CS.page.bookReader.topTool;
        _sideBar = CS.page.bookReader.sideBar;
        _vip = CS.vip;
        _nodes = {
            'chapterContainer': $('#chaptercontainer')
        };
        $("#top3GBanner").hide();
        _disableMenu();
    }
    function _disableMenu() {
        var returnFn = function() {
            return false;
        };
        document.ondragstart = returnFn;
        document.oncontextmenu = returnFn;
        document.onpaste = returnFn;
        document.oncopy = returnFn;
        document.oncut = returnFn;
        document.onselectstart = returnFn;
    }
    function _getChapterIdList() {
        if (!_params.arrVolumechapter) {
            return null;
        }
        var list = {},
        chapter_list = [];
        $(_params.arrVolumechapter).each(function(volumeIndex, volume) {
            $(volume.chapters).each(function(chapterIndex, chapter) {
                chapter_list.push({
                    'uuid': chapter.uuid,
                    'is_vip': volume.Isvip
                });
            });
        });
        var len = chapter_list.length;
        $(chapter_list).each(function(index, chapter) {
            var pre_uuid = 0,
            next_uuid = 0;
            if (index - 1 >= 0) {
                pre_uuid = chapter_list[index - 1]['uuid'];
            }
            if (index + 1 < len) {
                next_uuid = chapter_list[index + 1]['uuid'];
            }
            list[chapter.uuid] = {
                'uuid': chapter.uuid,
                'pre_uuid': pre_uuid,
                'next_uuid': next_uuid,
                'is_vip': chapter.is_vip
            };
        });
        return list;
    }
    function getPreChapterInfo(uuid) {
        if (!_chapterList) {
            _chapterList = _getChapterIdList();
        }
        if (!_chapterList || !_chapterList[uuid]) {
            return null;
        }
        var pre_uuid = _chapterList[uuid].pre_uuid;
        return _chapterList[pre_uuid];
    }
    function getNextChapterInfo(uuid) {
        if (!_chapterList) {
            _chapterList = _getChapterIdList();
        }
        if (!_chapterList || !_chapterList[uuid]) {
            return null;
        }
        var next_uuid = _chapterList[uuid].next_uuid;
        return _chapterList[next_uuid];
    }
    function getVolumnLastChapterInfo() {
        if (!_chapterList) {
            _chapterList = _getChapterIdList();
        }
        var arrCID = [];
        $.each(_chapterList,
        function(cid, item) {
            arrCID.push(cid);
        });
        return _chapterList[arrCID[arrCID.length - 1]];
    }
    function openPopupByChapterNum() {
        if (!_util.isLogin()) {
            var readCount = $.cookie(_readChapterNumCookieName);
            if (readCount) {
                readCount = parseInt(readCount, 10);
                if (readCount >= 10) {
                    _loginPopup.open();
                    $.cookie(_readChapterNumCookieName, 0);
                } else {
                    $.cookie(_readChapterNumCookieName, readCount + 1);
                }
            } else {
                $.cookie(_readChapterNumCookieName, 1);
            }
        }
    }
    function updateContentImgByOptions(options) {
        options = options || {};
        $('img[chaptercontent]', _nodes.chapterContainer).each(function() {
            var imgUrl = $(this).attr('src'),
            newImgUrl = imgUrl;
            if (options.width > 0) {
                if (imgUrl.indexOf('fontsize') === -1) {
                    newImgUrl = newImgUrl.replace(/(\/)(\d+)(\.html)$/, '$1' + options.width + '$3');
                } else {
                    newImgUrl = newImgUrl.replace(/(\/w\/)(\d+)(\/fontsize\/)/, '$1' + options.width + '$3');
                }
            }
            if (options.fontSize > 0) {
                if (imgUrl.indexOf('fontsize') === -1) {
                    newImgUrl = newImgUrl.replace(/\.html$/, '/fontsize/' + options.fontSize + '.html');
                } else {
                    newImgUrl = newImgUrl.replace(/(\/)(\d+)(\.html)$/, '$1' + options.fontSize + '$3');
                }
            }
            if (imgUrl !== newImgUrl) {
                $(this).attr('src', newImgUrl);
            }
        });
    }
    function loadChapterFromDB(showid, uuid, successCallback) {
        if (!showid || !uuid || _is_loading) {
            return;
        }
        _is_loading = 1;
        var getChapterFromWeb_url = _params.content_url + '?showId=' + showid + '&uuid=' + uuid;
        _util.request({
            type: "POST",
            dataType: 'json',
            url: getChapterFromWeb_url,
            data: {
                'lang': _util.getUserLang(),
                'w': _topTool.getContentWidth(),
                'fontsize': _topTool.getContentFontSize()
            },
            success: function(json) {
                _is_loading = 0;
                if (typeof successCallback === 'function') {
                    successCallback(json, 'db');
                }
            },
            error: function(json) {
                _is_loading = 0;
            }
        });
    }
    function loadBookEndContent(successCallback) {
        if (_is_loading) {
            return;
        }
        _is_loading = 1;
        _util.request({
            type: "POST",
            dataType: 'json',
            url: _params.end_url,
            data: {
                'nid': _params.novel_idx
            },
            success: function(json) {
                _is_loading = 0;
                if (typeof successCallback === 'function') {
                    successCallback(json);
                }
            },
            error: function(json) {
                _is_loading = 0;
            }
        });
    }
    function bindSubscribeChapterEvent() {
        var subscribe_box = $('[subscribebox]:last', _nodes.chapterContainer),
        isbindedEvent = subscribe_box.attr('isbindedevent');
        if (isbindedEvent === '1') {
            return;
        }
        subscribe_box.attr('isbindedevent', '1');
        $('.VIP_order_bottom [actiontype="login"]').on('click',
        function() {
            _loginPopup.open();
            return false;
        });
        $('#subscribeChaptersBtn').on('click',
        function() {
            _sideBar.togglePopup('subscribe');
            return false;
        });
        $('[subscribetype]', subscribe_box).on('click',
        function() {
            var isAutoSubscribe = $('#auto_checkbox').prop('checked') ? 1 : 0;
            _vip.subscribeBook(subscribe_box.attr('cid'), $(this).attr('subscribetype'), isAutoSubscribe, subscribe_box.attr('tp'), subscribe_box.attr('cp'), subscribe_box.attr('rp'));
            return false;
        });
    }
    _util.initNameSpace("CS.page.bookReader");
    CS.page.bookReader.main = {
        'init': init,
        'getPreChapterInfo': getPreChapterInfo,
        'getNextChapterInfo': getNextChapterInfo,
        'getVolumnLastChapterInfo': getVolumnLastChapterInfo,
        'openPopupByChapterNum': openPopupByChapterNum,
        'updateContentImgByOptions': updateContentImgByOptions,
        'loadChapterFromDB': loadChapterFromDB,
        'loadBookEndContent': loadBookEndContent,
        'bindSubscribeChapterEvent': bindSubscribeChapterEvent
    };
})(jQuery);; (function($) {
    var _util = CS.util,
    _dialog = CS.dialog,
    _loginPopup = CS.loginPopup,
    _bookshelf = CS.bookshelf,
    _readerInteract = CS.readerInteract,
    _subscribePopup = CS.page.bookReader.subscribePopup;
    var _params = {},
    _nodes = {};
    function init(novel_idx, novel_showid, addBookmark_ajaxUrl) {
        _params.novel_idx = novel_idx || '0';
        _params.novel_showid = novel_showid || '0';
        _params.addBookmark_ajaxUrl = addBookmark_ajaxUrl || '';
        _nodes = {
            'chapterContainer': $('#chaptercontainer')
        };
        _bindLeftFloatBarEvent();
        _bindRightFloatBarEvent();
        _bindCatalogEvent();
        _initFloatBar();
        readResize();
        $(window).on('resize', readResize);
        if (_util.isIE6()) {
            $(window).on('scroll', readResize);
        }
    }
    function _initFloatBar() {
        var leftFloatBar = $("#leftFloatBar"),
        rightFloatBar = $("#rightFloatBar");
        if (_util.isIE6()) {
            leftFloatBar.css('position', 'absolute');
            rightFloatBar.css('position', 'absolute');
        } else {
            leftFloatBar.css('position', 'fixed');
            rightFloatBar.css('position', 'fixed');
        }
        leftFloatBar.show();
        rightFloatBar.show();
        $('#topNav').addClass('fixed');
    }
    function readResize() {
        var leftFloatBar = $("#leftFloatBar"),
        rightFloatBar = $("#rightFloatBar"),
        isFixed = leftFloatBar.css('position') === 'fixed',
        scroll_left = isFixed ? 0 : _util.getScrollLeft(),
        scroll_top = isFixed ? 0 : _util.getScrollTop(),
        container_width = _nodes.chapterContainer.width(),
        container_left = _nodes.chapterContainer[0].offsetLeft;
        leftFloatBar.css({
            'left': (container_left - leftFloatBar.width() + scroll_left) + "px",
            'top': ($("#chapterTopTool").offset().top + scroll_top) + "px"
        });
        rightFloatBar.css({
            'left': (container_left + container_width + scroll_left + 2) + "px",
            'top': (_util.getClientHeight() - rightFloatBar.height() + scroll_top) + "px"
        });
        var dirContentHeight = $(window).height() - 132,
        subscribeListHeight = dirContentHeight;
        dirContentHeight = dirContentHeight < 70 ? 70 : dirContentHeight;
        $('#dirBox_content').css('height', dirContentHeight + 'px');
        subscribeListHeight -= 55;
        subscribeListHeight = subscribeListHeight < 70 ? 70 : subscribeListHeight;
        $("#subscribeBox_chapterList").css('height', subscribeListHeight + 'px');
    }
    function _bindLeftFloatBarEvent() {
        $("#toggleDirBoxBtn, #dirBox_closeBtn").on('click',
        function() {
            togglePopup("dir");
            return false;
        });
        $("#toggleSubscribeBoxBtn, #subscribeBox_closeBtn").on('click',
        function() {
            togglePopup("subscribe");
            return false;
        });
    }
    function _bindRightFloatBarEvent() {
        $('#addBookToBookshelfBtn').on('click',
        function() {
            _bookshelf.addToBookshelf(_params.novel_idx, _params.novel_showid);
            return false;
        });
        $("#addWebmark").click(function() {
            _addBookmark();
            return false;
        });
        $('#openRewardPopupBtn').on('click',
        function() {
            return _readerInteract.openPopup('reward');
        });
        $('#openVotePopupBtn').on('click',
        function() {
            return _readerInteract.openPopup('recommend');
        });
        $('#openMonthPopupBtn').on('click',
        function() {
            return _readerInteract.openPopup('monthTicket');
        });
    }
    function togglePopup(boxType) {
        var boxInfo = {
            "dir": {
                "$box": $('#dirBox'),
                "$toggleBtn": $("#toggleDirBoxBtn"),
                "boxComponent": null
            },
            "subscribe": {
                "$box": $('#subscribeBox'),
                "$toggleBtn": $("#toggleSubscribeBoxBtn"),
                "boxComponent": _subscribePopup
            }
        };
        if (!boxType || !boxInfo[boxType]) {
            return;
        }
        $.each(boxInfo,
        function(type, item) {
            if (type === boxType) {
                if (item.$box.css('display') === 'none') {
                    if (item.boxComponent && typeof item.boxComponent.open === 'function') {
                        item.boxComponent.open();
                    }
                    item.$box.show();
                    item.$toggleBtn.parent().attr("id", "rclick");
                } else {
                    item.$box.hide();
                    item.$toggleBtn.parent().removeAttr("id");
                }
            } else {
                if (item.$box.css('display') !== 'none') {
                    item.$box.hide();
                    item.$toggleBtn.parent().removeAttr("id");
                }
            }
        });
    }
    function _bindCatalogEvent() {
        $('#dirBox_content [actiontype="fold"]').on('click',
        function() {
            var $el = $(this);
            if ($el.hasClass('contract2')) {
                $el.attr('title', '展开');
                $el.addClass("develop2").removeClass("contract2");
                $el.parent().next("div").animate({
                    height: 'toggle',
                    opacity: 'toggle'
                },
                "fast");
            } else if ($el.hasClass('develop2')) {
                $el.attr('title', '收起');
                $el.addClass("contract2").removeClass("develop2");
                $el.parent().next("div").animate({
                    height: 'toggle',
                    opacity: 'toggle'
                },
                "fast");
            }
            return false;
        });
    }
    function _addBookmark() {
        if (!_util.isLogin()) {
            _loginPopup.open();
            return;
        }
        _util.request({
            type: "POST",
            dataType: 'json',
            url: _params.addBookmark_ajaxUrl,
            data: {
                "cid": $("#addWebmark").attr("cid")
            },
            success: function(data) {
                if (data && data.info) {
                    _dialog.alert(data.info);
                }
            },
            error: function(data, textStatus) {}
        });
    }
    CS.util.initNameSpace("CS.page.bookReader");
    CS.page.bookReader.sideBar = {
        'init': init,
        'readResize': readResize,
        'togglePopup': togglePopup
    };
})(jQuery);; (function($) {
    var _util = CS.util,
    _uiBinder = CS.uiBinder,
    _mask = CS.mask,
    _sideBar = null,
    _main = CS.page.bookReader.main;
    var _params = {},
    _nodes = {},
    _masks = {},
    _readModePopup_nodes = null;
    var _topTool_widthStep = 20,
    _defaultWidth = 920,
    _defaultFontSize = 14,
    _defaultBgColor = 'blue',
    _defaultReadMode = '2';
    var bgCookieName = 'read_bg',
    fontSizeCookieName = 'fontsize',
    readModeCookieName = 'readmode',
    widthCookieName = 'width';
    var _isAutoScroll = 0,
    _autoScrollInterval = null,
    _autoScrollIntervalTime = 200,
    _autoScrollStep = 1;
    var bgConfig = {
        "blue": {
            "cssName": "background",
            "cssValue": "#E9FAFF"
        },
        "yellow": {
            "cssName": "background",
            "cssValue": "#FFFFED"
        },
        "green": {
            "cssName": "background",
            "cssValue": "#EEFAEE"
        },
        "purple": {
            "cssName": "background",
            "cssValue": "#FCEFFF"
        },
        "white": {
            "cssName": "background",
            "cssValue": "#FFF"
        },
        "grey": {
            "cssName": "background",
            "cssValue": "#EFEFEF"
        },
        "parchment": {
            "cssName": "background-image",
            "cssValue": "url($imgUrl$/sheep_bg.png)"
        }
    };
    var _readMode_html = ['<div attr="inner:popup;" class="reader_mode_popup" style="display:none;">', '<h1>', '<a attr="click:closePopup" class="close_btn" href="javascript:" title="关闭"></a>设置阅读模式', '</h1>', '<div class="select_mode cf">', '<p>瀑布阅读</p>', '<span>传统翻页</span>', '<a attr="inner:scrollModeBtn;click:switchMode;" readmode="1" class="y_read" href="javascript:" title="瀑布阅读">瀑布阅读</a>', '<a attr="inner:clickModeBtn;click:switchMode;" readmode="2" class="x_read" href="javascript:" title="传统翻页">传统翻页</a>', '</div>', '</div>'].join('');
    function init(readPageType, imgUrl) {
        _params.readPageType = readPageType || 'page';
        _params.imgUrl = imgUrl || '';
        bgConfig['parchment']['cssValue'] = _util.replaceTpl(bgConfig['parchment']['cssValue'], {
            'imgUrl': _params.imgUrl
        });
        _nodes = {
            'chapterContainer': $('#chaptercontainer'),
            'chapterTopTool': $('#chapterTopTool')
        };
        _sideBar = CS.page.bookReader.sideBar;
        _bind_topTool_event();
        _setCssByCookie();
    }
    function _bind_topTool_event() {
        var $topBtnList = $('#read_tool li'),
        $topToolPopup = $topBtnList.find('.popup_wrap');
        $topBtnList.on('click',
        function() {
            var $popup = $(this).find(".popup_wrap");
            if ($popup.length) {
                if ($popup.is(":hidden")) {
                    $topToolPopup.hide();
                    $popup.fadeIn(200);
                } else {
                    $popup.fadeOut(200);
                }
            }
            return false;
        });
        $('#setup_ico').on('click',
        function() {
            $topToolPopup.hide();
            _openReadModePopup();
            return false;
        });
        var $bgPopup_setColorBtn = $('#bgPopup_setColorBtnList a');
        $bgPopup_setColorBtn.on('click',
        function() {
            var $this = $(this),
            colorType = $this.attr('colortype'),
            config = bgConfig[colorType];
            $bgPopup_setColorBtn.removeClass('color_cur');
            $(this).addClass('color_cur');
            _setChapterBG(colorType, config['cssName'], config['cssValue']);
            return false;
        });
        var $fontSizePopup_setBtn = $('#fontSizePopup input');
        $fontSizePopup_setBtn.on('click',
        function() {
            var fontSize = parseInt($(this).attr('fontsize'), 10);
            $fontSizePopup_setBtn.removeClass('font_cur');
            $(this).addClass('font_cur');
            _changeChapterFontSize(fontSize);
            return false;
        });
        var $widthPopup_setBtn = $('#widthPopup input');
        $widthPopup_setBtn.on('click',
        function() {
            var width = parseInt($(this).attr('w'), 10);
            $widthPopup_setBtn.removeClass('font_cur');
            $(this).addClass('font_cur');
            _setChapterWidth(width);
            return false;
        });
        $(document).on('dblclick',
        function() {
            if (_autoScrollInterval) {
                _autoScrollInterval = clearInterval(_autoScrollInterval);
            } else {
                _autoScrollInterval = setInterval(_autoScroll, _autoScrollIntervalTime);
            }
        });
        $topToolPopup.on('click',
        function() {
            return false;
        });
        $(document).on("click",
        function(e) {
            var target = $(e.target);
            if (target.closest('#read_tool li').length === 0) {
                $topToolPopup.fadeOut(200);
            }
        });
    }
    function _autoScroll() {
        window.scrollBy(0, _autoScrollStep);
        if (_params.readPageType === 'page') {
            var clientHeight = _util.getClientHeight(),
            scrollHeight = _util.getScrollHeight(),
            scrollTop = _util.getScrollTop();
            if (clientHeight + scrollTop >= scrollHeight) {
                if (_autoScrollInterval) {
                    _autoScrollInterval = clearInterval(_autoScrollInterval);
                }
                var nextChapterBtn = document.getElementById('nextChapterBtn');
                if (nextChapterBtn) {
                    nextChapterBtn.click();
                }
            }
        }
    }
    function _openReadModePopup() {
        if (!_readModePopup_nodes) {
            _readModePopup_nodes = _uiBinder.appendHTML(document.body, _readMode_html, {
                'readUrl': window.location.href
            },
            {
                'closePopup': function() {
                    _masks.readModePopup.close();
                },
                'switchMode': _switchReadMode
            });
            _masks.readModePopup = new _mask(_readModePopup_nodes.popup);
        }
        if (_readModePopup_nodes) {
            var readMode = $.cookie(readModeCookieName) || _defaultReadMode;
            if (readMode === '1') {
                $(_readModePopup_nodes.scrollModeBtn).addClass('y_cur').css('cursor', 'default');
            } else {
                $(_readModePopup_nodes.clickModeBtn).addClass('x_cur').css('cursor', 'default');
            }
            _masks.readModePopup.open();
        }
    }
    function _switchReadMode(e, el, nodes) {
        var $el = $(el),
        readMode = $.cookie(readModeCookieName) || _defaultReadMode;
        if ($el.attr('readmode') === readMode) {
            return false;
        }
        $.cookie(readModeCookieName, $el.attr('readmode'), {
            'expires': 365
        });
        setTimeout(function() {
            window.location.reload();
        },
        100);
        return false;
    }
    function _setChapterWidth(width) {
        if (width > 0) {
            _nodes.chapterTopTool.css('width', width - _topTool_widthStep + 'px');
            _nodes.chapterContainer.add('#bottomTool').css('width', width + 'px');
            _sideBar.readResize();
            $.cookie(widthCookieName, width, {
                expires: 365
            });
            _main.updateContentImgByOptions({
                'width': width - 90
            });
        }
        return false;
    }
    function _setChapterBG(colorType, cssName, cssValue) {
        $(".textbox", _nodes.chapterContainer).add('#bottomTool').css(cssName, cssValue);
        $.cookie(bgCookieName, colorType, {
            expires: 365
        });
        return false;
    }
    function _changeChapterFontSize(fontSize) {
        if (fontSize > 0) {
            $.cookie(fontSizeCookieName, fontSize, {
                expires: 365
            });
            setTimeout(function() {
                window.location.href = window.location.href;
            },
            100);
        }
        return false;
    }
    function _setCssByCookie() {
        var width = $.cookie(widthCookieName),
        fontSize = $.cookie(fontSizeCookieName),
        bgColor = $.cookie(bgCookieName);
        width = width || _defaultWidth;
        width = parseInt(width, 10);
        _nodes.chapterTopTool.css('width', width - _topTool_widthStep + 'px');
        _nodes.chapterContainer.add('#bottomTool').css('width', width + 'px');
        _sideBar.readResize();
        $('#widthPopup input[w="' + width + '"]').addClass('font_cur');
        fontSize = fontSize || _defaultFontSize;
        fontSize = parseInt(fontSize, 10);
        $('#fontSizePopup input[fontsize="' + fontSize + '"]').addClass('font_cur');
        bgColor = bgColor || _defaultBgColor;
        $('#bgPopup_setColorBtnList a[colortype="' + bgColor + '"]').addClass('color_cur');
    }
    function getContentWidth() {
        var width = parseInt($.cookie(widthCookieName) || _defaultWidth, 10) - 90;
        return width;
    }
    function getContentFontSize() {
        var fontSize = parseInt($.cookie(fontSizeCookieName) || _defaultFontSize, 10);
        return fontSize;
    }
    _util.initNameSpace("CS.page.bookReader");
    CS.page.bookReader.topTool = {
        'init': init,
        'getContentWidth': getContentWidth,
        'getContentFontSize': getContentFontSize,
        'bgCookieName': bgCookieName,
        'fontSizeCookieName': fontSizeCookieName,
        'readModeCookieName': readModeCookieName,
        'widthCookieName': widthCookieName,
        'bgConfig': bgConfig
    };
})(jQuery);; (function($) {
    var _util = CS.util,
    _dialog = CS.dialog,
    _loginPopup = CS.loginPopup,
    _vip = CS.vip,
    _main = CS.page.bookReader.main,
    _sideBar = CS.page.bookReader.sideBar,
    _topTool = CS.page.bookReader.topTool;
    var _params = {},
    _scroll_bottom_height = 300,
    _contentTips = '《$bookName$》最新章节由创世中文网首发，最新最火最快网络小说首发地！（本站提供：传统翻页、瀑布阅读两种模式，可在设置中选择）';
    var _wrap = null,
    _chapter_list = null;
    function init(novel_idx, showid, uuid, cid, last_cid, bookName, bookAuthor, content_url, cdn_url, cdnWebsiteId, end_url) {
        _params.novel_idx = novel_idx || 0;
        _params.showid = showid || 0;
        _params.uuid = uuid || 0;
        _params.cid = cid || 0;
        _params.last_cid = last_cid || 0;
        _params.bookName = bookName || '';
        _params.bookAuthor = bookAuthor || '';
        _params.content_url = content_url || '';
        _params.cdn_url = cdn_url || '';
        _params.cdnWebsiteId = cdnWebsiteId || 0;
        _params.end_url = end_url || '';
        _wrap = $("#wrap");
        _chapter_list = $('#chaptercontainer');
        if (!_chapter_list) {
            return;
        }
        _loadChapterContent(_params.uuid);
        _updateBookmarkCID();
    }
    function _updateBookmarkCID() {
        if (_params.last_cid) {
            $("#addWebmark").attr("cid", _params.last_cid);
        }
    }
    function _loadChapterContent(uuid) {
        if (!uuid) {
            return;
        }
        _main.loadChapterFromDB(_params.showid, uuid, _loadChapterSuccessCallback);
    }
    function _loadChapterSuccessCallback(data, dataSource) {
    	 var d = eval("("+data+")");
        if (!d || !d['Content']) {
            return;
        }
        var chapter = {
            "uuid": d["uuid"],
            "vip": d['Vip'],
            "content": d['Content']
        };
        _chapter_list.append(chapter['content']);
        _setChapterStyle(dataSource);
        _main.bindSubscribeChapterEvent();
        var nextChapterInfo = _main.getNextChapterInfo(chapter['uuid']),
        next_uuid = nextChapterInfo ? nextChapterInfo['uuid'] : 0;
        if (!next_uuid) {
            _main.loadBookEndContent(_loadBookEndContentSuccessCallback);
            return;
        }
        if (chapter['vip'] === 0 || chapter['vip'] === '0') {
            return;
        }
        debugger;
        _loadChapterContent(next_uuid);
    }
    function _loadBookEndContentSuccessCallback(json) {
        if (json && json.Content) {
            _chapter_list.append(json.Content);
            _setChapterBG();
        }
    }
    function _setChapterStyle(dataSource) {
        var book_info = _chapter_list.find('.textinfo:last a'),
        fontSize = $.cookie(_topTool.fontSizeCookieName);
        $('.bottom_tool:last', _chapter_list).hide();
        if (dataSource === 'cdn') {
            _contentTips = _contentTips.replace('$bookName$', _params.bookName);
            _contentTips = _util.sim2tra(_contentTips);
            $('.bookreadercontent p:last', _chapter_list).html(_contentTips);
        }
        $(book_info[0]).html(_params.bookName);
        $(book_info[1]).html(_params.bookAuthor);
        if (fontSize) {
            _chapter_list.find(".bookreadercontent:last").css("font-size", fontSize + 'px');
        }
        _setChapterBG();
    }
    function _setChapterBG() {
        var bgKey = $.cookie(_topTool.bgCookieName);
        if (bgKey) {
            var bgConfig = _topTool.bgConfig[bgKey];
            _chapter_list.find(".textbox:last").css(bgConfig['cssName'], bgConfig['cssValue']);
        }
    }
    _util.initNameSpace("CS.page.bookReader");
    CS.page.bookReader.readByAll = {
        'init': init
    };
})(jQuery);