﻿/* 
 批量“加入到我的企业”按钮跳转
  cids:课程ID,多个以","分隔
source：页面标识
 sform：来源
 type:提交类型（single-单个，batch-批量）
*/
function gotoAddFCourseToEl(cids, source, sform, type) {
    checkLogin2(function () {
        var urlParms = "";
        if (type == "single") {
            var url = "/index/freecoursetoelconfirm.htm";
            url += "?id=" + cids + "&source=" + source + "&sform=" + sform;
            location.href = url;
        }
        else if (type == "batch") {
            urlParms = "?cids=" + cids;
            urlParms += "&source=" + source;
            urlParms += "&sform=" + sform;
            AjaxPostUrlParameters("index_freecoursetoelconfirm", urlParms, false);
        }
    
     }, false, true);
}



/* 课程"立即购买"跳转 */
function gotoBuyCourse(version,cid, count, sform) {
    if (version != "30") {
        showWarningMsg("当前操作不可用");
        return;
    }

    var url = '/index/orderconfirm.htm';
    url += "?id=" + cid + "&count=" + count + "&source=0";

    if (sform) {
        url += "&sform=" + sform;
    }

    location.href = url;
}



/*选课车抛物线运动效果*/
var funParabola = function (element, target, options) {
    var defaults = {
        speed: 166.67,
        curvature: 0.001,
        progress: function () { },
        complete: function () { }
    };

    var params = {}; options = options || {};

    for (var key in defaults) {
        params[key] = options[key] || defaults[key];
    }

    var exports = {
        mark: function () { return this; },
        position: function () { return this; },
        move: function () { return this; },
        init: function () { return this; }
    };

    var moveStyle = "margin", testDiv = document.createElement("div");
    if ("oninput" in testDiv) {
        ["", "ms", "webkit"].forEach(function (prefix) {
            var transform = prefix + (prefix ? "T" : "t") + "ransform";
            if (transform in testDiv.style) {
                moveStyle = transform;
            }
        });
    }

    var a = params.curvature, b = 0, c = 0;

    var flagMove = true;

    if (element && target && element.nodeType == 1 && target.nodeType == 1) {
        var rectElement = {}, rectTarget = {};

        var centerElement = {}, centerTarget = {};

        var coordElement = {}, coordTarget = {};

        exports.mark = function () {
            if (flagMove == false) return this;
            if (typeof coordElement.x == "undefined") this.position();
            element.setAttribute("data-center", [coordElement.x, coordElement.y].join());
            target.setAttribute("data-center", [coordTarget.x, coordTarget.y].join());
            return this;
        }

        exports.position = function () {
            if (flagMove == false) return this;

            //  var scrollLeft = document.documentElement.scrollLeft || document.body.scrollLeft,
            //	scrollTop = document.documentElement.scrollTop || document.body.scrollTop;

            if (moveStyle == "margin") {
                element.style.marginLeft = element.style.marginTop = "0px";
            } else {
                element.style[moveStyle] = "translate(0, 0)";
            }

            rectElement = element.getBoundingClientRect();
            rectTarget = target.getBoundingClientRect();

            centerElement = {
                // x: rectElement.left + (rectElement.right - rectElement.left) / 2 + scrollLeft,
                x: rectElement.left + (rectElement.right - rectElement.left) / 2,
                y: rectElement.top + (rectElement.bottom - rectElement.top) / 2
                // y: rectElement.top + (rectElement.bottom - rectElement.top) / 2 + scrollTop
            };

            centerTarget = {
                //  x: rectTarget.left + (rectTarget.right - rectTarget.left) / 2 + scrollLeft,
                x: rectTarget.left + (rectTarget.right - rectTarget.left) / 2,
                y: rectTarget.top + (rectTarget.bottom - rectTarget.top) / 2
                //  y: rectTarget.top + (rectTarget.bottom - rectTarget.top) / 2 + scrollTop
            };

            coordElement = {
                x: 0,
                y: 0
            };
            coordTarget = {
                x: -1 * (centerElement.x - centerTarget.x),
                y: -1 * (centerElement.y - centerTarget.y)
            };


            b = (coordTarget.y - a * coordTarget.x * coordTarget.x) / coordTarget.x;

            return this;
        };

        exports.move = function () {
            if (flagMove == false) return this;

            var startx = 0, rate = coordTarget.x > 0 ? 1 : -1;

            var step = function () {
                var tangent = 2 * a * startx + b; // = y / x
                // (tangent * x)^2 + x*x = speed
                // x = Math.sqr(speed / (tangent * tangent + 1));
                startx = startx + rate * Math.sqrt(params.speed / (tangent * tangent + 1));

                if ((rate == 1 && startx > coordTarget.x) || (rate == -1 && startx < coordTarget.x)) {
                    startx = coordTarget.x;
                }
                var x = startx, y = a * x * x + b * x;

                element.setAttribute("data-center", [Math.round(x), Math.round(y)].join());

                if (moveStyle == "margin") {
                    element.style.marginLeft = x + "px";
                    element.style.marginTop = y + "px";
                } else {
                    element.style[moveStyle] = "translate(" + [x + "px", y + "px"].join() + ")";
                }

                if (startx !== coordTarget.x) {
                    params.progress(x, y);
                    window.requestAnimationFrame(step);
                } else {

                    params.complete();
                    flagMove = true;
                }
            };
            window.requestAnimationFrame(step);
            flagMove = false;

            return this;
        };

        exports.init = function () {
            this.position().mark().move();
        };
    }

    return exports;
};

/*抛物线移动*/
function customAnimation(sender) {
    var eleFlyElement = document.querySelector("#flyItem");
    var eleShopCart = document.querySelector("#shopCart");

    // 抛物线运动
    var myParabola = funParabola(eleFlyElement, eleShopCart, {
        speed: 100,
        curvature: 0.002,
        complete: function () {
            eleFlyElement.style.display = "none";
        }
    });

    // 滚动大小
    var x = sender.getBoundingClientRect().left;
    var y = sender.getBoundingClientRect().top;
    //    sender.className = "shoppcart2";
    //    $(sender).unbind("click");
    eleFlyElement.style.left = x + "px";
    eleFlyElement.style.top = y + "px";
    eleFlyElement.style.display = "block";
    eleFlyElement.style.position = "fixed";
    // 需要重定位
    myParabola.position().move();
}

/*平滑移动*/
function newAnimation(sender) {
    var x = sender.getBoundingClientRect().left;
    var y = sender.getBoundingClientRect().top;
    right = $(window).width() - x - $(sender).outerWidth();
    $(sender).addClass("shoppingcarthover ");
    $(sender).css({ "position": "fixed", "right": right + "px", "top": y, "margin": "0", "z-index": "99" });
    $(sender).animate({ "top": "310px", "right": "70px" }, 800).fadeOut("fast");
}

/*
*解析地址栏的参数
*@parameter[url]:地址栏
*@return:数组arr[name]=value
*创建人：赵扬
*创建时间：2014-4-17 10:47:45
*/
function getUrlParameterArray(url) {
    var arr = new Array();
    var pos = url.indexOf("?");
    if (pos > -1) {
        var search = url.substring(pos + 1);
        var tempArr = search.split("&");
        for (var i = 0; i < tempArr.length; i++) {
            var kvArr = tempArr[i].split("=");
            if (kvArr.length == 2) {
                arr[kvArr[0]] = kvArr[1];
            }
        }
    }
    return arr;
}

(function () {

    var special = jQuery.event.special,
        uid1 = 'D' + (+new Date()),
        uid2 = 'D' + (+new Date() + 1);

    special.scrollstart = {
        setup: function () {
            var timer,
                handler = function (evt) {
                    var _self = this,
                        _args = arguments;
                    if (timer) {
                        clearTimeout(timer);
                    } else {
                        evt.type = 'scrollstart';
                        jQuery.event.handle.apply(_self, _args);
                    }
                    timer = setTimeout(function () {
                        timer = null;
                    }, special.scrollstop.latency);
                };
            jQuery(this).bind('scroll', handler).data(uid1, handler);
        },
        teardown: function () {
            jQuery(this).unbind('scroll', jQuery(this).data(uid1));
        }
    };

    special.scrollstop = {
        latency: 3000,
        setup: function () {
            var timer,
                    handler = function (evt) {
                        var _self = this,
                        _args = arguments;
                        if (timer) {
                            clearTimeout(timer);
                        }
                        timer = setTimeout(function () {
                            timer = null;
                            evt.type = 'scrollstop';
                            jQuery.event.handle.apply(_self, _args);

                        }, special.scrollstop.latency);
                    };
            jQuery(this).bind('scroll', handler).data(uid2, handler);

        },
        teardown: function () {
            jQuery(this).unbind('scroll', jQuery(this).data(uid2));
        }
    };
})();

//2015-1-19添加了注释
$(function () {
    var lastTime = 0;
    var vendors = ['webkit', 'moz'];
    for (var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
        window.requestAnimationFrame = window[vendors[x] + 'RequestAnimationFrame'];
        window.cancelAnimationFrame = window[vendors[x] + 'CancelAnimationFrame'] ||    // name has changed in Webkit
                                      window[vendors[x] + 'CancelRequestAnimationFrame'];
    }

    if (!window.requestAnimationFrame) {
        window.requestAnimationFrame = function (callback, element) {
            var currTime = new Date().getTime();
            var timeToCall = Math.max(0, 16.7 - (currTime - lastTime));
            var id = window.setTimeout(function () {
                callback(currTime + timeToCall);
            }, timeToCall);
            lastTime = currTime + timeToCall;
            return id;
        };
    }
    if (!window.cancelAnimationFrame) {
        window.cancelAnimationFrame = function (id) {
            clearTimeout(id);
        };
    }

    //2015-1-19 注释此段js 原因：网页没有引用到  
    //	$('#back-top').css({"visibility":"hidden","opacity":"0"});
    //	$(window).scroll(function () {
    //		if ($(this).scrollTop() > 100) {
    //			if($("#back-top").css("visibility") == "hidden")
    //				$('#back-top').stop(true,true).css({"visibility":"visible"}).animate({"opacity":"1"},300);
    //		} else {
    //			$('#back-top').stop(true,true).animate({"opacity":"0"},300,function(){
    //				$(this).css("visibility","hidden");
    //			});
    //		}
    //    });
    //    $('#back-top').click(function () {
    //        //IE,FireFox版本下
    //        var iEScrollTop = $("html").scrollTop();
    //        //chrome浏览器下
    //        var chromeScrollTop = $("body").scrollTop();
    //        if (iEScrollTop > 0) {
    //            $("html").animate({
    //                scrollTop: 0
    //            }, 800);
    //        }
    //        else if (chromeScrollTop > 0) {
    //            $("body").animate({
    //                scrollTop: 0
    //            }, 800);
    //        }
    //        return false;
    //    });
 
    $.fn.hoverDelay = function (options) {
        var defaults = {
            hoverDuring: 200,
            outDuring: 200,
            hoverEvent: function () {
                $.noop();
            },
            outEvent: function () {
                $.noop();
            }
        };
        var sets = $.extend(defaults, options || {});
        var hoverTimer, outTimer;
        return $(this).each(function () {
            $(this).hover(function () {
                clearTimeout(outTimer);
                hoverTimer = setTimeout(sets.hoverEvent, sets.hoverDuring);
            }, function () {
                clearTimeout(hoverTimer);
                outTimer = setTimeout(sets.outEvent, sets.outDuring);
            });
        });
    }

    $('.pagebody').css('min-height', $(window).height() - 155); //页面最小高度
    $('<span>').addClass('tag-courseb-i').appendTo('.tag-courseb');
    $('<span>').addClass('tag-free-i').appendTo('.tag-free');
    $('<span>').addClass('tag-courseb-s-i').appendTo('.tag-courseb-s');
    $('<span>').addClass('tag-free-s-i').appendTo('<div class="tag-free-s"></div>');
    //【全部课程】 左侧导航 鼠标移入 右侧展示二级导航块 效果
    $(".all-c .body").mouseover(function () {
        var right = $(".body .outer");
        var html = $(this).find('ul').html();
        html = $.trim(html);
        if (html != "") {
            $(this).find('.outer').show();
            $(this).one("mouseout", function () {
                $(this).find('.outer').hide();
            });
        }
    });
    for (var i = 0; i < 4; i++) {
        if ($('.outer').eq(i).outerHeight() > 330) {
            $('.outer').eq(i).css('top', -110 * i);
        }
    };
    //【猜你喜欢的】 鼠标点击左右按键 下面图片向左向右滚动
    var page = 1;
    var i = 3;
    var speed = 500;
    var perwidth = 220;
    var mgr = 45;
    if ($(".l-you").attr("perNum")) {
        i = parseInt($(".l-you").attr("perNum"));
    }
    if ($(".l-you").attr("perwidth")) {
        perwidth = parseInt($(".l-you").attr("perwidth"));
    }
    if ($(".l-you").attr("mgr")) {
        mgr = parseInt($(".l-you").attr("mgr"));
    }
    perwidth = perwidth + mgr;
    var $parent = $("div.l-you");
    var $show = $parent.find("div.body");
    var $content = $parent.find("div.list");
    var width = perwidth * i;
    var len = $show.find(".c-box").length;
    $show.width(len * perwidth);
    $content.width(len * perwidth - mgr);
    $('#count').text(Math.ceil(len / i));
    $('#to').text(page);
    $(".l-arrow-r").click(function () {
        var pagecount = Math.ceil(len / i);
        if (!$content.is(":animated")) {
            if (page == pagecount) {
                $content.animate({ left: "0px" }, "normal");
                page = 1;
                $('#to').text(page);
            } else {
                $content.animate({ left: '-=' + width }, "normal");
                page++;
                $('#to').text(page);
            }
        }
    });
    $(".l-arrow").click(function () {
        var pagecount = Math.ceil(len / i);
        if (!$content.is(":animated")) {
            if (page == 1) {
                $content.animate({ left: "-=" + width * (pagecount - 1) }, "normal");
                page = pagecount;
                $('#to').text(page);
            } else {
                $content.animate({ left: '+=' + width }, "normal");
                page--;
                $('#to').text(page);
            }
        }



  });
 

    /*
    var $el, leftPos, newWidth;
    EXAMPLE ONE
    */

    /* Add Magic Line markup via JavaScript, because it ain't gonna work without 
    $("#example-one").append("<li id='magic-line'></li>");
    $('<div>').addClass('center').appendTo($magicLine).width($(".current_page_item").width());
    */
    /* Cache it */
    var $magicLine = $("#example-one li");
    var isNotShowMagic = false;
    /*try {
    $magicLine
    .width($(".current_page_item").width())
    .css("left", $(".current_page_item a").position().left - 30)
    .data("origLeft", $magicLine.position().left)
    .data("origWidth", $magicLine.width());
    } catch (e) {
    isNotShowMagic = true;
    $magicLine.hide();
    }

    $("#example-one li").find('a').hover(
    function () {
    $el = $(this);
    leftPos = $el.position().left-30;
    newWidth = $el.parent().width();

    $magicLine.stop().animate({
    left: leftPos,
    width: newWidth,
				
    });
    $('#example-one .center').stop().animate({width: newWidth});
    if($el.position().left != $magicLine.data('origLeft')){
    $(".current_page_item a").css('color','#e4e4e4');
    }else {$(".current_page_item a").css('color','#111');}
    if (isNotShowMagic) {
    $magicLine.show();
    }
    },
    function () {
    $magicLine.stop().animate({
    left: $magicLine.data("origLeft"),
    width: $magicLine.data("origWidth")
    });
    $(".current_page_item a").css('color','#111');
    $('#example-one .center').stop().animate({width: $magicLine.data("origWidth")});
    if (isNotShowMagic) {
    $magicLine.hide();
    }
    });*/

});

function floatbox1_hide() {
    //隐藏公共右侧导航【.floatbox1】2015-2-2
    $('.floatbox1,.floatbox2_entry').animate({ right: '-38' }, 1000).hide(500);
};

/*
*添加到企业大学课程库
*@parameter[courseIDs]:课程IDs
*@parameter[userID]:当前用户ID
*@parameter[source]:来源类型(cart选课车等)
*创建人：赵扬
*创建时间：2014-4-25 19:35:31
*/
function checkOutCart(courseIDs, userID, source) {
    if ((!courseIDs || courseIDs == "") && userID == "") {
        showWarningMsg("请选择要免费添加的课程。",50);
        return;
    }
    var url = '/Index/AddToElearning.aspx?cids=' + courseIDs;
    if (userID) {
        url += "&uid=" + userID;
    }
    if (source) {
        url += "&source=" + source;
    }

    checkLogin2(function () {
        ShowIFrameDialog('添加到企业知识库', 670, 478, url);
    });
}

/*
*添加到选课车
*@parameter[courseID]:课程ID
*@parameter[type]:购物车的商品类型
*@parameter[userID]:当前用户ID
*@parameter[orgID]:当前用户所在机构ID
*@parameter[sender]:当前点击的对象
*@parameter[callback]:回调函数
*创建人：赵扬
*创建时间：2014-4-29 14:53:20
*/
function AddToShoppingCart(courseID, type, userID, orgID, sender, callback,sform) {
    var methodName = 'AddShopCartInfo';
    var arr = '{"id":"' + courseID + '","type":"CourseInfo","userid":"' + userID + '","orgID":"' + orgID + '","sform":"' + sform + '"}';
    AjaxAsyncCallMethod(methodName, arr,
        function (result) {
            var res = result.split("|");
            if (res[0] == "1" || res[0] == "2") {
                try {
                    //默认将选课车小图标隐藏
                    //如果当前对象已经加入到选课车了那么就不做抛物线运动
                    if (res[0] == "1") {
                        customAnimation(sender);
                     }
                    $("input[id='sp" + courseID + "']").each(function (i, e) {
                        $(e).attr("class", "shoppcart2");
                        $(e).get(0).onclick = function () { };
                        $(e).attr("title", "已添加到选课车");
                    });
                } catch (e) { }

                try {
                    if ($("#spShoppingCar").length > 0) {
                        //课程详情页面改变样式，不可点击
                        $("#spShoppingCar").removeClass().addClass("btnaddtoshoppingcartdone").val("已加入选课车");
                        $("#spShoppingCar").unbind("click", LinkShoppingCart);
                    }
                } catch (e) { }

                try {
                    //课程详情（新版）
                    if ($("#btnShoppingCar").length > 0) {
                        //课程详情页面改变样式，不可点击
                        $("#btnShoppingCar").get(0).className = 'btnoranged';
                        $("#btnShoppingCar").get(0).onclick = function () { }
                    }
                } catch (e) { }
                try {
                    var addShoppingCar = $("#spAddShoppingCar");
                    if (addShoppingCar.length > 0) {
                        addShoppingCar.removeClass().addClass("btn-ed");
                        addShoppingCar.val('已加入选课车');
                        addShoppingCar.get(0).onclick = function () { }
                        //如果当前播放的是远程scorm要将播放区域隐藏掉然后再显示加入购物车成功以后弹出页面
                        var dvRemoteScorm = $("#dvRemoteScormIFrame");
                        if (dvRemoteScorm.length > 0) {
                            dvRemoteScorm.hide();
                        }
                        //如果是本地scrom的话就显示出iframe并且iframe的宽和高和弹出框相等
                        if ($("#iframeShape").length > 0) {
                            setMiddleIframe($("#dvRecommandCourse"), $("#iframeShape"));
                        }
                        //加入购物车成功以后在播放区域出现弹出层
                        $("#dvRecommandCourse").show();
                    }
                }
                catch (e) { }

                try {
                    //回调
                    if (callback) {
                        callback();
                    }
                } catch (e) {

                }

                if (res[1] != "") {
                    showWarningMsg(res[1]);
                }
            }
            else if (res[0] == "0") {
                showWarningMsg(res[1]);
            }
        }, false, true, false);
}

/*
*“赞”
*创建人：潘其林
*创建时间：2014-5-23
*/
function LikeIt(courseID, courseFriendlyName, orgID, userID, userName, masterType, callback) {

    var methodName = 'LikeIt';
    var arr = '{"courseID":"' + courseID + '","courseFriendlyName":"' + courseFriendlyName + '","orgID":"' + orgID + '","userID":"' + userID + '","userName":"' + userName + '","masterType":"' + masterType + '"}';

    AjaxAsyncCallMethod(methodName, arr,
        function (result) {
            var res = result.split("|");
            if (res[0] == "0") {
                showWarningMsg(res[1]);
            }
            else if (res[0] == "3") {
                try {
                    //课程详情赞后改变样式
                    $("#spLikeImg").removeClass().addClass("praised");
                    $("#spLikeDetail").attr("onclick", " function () { }");
                } catch (e) { }

                try {
                    //课时预览赞后样式改变
                    $("#spLikeIt").removeClass().addClass("icon-out-active");
                    $('#spLikeIt').attr("onclick", " function () { }");
                    $("#spLikeTip").text('已赞');
                    //将赞的数量加+1
                    var likeCount = parseInt($("#spLikeCount").text()); 
                    likeCount = likeCount + 1;
                    $("#spLikeCount").text(likeCount);
                } catch (e) { }

                try {
                    //回调
                    if (callback) {
                        callback();
                    }
                } catch (e) {

                }
            }
            else {

                try {
                    //课程详情赞后改变样式
                    $("#spLikeImg").removeClass().addClass("praised");
                    $("#spLikeDetail").attr("onclick", " function () { }");
                } catch (e) { }

                try {
                    //课时预览赞后样式改变
                    $("#spLikeIt").removeClass().addClass("icon-out-active");
                    $('#spLikeIt').attr("onclick", " function () { }");
                    $("#spLikeTip").text('已赞');
                    //将赞的数量加+1
                    var likeCount = parseInt($("#spLikeCount").text()); 
                    likeCount = likeCount + 1;
                    $("#spLikeCount").text(likeCount);
                } catch (e) { }

                try {
                    //回调
                    if (callback) {
                        callback();
                    }
                } catch (e) {

                }
            }
        }, false, true, false, true);
}

/*
*“收藏”
*@parameter[objectID]:操作对象ID
*@parameter[objectFriendlyName]:对象友好名称
*@parameter[orgID]:当前用户机构名称
*@parameter[userID]:当前用户机构编号
*@parameter[userName]:当前用户站点名称
*@parameter[masterType]:操作对象类型
*创建人：潘其林
*创建时间：2014-7-23s
*/
function FavoriteIt(objectID, objectFriendlyName, orgID, userID, userName, masterType, callback) {
   
    var methodName = 'FavoriteIt';
    var arr = '{"objectID":"' + objectID + '","objectFriendlyName":"' + objectFriendlyName + '","orgID":"' + orgID + '","userID":"' + userID + '","userName":"' + userName +'","masterType":"' + masterType + '"}';

    AjaxAsyncCallMethod(methodName, arr,
        function (result) {
            var res = result.split("|");
            if (res[0] == "0") {
                showWarningMsg(res[1]);
            }
            else if (res[0] == "3") {
                try {
                    //课程详情收藏后改变样式
                    $("#spFavoriteImg").removeClass().addClass("saved");
                    $("#spFavorite").attr("onclick", " function () { }");
                } catch (e) { }

                try {
                    //课时预览中的收藏后改变样式
                    $("#spFavoriteIt").removeClass().addClass("icon-out-active");
                    $('#spFavoriteIt').attr("onclick", " function () { }");
                    $('#spFavoriteTip').text('已收藏');
                } catch (e) { }

                try {
                    //回调
                    if (callback) {
                        callback();
                    }
                } catch (e) {

                }
            }
            else {

                try {
                    //课程详情收藏后改变样式
                    $("#spFavoriteImg").removeClass().addClass("saved");
                    $("#spFavorite").attr("onclick", " function () { }");
                } catch (e) { }

                try {
                    //课程预览中的收藏后改变样式
                    $("#spFavoriteIt").removeClass().addClass("icon-out-active");
                    $('#spFavoriteIt').attr("onclick", " function () { }");
                    $('#spFavoriteTip').text('已收藏');
                } catch (e) { }

                try {
                    //回调
                    if (callback) {
                        callback();
                    }
                } catch (e) {

                }
            }
        }, false, true, false, true);
}
/*
*在线咨询
*@parameter[uName]:当前用户名
*@parameter[cnName]:当前姓名
*@parameter[oName]:当前用户机构名称
*@parameter[oCode]:当前用户机构编号
*@parameter[siteName]:当前用户站点名称
*@parameter[pName]:当前页面名称
*@parameter[n]:在线客服号码，值为"n=yxt100"
*创建人：陈明明
*创建时间：2014-5-15
*/
function openChat_ymall(uName, cnName, oName, oCode, siteName, pName, n) {
    var wid = "height=450,width=650,directories=no,location=no,menubar=no,resizable=yes,status=no,toolbar=no,top=100,left=200";
    cnName = escape(cnName);
    oName = escape(oName);
    siteName = escape(siteName);
    pName = escape(pName);
    var params = '#params:userName,' + uName + ',userCnName,' + cnName + ',orgCode,' + oCode + ',orgName,' + oName + ',webSiteName,' + siteName + ',pageName,' + pName;
    
    var chatURL = "http://chat.looyu.com/chat/chat/p.do?c=52547&" + n;
    if (typeof (doyoo) != 'undefined' && doyoo) {
        var chatURL_d = doyoo.util.chatURL(n);
        chatURL = chatURL_d;
    }
    chatURL += ("&r=" + encodeURIComponent(params));
    window.open(chatURL, '', wid);
}

/*
*资讯预览
*@parameter[id]:资讯id
*创建人：陈明明
*创建时间：2014-5-15
*/
function addInfoDetailClickNum(id) {
    var methodName = "AddInforDetailClickNum";
    var arr = '{"id":"' + id + '"}';
    AjaxAsyncCallMethod(methodName, arr,
        function (result) {

        },
    true, true, false);
}

/*
*增加广告点击记录
*@parameter[adID]:广告ID
*@parameter[adName]:广告名称
*@parameter[orgID]:用户所属机构
*@parameter[userID]:用户ID
*@parameter[userName]:用户名称
*创建人：赵扬
*创建时间：2014-7-14 19:55:25
*/
function addAdClickRecord(adID, adName, orgID, userID, userName) {
    var methodName = "ClickAd";
    var arr = '{"adID":"' + adID + '","adName":"' + adName + '","orgID":"' + orgID + '","userID":"' + userID + '","userName":"' + userName + '"}';
    AjaxAsyncCallMethod(methodName, arr,
        function (result) {
            
        },
    true, true, false);
}

/*
*登出
*创建人：赵扬
*创建时间：2014-5-22
*/
function doLogout() {
    window.location.href = '/Logout.ashx';
}

/*
*登录
*@parameter[url]:登录地址
*创建人：赵扬
*创建时间：2014-5-22
*/
function doLogin(url) {
    window.location.href = url;
}
/*2015-1-19 注释此段js 原因：网页没有引用到
$(function () {
$(".bigitem,.smallitem, .normalitem").hover(function () {
$(this).find(":animated").stop(true);
image = $(this).find("img:eq(0)");
width = $(image).width();
height = $(this).outerHeight();
//console.log(height);
$(image).addClass("noshadow");
$(this).find(".rowhover").css({ "margin-top": "5px" }).animate({ "opacity": "1" }, "fast");
if ($(this).hasClass("bigitem")) {
$(this).find(".figure").css({ "opacity": "0", "background": "#FFF", "border": "1px solid #BBB", "top": "0", "left": "0", "width": "100%", "height": (height - 35) + "px" }).animate({ "left": "-7px", "top": "-7px", "height": height, "opacity": "1", "width": width + 14 + "px" }, "fast");
} else {
$(this).find(".figure").css({ "opacity": "0", "background": "#FFF", "border": "1px solid #BBB", "top": "0", "left": "0", "width": "100%", "height": (height - 35) + "px" }).animate({ "left": "-5px", "top": "-5px", "height": height, "opacity": "1", "width": width + 10 + "px" }, "fast");
}
}, function () {
$(this).find(":animated").stop(true);
$(image).removeClass("noshadow");
$(this).find(".rowhover").animate({ "opacity": "0" }, "fast");
if ($(this).hasClass("bigitem")) {
$(this).find(".figure").animate({ "width": width, "height": (height - 35) + "px", "opacity": "0", "left": "0", "top": "0" }, "fast");
} else {
$(this).find(".figure").animate({ "width": width, "height": (height - 35) + "px", "opacity": "0", "left": "0", "top": "0" }, "fast");
}
});
});
*/
/*
*js改变区域大小（根据容器）
*@parameter[w1]:区域宽度
*@parameter[h1]:区域高度
*@parameter[w2]:容器宽度
*@parameter[h2]:容器高度
*@parameter[bar]:底部控制条高度
*@parameter[obj]:区域对象
*创建人：叶兆利
*创建时间：2014-7-14 20:26:47
*/
function resizeObj(w1, h1, w2, h2, bar, obj) {
    var newW = w1;
    var newH = h1;
    h2 -= bar ;
    if (w1 > w2) {
        if (h1 > h2) {
            if ((w1 / w2) >= (h1 / h2)) {
                //以容器宽为基准
                newW = w2;
                newH = h1 * w2 / w1;
            }
            else {
                //以容器高为基准
                newW = w1 * h2 / h1;
                newH = h2;
            }
        }
        else {
            //以容器宽为基准
            newW = w2;
            newH = h1 * w2 / w1;
        }
    }
    else {
        if (h1 > h2) {
            //以容器高为基准
            newW = w1 * h2 / h1;
            newH = h2;
        }
    }

    if (newW <= w2 && newH <= h2) {
        try {
            $(obj).attr("width", newW + "px");
            $(obj).attr("height", newH + "px");
        } catch (e) {
            return;
        }
    }
    else {
        resizeObj(newW, newH, w2, h2, bar, obj);
    } 
}

/*
 *过滤参数中的单引号和双引号
 *@parameter[]:要过滤的参数
 *创建人：潘其林
 *创建时间：2014-9-4 14:26:47
*/
function filter(para) {
    //将参数中的双引号去除
    para = para.replace(/^\"|\"/g, "");
    //将查询框中的单引号去除
    para = para.replace(/\'/g, "");
    //将查询框中的<>符号去掉
    para = para.replace(/\<|\>/g, "");
    return para;
}

/*
 *页面传值（ajax post方式） 建议：Url参数过长时使用            
 *创建人：叶兆利
 *日期：2014年10月29日
 *目标页面Pagecode：targetPagecode或者目标页面地址
 *Url参数：urlparams 格式：?id=xxx&cid=xxx&pid=xxx
 *isShowIFrame：true:使用showiframe方式打开页面;false:页面跳转;
 *title:弹出框的Title名称
 *width:弹出框宽
 *height:弹出框高
*/
function AjaxPostUrlParameters(targetPagecode, urlparams, isShowIFrame, title, width, height) {
    //如果没有isShowIFrame参数时，默认按普通页面跳转方式
    var linkType = false;
    if (isShowIFrame) {
        linkType = true;
    }
    $.ajax({
        type: "POST",
        url: "/Services/AjaxPostUrlParams.ashx",
        data: { "code": targetPagecode, "params": urlparams, "type": linkType },
        datatype: "html",
        success: function (data) {
            if (data.length > 1) {
                if (linkType) {
                    checkLogin2(function () {
                        ShowIFrameDialog(title, width, height, data);
                    });
                }
                else {
                    window.location = data;
                }
            }
            else {
                showWarningMsg("操作失败。");
            }
        },
        error: function () {
            showWarningMsg("请求失败。");
        }
    });
}

/*
*干货频道 我要分享
*@parameter[url]:干货链接网址
*@parameter[cname]:姓名
*@parameter[mobile]:手机
*@parameter[callback]:回调方法
*创建人：叶兆利
*创建时间：2014年11月11日13:45:25
*/
function createNewShare(url, cname, mobile, callback) {
    if (url == "") {
        showWarningMsg("请输入链接网址！");
    }
    else {
        var methodName = 'CreateNewShare';
        var arr = '{"url":"' + url + '","cname":"' + cname + '","mobile":"' + mobile + '"}';
        AjaxAsyncCallMethod(methodName, arr,
        function (result) {
            var res = result.split("|");
            if (res[0] == "1") {
                if (callback) {
                    callback();
                }
                showSuccessMsg("谢谢您分享，我们期待您的下次参与！");
            }
            else if (res[0] == "0") {
                showWarningMsg(res[1]);
            }
        }, true, true, false);
    }
}

/*
*“弹出企业大学指派给员工页面”
*@parameter[courseIDs]:课程ID文本集合
*创建人：潘其林
*创建时间：2014-11-14
*/
function OpenAppointPlanPage(courseIDs) {
    var id = "";
    if (courseIDs != undefined && courseIDs != "") {
        id = courseIDs;
    }
    var methodName = 'GetAppointPlanUrl';
    var arr = '{"courseIDs":"' + id + '"}';

    AjaxAsyncCallMethod(methodName, arr,
        function (result) {
            if (result == "") {
                showWarningMsg("连接超时。");
            }
            else {
                try {
                    //链接到企业大学指派员工页面
                    window.open(result);
                } catch (e) { }
            }
        }, false, true, true);
    }


    /*
    *邮件订阅
    *@parameter[email]:邮箱
    *@parameter[cname]:姓名
    *@parameter[mobile]:手机
    *@parameter[callback]:回调方法
    *创建人：赵华森
    *创建时间：2014-11-24 16:40:44
    */
    function createMailSubscribe(email, cname, mobile, callback) {
        if (url == "") {
            showWarningMsg("请输入邮箱！");
        }
        else {
            var methodName = 'CreateMailSubscribe';
            var arr = '{"email":"' + email + '","cname":"' + cname + '","mobile":"' + mobile + '"}';
            AjaxAsyncCallMethod(methodName, arr,
        function (result) {
            var res = result.split("|");
            if (res[0] == "1") {
                if (callback) {
                    callback();
                }
                showSuccessMsg("订阅成功！");
            }
            else if (res[0] == "0") {
                showWarningMsg(res[1]);
            }
        }, true, true, false);
        }
}

/*
*邮件订阅
*@parameter[email]:邮箱
*@parameter[cname]:姓名
*@parameter[mobile]:手机
*@parameter[callback]:回调方法
*创建人：赵华森
*创建时间：2014-11-24 16:40:44
*/
function createMailSubscribe(email, cname, mobile,emailType, orgID, callback) {
    if (email == "") {
        showWarningMsg("请输入邮箱！");
    }
    else {
        var methodName = 'CreateMailSubscribe';
        var arr = '{"email":"' + email + '","cname":"' + cname + '","mobile":"' + mobile + '","emailType":"' + emailType + '","orgID":"' + orgID + '"}';
        AjaxAsyncCallMethod(methodName, arr,
        function (result) {
            var res = result.split("|");
            if (res[0] == "1") {
                if (callback) {
                    callback();
                }
                showSuccessMsg("订阅成功！");
            }
            else if (res[0] == "0") {
                showWarningMsg(res[1]);
            }
        }, true, true, false);
    }
}


/*
* 如果是本地scorm当点击弹出层的时候在scorm播放器和弹出层中间加一个ifram并且iframe大小和弹出层相同
*（用来解决scorm播放器遮盖弹出层）
*@parameter[dialogObj]:弹出层
*@parameter[middleIframe]:中间层
*创建人：潘其林
*创建时间：2014-12-10
*/
function setMiddleIframe(dialogObj, middleIframe) {
    if (dialogObj == null || middleIframe == null) {
        return;
    }
    middleIframe.show();
    var index = parseInt(dialogObj.css("z-index")); //让iframe显示在课程介绍下面 就是将弹出层的层级大于iframe
    index = index - 1;
    middleIframe.css("position", dialogObj.css("position"));
    middleIframe.css("z-index", index);
    middleIframe.css("background-color", dialogObj.css("background-color"));
    middleIframe.css({ "left": "0",
        "top": "0",
        "width": "100%",
        "height": "100%",
        "border": "0"
    });

}
/*
* 将数值转化成整数部分每三个数字用一个，分割
*@parameter[value]:要转化的数字
*创建人：潘其林
*创建时间：2014-12-31
修改人：叶兆利
时间：2015年3月27日09:04:56
*/
function SignIn(orgID, userID, UserCnName, operateNumber) {
    $("#btnSignIn").addClass("wait");
    var methodName = 'SignIn';
    var arr = '{"orgID":"' + orgID + '","userID":"' + userID + '","UserCnName":"' + UserCnName + '","operateNumber":"' + operateNumber + '"}';

    AjaxAsyncCallMethod(methodName, arr,
        function (result) {
            var res = result.split("|");
            if (res[0] == "0") {
                showWarningMsg(res[1]);
            }
            else if (res[0] == "3") {
                try {
                    //已经签到时未签到云豆区域隐藏已经签到区域显示、赋值今日签到总人数、我的签到排名
                    $("#divNoSignIn").hide();
                    $("#divSignIn").show();
                    $("#spTotalCount").text(res[2]);
                    $("#spRank").text(res[3]);

                    var balanceNumber = parseInt($("#spBalanceCount").text().replace(/,/g, ""));                    
                    //測試函式(注意數字要以字串輸入)
                    var balanceCount = formatNumber((balanceNumber + parseInt(operateNumber)).toString());
                    $("#spBalanceCount").text(balanceCount);

                    var balanceNumber = parseInt($("#spBalanceNumber").text().replace(/,/g, "")); //云豆可用数目增加
                    //測試函式(注意數字要以字串輸入)
                    var balanceCount = formatNumber((balanceNumber + parseInt(operateNumber)).toString());
                    $("#spBalanceNumber").text(balanceCount);

                    var activeDays = parseInt($("#spActiveDays").text()); //活跃天数加1
                    $("#spActiveDays").text(activeDays + 1);

                    var continueCount = parseInt($("#spContinueNumber").text()); //连续签到次数
                    $("#spContinueNumber").text(continueCount + 1);

                    //给当前日历中的当前日期添加选中样式
                    jQuery.signInCalendar.signIn(res[4]);
                    //签到按钮去掉等待样式添加不可点击样式同时去掉事件
                    $("#btnSignIn").removeClass().addClass("rigster_btn_disabled");
                    $("#btnSignIn").attr("onclick", " function () { }");
                    //提示框
                    showApply('registered', 'showDiv_01');
                } catch (e) { }
            }
            else {
                try {
                    //签到成功以后未签到云豆区域隐藏已经签到区域显示、赋值今日签到总人数、我的签到排名、云豆可用数目增加、连续签到次数、活跃天数加1、签到成功以后弹出框的云豆可用总数增加
                    $("#divNoSignIn").hide();
                    $("#divSignIn").show();
                    $("#spTotalCount").text(res[2]);
                    $("#spRank").text(res[3]);
                    var balanceNumber = parseInt($("#spBalanceNumber").text().replace(/,/g, "")); //云豆可用数目增加
                    //測試函式(注意數字要以字串輸入)
                    var balanceCount = formatNumber((balanceNumber + parseInt(operateNumber)).toString());
                    $("#spBalanceNumber").text(balanceCount);
                    $("#spBalanceNum").text(balanceCount); //签到成功以后弹出框的云豆可用总数

                    var continueCount = parseInt($("#spContinueNumber").text()); //连续签到次数
                    $("#spContinueNumber").text(continueCount + 1);

                    var activeDays = parseInt($("#spActiveDays").text()); //活跃天数加1
                    $("#spActiveDays").text(activeDays + 1);
                    //给当前日历中的当前日期添加选中样式
                    jQuery.signInCalendar.signIn(res[4]);
                    //签到按钮去掉等待样式添加不可点击样式同时去掉事件
                    $("#btnSignIn").removeClass().addClass("rigster_btn_disabled");
                    $("#btnSignIn").attr("onclick", " function () { }");
                    //签到成功提示框
                    showApply('register', 'showDiv_01');
                } catch (e) { }
            }
        }, false, true, false, true);

    }

    //将数值转化成整数部分每三个数字用一个，分割
    //创建人：叶兆利
    //时间：2015年3月27日09:05:16
    function formatNumber(str) {
        if (str.length <= 3) {
            return str;
        } else {
            return formatNumber(str.substr(0, str.length - 3)) + ',' + str.substr(str.length - 3);
        }
    }

    /*
    * 云豆任务中心 环形进度条
    *创建人：zyj
    *创建时间：2015/3/2
    */
    function init(b, n, t, c, bc) {
        /*圆形百分比*/
        var paper = null;
        //初始化Raphael画布 
        this.paper = Raphael(b, 80, 80);

        //把底图先画上去 
        // this.paper.image("http://172.17.125.16:99/SystemFiles/Themes/skin01/images/cloudbean/progressBg.png", 0, 0, 80, 80);

        //进度比例，0到1
        //需要注意，下面的算法不支持画100%，要按99.99%来画 
        var percent = n,
        drawPercent = percent >= 1 ? 0.9999 : percent;

        //开始计算各点的位置，见后图 
        //r1是内圆半径，r2是外圆半径 PI圆周率
        var r1 = 32, r2 = 37, PI = Math.PI, ax = "";

        if ((navigator.userAgent.indexOf('MSIE') >= 0)
         && (navigator.userAgent.indexOf('Opera') < 0)) {
            //ie兼容处理
            var ax = 40
        } else { var ax = 41 }

        p1 = {
            x: ax,
            y: 77
        }, p4 = {
            x: p1.x,
            y: p1.y - r2 + r1
        },
        p2 = {
            x: p1.x + r2 * Math.sin(2 * PI * (1 - drawPercent)),
            y: p1.y - r2 + r2 * Math.cos(2 * PI * (1 - drawPercent))
        },
        p3 = {
            x: p4.x + r1 * Math.sin(2 * PI * (1 - drawPercent)),
            y: p4.y - r1 + r1 * Math.cos(2 * PI * (1 - drawPercent))
        },
        path = [
          'M', p1.x, ' ', p1.y, //p1起点
          'A', r2, ' ', r2, ' 0 ', percent > 0.5 ? 1 : 0, ' 1 ', p2.x, ' ', p2.y, //p1到p2这段弧线
          'L', p3.x, ' ', p3.y,  //p2-p3直线
          'A', r1, ' ', r1, ' 0 ', percent > 0.5 ? 1 : 0, ' 0 ', p4.x, ' ', p4.y, //p3到p4这段弧线
          'Z' //图像闭合p4-p1直线
        ].join('');

        //用path方法画图形，由两段圆弧和两条直线组成，画弧线的算法见后 
        this.paper.path(path)
        //支持填充渐变色，从#3f0b3f到#ff66ff 
        .attr({ "stroke-width": 0.5, "stroke": bc, "fill": "90-" + c });

        //显示进度文字 
        $(t).text(Math.round(percent * 100) + "%");
    }

