/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerAdapter;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;

public class SubstanceListUI
extends BasicListUI {
    protected Set lafWidgets;
    protected Map<Integer, Object> selectedIndices;
    protected int rolledOverIndex = -1;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected boolean isFileList;
    protected boolean isLeftToRight;
    private static SubstanceGradientBackgroundDelegate backgroundDelegate = new SubstanceGradientBackgroundDelegate();
    protected ListSelectionListener substanceFadeSelectionListener;
    protected RolloverFadeListener substanceFadeRolloverListener;
    private Map<Integer, ComponentState> prevStateMap = new HashMap<Integer, ComponentState>();
    private Map<Integer, ComponentState> nextStateMap = new HashMap<Integer, ComponentState>();

    public void __org__jvnet__substance__SubstanceListUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceListUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceListUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceListUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceListUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceListUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceListUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceListUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceListUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceListUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent list) {
        return new SubstanceListUI();
    }

    public SubstanceListUI() {
        this.selectedIndices = new HashMap<Integer, Object>();
    }

    protected void __org__jvnet__substance__SubstanceListUI__installDefaults() {
        super.installDefaults();
        this.isFileList = Boolean.TRUE.equals(this.list.getClientProperty("List.isFileList"));
        this.isLeftToRight = this.list.getComponentOrientation().isLeftToRight();
        if (SubstanceCoreUtilities.toBleedWatermark(this.list)) {
            this.list.setOpaque(false);
        }
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            if (!this.list.isSelectedIndex(i)) continue;
            this.selectedIndices.put(i, this.list.getModel().getElementAt(i));
            this.prevStateMap.put(i, ComponentState.SELECTED);
        }
    }

    protected void __org__jvnet__substance__SubstanceListUI__uninstallDefaults() {
        this.selectedIndices.clear();
        super.uninstallDefaults();
    }

    protected void __org__jvnet__substance__SubstanceListUI__installListeners() {
        super.installListeners();
        this.substanceFadeSelectionListener = new ListSelectionListener(){

            protected void cancelFades(Set<Long> initiatedFadeSequences) {
                FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
                for (long fadeId : initiatedFadeSequences) {
                    fadeTrackerInstance.cancelFadeInstance(fadeId);
                }
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (LafWidgetUtilities.hasNoFades(SubstanceListUI.this.list, FadeKind.SELECTION)) {
                    return;
                }
                HashSet<Long> initiatedFadeSequences = new HashSet<Long>();
                boolean fadeCanceled = false;
                FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
                for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                    long fadeId;
                    if (i >= SubstanceListUI.this.list.getModel().getSize()) continue;
                    if (SubstanceListUI.this.list.isSelectedIndex(i)) {
                        if (SubstanceListUI.this.selectedIndices.containsKey(i)) continue;
                        if (!fadeCanceled) {
                            fadeId = fadeTrackerInstance.trackFadeIn(FadeKind.SELECTION, (Component)SubstanceListUI.this.list, i, false, (FadeTrackerCallback)new CellRepaintCallback(SubstanceListUI.this.list, i));
                            initiatedFadeSequences.add(fadeId);
                            if (initiatedFadeSequences.size() > 25) {
                                this.cancelFades(initiatedFadeSequences);
                                initiatedFadeSequences.clear();
                                fadeCanceled = true;
                            }
                        }
                        SubstanceListUI.this.selectedIndices.put(i, SubstanceListUI.this.list.getModel().getElementAt(i));
                        continue;
                    }
                    if (!SubstanceListUI.this.selectedIndices.containsKey(i)) continue;
                    if (SubstanceListUI.this.selectedIndices.get(i) == SubstanceListUI.this.list.getModel().getElementAt(i) && !fadeCanceled) {
                        fadeId = fadeTrackerInstance.trackFadeOut(FadeKind.SELECTION, (Component)SubstanceListUI.this.list, i, false, (FadeTrackerCallback)new CellRepaintCallback(SubstanceListUI.this.list, i));
                        initiatedFadeSequences.add(fadeId);
                        if (initiatedFadeSequences.size() > 25) {
                            this.cancelFades(initiatedFadeSequences);
                            initiatedFadeSequences.clear();
                            fadeCanceled = true;
                        }
                    }
                    SubstanceListUI.this.selectedIndices.remove(i);
                }
            }
        };
        this.list.getSelectionModel().addListSelectionListener(this.substanceFadeSelectionListener);
        this.substanceFadeRolloverListener = new RolloverFadeListener();
        this.list.addMouseMotionListener(this.substanceFadeRolloverListener);
        this.list.addMouseListener(this.substanceFadeRolloverListener);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.watermark.tobleed".equals(evt.getPropertyName())) {
                    SubstanceListUI.this.list.setOpaque(!SubstanceCoreUtilities.toBleedWatermark(SubstanceListUI.this.list));
                }
            }
        };
        this.list.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void __org__jvnet__substance__SubstanceListUI__uninstallListeners() {
        this.list.getSelectionModel().removeListSelectionListener(this.substanceFadeSelectionListener);
        this.substanceFadeSelectionListener = null;
        this.list.removeMouseMotionListener(this.substanceFadeRolloverListener);
        this.list.removeMouseListener(this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        this.list.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        float endAlpha;
        Object value = dataModel.getElementAt(row);
        boolean cellHasFocus = this.list.hasFocus() && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        boolean isWatermarkBleed = SubstanceCoreUtilities.toBleedWatermark(this.list);
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        if (this.isFileList) {
            int w = Math.min(cw, rendererComponent.getPreferredSize().width + 4);
            if (!this.isLeftToRight) {
                cx += cw - w;
            }
            cw = w;
        }
        boolean isRollover = this.rolledOverIndex >= 0 && this.rolledOverIndex == row;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.list, g));
        if (!isWatermarkBleed) {
            g2d.setColor(rendererComponent.getBackground());
            g2d.fillRect(cx, cy, cw, ch);
        }
        ComponentState prevState = this.getPrevCellState(row);
        ComponentState currState = this.getCellState(row);
        float alphaForPrevBackground = 0.0f;
        float startAlpha = SubstanceCoreUtilities.getHighlightAlpha(this.list, prevState, true);
        float alphaForCurrBackground = endAlpha = SubstanceCoreUtilities.getHighlightAlpha(this.list, currState, true);
        FadeState state = SubstanceFadeUtilities.getFadeState((Component)this.list, Integer.valueOf(row), FadeKind.SELECTION, FadeKind.ROLLOVER);
        if (state != null) {
            float fadeCoef = state.getFadePosition();
            float totalAlpha = 0.0f;
            totalAlpha = state.isFadingIn() ? startAlpha + (endAlpha - startAlpha) * fadeCoef / 10.0f : startAlpha + (endAlpha - startAlpha) * (10.0f - fadeCoef) / 10.0f;
            if (state.isFadingIn()) {
                fadeCoef = 10.0f - fadeCoef;
            }
            alphaForPrevBackground = totalAlpha * fadeCoef / 10.0f;
            alphaForCurrBackground = totalAlpha * (10.0f - fadeCoef) / 10.0f;
        }
        SubstanceTheme prevTheme = SubstanceCoreUtilities.getHighlightTheme((Component)this.list, prevState, true, false);
        SubstanceTheme currTheme = SubstanceCoreUtilities.getHighlightTheme((Component)this.list, currState, true, false);
        if (alphaForPrevBackground > 0.0f) {
            g2d.setComposite(TransitionLayout.getAlphaComposite(this.list, alphaForPrevBackground, g));
            backgroundDelegate.update(g2d, rendererComponent, new Rectangle(cx, cy, cw, ch), prevTheme, true);
            g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.list, g));
        }
        if (alphaForCurrBackground > 0.0f) {
            g2d.setComposite(TransitionLayout.getAlphaComposite(this.list, alphaForCurrBackground, g));
            backgroundDelegate.update(g2d, rendererComponent, new Rectangle(cx, cy, cw, ch), currTheme, true);
            g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.list, g));
        }
        if (rendererComponent instanceof JComponent) {
            JComponent jRenderer;
            JComponent jComponent = jRenderer = (JComponent)rendererComponent;
            synchronized (jComponent) {
                boolean newOpaque;
                boolean bl = newOpaque = !isSelected && !isRollover && state == null;
                if (SubstanceCoreUtilities.toBleedWatermark(this.list)) {
                    newOpaque = false;
                }
                HashMap<Component, Boolean> opacity = new HashMap<Component, Boolean>();
                if (!newOpaque) {
                    SubstanceCoreUtilities.makeNonOpaque(jRenderer, opacity);
                }
                this.rendererPane.paintComponent(g2d, rendererComponent, this.list, cx, cy, cw, ch, true);
                if (!newOpaque) {
                    SubstanceCoreUtilities.restoreOpaque(jRenderer, opacity);
                }
            }
        } else {
            this.rendererPane.paintComponent(g2d, rendererComponent, this.list, cx, cy, cw, ch, true);
        }
        g2d.dispose();
    }

    public ComponentState getPrevCellState(int cellIndex) {
        if (this.prevStateMap.containsKey(cellIndex)) {
            return this.prevStateMap.get(cellIndex);
        }
        return ComponentState.DEFAULT;
    }

    public ComponentState getCellState(int cellIndex) {
        DefaultButtonModel synthModel = new DefaultButtonModel();
        synthModel.setEnabled(this.list.isEnabled());
        synthModel.setRollover(this.rolledOverIndex >= 0 && this.rolledOverIndex == cellIndex);
        synthModel.setSelected(this.list.isSelectedIndex(cellIndex));
        return ComponentState.getState(synthModel, null);
    }

    public void resetRolloverIndex() {
        this.rolledOverIndex = -1;
    }

    protected class CellRepaintCallback
    extends FadeTrackerAdapter {
        protected JList list;
        protected int cellIndex;

        public CellRepaintCallback(JList list, int cellIndex) {
            this.list = list;
            this.cellIndex = cellIndex;
        }

        public void fadeEnded(FadeKind fadeKind) {
            if (SubstanceListUI.this.list == this.list && this.cellIndex < this.list.getModel().getSize()) {
                ComponentState currState = SubstanceListUI.this.getCellState(this.cellIndex);
                if (currState == ComponentState.DEFAULT) {
                    SubstanceListUI.this.prevStateMap.remove(this.cellIndex);
                    SubstanceListUI.this.nextStateMap.remove(this.cellIndex);
                } else {
                    SubstanceListUI.this.prevStateMap.put(this.cellIndex, currState);
                    SubstanceListUI.this.nextStateMap.put(this.cellIndex, currState);
                }
            }
            this.repaintCell();
        }

        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (SubstanceListUI.this.list == this.list && this.cellIndex < this.list.getModel().getSize()) {
                ComponentState nextState = (ComponentState)((Object)SubstanceListUI.this.nextStateMap.get(this.cellIndex));
                if (nextState == null) {
                    SubstanceListUI.this.prevStateMap.remove(this.cellIndex);
                } else {
                    SubstanceListUI.this.prevStateMap.put(this.cellIndex, nextState);
                }
            }
            this.repaintCell();
        }

        public void fadePerformed(FadeKind fadeKind, float fade10) {
            if (SubstanceListUI.this.list == this.list && this.cellIndex < this.list.getModel().getSize()) {
                SubstanceListUI.this.nextStateMap.put(this.cellIndex, SubstanceListUI.this.getCellState(this.cellIndex));
            }
            this.repaintCell();
        }

        private void repaintCell() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SubstanceListUI.this.list == null) {
                        return;
                    }
                    try {
                        SubstanceListUI.this.maybeUpdateLayoutState();
                        int cellCount = CellRepaintCallback.this.list.getModel().getSize();
                        if (cellCount > 0 && CellRepaintCallback.this.cellIndex < cellCount) {
                            Rectangle rect = SubstanceListUI.this.getCellBounds(CellRepaintCallback.this.list, CellRepaintCallback.this.cellIndex, CellRepaintCallback.this.cellIndex);
                            CellRepaintCallback.this.list.repaint(rect);
                        }
                    }
                    catch (RuntimeException re) {
                        return;
                    }
                }
            });
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            this.fadeOut();
            SubstanceListUI.this.resetRolloverIndex();
        }

        public void mouseMoved(MouseEvent e) {
            if (!SubstanceListUI.this.list.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (!SubstanceListUI.this.list.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        private void handleMove(MouseEvent e) {
            boolean fadeAllowed = FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.ROLLOVER, SubstanceListUI.this.list);
            if (!fadeAllowed) {
                this.fadeOut();
                SubstanceListUI.this.resetRolloverIndex();
                return;
            }
            int roIndex = SubstanceListUI.this.list.locationToIndex(e.getPoint());
            if (roIndex < 0 || roIndex >= SubstanceListUI.this.list.getModel().getSize()) {
                this.fadeOut();
                SubstanceListUI.this.resetRolloverIndex();
            } else {
                if (SubstanceListUI.this.rolledOverIndex >= 0 && SubstanceListUI.this.rolledOverIndex == roIndex) {
                    return;
                }
                this.fadeOut();
                FadeTracker.getInstance().trackFadeIn(FadeKind.ROLLOVER, (Component)SubstanceListUI.this.list, roIndex, false, (FadeTrackerCallback)new CellRepaintCallback(SubstanceListUI.this.list, roIndex));
                SubstanceListUI.this.rolledOverIndex = roIndex;
            }
        }

        private void fadeOut() {
            if (SubstanceListUI.this.rolledOverIndex < 0) {
                return;
            }
            FadeTracker.getInstance().trackFadeOut(FadeKind.ROLLOVER, (Component)SubstanceListUI.this.list, SubstanceListUI.this.rolledOverIndex, false, (FadeTrackerCallback)new CellRepaintCallback(SubstanceListUI.this.list, SubstanceListUI.this.rolledOverIndex));
        }
    }
}

