/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.grip;

import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.grip.GripPainter;
import org.jvnet.substance.theme.SubstanceTheme;

public class DragBumpsGripPainter
implements GripPainter {
    public void paintGrip(JComponent comp, Graphics graphics, SubstanceTheme theme, Rectangle gripArea, boolean isGripVertical, ComponentOrientation gripOrientation) {
        if (isGripVertical) {
            int thumbHeight = gripArea.height;
            if (thumbHeight < 30) {
                return;
            }
            int gripHeight = thumbHeight / 4;
            if (gripHeight > 40) {
                gripHeight = 40;
            }
            int thumbWidth = gripArea.width;
            int gripWidth = thumbWidth * 2 / 3;
            int gripX = gripArea.x + (thumbWidth - gripWidth) / 2;
            int gripY = gripArea.y + (thumbHeight - gripHeight) / 2;
            graphics.drawImage(SubstanceImageCreator.getDragImage(theme, true, gripWidth, gripHeight, true), gripX, gripY, null);
        } else {
            int thumbWidth = gripArea.width;
            if (thumbWidth < 30) {
                return;
            }
            int gripWidth = thumbWidth / 4;
            if (gripWidth > 40) {
                gripWidth = 40;
            }
            int thumbHeight = gripArea.height;
            int gripHeight = thumbHeight * 2 / 3;
            int gripX = gripArea.x + (thumbWidth - gripWidth) / 2;
            int gripY = 1 + gripArea.y + (thumbHeight - gripHeight) / 2;
            graphics.drawImage(SubstanceImageCreator.getRotated(SubstanceImageCreator.getDragImage(theme, true, gripHeight, gripWidth, true), 3), gripX, gripY, null);
        }
    }
}

