/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.theme;

import java.awt.Color;
import org.jvnet.substance.color.InvertedColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.SubstanceWrapperTheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceInvertedTheme
extends SubstanceWrapperTheme {
    public SubstanceInvertedTheme(SubstanceTheme substanceTheme) {
        super(substanceTheme, new InvertedColorScheme(substanceTheme.getColorScheme()), "Inverted " + substanceTheme.getDisplayName(), SubstanceTheme.ThemeKind.INVERTED);
        this.originalTheme = substanceTheme;
    }

    public SubstanceTheme invert() {
        return this.originalTheme;
    }

    public SubstanceTheme negate() {
        throw new UnsupportedOperationException("Negating an inverted theme is not supported");
    }

    public Color getWatermarkStampColor() {
        return SubstanceCoreUtilities.isThemeDark(this) ? SubstanceColorUtilities.getAlphaColor(this.getColorScheme().getDarkColor(), 60) : SubstanceColorUtilities.getAlphaColor(this.getColorScheme().getUltraLightColor(), 25);
    }

    public SubstanceTheme saturate(double saturateFactor, boolean toSaturateEverything) {
        return this.originalTheme.saturate(saturateFactor, toSaturateEverything).invert();
    }

    public SubstanceTheme tint(double tintFactor) {
        return this.originalTheme.tint(tintFactor).invert();
    }

    public SubstanceTheme tone(double toneFactor) {
        return this.originalTheme.tone(toneFactor).invert();
    }

    public SubstanceTheme shade(double shadeFactor) {
        return this.originalTheme.shade(shadeFactor).invert();
    }

    public SubstanceTheme hueShift(double hueShiftFactor) {
        return this.originalTheme.hueShift(hueShiftFactor).invert();
    }
}

