/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ButtonModel;
import org.jvnet.substance.utils.Trackable;

public class RolloverControlListener
implements MouseListener,
MouseMotionListener {
    private boolean isMouseInside;
    private ButtonModel model;
    private Trackable trackableUI;

    public RolloverControlListener(Trackable trackableUI, ButtonModel model) {
        this.trackableUI = trackableUI;
        this.model = model;
        this.isMouseInside = false;
    }

    public void mouseEntered(MouseEvent e) {
        boolean isInside;
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        this.isMouseInside = isInside = this.trackableUI.isInside(e);
        this.model.setRollover(isInside);
        this.model.setEnabled(component.isEnabled());
    }

    public void mouseExited(MouseEvent e) {
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        this.isMouseInside = false;
        this.model.setRollover(false);
        this.model.setEnabled(component.isEnabled());
    }

    public void mouseReleased(MouseEvent e) {
        boolean isInside;
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        this.isMouseInside = isInside = this.trackableUI.isInside(e);
        this.model.setRollover(this.isMouseInside);
        this.model.setPressed(false);
        this.model.setArmed(false);
        this.model.setSelected(false);
        this.model.setEnabled(component.isEnabled());
    }

    public void mousePressed(MouseEvent e) {
        boolean isInside;
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        this.isMouseInside = isInside = this.trackableUI.isInside(e);
        this.model.setRollover(this.isMouseInside);
        if (this.isMouseInside) {
            this.model.setPressed(true);
            this.model.setArmed(true);
            this.model.setSelected(true);
        }
        this.model.setEnabled(component.isEnabled());
    }

    public void mouseDragged(MouseEvent e) {
        boolean isInside;
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        this.isMouseInside = isInside = this.trackableUI.isInside(e);
        this.model.setEnabled(component.isEnabled());
    }

    public void mouseMoved(MouseEvent e) {
        boolean isInside;
        Component component = (Component)e.getSource();
        if (!component.isEnabled()) {
            return;
        }
        this.isMouseInside = isInside = this.trackableUI.isInside(e);
        this.model.setRollover(isInside);
        this.model.setEnabled(component.isEnabled());
    }

    public void mouseClicked(MouseEvent e) {
    }
}

