/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache6Upgrader;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.CacheUpgrader;
import com.sun.deploy.cache.CleanupThread;
import com.sun.deploy.cache.DefaultLocalApplicationProperties;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.cache.ResourceProviderImpl;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.net.BasicHttpRequest;
import com.sun.deploy.net.CanceledDownloadException;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpDownloadListener;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarFile;

public class Cache {
    static final boolean DEBUG = Config.getDeployDebug() || Config.getPluginDebug();
    public static final int VERSION_INT = 605;
    static final int VERSION_604 = 604;
    static final int VERSION_603 = 603;
    static final int VERSION_602 = 602;
    public static final String VERSION6_STRING = "6.0";
    public static final String VERSION_STRING = "6.0";
    private static boolean doIPLookup = true;
    private static final String IP_ADDR_CANNOT_RESOLVE = "0.0.0.0";
    private static final String DASH = "-";
    static final String INDEX_FILE_EXT = ".idx";
    static final String MUFFIN_FILE_EXT = ".muf";
    static final String HOST_FILE_EXT = ".hst";
    static final String LAP_FILE_EXT = ".lap";
    static final String MUFFIN_DIRNAME = "muffin";
    static final String SPLASH_DIRNAME = "splash";
    static final String HOST_DIRNAME = "host";
    static final int NUM_OF_CACHE_SUBDIR = 64;
    static final char APPLICATION_TYPE = 'A';
    static final char EXTENSION_TYPE = 'E';
    private static SecureRandom random = null;
    private static String cachePath;
    private static File cacheDir;
    private static File sysCacheDir;
    private static File muffinDir;
    private static File hostDir;
    private static final int BUF_SIZE = 32768;
    private static final Map loadedProperties;
    private static final CleanupThread ct;
    private static final Object syncObject;
    private static boolean cleanupEnabled;
    public static final long TIME_WAIT_BEFORE_JAR_PERVERIFY = 30000L;
    static final String LAST_ACCESS_FILE = "lastAccessed";
    static final String REMOVED_APPS = "removed.apps";

    public static void setCleanupEnabled(boolean bl) {
        cleanupEnabled = bl;
    }

    public static void setDoIPLookup(boolean bl) {
        doIPLookup = bl;
    }

    private static void createCacheBucketDirectories(String string) {
        for (int i = 0; i < 64; ++i) {
            File file = new File(string + File.separator + i);
            file.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = syncObject;
        synchronized (object) {
            MemoryCache.reset();
            Object object2 = loadedProperties;
            synchronized (object2) {
                loadedProperties.clear();
            }
            cachePath = Config.getCacheDirectory() + File.separator + "6.0";
            object2 = cachePath + File.separator + MUFFIN_DIRNAME;
            String string = cachePath + File.separator + HOST_DIRNAME;
            cacheDir = new File(cachePath);
            muffinDir = new File((String)object2);
            hostDir = new File(string);
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
                Cache6Upgrader.initializeUpgraderKeys();
            }
            hostDir.mkdirs();
            Cache.createCacheBucketDirectories(cachePath);
            muffinDir.mkdirs();
            if (Config.getSystemCacheDirectory() != null && Config.getSystemCacheDirectory().length() != 0) {
                String string2 = Config.getSystemCacheDirectory() + File.separator + "6.0";
                sysCacheDir = new File(string2);
                if (Environment.isSystemCacheMode()) {
                    sysCacheDir.mkdirs();
                    Cache.createCacheBucketDirectories(string2);
                }
            } else {
                sysCacheDir = null;
            }
            long l = Config.getCacheSizeMax();
            if (l > 0L && l < 0x500000L) {
                l = 0x500000L;
            }
        }
    }

    static void addToCleanupThreadLoadedResourceList(String string) {
        if (ct != null && cleanupEnabled) {
            ct.addToLoadedResourceList(string);
        }
    }

    static void cleanup() {
        if (ct != null && cleanupEnabled) {
            ct.startCleanup();
        }
    }

    public static boolean hasIncompatibleCompressEncoding(CacheEntry cacheEntry) {
        return cacheEntry != null && DownloadEngine.isInternalUse() && cacheEntry.hasCompressEncoding();
    }

    private Cache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void markResourceIncomplete(CacheEntry cacheEntry) {
        if (cacheEntry != null) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                cacheEntry.setIncomplete(CacheEntry.INCOMPLETE_TRUE);
                try {
                    cacheEntry.updateIndexHeaderOnDisk();
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
            }
        }
    }

    static boolean isSystemCacheEntry(CacheEntry cacheEntry) {
        File file;
        if (cacheEntry != null && sysCacheDir != null && (file = cacheEntry.getIndexFile()) != null && file.getParentFile() != null) {
            return sysCacheDir.equals(file.getParentFile().getParentFile());
        }
        return false;
    }

    static CacheEntry getSystemCacheEntry(URL uRL, String string) {
        if (uRL == null) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)MemoryCache.getLoadedResource(uRL.toString());
        if (Cache.isSystemCacheEntry(cacheEntry)) {
            String string2 = cacheEntry.getVersion();
            if (string == null && string2 == null || string != null && string2 != null && string2.compareTo(string) >= 0) {
                return cacheEntry;
            }
        }
        if ((cacheEntry = Cache.getCacheEntry(uRL, string, sysCacheDir)) == null) {
            cacheEntry = CacheUpgrader.getSystemInstance().upgradeItem(uRL, string, 1);
        }
        if (cacheEntry != null) {
            MemoryCache.addLoadedResource(uRL.toString(), cacheEntry);
        }
        return cacheEntry;
    }

    public static boolean isSupportedProtocol(URL uRL) {
        String string = uRL.getProtocol();
        return string != null && (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("https"));
    }

    public static boolean isCacheEnabled() {
        return Config.getBooleanProperty("deployment.cache.enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLoadedProperties(String string) {
        Map map = loadedProperties;
        synchronized (map) {
            loadedProperties.remove(string);
        }
    }

    public static LocalApplicationProperties getLocalApplicationProperties(CacheEntry cacheEntry) {
        URL uRL = null;
        try {
            uRL = new URL(cacheEntry.getURL());
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
        }
        return Cache.getLocalApplicationProperties(uRL, cacheEntry.getVersion(), true);
    }

    public static LocalApplicationProperties getLocalApplicationProperties(String string) {
        if (!Cache.isCacheEnabled()) {
            return null;
        }
        final File file = new File(string + INDEX_FILE_EXT);
        final CacheEntry cacheEntry = (CacheEntry)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Cache.getCacheEntryFromFile(file);
            }
        });
        if (cacheEntry == null) {
            return null;
        }
        URL uRL = null;
        try {
            uRL = new URL(cacheEntry.getURL());
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
            return null;
        }
        final URL uRL2 = uRL;
        return (LocalApplicationProperties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Cache.getLocalApplicationProperties(uRL2, cacheEntry.getVersion(), true);
            }
        });
    }

    public static LocalApplicationProperties getLocalApplicationProperties(URL uRL) {
        return Cache.getLocalApplicationProperties(uRL, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalApplicationProperties getLocalApplicationProperties(URL uRL, String string, boolean bl) {
        LocalApplicationProperties localApplicationProperties = null;
        if (Cache.isCacheEnabled() && uRL != null) {
            String string2 = uRL.toString() + "?" + string;
            Map map = loadedProperties;
            synchronized (map) {
                localApplicationProperties = (LocalApplicationProperties)loadedProperties.get(string2);
                if (localApplicationProperties == null) {
                    localApplicationProperties = new DefaultLocalApplicationProperties(uRL, string, bl);
                    loadedProperties.put(string2, localApplicationProperties);
                } else {
                    localApplicationProperties.refreshIfNecessary();
                }
            }
        }
        return localApplicationProperties;
    }

    public static String getLapFileName(URL uRL, String string) {
        String string2 = Cache.getKey(uRL);
        return Cache.getBucket(string2) + File.separator + string2 + "6.0" + Cache.getVersionTag(string) + LAP_FILE_EXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putLapData(char c, URL uRL, String string, byte[] byArray) throws IOException {
        File file = Cache.getActiveCacheDir();
        File file2 = new File(file, Cache.getLapFileName(uRL, string));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        byte[] byArray2 = new byte[32768];
        try {
            int n = byteArrayInputStream.read(byArray2);
            while (n >= 0) {
                bufferedOutputStream.write(byArray2, 0, n);
                n = byteArrayInputStream.read(byArray2);
            }
        }
        finally {
            bufferedOutputStream.close();
            ((InputStream)byteArrayInputStream).close();
        }
    }

    public static byte[] getLapData(char c, URL uRL, String string, boolean bl) throws IOException {
        File file;
        File file2 = file = bl ? sysCacheDir : cacheDir;
        if (file == null) {
            return null;
        }
        File file3 = new File(file, Cache.getLapFileName(uRL, string));
        return Cache.getLapBytes(file3);
    }

    public static byte[] getLapBytes(final File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = (ByteArrayOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    long l = file.length();
                    if (l > 0L && l < 0x100000L) {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)l);
                        byte[] byArray = new byte[32768];
                        try {
                            int n = bufferedInputStream.read(byArray);
                            while (n >= 0) {
                                byteArrayOutputStream.write(byArray, 0, n);
                                n = bufferedInputStream.read(byArray);
                            }
                        }
                        finally {
                            byteArrayOutputStream.close();
                            bufferedInputStream.close();
                        }
                        return byteArrayOutputStream;
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        if (byteArrayOutputStream != null) {
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public static String getNewExtensionInstallDirectory() throws IOException {
        String string = cacheDir.getAbsolutePath() + File.separator + "ext";
        String string2 = null;
        int n = 0;
        do {
            File file;
            if (!(file = new File(string2 = string + File.separator + "E" + new Date().getTime() + File.separator)).mkdirs()) {
                string2 = null;
            }
            Thread.yield();
        } while (string2 == null && ++n < 50);
        if (string2 == null) {
            throw new IOException("Unable to create temp. dir for extension");
        }
        return string2;
    }

    public static String getCacheEntryVersion(URL uRL) {
        String string = null;
        CacheEntry cacheEntry = Cache.getLatestCacheEntry(uRL);
        if (cacheEntry != null) {
            string = cacheEntry.getVersion();
        }
        return string;
    }

    private static void writeBytes(File file, byte[] byArray) throws IOException {
        FilterOutputStream filterOutputStream = null;
        boolean bl = false;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            filterOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            bl = true;
            throw iOException;
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
            if (bl) {
                file.delete();
            }
        }
    }

    private static CacheEntry createNewCacheEntry(URL uRL, String string) throws IOException {
        String string2 = Cache.generateCacheFileName(uRL, string);
        File file = Cache.getActiveCacheDir();
        File file2 = new File(file, string2 + Cache.getIndexFileExtension());
        CacheEntry cacheEntry = new CacheEntry(file2);
        cacheEntry.writeFileToDisk();
        return cacheEntry;
    }

    static CacheEntry downloadResourceToCache(final URL uRL, final String string, final URLConnection uRLConnection, final URL uRL2, final boolean bl, final int n, final InputStream inputStream, final boolean bl2) throws IOException, CanceledDownloadException {
        CacheEntry cacheEntry;
        block3: {
            cacheEntry = null;
            try {
                cacheEntry = (CacheEntry)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException, CanceledDownloadException {
                        String string3 = uRLConnection.getContentEncoding();
                        if (DownloadEngine.isPackContentType(n)) {
                            string3 = "pack200-gzip";
                        }
                        CacheEntry cacheEntry = Cache.createNewCacheEntry(uRL, string);
                        MessageHeader messageHeader = DownloadEngine.getHttpDownloadImpl().download(uRLConnection.getContentLength(), uRLConnection.getURL(), inputStream, string3, cacheEntry.getTempDataFile(), null, n, bl2);
                        if (cacheEntry.processTempDataFile(bl, null, uRL, uRL2, string)) {
                            cacheEntry.setBusy(CacheEntry.BUSY_FALSE);
                            cacheEntry.setIncomplete(CacheEntry.INCOMPLETE_FALSE);
                            cacheEntry.setURL(string == null ? uRL2.toString() : uRL.toString());
                            if (bl) {
                                cacheEntry.setContentLength((int)new File(cacheEntry.getResourceFilename()).length());
                            } else {
                                cacheEntry.setContentLength(uRLConnection.getContentLength());
                            }
                            cacheEntry.setLastModified(uRLConnection.getLastModified());
                            cacheEntry.setExpirationDate(uRLConnection.getExpiration());
                            if (string != null) {
                                cacheEntry.setVersion(string);
                            }
                            MessageHeader messageHeader2 = BasicHttpRequest.initializeHeaderFields(uRLConnection);
                            messageHeader2 = MessageHeader.merge(messageHeader2, messageHeader);
                            if (uRLConnection instanceof HttpURLConnection) {
                                ((HttpURLConnection)uRLConnection).disconnect();
                                String string2 = uRLConnection.getRequestProperty("content-type");
                                if (string2 != null && messageHeader2 != null) {
                                    messageHeader2.add("deploy-request-content-type", string2);
                                }
                            }
                            cacheEntry.setHeaders(messageHeader2);
                            Cache.setCeIsProxied(cacheEntry, uRL.getHost());
                            cacheEntry.writeFileToDisk(n, null);
                            Cache.recordLastAccessed();
                            return cacheEntry;
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw (IOException)privilegedActionException.getException();
                }
                if (!(privilegedActionException.getException() instanceof CanceledDownloadException)) break block3;
                throw (CanceledDownloadException)privilegedActionException.getException();
            }
        }
        return cacheEntry;
    }

    private static void setCeIsProxied(CacheEntry cacheEntry, String string) {
        if (Config.isJavaVersionAtLeast16()) {
            try {
                boolean bl = sun.net.www.URLConnection.isProxiedHost(string);
                int n = bl ? 1 : 0;
                cacheEntry.setIsProxied(n);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void setIsProxiedHost(String string) {
        if (Config.isJavaVersionAtLeast16()) {
            try {
                sun.net.www.URLConnection.setProxiedHost(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static CacheEntry downloadResourceToCache(URL uRL, String string, HttpResponse httpResponse, HttpDownloadListener httpDownloadListener, DownloadDelegate downloadDelegate, URL uRL2, boolean bl, int n) throws IOException, CanceledDownloadException {
        boolean bl2;
        URL uRL3 = HttpUtils.getFinalRedirectedURL(httpResponse);
        boolean bl3 = false;
        if (uRL3 != null && !URLUtil.sameURLs(uRL3, uRL2)) {
            bl3 = true;
        }
        URL uRL4 = bl3 ? uRL3 : uRL;
        URL uRL5 = bl3 ? uRL3 : uRL2;
        CacheEntry cacheEntry = Cache.getCacheEntry(uRL, string, n);
        CacheEntry cacheEntry2 = Cache.downloadResourceToTempFile(uRL4, string, httpResponse, httpDownloadListener, downloadDelegate, uRL5, bl, n);
        boolean bl4 = bl2 = string == null;
        if (cacheEntry2 != null) {
            CacheEntry cacheEntry3 = Cache.processNewCacheEntry(uRL, bl2, cacheEntry2, cacheEntry);
            if (bl3) {
                Cache.createRedirectEntry(uRL, uRL3, cacheEntry3);
            }
            return cacheEntry3;
        }
        return null;
    }

    public static CacheEntry downloadResourceToTempFile(URL uRL, String string, HttpResponse httpResponse, HttpDownloadListener httpDownloadListener, DownloadDelegate downloadDelegate, URL uRL2, boolean bl, int n) throws IOException, CanceledDownloadException {
        Object object;
        CacheEntry cacheEntry = Cache.createNewCacheEntry(uRL, string);
        String string2 = httpResponse.getContentEncoding();
        if (DownloadEngine.isPackContentType(n)) {
            string2 = "pack200-gzip";
        }
        MessageHeader messageHeader = null;
        boolean bl2 = DownloadEngine.isInternalUse();
        try {
            object = httpResponse.getInputStream();
            messageHeader = DownloadEngine.getHttpDownloadImpl().download(httpResponse.getContentLength(), httpResponse.getRequest(), (InputStream)object, string2, cacheEntry.getTempDataFile(), httpDownloadListener, n, bl2);
        }
        catch (IOException iOException) {
            Cache.removeCacheEntry(cacheEntry);
            throw iOException;
        }
        catch (CanceledDownloadException canceledDownloadException) {
            Cache.removeCacheEntry(cacheEntry);
            throw canceledDownloadException;
        }
        finally {
            httpResponse.disconnect();
        }
        if (cacheEntry.processTempDataFile(bl, downloadDelegate, uRL, uRL2, string)) {
            cacheEntry.setURL(string == null && !Environment.isImportMode() ? uRL2.toString() : uRL.toString());
            object = httpResponse.getHeaders();
            if (object != null) {
                if (DownloadEngine.isJarContentType(n)) {
                    ((MessageHeader)object).add("deploy-request-content-type", "application/x-java-archive");
                }
                object = MessageHeader.merge((MessageHeader)object, messageHeader);
            }
            cacheEntry.setHeaders((MessageHeader)object);
            cacheEntry.setContentLength(httpResponse.getContentLength());
            cacheEntry.setLastModified(httpResponse.getLastModified());
            cacheEntry.setExpirationDate(httpResponse.getExpiration());
            if (string != null) {
                cacheEntry.setVersion(string);
            }
            Cache.setCeIsProxied(cacheEntry, uRL.getHost());
            cacheEntry.writeFileToDisk(n, downloadDelegate);
            return cacheEntry;
        }
        return null;
    }

    public static boolean isBackgroundVerificationEnabled() {
        if (!Cache.isCacheEnabled()) {
            return false;
        }
        String string = System.getProperty("jnlp.disableBackgroundVerification");
        if (string != null && string.equalsIgnoreCase("true")) {
            Trace.println("Cached JAR background verification disabled", TraceLevel.CACHE);
            return false;
        }
        return true;
    }

    public static CacheEntry processNewCacheEntry(URL uRL, boolean bl, CacheEntry cacheEntry, CacheEntry cacheEntry2) throws IOException {
        Trace.println("Cache: Enable a new CacheEntry: " + uRL.toString(), TraceLevel.NETWORK);
        cacheEntry.setBusy(CacheEntry.BUSY_FALSE);
        cacheEntry.setIncomplete(CacheEntry.INCOMPLETE_FALSE);
        cacheEntry.updateIndexHeaderOnDisk();
        if (cacheEntry2 != null) {
            if (DownloadEngine.isBackgroundUpdateRequest() && MemoryCache.isCacheEntryLoaded(uRL.toString(), cacheEntry2.getVersion())) {
                bl = false;
                cacheEntry2.markIncompleteOnHold();
            }
            if (bl) {
                Cache.removeCacheEntry(cacheEntry2, false);
            }
        }
        Cache.recordLastAccessed();
        return cacheEntry;
    }

    public static int getCacheVersion() {
        return 605;
    }

    public static String getCacheVersionString() {
        return "6.0";
    }

    public static long getCacheSize(boolean bl) {
        long l = 0L;
        File[] fileArray = Cache.getCacheEntries(bl);
        for (int i = 0; i < fileArray.length; ++i) {
            l += fileArray[i].length();
            CacheEntry cacheEntry = Cache.getCacheEntryFromFile(fileArray[i]);
            if (cacheEntry == null) continue;
            l += new File(cacheEntry.getResourceFilename()).length();
            l += Cache.getTotalSize(new File(cacheEntry.getNativeLibPath()));
        }
        return l;
    }

    private static long getTotalSize(File file) {
        long l = 0L;
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    l += Cache.getTotalSize(fileArray[i]);
                }
            } else {
                l += file.length();
            }
        }
        return l;
    }

    private static SecureRandom getSecureRandom() {
        if (random == null) {
            random = ServiceManager.getService().getSecureRandom();
            random.nextInt();
        }
        return random;
    }

    public static boolean exists() {
        if (Environment.isSystemCacheMode()) {
            return sysCacheDir != null && sysCacheDir.exists();
        }
        return cacheDir.exists();
    }

    public static boolean canWrite() {
        if (Environment.isSystemCacheMode()) {
            return sysCacheDir != null && sysCacheDir.canWrite();
        }
        return cacheDir.canWrite();
    }

    public static CacheEntry createOrUpdateCacheEntry(URL uRL, byte[] byArray) throws IOException {
        CacheEntry cacheEntry = Cache.getCacheEntry(uRL, null, Cache.getActiveCacheDir());
        CacheEntry cacheEntry2 = Cache.createNewCacheEntry(uRL, null);
        Cache.writeBytes(cacheEntry2.getTempDataFile(), byArray);
        if (cacheEntry2.processTempDataFile(false, null, uRL, uRL, null)) {
            cacheEntry2.setBusy(CacheEntry.BUSY_FALSE);
            cacheEntry2.setIncomplete(CacheEntry.INCOMPLETE_FALSE);
            cacheEntry2.setURL(uRL.toString());
            Cache.setCeIsProxied(cacheEntry2, uRL.getHost());
            cacheEntry2.writeFileToDisk();
            if (cacheEntry != null) {
                Cache.removeCacheEntry(cacheEntry, false);
            }
            Cache.recordLastAccessed();
            Cache.addLoadedResource(cacheEntry2);
        } else {
            Cache.removeCacheEntry(cacheEntry2, false);
        }
        return cacheEntry2;
    }

    public static CacheEntry createRedirectEntry(URL uRL, URL uRL2, CacheEntry cacheEntry) throws IOException {
        if (cacheEntry == null && (cacheEntry = Cache.getCacheEntry(uRL2, null)) == null) {
            return null;
        }
        CacheEntry cacheEntry2 = Cache.createNewCacheEntry(uRL, cacheEntry.getVersion());
        cacheEntry2.processRedirectData(uRL, cacheEntry);
        Cache.recordLastAccessed();
        Cache.addLoadedResource(cacheEntry);
        Cache.addLoadedResource(uRL.toString(), cacheEntry);
        return cacheEntry2;
    }

    private static void addLoadedResource(CacheEntry cacheEntry) {
        Cache.addLoadedResource(cacheEntry.getURL().toString(), cacheEntry);
    }

    public static void addLoadedResource(String string, CacheEntry cacheEntry) {
        CacheEntry cacheEntry2 = (CacheEntry)MemoryCache.getLoadedResource(string);
        if (cacheEntry2 != cacheEntry && (cacheEntry2 = (CacheEntry)MemoryCache.addLoadedResource(string, cacheEntry)) != cacheEntry && cacheEntry2 != null && cacheEntry2.getVersion() == null && cacheEntry.getVersion() == null) {
            Cache.markResourceIncomplete(cacheEntry2);
        }
    }

    public static String getIndexFileExtension() {
        return INDEX_FILE_EXT;
    }

    static String getVersionTag(String string) {
        return string == null ? "" : DASH + string + DASH;
    }

    static File getCacheDir() {
        return cacheDir;
    }

    static File getSystemCacheDir() {
        return sysCacheDir;
    }

    public static void setSystemCacheDir(String string) {
        if (string == null || string.length() == 0) {
            sysCacheDir = null;
        } else {
            String string2 = string + File.separator + "6.0";
            sysCacheDir = new File(string2);
        }
    }

    public static File getActiveCacheDir() {
        return Environment.isSystemCacheMode() ? sysCacheDir : cacheDir;
    }

    public static File[] getCacheEntries(boolean bl) {
        File file;
        File file2 = file = bl || Environment.isSystemCacheMode() ? sysCacheDir : cacheDir;
        if (file == null) {
            return new File[0];
        }
        return Cache.getIndexFiles(file);
    }

    public static File[] getIndexFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < 64; ++i) {
            File file2 = new File(file, String.valueOf(i));
            if (!file2.isDirectory()) continue;
            File[] fileArray = file2.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    String string = file.getName();
                    boolean bl = string.endsWith(Cache.INDEX_FILE_EXT);
                    return bl;
                }
            });
            arrayList.addAll(Arrays.asList(fileArray));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static ArrayList getJnlpCacheEntries(boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = Cache.getCacheEntries(bl);
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                CacheEntry cacheEntry = Cache.getCacheEntryFromFile(fileArray[i]);
                if (cacheEntry == null || !cacheEntry.isJNLPFile()) continue;
                String string = fileArray[i].getPath();
                String string2 = string.substring(0, string.length() - 4);
                arrayList.add(new File(string2));
            }
        }
        return arrayList;
    }

    public static void removeRemovedApp(String string, String string2) {
        Properties properties = Cache.getRemovedApps();
        String string3 = properties.getProperty(string);
        if (string3 != null && string3.equals(string2)) {
            properties.remove(string);
            Cache.setRemovedApps(properties);
        }
    }

    public static void saveRemovedApp(URL uRL, String string) {
        if (Environment.isSystemCacheMode() ? Cache.getCacheEntry(uRL, null, cacheDir) != null : Cache.getCacheEntry(uRL, null, sysCacheDir) != null) {
            return;
        }
        Properties properties = Cache.getRemovedApps();
        properties.setProperty(uRL.toString(), string);
        Cache.setRemovedApps(properties);
    }

    static void setRemovedApps(Properties properties) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(Cache.getRemovePath());
            properties.store(fileOutputStream, "Removed JNLP Applications");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getRemovedApps() {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(Cache.getRemovePath());
            properties.load(fileInputStream);
        }
        catch (Throwable throwable) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    public static long getLastAccessed(boolean bl) {
        final File file = new File(bl ? sysCacheDir : cacheDir, LAST_ACCESS_FILE);
        Long l = (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(file.lastModified());
            }
        });
        return l;
    }

    static void recordLastAccessed() {
        File file = new File(Cache.getActiveCacheDir(), LAST_ACCESS_FILE);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(46);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getRemovePath() {
        return cachePath + File.separator + REMOVED_APPS;
    }

    static boolean removeCacheEntry(URL uRL, String string) {
        CacheEntry cacheEntry = Cache.getCacheEntry(uRL, string, Cache.getActiveCacheDir());
        return Cache.removeCacheEntry(cacheEntry);
    }

    static void touch(final File file) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    file.setLastModified(System.currentTimeMillis());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignoredException(privilegedActionException);
        }
    }

    public static void removeAllCacheEntries(CacheEntry cacheEntry) {
        if (cacheEntry == null) {
            return;
        }
        URL uRL = null;
        try {
            uRL = new URL(cacheEntry.getURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String string = cacheEntry.getVersion();
        Cache.removeCacheEntry(cacheEntry);
        if (uRL == null) {
            return;
        }
        File[] fileArray = Cache.getMatchingIndexFiles(Cache.getActiveCacheDir(), uRL);
        for (int i = 0; i < fileArray.length; ++i) {
            CacheEntry cacheEntry2 = new CacheEntry(fileArray[i]);
            String string2 = cacheEntry2.getVersion();
            if ((string != null || string2 != null) && (string == null || !string.equals(string2))) continue;
            Cache.removeCacheEntry(cacheEntry2);
        }
    }

    public static int removeDuplicateEntries(boolean bl, boolean bl2) {
        int n = 0;
        File[] fileArray = Cache.getCacheEntries(bl);
        for (int i = 0; i < fileArray.length; ++i) {
            CacheEntry cacheEntry = Cache.getCacheEntryFromFile(fileArray[i]);
            n += Cache.removeDuplicateEntries(cacheEntry, bl2);
        }
        if (n > 0) {
            Trace.println("Remove All Duplicates: " + n + " bytes", TraceLevel.NETWORK);
        }
        return n;
    }

    public static int removeDuplicateEntries(CacheEntry cacheEntry, boolean bl) {
        String string;
        String string2;
        Object object;
        String string3;
        int n = 0;
        String string4 = string3 = null != cacheEntry ? cacheEntry.getURL() : null;
        if (cacheEntry == null || string3 == null || cacheEntry.isIncomplete() || MemoryCache.contains(string3)) {
            return n;
        }
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL == null) {
            return n;
        }
        File[] fileArray = Cache.getMatchingIndexFiles(cacheDir, uRL);
        CacheEntry cacheEntry2 = cacheEntry;
        for (int i = 0; i < fileArray.length; ++i) {
            CacheEntry cacheEntry3 = new CacheEntry(fileArray[i]);
            String string5 = cacheEntry2.getVersion();
            object = cacheEntry3.getVersion();
            if ((string5 != null || object != null) && (string5 == null || !string5.equals(object))) continue;
            string2 = bl ? null : cacheEntry2.getCodebaseIP();
            String string6 = string = bl ? null : cacheEntry3.getCodebaseIP();
            if (string2 != string && (string2 == null || !string2.equals(string)) || !cacheEntry2.removeBefore(cacheEntry3)) continue;
            cacheEntry2 = cacheEntry3;
        }
        String string7 = cacheEntry2.getVersion();
        int n2 = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            String string8;
            object = new CacheEntry(fileArray[i]);
            string2 = ((CacheEntry)object).getVersion();
            if ((string7 != null || string2 != null) && (string7 == null || !string7.equals(string2))) continue;
            string = bl ? null : cacheEntry2.getCodebaseIP();
            String string9 = string8 = bl ? null : ((CacheEntry)object).getCodebaseIP();
            if (string != string8 && (string == null || !string.equals(string8)) || ((CacheEntry)object).getIndexFile().equals(cacheEntry2.getIndexFile()) || !Cache.removeCacheEntry((CacheEntry)object, false)) continue;
            n += ((CacheEntry)object).getContentLength();
            ++n2;
        }
        if (n > 0) {
            Trace.println("Remove " + n2 + " Duplicates of: [" + cacheEntry2.getURL() + ", ", TraceLevel.NETWORK);
            Trace.println("\tidx: " + cacheEntry2.getIndexFile() + "], " + n + " bytes", TraceLevel.NETWORK);
        }
        return n;
    }

    static boolean removeCacheEntry(final CacheEntry cacheEntry, final boolean bl) {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean bl2 = Cache.removeCacheEntryImpl(cacheEntry, bl);
                return Boolean.valueOf(String.valueOf(bl2));
            }
        });
        boolean bl3 = bl2;
        if (!bl3 && !cacheEntry.isIncomplete()) {
            Cache.markResourceIncomplete(cacheEntry);
        }
        return bl3;
    }

    private static boolean removeCacheEntryImpl(CacheEntry cacheEntry, boolean bl) {
        Object object;
        if (Trace.isEnabled(TraceLevel.NETWORK)) {
            Trace.println(ResourceManager.getString("cache.removeCacheEntry", cacheEntry == null ? "" : cacheEntry.getURL()), TraceLevel.NETWORK);
        }
        if (!cacheEntry.getIndexFile().getParentFile().getParentFile().equals(Cache.getActiveCacheDir())) {
            return true;
        }
        File file = new File(cacheEntry.getResourceFilename());
        File file2 = cacheEntry.getIndexFile();
        String string = cacheEntry.getURL();
        String string2 = cacheEntry.getVersion();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!MemoryCache.contains(string)) {
            bl2 = file.delete();
            if (!bl2) {
                Trace.println("Failed to delete: " + file, TraceLevel.CACHE);
                file.deleteOnExit();
            }
            if (!(bl3 = file2.delete())) {
                file2.deleteOnExit();
            }
        } else {
            file.deleteOnExit();
            file2.deleteOnExit();
        }
        Cache.clobber(new File(cacheEntry.getNativeLibPath()));
        try {
            object = Cache.getLapFileName(new URL(string), string2);
            File file3 = new File(Cache.getActiveCacheDir(), (String)object);
            if (file3.exists() && bl) {
                file3.delete();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        object = new File(cacheEntry.getResourceFilename() + ".ico");
        Cache.ensureFileDeleted((File)object);
        Cache.recordLastAccessed();
        MemoryCache.removeLoadedResource(cacheEntry.getURL());
        return bl2 && bl3;
    }

    private static void clobber(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    Cache.clobber(fileArray[i]);
                }
                Cache.ensureFileDeleted(file);
            } else {
                Cache.ensureFileDeleted(file);
            }
        }
    }

    private static void ensureFileDeleted(File file) {
        if (file != null && file.exists() && !file.delete()) {
            file.deleteOnExit();
        }
    }

    public static boolean removeCacheEntry(CacheEntry cacheEntry) {
        return Cache.removeCacheEntry(cacheEntry, true);
    }

    static File[] getMatchingIndexFiles(File file, URL uRL) {
        final String string = Cache.getKey(uRL);
        final File file2 = new File(file.getPath() + File.separator + Cache.getBucket(string));
        File[] fileArray = (File[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File[] fileArray = file2.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        String string = file.getName();
                        return string.startsWith(string) && string.endsWith(Cache.INDEX_FILE_EXT);
                    }
                });
                return fileArray;
            }
        });
        return fileArray;
    }

    public static CacheEntry getCacheEntryFromFile(File file) {
        return Cache.getCacheEntryFromFile(file, false);
    }

    public static CacheEntry getCacheEntryFromFile(File file, boolean bl) {
        CacheEntry cacheEntry = new CacheEntry(file, bl);
        if (cacheEntry != null && !cacheEntry.isIncomplete() && Cache.isCacheEntryIPValid(cacheEntry)) {
            return cacheEntry;
        }
        return null;
    }

    public static String getVersionFromFilename(String string) {
        int n = string.indexOf(DASH);
        int n2 = string.indexOf(DASH, n + 1);
        int n3 = string.lastIndexOf(DASH);
        if (n2 >= 0 && n3 > n2 + 1) {
            return string.substring(n2 + 1, n3);
        }
        return null;
    }

    public static CacheEntry getLatestCacheEntry(URL uRL) {
        File file = null;
        String string = null;
        File[] fileArray = Cache.getMatchingIndexFiles(cacheDir, uRL);
        for (int i = 0; i < fileArray.length; ++i) {
            if (file == null) {
                file = fileArray[i];
                continue;
            }
            String string2 = Cache.getVersionFromFilename(fileArray[i].getName());
            String string3 = Cache.getVersionFromFilename(file.getName());
            if (string2 == null || string3 != null && string2.compareTo(string3) <= 0) continue;
            file = fileArray[i];
        }
        if (file != null) {
            return Cache.getCacheEntryFromFile(file);
        }
        return CacheUpgrader.getInstance().upgradeItem(uRL, string, 1);
    }

    private static CacheEntry getCacheEntryFromIdxFiles(File[] fileArray, URL uRL, String string, int n) {
        File file;
        CacheEntry cacheEntry = null;
        CacheEntry cacheEntry2 = null;
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                cacheEntry = new CacheEntry(fileArray[i]);
                if (cacheEntry.getIncomplete() == CacheEntry.INCOMPLETE_FALSE) {
                    if (cacheEntry.getURL().equals(uRL.toString())) {
                        if (!Cache.isCacheEntryIPValid(cacheEntry)) continue;
                        if (string == null && cacheEntry.getVersion() == null) {
                            cacheEntry2 = cacheEntry;
                            break;
                        }
                        if (string == null || !new VersionString(string).contains(cacheEntry.getVersion())) continue;
                        if (cacheEntry2 == null) {
                            cacheEntry2 = cacheEntry;
                            continue;
                        }
                        if (cacheEntry.getVersion() == null || cacheEntry.getVersion().compareTo(cacheEntry2.getVersion()) <= 0) continue;
                        cacheEntry2 = cacheEntry;
                        continue;
                    }
                    if (cacheEntry.getURL().indexOf(63) == -1) continue;
                    Cache.removeCacheEntry(cacheEntry, false);
                    continue;
                }
                Cache.cleanup();
            }
        }
        if (cacheEntry2 != null && DownloadEngine.isNativeContentType(n) && !cacheEntry2.isRedirectEntry() && !(file = new File(cacheEntry2.getNativeLibPath())).isDirectory()) {
            Cache.removeCacheEntry(cacheEntry2);
            cacheEntry2 = null;
        }
        return cacheEntry2;
    }

    public static void updateHostIPFile(String string) {
        String string2 = Cache.getCachedHostIP(string);
        if (string2 == null) {
            Cache.createHostEntry(string);
        } else {
            String string3 = Cache.getCurrentIP(string, string2);
            if (string3 != null && !string3.equals(string2)) {
                Cache.updateHostEntry(string);
            }
        }
    }

    private static URL getHostURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL("http://" + string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    private static void updateHostEntry(String string) {
        URL uRL = Cache.getHostURL(string);
        final File[] fileArray = Cache.getMatchingHostFiles(hostDir, uRL);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < fileArray.length; ++i) {
                    fileArray[i].delete();
                }
                return null;
            }
        });
        Cache.createHostEntry(string);
    }

    private static String getCurrentIP(String string, String string2) {
        Method method;
        if (string == null || string2 == null) {
            return null;
        }
        if (!doIPLookup) {
            return null;
        }
        String string3 = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.net.InetAddress");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.ignoredException(classNotFoundException);
            return null;
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            Trace.ignoredException(unknownHostException);
        }
        Object[] objectArray = new Object[]{string, inetAddress};
        Class[] classArray = new Class[2];
        try {
            classArray[0] = Class.forName("java.lang.String");
            classArray[1] = clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.ignoredException(classNotFoundException);
            return null;
        }
        try {
            method = clazz.getDeclaredMethod("getByName", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                method.setAccessible(true);
                return null;
            }
        });
        if (!Modifier.isStatic(method.getModifiers())) {
            return null;
        }
        InetAddress inetAddress2 = null;
        try {
            inetAddress2 = (InetAddress)method.invoke((Object)null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            Trace.ignoredException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (inetAddress2 != null) {
            string3 = inetAddress2.getHostAddress();
        }
        return string3;
    }

    private static boolean isCacheEntryIPValid(CacheEntry cacheEntry) {
        boolean bl = true;
        if (cacheEntry != null && cacheEntry.isKnownToBeSigned()) {
            return bl;
        }
        String string = cacheEntry.getCodebaseIP();
        if (string == null) {
            return bl;
        }
        URL uRL = null;
        try {
            uRL = new URL(cacheEntry.getURL());
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
            return false;
        }
        String string2 = uRL.getHost();
        String string3 = Cache.getCurrentIP(string2, string);
        if (string3 == null) {
            return true;
        }
        if (!string3.equals(string)) {
            Trace.println("CacheEntry IP mismatch: " + string3 + " != " + string, TraceLevel.CACHE);
            bl = false;
        }
        return bl;
    }

    public static CacheEntry getCacheEntry(URL uRL, String string) {
        return Cache.getCacheEntry(uRL, string, 1);
    }

    public static CacheEntry getCacheEntry(URL uRL, String string, int n) {
        CacheEntry cacheEntry;
        CacheEntry cacheEntry2 = (CacheEntry)MemoryCache.getLoadedResource(uRL.toString());
        if (cacheEntry2 != null && cacheEntry2.matchesVersionString(string, true)) {
            if (cacheEntry2.getIsProxied() != 0) {
                Cache.setIsProxiedHost(uRL.getHost());
            }
            return cacheEntry2;
        }
        CacheEntry cacheEntry3 = Cache.getCacheEntry(uRL, string, cacheDir, n);
        if (cacheEntry3 == null) {
            cacheEntry3 = CacheUpgrader.getInstance().upgradeItem(uRL, string, n);
        }
        if ((cacheEntry = Cache.getCacheEntry(uRL, string, sysCacheDir, n)) == null) {
            cacheEntry = CacheUpgrader.getSystemInstance().upgradeItem(uRL, string, n);
        }
        if (Environment.isSystemCacheMode()) {
            if (cacheEntry != null) {
                MemoryCache.addLoadedResource(uRL.toString(), cacheEntry);
                Trace.println("System Cache: " + ResourceManager.getString("cache.getCacheEntry.return.found", uRL == null ? "" : uRL.toString(), string) + " prevalidated=" + cacheEntry.isKnownToBeSigned() + "/" + cacheEntry.getClassesVerificationStatus(), TraceLevel.NETWORK);
                if (cacheEntry.getIsProxied() != 0) {
                    Cache.setIsProxiedHost(uRL.getHost());
                }
            }
            return cacheEntry;
        }
        if (cacheEntry != null) {
            if (cacheEntry3 != null) {
                if (cacheEntry3.getLastModified() <= cacheEntry.getLastModified()) {
                    cacheEntry3 = cacheEntry;
                }
            } else {
                cacheEntry3 = cacheEntry;
            }
        }
        if (Cache.hasIncompatibleCompressEncoding(cacheEntry3)) {
            Cache.markResourceIncomplete(cacheEntry3);
            cacheEntry3 = null;
        }
        if (cacheEntry3 == null) {
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.println(ResourceManager.getString("cache.getCacheEntry.return.notfound", uRL == null ? "" : uRL.toString(), string), TraceLevel.NETWORK);
            }
        } else {
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.println(ResourceManager.getString("cache.getCacheEntry.return.found", uRL == null ? "" : uRL.toString(), string) + " prevalidated=" + cacheEntry3.isKnownToBeSigned() + "/" + cacheEntry3.getClassesVerificationStatus(), TraceLevel.NETWORK);
            }
            MemoryCache.addLoadedResource(uRL.toString(), cacheEntry3);
        }
        if (cacheEntry3 != null && cacheEntry3.getIsProxied() != 0) {
            Cache.setIsProxiedHost(uRL.getHost());
        }
        return cacheEntry3;
    }

    private static CacheEntry getCacheEntry(URL uRL, String string, File file) {
        return Cache.getCacheEntry(uRL, string, file, 1);
    }

    private static CacheEntry getCacheEntry(URL uRL, String string, File file, int n) {
        if (file == null) {
            return null;
        }
        File[] fileArray = Cache.getMatchingIndexFiles(file, uRL);
        CacheEntry cacheEntry = Cache.getCacheEntryFromIdxFiles(fileArray, uRL, string, n);
        if ((cacheEntry = Cache.followsRedirect(cacheEntry, file, n)) != null && cacheEntry.getIsProxied() != 0) {
            Cache.setIsProxiedHost(uRL.getHost());
        }
        return cacheEntry;
    }

    private static CacheEntry followsRedirect(CacheEntry cacheEntry, File file, int n) {
        URL uRL;
        URL uRL2 = uRL = cacheEntry == null ? null : cacheEntry.getRedirectFinalURL();
        if (uRL != null) {
            CacheEntry cacheEntry2 = Cache.getCacheEntry(uRL, cacheEntry.getVersion(), file, n);
            if (cacheEntry2 != null) {
                Cache.addLoadedResource(cacheEntry2);
            }
            return cacheEntry2;
        }
        return cacheEntry;
    }

    private static File[] getMatchingMuffinFiles(File file, URL uRL) {
        final String string = Cache.getKey(uRL);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string2 = file.getName();
                return string2.startsWith(string) && !string2.endsWith(Cache.MUFFIN_FILE_EXT);
            }
        });
        return fileArray;
    }

    private static File[] getMatchingMuffinAttributeFiles(File file, URL uRL) {
        final String string = Cache.getKey(uRL);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string2 = file.getName();
                return string2.startsWith(string) && string2.endsWith(Cache.MUFFIN_FILE_EXT);
            }
        });
        return fileArray;
    }

    public static File getMuffinFile(URL uRL) {
        String string = Cache.getKey(uRL);
        File[] fileArray = Cache.getMatchingMuffinFiles(muffinDir, uRL);
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        return fileArray[0];
    }

    public static File getMuffinAttributeFile(URL uRL) {
        String string = Cache.getKey(uRL);
        File[] fileArray = Cache.getMatchingMuffinAttributeFiles(muffinDir, uRL);
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        return fileArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getMuffinAttributes(URL uRL) throws IOException {
        BufferedReader bufferedReader = null;
        long l = -1L;
        long l2 = -1L;
        try {
            File file = Cache.getMuffinAttributeFile(uRL);
            if (file == null) {
                throw new FileNotFoundException("Muffin not found for " + uRL);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string = bufferedReader.readLine();
            try {
                l = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
            string = bufferedReader.readLine();
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return new long[]{l, l2};
    }

    public static void removeMuffinEntry(URL uRL) throws IOException {
        File file = Cache.getMuffinFile(uRL);
        if (file != null) {
            if (!file.delete()) {
                throw new IOException("delete failed for muffin: " + uRL);
            }
            File file2 = new File(file.getPath() + MUFFIN_FILE_EXT);
            if (!file2.delete()) {
                throw new IOException("delete failed for muffin: " + uRL);
            }
        } else {
            throw new FileNotFoundException("Muffin for " + uRL + " does not exists");
        }
    }

    private static String getCachedHostIP(String string) {
        if (string == null) {
            return null;
        }
        URL uRL = Cache.getHostURL(string);
        String string2 = null;
        final File file = Cache.getHostFile(uRL);
        if (file != null) {
            string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = null;
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                        string = bufferedReader.readLine();
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException(iOException);
                    }
                    return string;
                }
            });
        }
        return string2;
    }

    private static File getHostFile(URL uRL) {
        File[] fileArray = Cache.getMatchingHostFiles(hostDir, uRL);
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        return fileArray[0];
    }

    private static File[] getMatchingHostFiles(final File file, URL uRL) {
        final String string = Cache.getKey(uRL);
        File[] fileArray = (File[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File[] fileArray = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        String string = file.getName();
                        return string.startsWith(string) && string.endsWith(Cache.HOST_FILE_EXT);
                    }
                });
                return fileArray;
            }
        });
        return fileArray;
    }

    static InetAddress getHostIP(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            try {
                inetAddress = InetAddress.getByName(IP_ADDR_CANNOT_RESOLVE);
            }
            catch (UnknownHostException unknownHostException2) {
                // empty catch block
            }
        }
        return inetAddress;
    }

    private static void createHostEntry(String string) {
        URL uRL = Cache.getHostURL(string);
        String string2 = Cache.getKey(uRL);
        String string3 = string2 + Integer.toString(Cache.getRandom(), 16);
        final File file = new File(hostDir, string3 + HOST_FILE_EXT);
        InetAddress inetAddress = Cache.getHostIP(string);
        if (inetAddress != null) {
            final String string4 = inetAddress.getHostAddress();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                        bufferedWriter.write(string4);
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException(iOException);
                    }
                    return null;
                }
            });
        }
    }

    public static void createMuffinEntry(URL uRL, int n, long l) throws IOException {
        String string = Cache.getKey(uRL);
        File[] fileArray = Cache.getMatchingMuffinAttributeFiles(muffinDir, uRL);
        if (fileArray.length != 0) {
            throw new IOException("insert failed in cache: target already exixts");
        }
        String string2 = string + Integer.toString(Cache.getRandom(), 16);
        File file = new File(muffinDir, string2 + MUFFIN_FILE_EXT);
        File file2 = new File(muffinDir, string2);
        Cache.putMuffinAttributes(file, uRL, n, l);
        file2.createNewFile();
    }

    public static String[] getMuffinNames(URL uRL) {
        Vector<String> vector = new Vector<String>();
        File[] fileArray = muffinDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                return string.endsWith(Cache.MUFFIN_FILE_EXT);
            }
        });
        URL uRL2 = null;
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                uRL2 = Cache.getCachedMuffinURL(fileArray[i]);
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            if (uRL2 == null) continue;
            URL uRL3 = HttpUtils.removeQueryStringFromURL(uRL2);
            String string = uRL3.getFile().substring(1 + uRL3.getFile().lastIndexOf(47));
            if (!uRL2.toString().equals(uRL.toString() + string)) continue;
            vector.add(string);
        }
        return vector.toArray(new String[0]);
    }

    public static URL[] getAccessibleMuffins(URL uRL) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        File[] fileArray = muffinDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                return string.endsWith(Cache.MUFFIN_FILE_EXT);
            }
        });
        boolean bl = false;
        for (int i = 0; i < fileArray.length; ++i) {
            URL uRL2 = Cache.getCachedMuffinURL(fileArray[i]);
            if (!uRL2.getHost().equals(uRL.getHost())) continue;
            arrayList.add(uRL2);
        }
        return arrayList.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL getCachedMuffinURL(File file) throws IOException {
        Object object;
        BufferedReader bufferedReader = null;
        long l = -1L;
        long l2 = -1L;
        String string = null;
        try {
            object = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            string = bufferedReader.readLine();
            string = bufferedReader.readLine();
            string = bufferedReader.readLine();
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        object = null;
        try {
            object = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
        }
        return object;
    }

    public static long getMuffinSize(URL uRL) throws IOException {
        long l = 0L;
        File file = Cache.getMuffinFile(uRL);
        if (file != null && file.exists()) {
            l += file.length();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putMuffinAttributes(File file, URL uRL, int n, long l) throws IOException {
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        try {
            printStream.println(n);
            printStream.println(l);
            printStream.println(uRL.toString());
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putMuffinAttributes(URL uRL, int n, long l) throws IOException {
        File file = Cache.getMuffinAttributeFile(uRL);
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        try {
            printStream.println(n);
            printStream.println(l);
            printStream.println(uRL.toString());
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    static String generateCacheFileName(final URL uRL, final String string) throws IOException {
        String string2;
        block2: {
            string2 = null;
            try {
                string2 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        File file;
                        String string3;
                        File file2;
                        String string2 = Cache.getKey(uRL);
                        do {
                            string3 = Cache.getBucket(string2) + File.separator + string2 + Integer.toString(Cache.getRandom(), 16) + Cache.getVersionTag(string);
                            file = new File(cacheDir, string3);
                        } while ((file2 = new File(cacheDir, string3 + Cache.INDEX_FILE_EXT)).exists() || file.exists());
                        file2 = null;
                        file = null;
                        return string3;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
        return string2;
    }

    private static int getBucket(String string) {
        return Integer.valueOf(string.substring(0, string.length() - 1), 16) & 0x3F;
    }

    protected static String getKey(URL uRL) {
        int n = Cache.hashCode(HttpUtils.removeQueryStringFromURL(uRL));
        if (n < 0) {
            n -= Integer.MIN_VALUE;
        }
        String string = Integer.toString(n, 16);
        return string + DASH;
    }

    protected static int hashCode(URL uRL) {
        int n = uRL.toString().hashCode();
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    protected static String getFileExtension(String string) {
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = string.substring(n);
        }
        return string2;
    }

    protected static int getRandom() {
        return 0x10000000 + Cache.getSecureRandom().nextInt(0x6FFFFFFF);
    }

    public static void insertFile(File file, int n, URL uRL, String string, long l, long l2) throws IOException {
        CacheEntry cacheEntry = Cache.createNewCacheEntry(uRL, string);
        try {
            Cache.copyFile(file, new File(cacheEntry.getResourceFilename()));
        }
        catch (IOException iOException) {
            Cache.removeCacheEntry(cacheEntry);
            throw iOException;
        }
        cacheEntry.setBusy(CacheEntry.BUSY_FALSE);
        cacheEntry.setIncomplete(CacheEntry.INCOMPLETE_FALSE);
        cacheEntry.setURL(uRL.toString());
        cacheEntry.setContentLength((int)file.length());
        cacheEntry.setLastModified(l);
        cacheEntry.setExpirationDate(l2);
        if (string != null) {
            cacheEntry.setVersion(string);
        }
        if (DownloadEngine.isJarContentType(n)) {
            MessageHeader messageHeader = new MessageHeader();
            messageHeader.add("deploy-request-content-type", "application/x-java-archive");
            cacheEntry.setHeaders(messageHeader);
        }
        Cache.setCeIsProxied(cacheEntry, uRL.getHost());
        cacheEntry.writeFileToDisk(n, null);
        Cache.recordLastAccessed();
    }

    public static void insertMuffin(URL uRL, File file, int n, long l) throws IOException {
        File[] fileArray = Cache.getMatchingMuffinAttributeFiles(muffinDir, uRL);
        if (fileArray.length != 0) {
            throw new IOException("insert failed in cache: target already exixts");
        }
        String string = Cache.getKey(uRL);
        String string2 = string + Integer.toString(Cache.getRandom(), 16);
        File file2 = new File(muffinDir, string2 + MUFFIN_FILE_EXT);
        Cache.putMuffinAttributes(file2, uRL, n, l);
        Cache.copyFile(file, new File(muffinDir, string2));
    }

    public static void copyFile(File file, File file2) throws IOException {
        Object var2_2 = null;
        Object var3_3 = null;
        Cache.copyStream(new FileInputStream(file), new FileOutputStream(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        byte[] byArray = new byte[10240];
        try {
            int n = bufferedInputStream.read(byArray);
            while (n >= 0) {
                bufferedOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray);
            }
        }
        finally {
            try {
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void removeAllMuffins() {
        File[] fileArray = muffinDir.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i].delete();
        }
    }

    static String getCachedResourceFilePath(URL uRL, String string) throws IOException {
        if (Cache.isCacheEnabled()) {
            CacheEntry cacheEntry = Cache.getCacheEntry(uRL, string);
            if (cacheEntry != null) {
                return cacheEntry.getResourceFilename();
            }
        } else {
            Object object = MemoryCache.getLoadedResource(uRL.toString());
            if (object != null) {
                if (object instanceof JarFile) {
                    return ((JarFile)object).getName();
                }
                if (object instanceof CacheEntry) {
                    return ((CacheEntry)object).getResourceFilename();
                }
            }
        }
        throw new IOException("Cannot find cached resource for URL: " + uRL.toString());
    }

    static {
        loadedProperties = new HashMap();
        syncObject = new Object();
        cleanupEnabled = true;
        ResourceProviderImpl.init();
        Cache.reset();
        if (Cache.isCacheEnabled()) {
            ct = new CleanupThread("CacheCleanUpThread", syncObject);
            ct.start();
        } else {
            ct = null;
        }
    }
}

