/*
 * Decompiled with CFR 0.152.
 */
package wafly.application.scanCD;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import wafly.application.scanCD.forms.MainForm;
import wafly.tool.util.draw.ImageUtil;
import wafly.tool.util.file.FileUtil;
import wafly.tool.util.properties.Language;
import wafly.tool.util.properties.Parameter;

public class Core {
    private static String CDroot = "";
    private static String StorePath = "";
    private static String cdLabel = "";
    private static boolean isStart = false;
    private static boolean isPause = false;
    private static long recordDate;
    private static long filesCount;
    private static long diskSize;
    private static final String imgType = "/.jpg/.png/.bmp/.gif/.jpeg";
    private static final String textType = "/.txt/.ini/.inf/.html/.htm/.asp/.asa/.aspx/.asax/.shtml/.cpp/.c/.h/.rc/.pl/.pm/.cgi/.php/.java/.jsp/.js/.vbs/.vb/.css/.xml/.cs/.py/.rb/.erb/.rhtml";

    public static void init(String CDroot, String StorePath, String cdLabel) {
        Core.CDroot = CDroot;
        Core.StorePath = StorePath;
        Core.cdLabel = cdLabel;
    }

    private static void scan(String filepath) {
        File[] files;
        while (isPause) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        File currScan = new File(filepath);
        File currStore = new File(String.valueOf(StorePath) + cdLabel + "\\" + filepath.substring(CDroot.length()));
        MainForm.getInstance().updateStatus(currScan.getName());
        if (!currScan.exists()) {
            MainForm.getInstance().recordError(String.valueOf(currScan.getAbsolutePath()) + " " + Language.getString((String)"LOSE"));
            return;
        }
        if (!currScan.isDirectory()) {
            String ext = filepath.substring(filepath.lastIndexOf(".")).toLowerCase();
            try {
                if (imgType.indexOf(ext) > 0) {
                    ImageUtil.saveToFile((BufferedImage)((BufferedImage)ImageUtil.getThumbnail((Image)ImageUtil.getImage((String)filepath), (int)64)), (File)currStore);
                } else if (textType.indexOf(ext) > 0) {
                    currStore.createNewFile();
                    FileWriter fw = new FileWriter(currStore);
                    fw.write(new FileUtil().getTextSummary(filepath, 50));
                    fw.close();
                } else {
                    currStore.createNewFile();
                }
                ++filesCount;
                diskSize += currScan.length();
            }
            catch (Exception e) {
                String filePath = currStore.getAbsolutePath();
                new File(filePath.substring(0, filePath.lastIndexOf("\\"))).mkdirs();
                try {
                    if (imgType.indexOf(ext) > 0) {
                        ImageUtil.saveToFile((BufferedImage)((BufferedImage)ImageUtil.getThumbnail((Image)ImageUtil.getImage((String)filepath), (int)64)), (String)filePath);
                    } else if (textType.indexOf(ext) > 0) {
                        currStore.createNewFile();
                        FileWriter fw = new FileWriter(currStore);
                        fw.write(new FileUtil().getTextSummary(filepath, 50));
                        fw.close();
                    } else {
                        currStore.createNewFile();
                    }
                    ++filesCount;
                    diskSize += currScan.length();
                }
                catch (Exception e1) {
                    MainForm.getInstance().recordError(String.valueOf(Language.getString((String)"FILE")) + " " + currStore.getAbsolutePath() + " " + Language.getString((String)"RECORD_FAIL"));
                }
            }
            return;
        }
        if (!currStore.exists() && !currStore.mkdirs()) {
            MainForm.getInstance().recordError(String.valueOf(Language.getString((String)"FOLDER")) + " " + currStore.getAbsolutePath() + " " + Language.getString((String)"RECORD_FAIL"));
        }
        if ((files = currScan.listFiles()) != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                Core.scan(files[i].getAbsolutePath());
                ++i;
            }
        }
    }

    public static void start() {
        if (!isStart) {
            isStart = true;
            recordDate = System.currentTimeMillis();
            new Thread(){

                @Override
                public void run() {
                    filesCount = 0L;
                    diskSize = 0L;
                    Core.scan(CDroot);
                    Parameter params = new Parameter(String.valueOf(StorePath) + cdLabel + ".properties");
                    params.setParam("LABEL", (Object)cdLabel);
                    params.setParam("RECORD_DATE", (Object)recordDate);
                    params.setParam("FILES_COUNT", (Object)filesCount);
                    params.setParam("DISK_SIZE", (Object)diskSize);
                    params.saveToFile();
                    MainForm.getInstance().missionClear();
                    isStart = false;
                }
            }.start();
        } else {
            isPause = false;
        }
    }

    public static void pause() {
        isPause = true;
    }
}

