/*
 * Decompiled with CFR 0.152.
 */
package wafly.application.scanCD.forms;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import wafly.application.scanCD.Core;
import wafly.application.scanCD.forms.HelpForm;
import wafly.application.scanCD.forms.RecordForm;
import wafly.application.scanCD.forms.RegisterForm;
import wafly.tool.util.process.TryUtil;
import wafly.tool.util.properties.Language;
import wafly.tool.util.properties.Parameter;
import wafly.tool.util.ui.FormUtil;

public class MainForm
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int size_width = 375;
    private static final int size_height_0 = 165;
    private static final int size_height_1 = 400;
    private static MainForm instance = new MainForm();
    private JLabel statusValueLabel = new JLabel("");
    private DefaultListModel model = new DefaultListModel();
    private final JTextField storePathTextField = new JTextField();
    private JButton selectStorePathButton = new JButton(Language.getString((String)"SELECT"));
    private final JTextField cdLabelTextField = new JTextField();
    private final JButton startScanButton = new JButton(Language.getString((String)"START_SCAN"));
    private final JComboBox driversComboBox = new JComboBox<String>(new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"});
    private JList errorList = new JList();
    private final JButton spandButton = new JButton("\u25bc" + Language.getString((String)"EXPAN") + "\u25bc");
    private final JLabel driverLabel = new JLabel(Language.getString((String)"DRIVER"));
    private final JLabel storePathLabel = new JLabel(Language.getString((String)"STORE_PATH"));
    private final JLabel cdLabelLabel = new JLabel(Language.getString((String)"LABEL"));
    private final JLabel statusLabel = new JLabel(Language.getString((String)"SURR_STATUS"));
    private final JLabel errorLabel = new JLabel(Language.getString((String)"ERR_MSG"));
    private final JMenuItem viewRecordsMenuItem = new JMenuItem(Language.getString((String)"VIEW"));
    private final JMenuItem registerMenuItem = new JMenuItem(Language.getString((String)"REGISTER"));
    private final JMenuItem helpMenuItem = new JMenuItem(Language.getString((String)"HELP"));
    private static boolean isSpan = false;
    private static boolean isStart = false;
    private static boolean isRefreshing = false;

    public static MainForm getInstance() {
        return instance;
    }

    private MainForm() {
        final Parameter params = new Parameter("setting.ini");
        FormUtil.setWindowStyle((Frame)this, (int)4);
        this.setSize(375, 165);
        this.setTitle(Language.getString((String)"APP_TITLE"));
        try {
            this.setIconImage(ImageIO.read(new File("ICON.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        FormUtil.setCloseAction((Window)this, (FormUtil.WindowAction)FormUtil.WindowAction.EXIT, (FormUtil.ActionMethod)new FormUtil.ActionMethod(){

            public boolean onClosing() {
                params.saveToFile();
                return true;
            }
        });
        FormUtil.locateOnScreenCenter((Window)this);
        this.setLayout(null);
        this.initControls(params);
        String langFilePath = params.getParam("LANG_FILE");
        if (langFilePath == null) {
            langFilePath = "../lang/cn.properties";
            params.setParam("LANG_FILE", (Object)"../lang/cn.properties");
        }
        this.setLanguage(langFilePath);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.BLACK);
        g.drawLine(20, 140, 135, 140);
        g.drawLine(250, 140, 350, 140);
    }

    private void initControls(final Parameter params) {
        this.driverLabel.setSize(80, 20);
        this.driverLabel.setLocation(20, 20);
        this.add(this.driverLabel);
        this.driversComboBox.setSize(50, 20);
        this.driversComboBox.setLocation(100, 20);
        int defaultIdx = 0;
        try {
            defaultIdx = Integer.parseInt(params.getParam("CD_DRV"));
        }
        catch (Exception e) {
            params.setParam("CD_DRV", (Object)0);
        }
        this.driversComboBox.setSelectedIndex(defaultIdx);
        this.driversComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                params.setParam("CD_DRV", (Object)MainForm.this.driversComboBox.getSelectedIndex());
                try {
                    InputStream cmdIS = Runtime.getRuntime().exec("cmd /c vol " + MainForm.this.driversComboBox.getSelectedItem() + ": 2>nul").getInputStream();
                    BufferedReader cmdBR = new BufferedReader(new InputStreamReader(cmdIS, "GBK"));
                    String line = cmdBR.readLine();
                    if (line != null && line.trim().indexOf(" ") > 0) {
                        MainForm.this.cdLabelTextField.setText(line.substring(line.trim().lastIndexOf(" ") + 1).trim());
                    }
                    cmdBR.close();
                    cmdIS.close();
                }
                catch (Exception ex) {
                    MainForm.this.cdLabelTextField.setText("");
                }
                instance.invalidate();
                instance.repaint();
            }
        });
        this.add(this.driversComboBox);
        final JPopupMenu settingMenu = new JPopupMenu();
        JMenuItem chLangMenuItem = new JMenuItem("\u5207\u6362\u754c\u9762\u4e3a\u4e2d\u6587");
        chLangMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.setLanguage("../lang/cn.properties");
                params.setParam("LANG_FILE", (Object)"../lang/cn.properties");
            }
        });
        settingMenu.add(chLangMenuItem);
        JMenuItem enLangMenuItem = new JMenuItem("Switch to English");
        settingMenu.add(enLangMenuItem);
        enLangMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.setLanguage("../lang/en.properties");
                params.setParam("LANG_FILE", (Object)"../lang/en.properties");
            }
        });
        settingMenu.addSeparator();
        JMenu moreMenu = new JMenu("...");
        settingMenu.add(moreMenu);
        moreMenu.add(this.viewRecordsMenuItem);
        this.viewRecordsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordForm.instance.setVisible(true);
            }
        });
        moreMenu.addSeparator();
        moreMenu.add(this.registerMenuItem);
        this.registerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new RegisterForm().setVisible(true);
            }
        });
        moreMenu.add(this.helpMenuItem);
        this.helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new HelpForm().setVisible(true);
            }
        });
        final JButton settingButton = new JButton();
        settingButton.setSize(20, 20);
        settingButton.setLocation(330, 20);
        settingButton.setIcon(new ImageIcon("setting.png"));
        settingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settingMenu.show(settingButton, 10, 10);
            }
        });
        this.add(settingButton);
        this.storePathLabel.setSize(80, 20);
        this.storePathLabel.setLocation(20, 50);
        this.add(this.storePathLabel);
        this.storePathTextField.setSize(190, 20);
        this.storePathTextField.setLocation(100, 50);
        String storePath = params.getParam("STORE_PATH");
        if (storePath != null) {
            this.storePathTextField.setText(storePath);
        } else {
            this.storePathTextField.setText(new File("CD_Store").getAbsolutePath());
        }
        this.add(this.storePathTextField);
        this.selectStorePathButton.setSize(50, 20);
        this.selectStorePathButton.setLocation(300, 50);
        this.selectStorePathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser();
                jfc.setFileSelectionMode(1);
                if (jfc.showOpenDialog(instance) == 1) {
                    instance.invalidate();
                    instance.repaint();
                    return;
                }
                String storePath = String.valueOf(jfc.getSelectedFile().getAbsolutePath()) + "\\";
                MainForm.this.storePathTextField.setText(storePath);
                instance.invalidate();
                instance.repaint();
            }
        });
        this.add(this.selectStorePathButton);
        this.cdLabelLabel.setSize(80, 20);
        this.cdLabelLabel.setLocation(20, 80);
        this.add(this.cdLabelLabel);
        this.cdLabelTextField.setSize(100, 20);
        this.cdLabelTextField.setLocation(100, 80);
        String cdLabel = params.getParam("CD_LABEL");
        if (cdLabel != null) {
            this.cdLabelTextField.setText(cdLabel);
        } else {
            this.cdLabelTextField.setText(Language.getString((String)"NEW_CD"));
        }
        this.add(this.cdLabelTextField);
        this.spandButton.setSize(100, 20);
        this.spandButton.setLocation(140, 105);
        this.spandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (isSpan) {
                    MainForm.this.spandButton.setText("\u25bc" + Language.getString((String)"EXPAN") + "\u25bc");
                    instance.setSize(375, 165);
                    isSpan = false;
                } else {
                    MainForm.this.spandButton.setText("\u25b2" + Language.getString((String)"PACKUP") + "\u25b2");
                    instance.setSize(375, 400);
                    isSpan = true;
                }
            }
        });
        this.add(this.spandButton);
        this.startScanButton.setSize(100, 20);
        this.startScanButton.setLocation(250, 80);
        this.startScanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (isStart) {
                    MainForm.this.storePathTextField.setEnabled(true);
                    MainForm.this.selectStorePathButton.setEnabled(true);
                    MainForm.this.cdLabelTextField.setEnabled(true);
                    MainForm.this.startScanButton.setText(Language.getString((String)"START_SCAN"));
                    Core.pause();
                    isStart = false;
                } else {
                    if (TryUtil.datesTry((int)30, (String)"ScanCD", (String)"../key") == 0) {
                        JOptionPane.showMessageDialog(MainForm.getInstance(), Language.getString((String)"MSG_TIMEOUT"), Language.getString((String)"ERROR"), 0);
                        System.exit(0);
                        return;
                    }
                    String storePathStr = MainForm.this.storePathTextField.getText().trim();
                    String cdLabelStr = MainForm.this.cdLabelTextField.getText().trim();
                    if (storePathStr.length() == 0) {
                        JOptionPane.showMessageDialog(instance, Language.getString((String)"MSG_INPUT_PATH"), Language.getString((String)"ERROR"), 0);
                        return;
                    }
                    if (cdLabelStr.length() == 0) {
                        JOptionPane.showMessageDialog(instance, Language.getString((String)"MSG_INPUT_LABEL"), Language.getString((String)"ERROR"), 0);
                        return;
                    }
                    File storePath = new File(storePathStr);
                    if (!storePath.exists() && !storePath.mkdirs() || !storePath.isDirectory()) {
                        JOptionPane.showMessageDialog(instance, Language.getString((String)"MSG_PATH_INVALID"), Language.getString((String)"ERROR"), 0);
                        return;
                    }
                    if (new File(String.valueOf(storePathStr) + File.separator + cdLabelStr).exists() && JOptionPane.showConfirmDialog(instance, Language.getString((String)"MSG_RESCEN"), Language.getString((String)"CONFIRM"), 0) == 1) {
                        return;
                    }
                    MainForm.this.driversComboBox.setEnabled(false);
                    MainForm.this.storePathTextField.setEnabled(false);
                    MainForm.this.selectStorePathButton.setEnabled(false);
                    MainForm.this.cdLabelTextField.setEnabled(false);
                    if (!storePathStr.endsWith("\\")) {
                        storePathStr = String.valueOf(storePathStr) + "\\";
                    }
                    params.setParam("STORE_PATH", (Object)storePathStr);
                    params.setParam("CD_LABEL", (Object)cdLabelStr);
                    params.saveToFile();
                    MainForm.this.startScanButton.setText(Language.getString((String)"PAUSE_SCAN"));
                    isStart = true;
                    MainForm.this.spandButton.setText("\u25b2" + Language.getString((String)"PACKUP") + "\u25b2");
                    instance.setSize(375, 400);
                    isSpan = true;
                    Core.init(String.valueOf((String)MainForm.this.driversComboBox.getSelectedItem()) + ":\\", storePathStr, cdLabelStr);
                    Core.start();
                }
            }
        });
        this.add(this.startScanButton);
        this.statusLabel.setSize(80, 20);
        this.statusLabel.setLocation(20, 135);
        this.add(this.statusLabel);
        this.statusValueLabel.setSize(250, 20);
        this.statusValueLabel.setLocation(100, 135);
        this.statusValueLabel.setBorder(new LineBorder(Color.BLACK));
        this.add(this.statusValueLabel);
        this.errorLabel.setSize(80, 20);
        this.errorLabel.setLocation(20, 165);
        this.add(this.errorLabel);
        JScrollPane jScrollPane1 = new JScrollPane(this.errorList);
        jScrollPane1.setSize(330, 150);
        jScrollPane1.setLocation(20, 195);
        this.add(jScrollPane1);
    }

    private void setLanguage(String langFile) {
        Language.switchLanguage((File)new File(langFile));
        this.setTitle(Language.getString((String)"APP_TITLE"));
        this.driverLabel.setText(Language.getString((String)"DRIVER"));
        this.storePathLabel.setText(Language.getString((String)"STORE_PATH"));
        this.cdLabelLabel.setText(Language.getString((String)"LABEL"));
        this.spandButton.setText("\u25bc" + Language.getString((String)"EXPAN") + "\u25bc");
        this.setSize(375, 165);
        isSpan = false;
        this.selectStorePathButton.setText(Language.getString((String)"SELECT"));
        this.startScanButton.setText(Language.getString((String)"START_SCAN"));
        this.statusLabel.setText(Language.getString((String)"SURR_STATUS"));
        this.errorLabel.setText(Language.getString((String)"ERR_MSG"));
        this.registerMenuItem.setText(Language.getString((String)"REGISTER"));
        this.viewRecordsMenuItem.setText(Language.getString((String)"VIEW"));
        this.helpMenuItem.setText(Language.getString((String)"HELP"));
    }

    public void updateStatus(String msg) {
        this.statusValueLabel.setText(msg);
    }

    public void recordError(String msg) {
        while (isRefreshing) {
        }
        isRefreshing = true;
        this.model.insertElementAt(msg, 0);
        this.errorList.setModel(this.model);
        this.spandButton.setText("\u25b2" + Language.getString((String)"PACKUP") + "\u25b2");
        instance.setSize(375, 400);
        isSpan = true;
        this.errorList.invalidate();
        this.errorList.repaint();
        isRefreshing = false;
    }

    public void missionClear() {
        this.driversComboBox.setEnabled(true);
        this.storePathTextField.setEnabled(true);
        this.selectStorePathButton.setEnabled(true);
        this.cdLabelTextField.setEnabled(true);
        this.startScanButton.setText(Language.getString((String)"START_SCAN"));
        isStart = false;
        this.statusValueLabel.setText(Language.getString((String)"COMPLETED"));
    }
}

