/*
 * Decompiled with CFR 0.152.
 */
package wafly.application.scanCD.forms;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import wafly.application.scanCD.CDbean;
import wafly.control.explorer.Icon;
import wafly.control.explorer.IconExplorer;
import wafly.control.explorer.SelectionListener;
import wafly.tool.util.properties.Language;
import wafly.tool.util.properties.Parameter;
import wafly.tool.util.ui.FormUtil;

public class RecordForm
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static RecordForm instance = new RecordForm();
    private IconExplorer explorer = new IconExplorer();

    private RecordForm() {
        this.setSize(800, 600);
        this.setTitle(Language.getString((String)"APP_TITLE"));
        try {
            this.setIconImage(ImageIO.read(new File("ICON.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        FormUtil.locateOnScreenCenter((Window)this);
        FormUtil.setCloseAction((Window)this, (FormUtil.WindowAction)FormUtil.WindowAction.HIDE);
        JPanel infoPanel = new JPanel();
        infoPanel.setPreferredSize(new Dimension(1, 150));
        infoPanel.setLayout(null);
        this.add((Component)infoPanel, "South");
        JLabel labelLabel = new JLabel(Language.getString((String)"LABEL"));
        labelLabel.setSize(100, 20);
        labelLabel.setLocation(20, 20);
        infoPanel.add(labelLabel);
        final JLabel labelValueLabel = new JLabel();
        labelValueLabel.setSize(200, 20);
        labelValueLabel.setLocation(120, 20);
        infoPanel.add(labelValueLabel);
        JLabel dateLabel = new JLabel(Language.getString((String)"RECORD_DATE"));
        dateLabel.setSize(100, 20);
        dateLabel.setLocation(20, 50);
        infoPanel.add(dateLabel);
        final JLabel dateValueLabel = new JLabel();
        dateValueLabel.setSize(200, 20);
        dateValueLabel.setLocation(120, 50);
        infoPanel.add(dateValueLabel);
        JLabel countLabel = new JLabel(Language.getString((String)"FILE_COUNT"));
        countLabel.setSize(100, 20);
        countLabel.setLocation(20, 80);
        infoPanel.add(countLabel);
        final JLabel countValueLabel = new JLabel();
        countValueLabel.setSize(200, 20);
        countValueLabel.setLocation(120, 80);
        infoPanel.add(countValueLabel);
        JLabel sizeLabel = new JLabel(Language.getString((String)"DISK_SIZE"));
        sizeLabel.setSize(100, 20);
        sizeLabel.setLocation(20, 110);
        infoPanel.add(sizeLabel);
        final JLabel sizeValueLabel = new JLabel();
        sizeValueLabel.setSize(200, 20);
        sizeValueLabel.setLocation(120, 110);
        infoPanel.add(sizeValueLabel);
        this.explorer.addSelectionListener(new SelectionListener(){

            public void onSelected(Icon icon) {
                if (icon == null) {
                    labelValueLabel.setText("");
                    dateValueLabel.setText("");
                    countValueLabel.setText("");
                    sizeValueLabel.setText("");
                } else {
                    CDbean info = (CDbean)icon;
                    labelValueLabel.setText(info.getLabel());
                    dateValueLabel.setText(new SimpleDateFormat(Language.getString((String)"DATE_FORMAT")).format(new Date(info.getRecordDate())));
                    countValueLabel.setText(String.valueOf(info.getFilesCount()));
                    sizeValueLabel.setText(String.valueOf(info.getDiskSize()));
                }
            }
        });
        this.add((Component)this.explorer, "Center");
    }

    public IconExplorer getExplorer() {
        return this.explorer;
    }

    @Override
    public void setVisible(boolean b) {
        String[] CDs;
        super.setVisible(b);
        this.explorer.clear();
        Parameter params = new Parameter("setting.ini");
        String storePath = params.getParam("STORE_PATH");
        if (storePath != null && (CDs = new File(storePath).list()) != null && CDs.length > 0) {
            int i = 0;
            while (i < CDs.length) {
                if (!CDs[i].endsWith(".properties")) {
                    CDbean icon = new CDbean("ICON.png", 100);
                    icon.setStorePath(String.valueOf(storePath) + CDs[i]);
                    icon.setLabel(CDs[i]);
                    Parameter cdInfo = new Parameter(String.valueOf(storePath) + CDs[i] + ".properties");
                    try {
                        icon.setRecordDate(Long.parseLong(cdInfo.getParam("RECORD_DATE")));
                        icon.setFilesCount(Long.parseLong(cdInfo.getParam("FILES_COUNT")));
                        icon.setDiskSize(Long.parseLong(cdInfo.getParam("DISK_SIZE")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.explorer.addIcon((Icon)icon);
                }
                ++i;
            }
        }
    }
}

