/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import sun.invoke.WrapperInstance;

public class MethodHandleProxies {
    private MethodHandleProxies() {
    }

    public static <T> T asInterfaceInstance(final Class<T> clazz, final MethodHandle methodHandle) {
        if (!clazz.isInterface() || !Modifier.isPublic(clazz.getModifiers())) {
            throw new IllegalArgumentException("not a public interface: " + clazz.getName());
        }
        final Method[] methodArray = MethodHandleProxies.getSingleNameMethods(clazz);
        if (methodArray == null) {
            throw new IllegalArgumentException("not a single-method interface: " + clazz.getName());
        }
        final MethodHandle[] methodHandleArray = new MethodHandle[methodArray.length];
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
            MethodHandle methodHandle2 = methodHandle.asType(methodType);
            methodHandle2 = methodHandle2.asType(methodHandle2.type().changeReturnType(Object.class));
            methodHandleArray[i] = methodHandle2.asSpreader(Object[].class, methodType.parameterCount());
        }
        return clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, WrapperInstance.class}, new InvocationHandler(){

            private Object getArg(String string) {
                if (string == "getWrapperInstanceTarget") {
                    return methodHandle;
                }
                if (string == "getWrapperInstanceType") {
                    return clazz;
                }
                throw new AssertionError();
            }

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                for (int i = 0; i < methodArray.length; ++i) {
                    if (!method.equals(methodArray[i])) continue;
                    return methodHandleArray[i].invokeExact(objectArray);
                }
                if (method.getDeclaringClass() == WrapperInstance.class) {
                    return this.getArg(method.getName());
                }
                if (MethodHandleProxies.isObjectMethod(method)) {
                    return MethodHandleProxies.callObjectMethod(this, method, objectArray);
                }
                throw new InternalError("bad proxy method: " + method);
            }
        }));
    }

    public static boolean isWrapperInstance(Object object) {
        return object instanceof WrapperInstance;
    }

    private static WrapperInstance asWrapperInstance(Object object) {
        try {
            if (object != null) {
                return (WrapperInstance)object;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new IllegalArgumentException("not a wrapper instance");
    }

    public static MethodHandle wrapperInstanceTarget(Object object) {
        return MethodHandleProxies.asWrapperInstance(object).getWrapperInstanceTarget();
    }

    public static Class<?> wrapperInstanceType(Object object) {
        return MethodHandleProxies.asWrapperInstance(object).getWrapperInstanceType();
    }

    private static boolean isObjectMethod(Method method) {
        switch (method.getName()) {
            case "toString": {
                return method.getReturnType() == String.class && method.getParameterTypes().length == 0;
            }
            case "hashCode": {
                return method.getReturnType() == Integer.TYPE && method.getParameterTypes().length == 0;
            }
            case "equals": {
                return method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
            }
        }
        return false;
    }

    private static Object callObjectMethod(Object object, Method method, Object[] objectArray) {
        assert (MethodHandleProxies.isObjectMethod(method)) : method;
        switch (method.getName()) {
            case "toString": {
                return object.getClass().getName() + "@" + Integer.toHexString(object.hashCode());
            }
            case "hashCode": {
                return System.identityHashCode(object);
            }
            case "equals": {
                return object == objectArray[0];
            }
        }
        return null;
    }

    private static Method[] getSingleNameMethods(Class<?> clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        String string = null;
        for (Method method : clazz.getMethods()) {
            if (MethodHandleProxies.isObjectMethod(method) || !Modifier.isAbstract(method.getModifiers())) continue;
            String string2 = method.getName();
            if (string == null) {
                string = string2;
            } else if (!string.equals(string2)) {
                return null;
            }
            arrayList.add(method);
        }
        if (string == null) {
            return null;
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }
}

