/*
 * Decompiled with CFR 0.152.
 */
package wafly.tool.util.code;

public class CodecUtil {
    public static String native2Html(String str) {
        char[] chars = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] <= '\u00ff') {
                sb.append(Character.toString(chars[i]));
            } else {
                StringBuilder csb = new StringBuilder();
                int code = chars[i] >> 8;
                String tmp = Integer.toHexString(code);
                if (tmp.length() == 1) {
                    csb.append("0");
                }
                csb.append(tmp);
                code = chars[i] & 0xFF;
                tmp = Integer.toHexString(code);
                if (tmp.length() == 1) {
                    csb.append("0");
                }
                csb.append(tmp).append(";");
                sb.append("&#x").append(csb.toString().toUpperCase());
            }
            ++i;
        }
        return sb.toString();
    }

    public static String html2native(String str) {
        StringBuilder sb = new StringBuilder();
        int bIdx = str.indexOf("&#x");
        int eIdx = str.indexOf(";");
        if (bIdx < 0 || eIdx < 0) {
            return str;
        }
        sb.append(str.substring(0, bIdx));
        while (bIdx > -1 && eIdx > -1 && eIdx > bIdx) {
            String htmlValue = str.substring(bIdx + 3, eIdx);
            try {
                int code = Integer.parseInt(htmlValue.substring(0, 2), 16) << 8;
                sb.append((char)(code += Integer.parseInt(htmlValue.substring(2, 4), 16)));
            }
            catch (Exception e) {
                sb.append(str.substring(bIdx, eIdx));
            }
            bIdx = str.indexOf("&#x", eIdx);
            if (bIdx <= -1) continue;
            sb.append(str.substring(eIdx + 1, bIdx));
            eIdx = str.indexOf(";", bIdx);
        }
        sb.append(str.substring(eIdx + 1));
        return sb.toString();
    }
}

