/*
 * Decompiled with CFR 0.152.
 */
package wafly.tool.util.code;

import java.io.File;
import java.io.FileInputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;

public class MD5Util {
    public static String getFileMD5(File file) {
        try {
            MessageDigest messagedigest = MessageDigest.getInstance("MD5");
            FileInputStream in = new FileInputStream(file);
            FileChannel ch = in.getChannel();
            MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            messagedigest.update(byteBuffer);
            byte[] bytes = messagedigest.digest();
            ch.close();
            in.close();
            return MD5Util.bufferToHex(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getStrMD5(String str) {
        try {
            MessageDigest messagedigest = MessageDigest.getInstance("MD5");
            messagedigest.update(str.getBytes());
            byte[] bytes = messagedigest.digest();
            return MD5Util.bufferToHex(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        int l = m;
        while (l < k) {
            char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            char c0 = hexDigits[(bytes[l] & 0xF0) >> 4];
            char c1 = hexDigits[bytes[l] & 0xF];
            stringbuffer.append(c0);
            stringbuffer.append(c1);
            ++l;
        }
        return stringbuffer.toString();
    }
}

