/*
 * Decompiled with CFR 0.152.
 */
package wafly.tool.util.draw;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import wafly.tool.util.file.FileUtil;

public class ImageUtil {
    public static Image getImage(String path) {
        File imgFile = new File(path);
        return ImageUtil.getImage(imgFile);
    }

    public static Image getImage(File imgFile) {
        if (!imgFile.exists() || !imgFile.isFile()) {
            return new BufferedImage(1, 1, 10);
        }
        try {
            return ImageIO.read(imgFile);
        }
        catch (Exception e) {
            return new BufferedImage(1, 1, 10);
        }
    }

    public static void convertToGray(BufferedImage image) {
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int i = 0;
        while (i < pixels.length) {
            if (pixels[i] != 0) {
                int value = (int)(0.299 * (double)(pixels[i] >> 16 & 0xFF) + 0.587 * (double)(pixels[i] >> 8 & 0xFF) + 0.114 * (double)(pixels[i] & 0xFF));
                pixels[i] = -16777216 + (value << 16) + (value << 8) + value;
            }
            ++i;
        }
    }

    public static void convertToXor(BufferedImage image) {
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int i = 0;
        while (i < pixels.length) {
            if (pixels[i] != 0) {
                pixels[i] = -16777216 + (pixels[i] >> 16 & 0xFF ^ 0xFF0000) + (pixels[i] >> 8 & 0xFF ^ 0xFF00) + (pixels[i] & 0xFF) ^ 0xFF;
            }
            ++i;
        }
    }

    public static void fillColor(Image image, Color color, float alpha) {
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setComposite(AlphaComposite.getInstance(3, alpha));
        g.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
    }

    public static Image getThumbnail(Image img, int size) {
        int drawWidth = img.getWidth(null);
        int drawHeight = img.getHeight(null);
        if (drawWidth > size || drawHeight > size) {
            if (drawWidth > drawHeight) {
                drawHeight = size * drawHeight / drawWidth;
                drawWidth = size;
            } else {
                drawWidth = size * drawWidth / drawHeight;
                drawHeight = size;
            }
            BufferedImage thumb = new BufferedImage(drawWidth, drawHeight, 5);
            thumb.getGraphics().drawImage(img, 0, 0, drawWidth, drawHeight, null);
            return thumb;
        }
        return img;
    }

    public static boolean saveToFile(BufferedImage img, String filePath) {
        File imgFile = new File(filePath);
        return ImageUtil.saveToFile(img, imgFile);
    }

    public static boolean saveToFile(BufferedImage img, File imgFile) {
        if (imgFile.exists() && !new FileUtil().delete(imgFile.getAbsolutePath())) {
            return false;
        }
        try {
            ImageIO.write((RenderedImage)img, "JPG", imgFile);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

