/*
 * Decompiled with CFR 0.152.
 */
package wafly.tool.util.file;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import wafly.tool.util.file.FileOperateListener;

public class FileUtil {
    private ArrayList<FileOperateListener> operations = new ArrayList();

    public boolean delete(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            return this.loopDelete(file);
        }
        return file.delete();
    }

    private boolean loopDelete(File folder) {
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory()) {
                if (files[i].delete()) {
                    for (FileOperateListener operation : this.operations) {
                        operation.onFileDeleted(files[i]);
                    }
                }
            } else if (files[i].isDirectory()) {
                this.loopDelete(files[i]);
            }
            ++i;
        }
        if (folder.listFiles().length == 0) {
            boolean result = folder.delete();
            if (result) {
                for (FileOperateListener operation : this.operations) {
                    operation.onFolderDeleted(folder);
                }
            }
            return result;
        }
        return false;
    }

    public boolean deleteAllFile(String folderPath) {
        File folder = new File(folderPath);
        if (!folder.isDirectory()) {
            return false;
        }
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory() && !files[i].delete()) {
                return false;
            }
            for (FileOperateListener operation : this.operations) {
                operation.onFileDeleted(files[i]);
            }
            ++i;
        }
        return true;
    }

    public void addFileOperateListener(FileOperateListener listener) {
        this.operations.add(listener);
    }

    public void removeFileOperateListener(FileOperateListener listener) {
        this.operations.remove(listener);
    }

    public String getTextSummary(String txtFilePath, int length) {
        File txtFile = new File(txtFilePath);
        return this.getTextSummary(txtFile, length);
    }

    public String getTextSummary(File txtFile, int length) {
        if (!txtFile.isFile()) {
            return null;
        }
        try {
            FileReader fr = new FileReader(txtFile);
            char[] contents = new char[length];
            fr.read(contents, 0, length);
            fr.close();
            return String.valueOf(contents);
        }
        catch (Exception e) {
            return null;
        }
    }
}

