/*
 * Decompiled with CFR 0.152.
 */
package wafly.tool.util.file;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    private String logFilePath;
    private String fileSeparator;

    public Logger(String logFilePath) {
        this.logFilePath = logFilePath;
        this.fileSeparator = System.getProperty("file.separator");
        this.logFilePath.replace(logFilePath.indexOf("/") < 0 ? "\\" : "/", this.fileSeparator);
        if (this.logFilePath.lastIndexOf(this.fileSeparator) > 0) {
            this.enableDir(this.logFilePath.substring(0, this.logFilePath.lastIndexOf(this.fileSeparator)));
        }
    }

    private void enableDir(String path) {
        if (!new File(path).isDirectory()) {
            if (path.indexOf(this.fileSeparator) > 0) {
                this.enableDir(path.substring(0, path.lastIndexOf(this.fileSeparator)));
            }
            new File(path).mkdir();
        }
    }

    public synchronized void out(Object msg) {
        OutputStreamWriter writer = null;
        try {
            try {
                Date logTime = new Date();
                File logFile = new File(String.valueOf(this.logFilePath) + new SimpleDateFormat(".yyyyMMdd").format(new Date()));
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                StackTraceElement ste = new Throwable().getStackTrace()[1];
                writer = new FileWriter(logFile, true);
                writer.write(String.valueOf(new SimpleDateFormat("[HH:mm:ss.SSS] ").format(logTime)) + ste.getClassName() + "." + ste.getMethodName() + " -> " + msg + "\r\n");
            }
            catch (Exception exception) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void out(Object msg, Throwable e) {
        OutputStreamWriter writer = null;
        try {
            try {
                Date logTime = new Date();
                File logFile = new File(String.valueOf(this.logFilePath) + new SimpleDateFormat(".yyyyMMdd").format(new Date()));
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                StackTraceElement ste = e.getStackTrace()[0];
                writer = new FileWriter(logFile, true);
                writer.write(String.valueOf(new SimpleDateFormat("[HH:mm:ss.SSS] ").format(logTime)) + ste.getClassName() + "." + ste.getMethodName() + " -> " + msg + " (" + e.getClass().toString().substring(e.getClass().toString().lastIndexOf(".") + 1) + ": " + e.getMessage() + ")\r\n");
                int i = 0;
                while (i < e.getStackTrace().length) {
                    ste = e.getStackTrace()[i];
                    writer.write("\t\t" + ste.getClassName() + "." + ste.getMethodName() + " (" + ste.getFileName() + ": " + ste.getLineNumber() + ")\r\n");
                    ++i;
                }
            }
            catch (Exception exception) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

