/*
 * Decompiled with CFR 0.152.
 */
package wafly.tool.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static boolean zip(String sourcePath, String targetZipFilePath) {
        File inputFile;
        File outputFile;
        block7: {
            block6: {
                outputFile = new File(targetZipFilePath);
                if (outputFile.exists() || outputFile.createNewFile()) break block6;
                return false;
            }
            inputFile = new File(sourcePath);
            if (inputFile.exists()) break block7;
            return false;
        }
        try {
            FileOutputStream fos = new FileOutputStream(outputFile);
            CheckedOutputStream cos = new CheckedOutputStream(fos, new CRC32());
            ZipOutputStream zos = new ZipOutputStream(cos);
            if (inputFile.isDirectory()) {
                String baseDir = inputFile.getAbsolutePath();
                ZipUtil.compressDir(inputFile, zos, baseDir.substring(0, baseDir.lastIndexOf(File.separator) + 1));
            } else {
                ZipUtil.compressFile(inputFile, zos, "");
            }
            fos.close();
            cos.close();
            zos.flush();
            zos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static void compressFile(File inputFile, ZipOutputStream zos, String dir) {
        try {
            ZipEntry entry = new ZipEntry(inputFile.getAbsolutePath().substring(dir.length()));
            zos.putNextEntry(entry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(inputFile));
            byte[] data = new byte[1024];
            int count = 0;
            while ((count = bis.read(data, 0, 1024)) != -1) {
                zos.write(data, 0, count);
            }
            bis.close();
            zos.closeEntry();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void compressDir(File dir, ZipOutputStream zos, String baseDir) {
        File[] files = dir.listFiles();
        if (files == null || files.length < 1) {
            ZipEntry entry = new ZipEntry(dir.getAbsolutePath().substring(baseDir.length()));
            try {
                zos.putNextEntry(entry);
                zos.closeEntry();
            }
            catch (Exception exception) {}
        } else {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    ZipUtil.compressDir(file, zos, baseDir);
                } else {
                    ZipUtil.compressFile(file, zos, baseDir);
                }
                ++n2;
            }
        }
    }

    public static boolean unzip(String sourceZipFilePath, String targetFolderPath) {
        File zipFile = new File(sourceZipFilePath);
        if (!zipFile.exists() || zipFile.isDirectory()) {
            return false;
        }
        File outputDir = new File(targetFolderPath);
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            return false;
        }
        try {
            CheckedInputStream cis = new CheckedInputStream(new FileInputStream(zipFile), new CRC32());
            ZipInputStream zis = new ZipInputStream(cis);
            ZipEntry entry = null;
            String baseDir = outputDir.getAbsolutePath();
            while ((entry = zis.getNextEntry()) != null) {
                File destFile = new File(String.valueOf(baseDir) + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    destFile.mkdirs();
                } else {
                    destFile.getParentFile().mkdirs();
                    destFile.createNewFile();
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));
                    byte[] data = new byte[1024];
                    int count = 0;
                    while ((count = zis.read(data, 0, 1024)) != -1) {
                        bos.write(data, 0, count);
                    }
                    bos.close();
                }
                zis.closeEntry();
            }
            cis.close();
            zis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean unzipFile(String sourceZipFilePath, String zipEntryName, String targetFolderPath) {
        File zipFile = new File(sourceZipFilePath);
        if (!zipFile.exists() || zipFile.isDirectory()) {
            return false;
        }
        File outputDir = new File(targetFolderPath);
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            return false;
        }
        if (zipEntryName == null || zipEntryName.trim().length() == 0) {
            return false;
        }
        try {
            CheckedInputStream cis = new CheckedInputStream(new FileInputStream(zipFile), new CRC32());
            ZipInputStream zis = new ZipInputStream(cis);
            ZipEntry entry = null;
            String baseDir = outputDir.getAbsolutePath();
            zipEntryName = zipEntryName.replace("\\", "/");
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().replace("\\", "/").equals(zipEntryName)) continue;
                File destFile = new File(String.valueOf(baseDir) + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    destFile.mkdirs();
                } else {
                    destFile.getParentFile().mkdirs();
                    destFile.createNewFile();
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));
                    byte[] data = new byte[1024];
                    int count = 0;
                    while ((count = zis.read(data, 0, 1024)) != -1) {
                        bos.write(data, 0, count);
                    }
                    bos.close();
                }
                zis.closeEntry();
            }
            cis.close();
            zis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void main(String[] args) {
        ZipUtil.unzip("C:\\Users\\Administrator\\Projects\\test.zip", "C:\\Users\\Administrator\\Projects\\1");
    }
}

