/*
 * Decompiled with CFR 0.152.
 */
package wafly.tool.util.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import wafly.tool.util.code.MD5Util;
import wafly.tool.util.code.RSAUtil;

public class TryUtil {
    public static boolean isRegister(String appCode, String keyFilePath) {
        File keyFile;
        block5: {
            keyFile = new File(keyFilePath);
            if ((keyFile.exists() || keyFile.createNewFile()) && keyFile.isFile()) break block5;
            return false;
        }
        try {
            FileReader fr = new FileReader(keyFile);
            BufferedReader br = new BufferedReader(fr);
            String macCode = br.readLine();
            String keyCode = null;
            if (macCode != null) {
                keyCode = br.readLine();
            }
            br.close();
            fr.close();
            if (TryUtil.getMachineCode(appCode).equals(macCode) && TryUtil.verifyKey(appCode, keyCode)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int timesTry(int maxTimes, String appCode, String keyFilePath) {
        try {
            FileReader fr = new FileReader(keyFilePath);
            BufferedReader br = new BufferedReader(fr);
            String macCode = br.readLine();
            String tryTimeStr = null;
            if (macCode != null) {
                tryTimeStr = br.readLine();
            }
            br.close();
            fr.close();
            String realMacCode = TryUtil.getMachineCode(appCode);
            if (!realMacCode.equals(macCode)) {
                FileWriter fw = new FileWriter(keyFilePath);
                fw.write(String.valueOf(realMacCode) + "\r\n" + MD5Util.getStrMD5(String.valueOf(appCode) + (maxTimes - 1)));
                fw.close();
                return maxTimes;
            }
            if (TryUtil.verifyKey(appCode, tryTimeStr)) {
                return -1;
            }
            String[] tryTimes = new String[maxTimes];
            int i = 0;
            while (i < tryTimes.length) {
                tryTimes[i] = MD5Util.getStrMD5(String.valueOf(appCode) + (i + 1));
                ++i;
            }
            i = maxTimes - 1;
            while (i >= 0) {
                if (tryTimes[i].equals(tryTimeStr)) {
                    FileWriter fw = new FileWriter(keyFilePath);
                    fw.write(tryTimes[i - 1]);
                    fw.close();
                    return i;
                }
                --i;
            }
            return 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int datesTry(int maxDays, String appCode, String keyFilePath) {
        int remainDay = 0;
        try {
            File keyFile = new File(keyFilePath);
            if (!keyFile.exists()) {
                if (!keyFile.createNewFile()) return 0;
            }
            if (!keyFile.isFile()) {
                return 0;
            }
            FileReader fr = new FileReader(keyFile);
            BufferedReader br = new BufferedReader(fr);
            String macCode = br.readLine();
            String tryTimeStr = null;
            if (macCode != null) {
                tryTimeStr = br.readLine();
            }
            br.close();
            fr.close();
            String realMacCode = TryUtil.getMachineCode(appCode);
            long timeMillis = 0L;
            if (!realMacCode.equals(macCode)) {
                timeMillis = System.currentTimeMillis() + 86400000L * (long)maxDays;
                tryTimeStr = RSAUtil.encode(String.valueOf(appCode) + timeMillis, "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAIT9ulVHONrhB83ZXKe4O6tSOFnQ3Eawzz3uctybUDzC4rTwTKo8VjyH/XXuextn9xgmbKafwoFbCoSfTIpEum0CAwEAAQ==");
                FileWriter fw = new FileWriter(keyFilePath);
                fw.write(String.valueOf(realMacCode) + "\r\n" + tryTimeStr);
                fw.close();
                return maxDays;
            }
            if (TryUtil.verifyKey(appCode, tryTimeStr)) {
                return -1;
            }
            String startDate = RSAUtil.decode(tryTimeStr, "MIIBVAIBADANBgkqhkiG9w0BAQEFAASCAT4wggE6AgEAAkEAhP26VUc42uEHzdlcp7g7q1I4WdDcRrDPPe5y3JtQPMLitPBMqjxWPIf9de57G2f3GCZspp/CgVsKhJ9MikS6bQIDAQABAkBsKUPDmcJW2dAUDiU6Ty9QXfVwrtqIL8LNdsI6Q6MVVqqczqzIp1ALDj5MQsrqaGEhEAeu1M6m8ZJZimdNLKYNAiEAwwYH5VdqBLwxoTcX8RK9mEJCmTv+sW3mZCBQpQ1vCjMCIQCukoflVzrsJMmkltxOgDQp1VAVrtZ3zAy5IKA0IiHI3wIgEu0K5x7MkxkQV+zYzfRboeMMQ4Km/OEFcsIQEXR0SjECIG859VPuTCCBH+i6JgvuK04sFyZ5izQw0jpxyyDsTlJJAiEAiDH9iQQ/klqRSFlL08SZjAbJT8arnZ3MSkrziHIIwR4=");
            if (startDate == null) return 0;
            if (startDate.length() <= appCode.length()) {
                return 0;
            }
            try {
                timeMillis = Long.parseLong(startDate.substring(appCode.length()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            remainDay = (int)(timeMillis / 86400000L) - (int)(System.currentTimeMillis() / 86400000L);
            if (remainDay >= 0) return remainDay;
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getMachineCode(String appCode) {
        try {
            byte[] hardwareAddress = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
            return MD5Util.getStrMD5(String.valueOf(appCode) + new String(hardwareAddress));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean verifyKey(String appCode, String keyCode) {
        String macCode;
        if (keyCode == null || keyCode.trim().length() == 0) {
            return false;
        }
        if (appCode == null) {
            appCode = "";
        }
        if ((macCode = TryUtil.getMachineCode(appCode)) == null) {
            macCode = "";
        }
        return (String.valueOf(MD5Util.getStrMD5(appCode)) + MD5Util.getStrMD5(macCode) + MD5Util.getStrMD5(String.valueOf(appCode) + macCode)).equals(keyCode);
    }

    private static String generateKey(String appCode) {
        String macCode;
        if (appCode == null) {
            appCode = "";
        }
        if ((macCode = TryUtil.getMachineCode(appCode)) == null) {
            macCode = "";
        }
        return String.valueOf(MD5Util.getStrMD5(appCode)) + MD5Util.getStrMD5(macCode) + MD5Util.getStrMD5(String.valueOf(appCode) + macCode);
    }

    public static void main(String[] args) {
        System.out.println(TryUtil.getMachineCode("ScanCD"));
        System.out.println(TryUtil.generateKey("ScanCD"));
    }
}

