/*
 * Decompiled with CFR 0.152.
 */
package wafly.tool.util.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.Properties;
import wafly.tool.util.code.CodecUtil;

public class Parameter {
    private File cfgFile;
    private Properties prop = new Properties();

    public Parameter(String configFilePath) {
        this.cfgFile = new File(configFilePath);
        if (!this.cfgFile.exists()) {
            try {
                this.cfgFile.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.cfgFile.isDirectory()) {
            try {
                FileInputStream fis = new FileInputStream(configFilePath);
                this.prop.load(fis);
                fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getParam(String key) {
        String value = this.prop.getProperty(key);
        if (value != null) {
            return CodecUtil.html2native(value);
        }
        return null;
    }

    public void setParam(String key, Object value) {
        if (value == null) {
            return;
        }
        this.prop.setProperty(key, CodecUtil.native2Html(value.toString()));
    }

    public boolean saveToFile() {
        if (this.cfgFile.isDirectory()) {
            return false;
        }
        try {
            if (!this.cfgFile.exists() && !this.cfgFile.createNewFile()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        try {
            FileWriter fw = new FileWriter(this.cfgFile);
            this.prop.store(fw, "");
            fw.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Parameter clone(String newCfgFilePath) {
        Parameter newPU = new Parameter(newCfgFilePath);
        newPU.prop = this.prop;
        return newPU;
    }
}

