/*
 * Decompiled with CFR 0.152.
 */
package wafly.tool.util.ui;

import com.sun.awt.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class FormUtil {
    public static final int NO_TITLE = 1;
    public static final int MAXIMIZE = 2;
    public static final int FIXEDSIZE = 4;
    public static final int NO_MINIMIZE = 8;
    private static Point origin = new Point();
    private static boolean isDragForm = false;

    public static void locateOnScreenCenter(Window window) {
        Dimension ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        window.setLocation((int)((ScreenSize.getWidth() - (double)window.getWidth()) / 2.0), (int)((ScreenSize.getHeight() - (double)window.getHeight()) / 2.0));
    }

    public static void setCloseAction(final Window window, WindowAction action) {
        switch (action) {
            case EXIT: {
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                break;
            }
            case HIDE: {
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        window.dispose();
                    }
                });
                break;
            }
            case MINIMIZE: {
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        if (window instanceof Frame) {
                            ((Frame)window).setState(1);
                        }
                    }
                });
            }
        }
    }

    public static void setCloseAction(final Window window, WindowAction action, final ActionMethod actionMethod) {
        switch (action) {
            case EXIT: {
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        if (actionMethod.onClosing()) {
                            System.exit(0);
                        }
                    }
                });
                break;
            }
            case HIDE: {
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        if (!actionMethod.onClosing()) {
                            window.setVisible(true);
                        } else {
                            window.dispose();
                        }
                    }
                });
                break;
            }
            case MINIMIZE: {
                window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        if (window instanceof Frame && actionMethod.onClosing()) {
                            ((Frame)window).setState(1);
                        }
                    }
                });
            }
        }
    }

    public static void setWindowStyle(final Frame frame, int style) {
        if ((style >> 3 & 1) == 1) {
            frame.addWindowStateListener(new WindowStateListener(){

                @Override
                public void windowStateChanged(WindowEvent e) {
                    if (frame.getState() == 1) {
                        frame.setState(0);
                    }
                }
            });
        }
        if ((style >> 2 & 1) == 1) {
            frame.setResizable(false);
        }
        if ((style >> 1 & 1) == 1) {
            frame.setExtendedState(6);
        }
        if ((style >> 0 & 1) == 1) {
            frame.setUndecorated(true);
        }
    }

    public static void setWindowLookAndFeel(LookAndFeels lnfName, boolean includeTitle) {
        String classPath = null;
        switch (lnfName) {
            case Autumn: {
                classPath = "org.jvnet.substance.skin.SubstanceAutumnLookAndFeel";
                break;
            }
            case RavenGraphite: {
                classPath = "org.jvnet.substance.skin.SubstanceRavenGraphiteLookAndFeel";
                break;
            }
            case BusinessBlackSteel: {
                classPath = "org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel";
                break;
            }
            case BusinessBlueSteel: {
                classPath = "org.jvnet.substance.skin.SubstanceBusinessBlueSteelLookAndFeel";
                break;
            }
            case Business: {
                classPath = "org.jvnet.substance.skin.SubstanceBusinessLookAndFeel";
                break;
            }
            case ChallengerDeep: {
                classPath = "org.jvnet.substance.skin.SubstanceChallengerDeepLookAndFeel";
                break;
            }
            case Creme: {
                classPath = "org.jvnet.substance.skin.SubstanceCremeLookAndFeel";
                break;
            }
            case EmeraldDusk: {
                classPath = "org.jvnet.substance.skin.SubstanceEmeraldDuskLookAndFeel";
                break;
            }
            case FieldOfWheat: {
                classPath = "org.jvnet.substance.skin.SubstanceFieldOfWheatLookAndFeel";
                break;
            }
            case GreenMagic: {
                classPath = "org.jvnet.substance.skin.SubstanceGreenMagicLookAndFeel";
                break;
            }
            case Magma: {
                classPath = "org.jvnet.substance.skin.SubstanceMagmaLookAndFeel";
                break;
            }
            case Mango: {
                classPath = "org.jvnet.substance.skin.SubstanceMangoLookAndFeel";
                break;
            }
            case MistAqua: {
                classPath = "org.jvnet.substance.skin.SubstanceMistAquaLookAndFeel";
                break;
            }
            case MistSilver: {
                classPath = "org.jvnet.substance.skin.SubstanceMistSilverLookAndFeel";
                break;
            }
            case Moderate: {
                classPath = "org.jvnet.substance.skin.SubstanceModerateLookAndFeel";
                break;
            }
            case NebulaBrickWall: {
                classPath = "org.jvnet.substance.skin.SubstanceNebulaBrickWallLookAndFeel";
                break;
            }
            case Nebula: {
                classPath = "org.jvnet.substance.skin.SubstanceNebulaLookAndFeel";
                break;
            }
            case OfficeBlue2007: {
                classPath = "org.jvnet.substance.skin.SubstanceOfficeBlue2007LookAndFeel";
                break;
            }
            case OfficeSilver2007: {
                classPath = "org.jvnet.substance.skin.SubstanceOfficeSilver2007LookAndFeel";
                break;
            }
            case RavenGraphiteGlass: {
                classPath = "org.jvnet.substance.skin.SubstanceRavenGraphiteGlassLookAndFeel";
                break;
            }
            case Raven: {
                classPath = "org.jvnet.substance.skin.SubstanceRavenLookAndFeel";
                break;
            }
            case Sahara: {
                classPath = "org.jvnet.substance.skin.SubstanceSaharaLookAndFeel";
            }
        }
        try {
            UIManager.setLookAndFeel(classPath);
            JFrame.setDefaultLookAndFeelDecorated(includeTitle);
            JDialog.setDefaultLookAndFeelDecorated(includeTitle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setImageAsShape(Window window, Image img) {
        if (window instanceof Frame) {
            ((Frame)window).setUndecorated(true);
        }
        window.setSize(img.getWidth(null), img.getHeight(null));
        AWTUtilities.setWindowShape((Window)window, (Shape)FormUtil.getImageShape(img));
    }

    public static void setImageAsBackground(Window window, Image img, boolean isMouseDrag) {
        FormUtil.setImageAsShape(window, img);
        BackgroundPanel panel = new BackgroundPanel();
        panel.bg = img;
        panel.setSize(window.getWidth(), window.getHeight());
        panel.setLocation(0, 0);
        window.add(panel);
        if (isMouseDrag) {
            FormUtil.enableMouseDrag(window, panel);
        }
    }

    public static Panel setImageAsWindow(final Window frame, final Image backImg, boolean isMouseDrag) {
        try {
            int width = backImg.getWidth(null);
            int height = backImg.getHeight(null);
            frame.setLayout(new BorderLayout());
            if (frame instanceof Frame && !frame.isDisplayable()) {
                ((Frame)frame).setUndecorated(true);
            }
            if (frame instanceof Dialog && !frame.isDisplayable()) {
                ((Dialog)frame).setUndecorated(true);
            }
            frame.setSize(width, height);
            AWTUtilities.setWindowShape((Window)frame, (Shape)FormUtil.getImageShape(backImg));
            final BackgroundPanel panel = new BackgroundPanel();
            panel.bg = backImg;
            panel.setSize(width, height);
            panel.setLocation(0, 0);
            frame.add((Component)panel, "Center");
            panel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    origin.x = e.getX();
                    origin.y = e.getY();
                }
            });
            if (isMouseDrag) {
                panel.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        Point p = frame.getLocation();
                        Point pc = panel.getLocation();
                        frame.setLocation(p.x + pc.x + e.getX() - origin.x, p.y + pc.y + e.getY() - origin.y);
                    }
                });
                panel.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent evt) {
                        BufferedImage newImg = new BufferedImage(frame.getWidth(), frame.getHeight(), 2);
                        newImg.getGraphics().drawImage(backImg, 0, 0, frame.getWidth(), frame.getHeight(), null);
                        panel.bg = newImg;
                        AWTUtilities.setWindowShape((Window)frame, (Shape)FormUtil.getImageShape(newImg));
                    }
                });
            }
            return panel;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Shape getImageShape(Image img) {
        if (img == null) {
            return null;
        }
        ArrayList<Integer> x = new ArrayList<Integer>();
        ArrayList<Integer> y = new ArrayList<Integer>();
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        PixelGrabber pgr = new PixelGrabber(img, 0, 0, width, height, true);
        try {
            pgr.grabPixels();
        }
        catch (Exception ex) {
            ex.getStackTrace();
        }
        int[] pixels = (int[])pgr.getPixels();
        int i = 0;
        while (i < pixels.length) {
            int alpha = pixels[i] >> 24 & 0xFF;
            if (alpha != 0) {
                x.add(i % width > 0 ? i % width - 1 : 0);
                y.add(i % width == 0 ? (i == 0 ? 0 : i / width - 1) : i / width);
            }
            ++i;
        }
        int[][] matrix = new int[height][width];
        int i2 = 0;
        while (i2 < height) {
            int j = 0;
            while (j < width) {
                matrix[i2][j] = 0;
                ++j;
            }
            ++i2;
        }
        int c = 0;
        while (c < x.size()) {
            matrix[((Integer)y.get((int)c)).intValue()][((Integer)x.get((int)c)).intValue()] = 1;
            ++c;
        }
        Area rec = new Area();
        int temp = 0;
        int i3 = 0;
        while (i3 < height) {
            int j = 0;
            while (j < width) {
                Rectangle rectemp;
                if (matrix[i3][j] == 1) {
                    if (temp == 0) {
                        temp = j;
                    } else if (j == width) {
                        if (temp == 0) {
                            rectemp = new Rectangle(j, i3, 1, 1);
                            rec.add(new Area(rectemp));
                        } else {
                            rectemp = new Rectangle(temp, i3, j - temp, 1);
                            rec.add(new Area(rectemp));
                            temp = 0;
                        }
                    }
                } else if (temp != 0) {
                    rectemp = new Rectangle(temp, i3, j - temp, 1);
                    rec.add(new Area(rectemp));
                    temp = 0;
                }
                ++j;
            }
            temp = 0;
            ++i3;
        }
        return rec;
    }

    public static void enableMouseDrag(final Window window, final Component comp) {
        isDragForm = window == comp;
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                origin.x = e.getX();
                origin.y = e.getY();
            }
        });
        comp.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point p = window.getLocation();
                if (isDragForm) {
                    window.setLocation(p.x + e.getX() - origin.x, p.y + e.getY() - origin.y);
                } else {
                    Point pc = comp.getLocation();
                    window.setLocation(p.x + pc.x + e.getX() - origin.x, p.y + pc.y + e.getY() - origin.y);
                }
            }
        });
    }

    public static void setOpacity(Window window, float opacity) {
        try {
            AWTUtilities.setWindowOpacity((Window)window, (float)opacity);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setGlobalFont(String fontName) {
        Font f = new Font(fontName, 0, new JLabel().getFont().getSize());
        UIManager.put("TextField.font", f);
        UIManager.put("Label.font", f);
        UIManager.put("ComboBox.font", f);
        UIManager.put("MenuBar.font", f);
        UIManager.put("Menu.font", f);
        UIManager.put("ToolTip.font", f);
        UIManager.put("MenuItem.font", f);
        UIManager.put("CheckBoxMenuItem.font", f);
    }

    public static void setGlobalFont(String fontName, int fontStyle, int fontSize) {
        Font oriFont = new JLabel().getFont();
        if (fontName == null) {
            fontName = oriFont.getFamily();
        }
        if (fontSize < 1) {
            fontSize = oriFont.getSize();
        }
        Font f = new Font(fontName, fontStyle, fontSize);
        UIManager.put("TextField.font", f);
        UIManager.put("Label.font", f);
        UIManager.put("ComboBox.font", f);
        UIManager.put("MenuBar.font", f);
        UIManager.put("Menu.font", f);
        UIManager.put("ToolTip.font", f);
        UIManager.put("MenuItem.font", f);
        UIManager.put("CheckBoxMenuItem.font", f);
        UIManager.put("Button.font", f);
    }

    public static interface ActionMethod {
        public boolean onClosing();
    }

    private static class BackgroundPanel
    extends Panel {
        private static final long serialVersionUID = 1L;
        public Image bg = null;

        private BackgroundPanel() {
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.bg, 0, 0, null);
            super.paint(g);
        }
    }

    public static enum LookAndFeels {
        Autumn,
        RavenGraphite,
        BusinessBlackSteel,
        BusinessBlueSteel,
        Business,
        ChallengerDeep,
        Creme,
        EmeraldDusk,
        FieldOfWheat,
        GreenMagic,
        Magma,
        Mango,
        MistAqua,
        MistSilver,
        Moderate,
        NebulaBrickWall,
        Nebula,
        OfficeBlue2007,
        OfficeSilver2007,
        RavenGraphiteGlass,
        Raven,
        Sahara;

    }

    public static enum WindowAction {
        EXIT,
        HIDE,
        MINIMIZE;

    }
}

