/*
 * Decompiled with CFR 0.152.
 */
package wafly.tool.util.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;

public class WebUtil {
    public static String getService(String requestURL, String charset) {
        StringBuilder pageHTML = new StringBuilder("");
        try {
            URL url = new URL(requestURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", "MSIE 7.0");
            InputStreamReader isr = new InputStreamReader(connection.getInputStream(), charset);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                pageHTML.append(line);
            }
            isr.close();
            br.close();
            connection.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pageHTML.toString();
    }

    public static String postService(String requestURL, HashMap<String, String> params, String charset) {
        if (params == null) {
            params = new HashMap();
        }
        String BOUNDARY = "---------------------------WaflysWebUtil";
        StringBuilder sb = new StringBuilder();
        for (String key : params.keySet()) {
            String value = params.get(key);
            sb.append("--" + BOUNDARY + "\r\n");
            sb.append("Content-Disposition: form-data; name=\"" + key + "\"" + "\r\n\r\n");
            sb.append(String.valueOf(value) + "\r\n");
        }
        sb.append("\r\n--" + BOUNDARY + "--\r\n");
        StringBuilder pageHTML = new StringBuilder("");
        try {
            byte[] contentBytes = sb.toString().getBytes("UTF-8");
            URL uUrl = new URL(requestURL);
            HttpURLConnection conn = (HttpURLConnection)uUrl.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            conn.setRequestProperty("Content-Length", String.valueOf(contentBytes.length));
            conn.setRequestProperty("Host", uUrl.getHost());
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.2; rv:18.0) Gecko/20100101 Firefox");
            conn.setRequestProperty("Connection", "keep-alive");
            conn.setDoOutput(true);
            OutputStream out = conn.getOutputStream();
            out.write(contentBytes);
            out.close();
            InputStreamReader isr = new InputStreamReader(conn.getInputStream(), charset);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                pageHTML.append(line);
            }
            isr.close();
            br.close();
            conn.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageHTML.toString();
    }

    public static String postService(String requestURL, HashMap<String, String> params, String postMsg, String charset) {
        try {
            String line;
            URL url = new URL(requestURL);
            URLConnection uc = null;
            OutputStreamWriter out = null;
            BufferedReader rd = null;
            uc = url.openConnection();
            uc.setDoOutput(true);
            uc.setRequestProperty("Content-Type", "text/xml");
            for (String key : params.keySet()) {
                String value = params.get(key);
                uc.setRequestProperty(key, value);
            }
            out = new OutputStreamWriter(uc.getOutputStream(), charset);
            out.write(postMsg);
            out.flush();
            out.close();
            rd = new BufferedReader(new InputStreamReader(uc.getInputStream(), charset));
            StringBuffer sb = new StringBuffer("");
            while ((line = rd.readLine()) != null) {
                sb.append(line).append("\n");
            }
            rd.close();
            return sb.toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static boolean downloadFile(String url, String newFilePath) {
        File dwnloadFile;
        block5: {
            dwnloadFile = new File(newFilePath);
            File destDir = dwnloadFile.getParentFile();
            if (dwnloadFile.isDirectory() || !destDir.isDirectory() || !destDir.exists() && !destDir.mkdirs()) {
                return false;
            }
            if (dwnloadFile.createNewFile()) break block5;
            return false;
        }
        try {
            int readed;
            URL uUrl = new URL(url);
            FileOutputStream os = new FileOutputStream(dwnloadFile);
            InputStream is = uUrl.openStream();
            byte[] buff = new byte[1024];
            while ((readed = is.read(buff)) != -1) {
                byte[] temp = new byte[readed];
                System.arraycopy(buff, 0, temp, 0, readed);
                os.write(temp);
            }
            is.close();
            os.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean uploadFile(String localFilePath, String fileParamName, String url, HashMap<String, String> params) {
        byte[] before;
        if (localFilePath == null || fileParamName == null || fileParamName.trim().length() == 0 || url == null || url.trim().length() == 0) {
            return false;
        }
        File file = new File(localFilePath);
        if (!file.exists() || file.isDirectory()) {
            return false;
        }
        if (params == null) {
            params = new HashMap();
        }
        String BOUNDARY = "---------------------------WaflysWebUtil";
        StringBuilder sb = new StringBuilder();
        for (String key : params.keySet()) {
            String value = params.get(key);
            sb.append("--" + BOUNDARY + "\r\n");
            sb.append("Content-Disposition: form-data; name=\"" + key + "\"" + "\r\n\r\n");
            sb.append(String.valueOf(value) + "\r\n");
        }
        sb.append("--" + BOUNDARY + "\r\n");
        sb.append("Content-Disposition: form-data; name=\"" + fileParamName + "\"; filename=\"" + file.getName() + "\"" + "\r\n");
        sb.append("Content-Type: application/octet-stream\r\n\r\n");
        try {
            before = sb.toString().getBytes("UTF-8");
        }
        catch (Exception e) {
            before = new byte[]{};
        }
        byte[] after = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
        try {
            int len;
            URL uUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)uUrl.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            conn.setRequestProperty("Content-Length", String.valueOf((long)before.length + file.length() + (long)after.length));
            conn.setRequestProperty("Host", uUrl.getHost());
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.2; rv:18.0) Gecko/20100101 Firefox");
            conn.setRequestProperty("Connection", "keep-alive");
            conn.setDoOutput(true);
            OutputStream out = conn.getOutputStream();
            FileInputStream in = new FileInputStream(file);
            out.write(before);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            out.write(after);
            ((InputStream)in).close();
            out.close();
            return conn.getResponseCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println(WebUtil.postService("http://221.179.7.250/ENSDL100Rest_B/oauth2/todolist/create?access_token=3e11c04d-2c4e-4727-9fc1-ae2cb6780f81&timestamp=2013-02-04+15%3A56%3A05&sign=B920CFB72DE3C864E1F57C22B5104203", new HashMap<String, String>(), "<todolist><title>test</title><content>\u5df2\u540c\u6b65\u7684\u4ee3\u529e\u4e8b\u9879</content><sender>adcadministrator@2000101126</sender><receivers>adcadministrator@2000101126</receivers><identifytype>1</identifytype><completetime>2013-06-06 00:00:00</completetime><importance>2</importance><urgency>1</urgency><targeturl>http://183.62.50.110:8252/35zhiwei/OAService</targeturl><createtime>2013-02-04 16:11:13</createtime><appcode>35_3</appcode></todolist>", "UTF-8"));
    }
}

