/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import com.sun.deploy.config.Config;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.Property;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.jnl.JARDesc;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import sun.net.www.protocol.jar.URLJarFileCallBack;

public class PluginURLJarFileCallBack
implements URLJarFileCallBack {
    private static int BUF_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void downloadJAR(URLConnection uRLConnection, String string, boolean bl) throws IOException {
        URL uRL = uRLConnection.getURL();
        if (bl && !HttpUtils.hasGzipOrPack200Encoding((URLConnection)uRLConnection)) {
            uRLConnection.setRequestProperty("accept-encoding", "pack200-gzip, gzip");
        }
        uRLConnection.setRequestProperty("content-type", "application/x-java-archive");
        InputStream inputStream = null;
        try {
            inputStream = uRLConnection.getInputStream();
            if (inputStream != null && !(inputStream instanceof FileInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
                byte[] byArray = new byte[BUF_SIZE];
                while (inputStream.read(byArray) != -1) {
                }
            }
            Object var8_7 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JarFile retrieve(final URL uRL) throws IOException {
        JarFile jarFile = null;
        final boolean bl = PluginURLJarFileCallBack.isPackEnable(uRL);
        URL uRL2 = uRL;
        if (bl) {
            uRL2 = URLUtil.getPack200URL((URL)uRL, (boolean)true);
        }
        final URLConnection uRLConnection = uRL2.openConnection();
        int n = ResourceProvider.get().incrementInternalUse();
        try {
            try {
                jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Object object;
                        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getPath());
                        String string = (String)ToolkitStore.get().getAppContext().get((Object)("deploy-" + uRL2.toString()));
                        if (ResourceProvider.get().canCache(uRL2)) {
                            JarFile jarFile;
                            block10: {
                                jarFile = null;
                                try {
                                    try {
                                        PluginURLJarFileCallBack.this.downloadJAR(uRLConnection, string, true);
                                    }
                                    catch (FileNotFoundException fileNotFoundException) {
                                        if (bl) {
                                            HttpUtils.cleanupConnection((URLConnection)uRLConnection);
                                            URLUtil.clearPack200Original();
                                            object = uRL.openConnection();
                                            PluginURLJarFileCallBack.this.downloadJAR((URLConnection)object, string, true);
                                            break block10;
                                        }
                                        throw fileNotFoundException;
                                    }
                                }
                                catch (IOException iOException) {
                                    Trace.ignoredException((Exception)iOException);
                                    HttpUtils.cleanupConnection((URLConnection)uRLConnection);
                                    object = uRL.openConnection();
                                    PluginURLJarFileCallBack.this.downloadJAR((URLConnection)object, string, false);
                                }
                            }
                            if (jarFile == null) {
                                jarFile = ResourceProvider.get().getCachedJarFile(string == null ? uRL : uRL2, string);
                            }
                            if (jarFile != null) {
                                return jarFile;
                            }
                        }
                        int n = 256;
                        if (bl) {
                            n |= 0x1000;
                        }
                        Resource resource = ResourceProvider.get().getResource(string == null ? uRL : uRL2, string, true, n, null);
                        Object object2 = object = resource != null ? resource.getJarFile() : null;
                        if (object != null && uRL.toString().toUpperCase().endsWith(".JARJAR")) {
                            return PluginURLJarFileCallBack.getNestedJarFile((JarFile)object);
                        }
                        return object;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            ResourceProvider.get().decrementInternalUse(n);
            if (!bl) throw throwable;
            URLUtil.clearPack200Original();
            throw throwable;
        }
        ResourceProvider.get().decrementInternalUse(n);
        if (!bl) return jarFile;
        URLUtil.clearPack200Original();
        return jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JarFile getNestedJarFile(JarFile jarFile) throws IOException {
        JarFile jarFile2;
        OutputStream outputStream;
        block9: {
            InputStream inputStream = null;
            outputStream = null;
            try {
                Enumeration<JarEntry> enumeration = jarFile.entries();
                ZipEntry zipEntry = null;
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    zipEntry = enumeration.nextElement();
                    if (zipEntry.getName().toUpperCase().startsWith("META-INF")) continue;
                    if (!zipEntry.toString().toUpperCase().endsWith(".JAR")) {
                        throw new IOException("Invalid entry in jarjar file");
                    }
                    if (++n <= 1) continue;
                }
                if (n > 1) {
                    throw new IOException("Multiple JAR files inside JARJAR file");
                }
                byte[] byArray = new byte[BUF_SIZE];
                int n2 = 0;
                File file = File.createTempFile("jar_cache", null);
                file.deleteOnExit();
                inputStream = new BufferedInputStream(jarFile.getInputStream(zipEntry));
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                n2 = 0;
                while ((n2 = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n2);
                }
                outputStream.close();
                outputStream = null;
                jarFile2 = new JarFile(file, false);
                Object var11_10 = null;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                jarFile.close();
                throw throwable;
            }
            inputStream.close();
        }
        if (outputStream != null) {
            outputStream.close();
        }
        jarFile.close();
        return jarFile2;
    }

    private static boolean isPackEnable(URL uRL) {
        if (!Config.isJavaVersionAtLeast15()) {
            return false;
        }
        try {
            JARDesc jARDesc;
            JNLPClassLoaderIf jNLPClassLoaderIf = JNLPClassLoaderUtil.getInstance();
            if (jNLPClassLoaderIf != null && (jARDesc = jNLPClassLoaderIf.getJarDescFromURL(uRL)) != null) {
                return jARDesc.isPack200Enabled();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Property.isPackEnabled();
    }
}

