/*
 * Decompiled with CFR 0.152.
 */
package wafly.control.button;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageButton
extends JLabel {
    private static final long serialVersionUID = 1L;
    private boolean isEnable = true;
    private ImageIcon background;
    private ImageIcon hoverView;
    private ImageIcon downView;
    private ImageIcon disableView;
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private ActionEvent actionEvent = null;
    private Color backColor = new JPanel().getBackground();

    public ImageButton(ImageIcon background, ImageIcon hoverView, ImageIcon downView, ImageIcon disableView) {
        this.background = background;
        if (this.background == null) {
            this.background = hoverView != null ? new ImageIcon(new BufferedImage(hoverView.getIconWidth(), hoverView.getIconHeight(), 2)) : (downView != null ? new ImageIcon(new BufferedImage(downView.getIconWidth(), downView.getIconHeight(), 2)) : (disableView != null ? new ImageIcon(new BufferedImage(disableView.getIconWidth(), disableView.getIconHeight(), 2)) : new ImageIcon(new BufferedImage(1, 1, 2))));
        }
        this.hoverView = hoverView == null ? this.background : hoverView;
        this.downView = downView == null ? this.background : downView;
        this.disableView = disableView;
        if (this.disableView == null) {
            BufferedImage tmpBack = new BufferedImage(this.background.getIconWidth(), this.background.getIconHeight(), 2);
            Graphics g = tmpBack.getGraphics();
            g.setColor(this.backColor);
            g.fillRect(0, 0, tmpBack.getWidth(), tmpBack.getHeight());
            this.disableView = new ImageIcon(tmpBack);
        }
        this.setIcon(this.background);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(0);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.actionEvent = new ActionEvent(this, (int)(Math.random() * 10000.0), this.getText());
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ImageButton.this.isEnable) {
                    ImageButton.this.setIcon(ImageButton.this.hoverView);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (ImageButton.this.isEnable) {
                    ImageButton.this.setIcon(ImageButton.this.downView);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (ImageButton.this.isEnable) {
                    ImageButton.this.setIcon(ImageButton.this.background);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ImageButton.this.isEnable) {
                    ImageButton.this.setIcon(ImageButton.this.hoverView);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    ImageButton.this.onClick(e);
                }
            }
        });
    }

    public ImageButton(ImageIcon background) {
        this(background, null, null, null);
    }

    private void onClick(MouseEvent e) {
        if (!this.isEnable) {
            return;
        }
        for (ActionListener listener : this.actionListeners) {
            if (listener == null) continue;
            listener.actionPerformed(this.actionEvent);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public ActionListener[] getActionListeners() {
        return this.actionListeners.toArray(new ActionListener[0]);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    @Override
    public void setEnabled(boolean b) {
        this.isEnable = b;
        this.setIcon(this.isEnable ? this.background : this.disableView);
        this.validate();
        this.repaint();
    }

    @Override
    public boolean isEnabled() {
        return this.isEnable;
    }

    public ImageIcon getBackgroundImage() {
        return this.background;
    }

    public void setBackgroundImage(ImageIcon background) {
        this.background = background;
    }

    public ImageIcon getHoverView() {
        return this.hoverView;
    }

    public void setHoverView(ImageIcon hoverView) {
        this.hoverView = hoverView;
    }

    public ImageIcon getDownView() {
        return this.downView;
    }

    public void setDownView(ImageIcon downView) {
        this.downView = downView;
    }

    public ImageIcon getDisableView() {
        return this.disableView;
    }

    public void setDisableView(ImageIcon disableView) {
        this.disableView = disableView;
    }
}

