/*
 * Decompiled with CFR 0.152.
 */
package wafly.control.editer;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.undo.UndoManager;

public class TextEditBox
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private File storeFile = null;
    private SimpleAttributeSet globalAttributeSet = new SimpleAttributeSet();
    private AttributeSet copiedAttributeSet = null;
    UndoManager undoManager = new UndoManager();
    private JPopupMenu rightMenu = new JPopupMenu();
    private SearchDialog searchDialog = null;
    boolean isChanged = false;
    private boolean autoIndentation = false;
    private int replaceTABcount = 0;

    public TextEditBox() {
        this.setContentType("text/html");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TextEditBox.this.onKeyDown(e.getModifiersEx(), e.getKeyCode());
                TextEditBox.this.isChanged = true;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (TextEditBox.this.autoIndentation && e.getKeyCode() == 10) {
                    String[] lines;
                    try {
                        lines = TextEditBox.this.getStyledDocument().getText(0, TextEditBox.this.getSelectionStart()).split("\n");
                    }
                    catch (Exception ex) {
                        System.err.println("\u8bbe\u7f6e\u81ea\u52a8\u7f29\u8fdb\u65f6\u53d1\u751f\u9519\u8bef\uff0c" + ex.getMessage());
                        lines = new String[]{};
                    }
                    String lastLine = lines[lines.length - 1];
                    int copyAttrIndex = 0;
                    int i = 0;
                    while (i < lines.length - 1) {
                        copyAttrIndex += lines[i].length();
                        ++i;
                    }
                    try {
                        TextEditBox.this.getStyledDocument().insertString(TextEditBox.this.getSelectionStart(), "\n", TextEditBox.this.globalAttributeSet);
                    }
                    catch (Exception ex) {
                        System.err.println("\u8bbe\u7f6e\u81ea\u52a8\u7f29\u8fdb\u65f6\u53d1\u751f\u9519\u8bef\uff0c" + ex.getMessage());
                    }
                    i = 0;
                    while (i < lastLine.length()) {
                        char c = lastLine.charAt(i);
                        if (c != ' ' && c != '\t') break;
                        try {
                            TextEditBox.this.getStyledDocument().insertString(TextEditBox.this.getSelectionStart(), String.valueOf(c), TextEditBox.this.getStyledDocument().getCharacterElement(copyAttrIndex + i).getAttributes());
                        }
                        catch (Exception ex) {
                            System.err.println("\u8bbe\u7f6e\u81ea\u52a8\u7f29\u8fdb\u65f6\u53d1\u751f\u9519\u8bef\uff0c" + ex.getMessage());
                        }
                        ++i;
                    }
                } else if (TextEditBox.this.replaceTABcount > 0 && e.getKeyCode() == 9) {
                    try {
                        TextEditBox.this.getStyledDocument().remove(TextEditBox.this.getSelectionStart() - 1, 1);
                        int i = 0;
                        while (i < TextEditBox.this.replaceTABcount) {
                            TextEditBox.this.getStyledDocument().insertString(TextEditBox.this.getSelectionStart(), " ", TextEditBox.this.globalAttributeSet);
                            ++i;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                TextEditBox.this.isChanged = true;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3 && TextEditBox.this.rightMenu != null && TextEditBox.this.isEnabled() && TextEditBox.this.isFocusable()) {
                    TextEditBox.this.rightMenu.show(TextEditBox.this, e.getX(), e.getY());
                }
            }
        });
        this.getStyledDocument().addUndoableEditListener(this.undoManager);
    }

    public TextEditBox(String storePath) {
        this();
        if (storePath == null) {
            storePath = ".~tmp";
        } else {
            File storeFolder = new File(storePath);
            if (storeFolder.exists() && !storeFolder.isDirectory()) {
                storePath = ".~tmp";
            }
        }
        File sf = new File(storePath);
        try {
            sf.getParentFile().mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            sf.createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.storeFile = sf;
    }

    public void setStorePath(String storePath) {
        if (storePath == null) {
            storePath = ".~tmp";
        }
        File sf = new File(storePath);
        try {
            sf.getParentFile().mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            sf.createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.storeFile = sf;
    }

    private void onKeyDown(int modifier, int keyCode) {
        boolean isShiftDown = (modifier & 0x40) != 0;
        boolean isCtrlDown = (modifier & 0x80) != 0;
        switch (keyCode) {
            case 66: {
                if (!isCtrlDown) break;
                if (this.getSelectionStart() == this.getSelectionEnd()) {
                    this.setGlobalBold(!this.isGlobalBold());
                    break;
                }
                this.setSelectedBold(!StyleConstants.isBold(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes()));
                break;
            }
            case 85: {
                if (!isCtrlDown) break;
                if (this.getSelectionStart() == this.getSelectionEnd()) {
                    this.setGlobalUnderline(!this.isGlobalUnderline());
                    break;
                }
                this.setSelectedUnderline(!StyleConstants.isUnderline(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes()));
                break;
            }
            case 73: {
                if (!isCtrlDown) break;
                if (this.getSelectionStart() == this.getSelectionEnd()) {
                    this.setGlobalItalic(!this.isGlobalItalic());
                    break;
                }
                this.setSelectedItalic(!StyleConstants.isItalic(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes()));
                break;
            }
            case 61: {
                if (!isCtrlDown) break;
                if (isShiftDown) {
                    if (this.getSelectionStart() == this.getSelectionEnd()) {
                        this.setGlobalSuperscript(!this.isGlobalSuperscript());
                        break;
                    }
                    this.setSelectedSuperscript(!StyleConstants.isSuperscript(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes()));
                    break;
                }
                if (this.getSelectionStart() == this.getSelectionEnd()) {
                    this.setGlobalSubscript(!this.isGlobalSubscript());
                    break;
                }
                this.setSelectedSubscript(!StyleConstants.isSubscript(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes()));
                break;
            }
            case 83: {
                if (!isCtrlDown) break;
                this.saveToFile();
                break;
            }
            case 44: {
                if (!isCtrlDown || !isShiftDown) break;
                if (this.getSelectionStart() == this.getSelectionEnd()) {
                    int size = this.getGlobalFontSize() - 1;
                    if (size < 1) {
                        size = 1;
                    }
                    this.setGlobalFontSize(size);
                    break;
                }
                int size = this.getSelectedFontSize() - 1;
                if (size < 1) {
                    size = 1;
                }
                this.setSelectedFontSize(size);
                break;
            }
            case 46: {
                if (!isCtrlDown || !isShiftDown) break;
                if (this.getSelectionStart() == this.getSelectionEnd()) {
                    this.setGlobalFontSize(this.getGlobalFontSize() + 1);
                    break;
                }
                this.setSelectedFontSize(this.getSelectedFontSize() + 1);
                break;
            }
            case 90: {
                if (!isCtrlDown) break;
                this.undo();
                break;
            }
            case 89: {
                if (!isCtrlDown) break;
                this.redo();
                break;
            }
            case 114: {
                if (isShiftDown) {
                    this.switchSelectionCase();
                    break;
                }
                this.locateNextSearchString();
                break;
            }
            case 115: {
                if (!isShiftDown) break;
                this.selectionToLowerCase();
                break;
            }
            case 116: {
                if (!isShiftDown) break;
                this.selectionToUpperCase();
                break;
            }
            case 67: {
                if (!isCtrlDown || !isShiftDown) break;
                this.copySelectionAttributeSet();
                break;
            }
            case 86: {
                if (!isCtrlDown || !isShiftDown) break;
                this.pasteCopiedAttributeSet(true);
                break;
            }
            case 76: {
                if (!isCtrlDown) break;
                this.setAlignment(0);
                break;
            }
            case 69: {
                if (!isCtrlDown) break;
                this.setAlignment(1);
                break;
            }
            case 82: {
                if (!isCtrlDown) break;
                this.setAlignment(2);
                break;
            }
            case 70: {
                if (!isCtrlDown) break;
                if (this.searchDialog == null) {
                    this.searchDialog = new SearchDialog();
                }
                this.searchDialog.setVisible(true);
            }
        }
    }

    public void setRightMenu(JPopupMenu menu) {
        this.rightMenu = menu;
    }

    public JPopupMenu getRightMenu() {
        return this.rightMenu;
    }

    public void copySelectionAttributeSet() {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return;
        }
        this.copiedAttributeSet = this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes();
    }

    public void pasteCopiedAttributeSet(boolean isClearCopiedAttribute) {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return;
        }
        this.setCharacterAttributes(this.copiedAttributeSet, true);
        if (isClearCopiedAttribute) {
            this.copiedAttributeSet = null;
        }
        this.isChanged = true;
    }

    public void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public void switchSelectionCase() {
        int eIndex;
        int sIndex = this.getSelectionStart();
        if (sIndex == (eIndex = this.getSelectionEnd())) {
            return;
        }
        try {
            String str = this.getStyledDocument().getText(sIndex, eIndex - sIndex);
            StringBuffer nStr = new StringBuffer("");
            int i = 0;
            while (i < str.length()) {
                char charCode = str.charAt(i);
                if (charCode > '`' && charCode < '{') {
                    nStr.append((char)(charCode - 32));
                } else if (charCode > '@' && charCode < '[') {
                    nStr.append((char)(charCode + 32));
                } else {
                    nStr.append(charCode);
                }
                ++i;
            }
            AttributeSet attrSet = this.getStyledDocument().getCharacterElement(sIndex).getAttributes();
            this.getStyledDocument().remove(sIndex, eIndex - sIndex);
            this.getStyledDocument().insertString(sIndex, nStr.toString(), attrSet);
            this.setSelectionStart(sIndex);
            this.setSelectionEnd(eIndex);
            nStr = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isChanged = true;
    }

    public void selectionToLowerCase() {
        int eIndex;
        int sIndex = this.getSelectionStart();
        if (sIndex == (eIndex = this.getSelectionEnd())) {
            return;
        }
        try {
            String str = this.getStyledDocument().getText(sIndex, eIndex - sIndex);
            StringBuffer nStr = new StringBuffer("");
            int i = 0;
            while (i < str.length()) {
                char charCode = str.charAt(i);
                if (charCode > '@' && charCode < '[') {
                    nStr.append((char)(charCode + 32));
                } else {
                    nStr.append(charCode);
                }
                ++i;
            }
            AttributeSet attrSet = this.getStyledDocument().getCharacterElement(sIndex).getAttributes();
            this.getStyledDocument().remove(sIndex, eIndex - sIndex);
            this.getStyledDocument().insertString(sIndex, nStr.toString(), attrSet);
            this.setSelectionStart(sIndex);
            this.setSelectionEnd(eIndex);
            nStr = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isChanged = true;
    }

    public void selectionToUpperCase() {
        int eIndex;
        int sIndex = this.getSelectionStart();
        if (sIndex == (eIndex = this.getSelectionEnd())) {
            return;
        }
        try {
            String str = this.getStyledDocument().getText(sIndex, eIndex - sIndex);
            StringBuffer nStr = new StringBuffer("");
            int i = 0;
            while (i < str.length()) {
                char charCode = str.charAt(i);
                if (charCode > '`' && charCode < '{') {
                    nStr.append((char)(charCode - 32));
                } else {
                    nStr.append(charCode);
                }
                ++i;
            }
            AttributeSet attrSet = this.getStyledDocument().getCharacterElement(sIndex).getAttributes();
            this.getStyledDocument().remove(sIndex, eIndex - sIndex);
            this.getStyledDocument().insertString(sIndex, nStr.toString(), attrSet);
            this.setSelectionStart(sIndex);
            this.setSelectionEnd(eIndex);
            nStr = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isChanged = true;
    }

    public boolean saveToFile() {
        if (this.storeFile == null) {
            this.setStorePath(null);
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(this.storeFile);
                Document doc = this.getDocument();
                new HTMLEditorKit().write(fos, doc, 0, doc.getLength());
            }
            catch (Exception e) {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        this.isChanged = false;
        return true;
    }

    public boolean restoreFromFile() {
        FileInputStream fis;
        block18: {
            if (this.storeFile == null) {
                this.setStorePath(null);
            }
            fis = null;
            if (this.storeFile.exists() && !this.storeFile.isDirectory()) break block18;
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        try {
            try {
                fis = new FileInputStream(this.storeFile);
                new HTMLEditorKit().read(fis, this.getDocument(), 0);
            }
            catch (Exception e) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        this.isChanged = false;
        return true;
    }

    public void setSelectedBold(boolean bold) {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return;
        }
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        StyleConstants.setBold(attrSet, bold);
        this.setCharacterAttributes(attrSet, false);
        this.isChanged = true;
    }

    public boolean isSelectedBold() {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return false;
        }
        return StyleConstants.isBold(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes());
    }

    public void setGlobalBold(boolean bold) {
        this.setSelectionEnd(this.getSelectionStart());
        StyleConstants.setBold(this.globalAttributeSet, bold);
        this.setCharacterAttributes(this.globalAttributeSet, false);
    }

    public boolean isGlobalBold() {
        return StyleConstants.isBold(this.globalAttributeSet);
    }

    public void setSelectedUnderline(boolean underline) {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return;
        }
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        StyleConstants.setUnderline(attrSet, underline);
        this.setCharacterAttributes(attrSet, false);
        this.isChanged = true;
    }

    public boolean isSelectedUnderline() {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return false;
        }
        return StyleConstants.isUnderline(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes());
    }

    public void setGlobalUnderline(boolean underline) {
        this.setSelectionEnd(this.getSelectionStart());
        StyleConstants.setUnderline(this.globalAttributeSet, underline);
        this.setCharacterAttributes(this.globalAttributeSet, false);
    }

    public boolean isGlobalUnderline() {
        return StyleConstants.isUnderline(this.globalAttributeSet);
    }

    public void setSelectedItalic(boolean italic) {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return;
        }
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        StyleConstants.setItalic(attrSet, italic);
        this.setCharacterAttributes(attrSet, false);
        this.isChanged = true;
    }

    public boolean isSelectedItalic() {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return false;
        }
        return StyleConstants.isItalic(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes());
    }

    public void setGlobalItalic(boolean italic) {
        this.setSelectionEnd(this.getSelectionStart());
        StyleConstants.setItalic(this.globalAttributeSet, italic);
        this.setCharacterAttributes(this.globalAttributeSet, false);
    }

    public boolean isGlobalItalic() {
        return StyleConstants.isItalic(this.globalAttributeSet);
    }

    public void setSelectedStrikeThrough(boolean strikeThrough) {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return;
        }
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        StyleConstants.setStrikeThrough(attrSet, strikeThrough);
        this.setCharacterAttributes(attrSet, false);
        this.isChanged = true;
    }

    public boolean isSelectedStrikeThrough() {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return false;
        }
        return StyleConstants.isStrikeThrough(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes());
    }

    public void setGlobalStrikeThrough(boolean strikeThrough) {
        this.setSelectionEnd(this.getSelectionStart());
        StyleConstants.setItalic(this.globalAttributeSet, strikeThrough);
        this.setCharacterAttributes(this.globalAttributeSet, false);
    }

    public boolean isGlobalStrikeThrough() {
        return StyleConstants.isStrikeThrough(this.globalAttributeSet);
    }

    public void setSelectedSubscript(boolean subscript) {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return;
        }
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        StyleConstants.setSubscript(attrSet, subscript);
        this.setCharacterAttributes(attrSet, false);
        this.isChanged = true;
    }

    public boolean isSelectedSubscript() {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return false;
        }
        return StyleConstants.isSubscript(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes());
    }

    public void setGlobalSubscript(boolean subscript) {
        this.setSelectionEnd(this.getSelectionStart());
        StyleConstants.setItalic(this.globalAttributeSet, subscript);
        this.setCharacterAttributes(this.globalAttributeSet, false);
    }

    public boolean isGlobalSubscript() {
        return StyleConstants.isSubscript(this.globalAttributeSet);
    }

    public void setSelectedSuperscript(boolean superscript) {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return;
        }
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        StyleConstants.setSuperscript(attrSet, superscript);
        this.setCharacterAttributes(attrSet, false);
        this.isChanged = true;
    }

    public boolean isSelectedSuperscript() {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return false;
        }
        return StyleConstants.isSuperscript(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes());
    }

    public void setGlobalSuperscript(boolean superscript) {
        this.setSelectionEnd(this.getSelectionStart());
        StyleConstants.setItalic(this.globalAttributeSet, superscript);
        this.setCharacterAttributes(this.globalAttributeSet, false);
    }

    public boolean isGlobalSuperscript() {
        return StyleConstants.isSuperscript(this.globalAttributeSet);
    }

    public void setSelectedFont(String fontName) {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return;
        }
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attrSet, fontName);
        this.setCharacterAttributes(attrSet, false);
        this.isChanged = true;
    }

    public String getSelectedFontName() {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return null;
        }
        return StyleConstants.getFontFamily(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes());
    }

    public void setGlobalFont(String fontName) {
        this.setSelectionEnd(this.getSelectionStart());
        StyleConstants.setFontFamily(this.globalAttributeSet, fontName);
        this.setCharacterAttributes(this.globalAttributeSet, false);
    }

    public String getGlobalFontName() {
        return StyleConstants.getFontFamily(this.globalAttributeSet);
    }

    public void setSelectedFontSize(int fontSize) {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return;
        }
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        StyleConstants.setFontSize(attrSet, fontSize);
        this.setCharacterAttributes(attrSet, false);
        this.isChanged = true;
    }

    public int getSelectedFontSize() {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return 0;
        }
        return StyleConstants.getFontSize(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes());
    }

    public void setGlobalFontSize(int fontSize) {
        this.setSelectionEnd(this.getSelectionStart());
        StyleConstants.setFontSize(this.globalAttributeSet, fontSize);
        this.setCharacterAttributes(this.globalAttributeSet, false);
    }

    public int getGlobalFontSize() {
        return StyleConstants.getFontSize(this.globalAttributeSet);
    }

    public void setSelectedFontColor(Color color) {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return;
        }
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        StyleConstants.setForeground(attrSet, color);
        this.setCharacterAttributes(attrSet, false);
        this.isChanged = true;
    }

    public Color getSelectedFontColor() {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return null;
        }
        return StyleConstants.getForeground(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes());
    }

    public void setGlobalFontColor(Color color) {
        this.setSelectionEnd(this.getSelectionStart());
        StyleConstants.setForeground(this.globalAttributeSet, color);
        this.setCharacterAttributes(this.globalAttributeSet, false);
    }

    public Color getGlobalFontColor() {
        return StyleConstants.getForeground(this.globalAttributeSet);
    }

    public void setSelectedBackgroundColor(Color color) {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return;
        }
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        StyleConstants.setBackground(attrSet, color);
        this.setCharacterAttributes(attrSet, false);
        this.isChanged = true;
    }

    public Color getSelectedBackgroundColor() {
        if (this.getSelectionStart() == this.getSelectionEnd()) {
            return null;
        }
        return StyleConstants.getBackground(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes());
    }

    public void setGlobalFontBackgroundColor(Color color) {
        this.setSelectionEnd(this.getSelectionStart());
        StyleConstants.setBackground(this.globalAttributeSet, color);
        this.setCharacterAttributes(this.globalAttributeSet, false);
    }

    public Color getGlobalFontBackgroundColor() {
        return StyleConstants.getBackground(this.globalAttributeSet);
    }

    public void setAlignment(int align) {
        this.setSelectionEnd(this.getSelectionStart());
        StyleConstants.setAlignment(this.globalAttributeSet, align);
        this.setParagraphAttributes(this.globalAttributeSet, true);
        this.isChanged = true;
    }

    public int getAlignment() {
        return StyleConstants.getAlignment(this.getStyledDocument().getCharacterElement(this.getSelectionStart()).getAttributes());
    }

    public void locateNextSearchString() {
        String searchStr = this.searchDialog.searchContentBox.getText().trim();
        if (searchStr.equals("")) {
            return;
        }
        int searchDoneIndex = this.getSelectionEnd();
        String searchTargetStr = this.getText().substring(searchDoneIndex);
        int searchStrIndex = searchTargetStr.indexOf(searchStr);
        if (searchStrIndex < 0) {
            searchDoneIndex = 0;
            searchStrIndex = this.getText().indexOf(searchStr);
            if (searchStrIndex < 0) {
                return;
            }
        }
        this.setSelectionStart(searchDoneIndex + searchStrIndex);
        this.setSelectionEnd(searchDoneIndex + searchStrIndex + searchStr.length());
    }

    public void setAutoIndentation(boolean autoIndentation) {
        this.autoIndentation = autoIndentation;
    }

    public boolean isAutoIndentation() {
        return this.autoIndentation;
    }

    public void setCountOfBlankReplaceTab(int blankCount) {
        this.replaceTABcount = blankCount;
    }

    public int getCountOfBlankReplaceTab() {
        return this.replaceTABcount;
    }

    public boolean isContentChanged() {
        return this.isChanged;
    }

    private class SearchDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private JTextField searchContentBox = new JTextField();

        private SearchDialog() {
            this.setSize(200, 60);
            this.setLocation(TextEditBox.this.getX() + TextEditBox.this.getWidth() - 200, TextEditBox.this.getY() + 50);
            this.setAlwaysOnTop(true);
            this.setLayout(null);
            this.setResizable(false);
            Font font = new Font(null, 0, 10);
            this.searchContentBox.setSize(130, 20);
            this.searchContentBox.setLocation(5, 5);
            this.searchContentBox.setFont(font);
            this.add(this.searchContentBox);
            JButton searchBtn = new JButton("\u641c\u7d22");
            searchBtn.setSize(55, 20);
            searchBtn.setLocation(140, 5);
            searchBtn.setFont(font);
            searchBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextEditBox.this.locateNextSearchString();
                }
            });
            this.add(searchBtn);
        }
    }
}

