/*
 * Decompiled with CFR 0.152.
 */
package wafly.control.explorer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import wafly.control.explorer.IconExplorer;

public class Icon
extends JLabel {
    private static final long serialVersionUID = 1L;
    boolean isSelected = false;
    IconExplorer container = null;
    private JPopupMenu popupMenu = new JPopupMenu();

    public Icon(String iconPath, int size) {
        try {
            BufferedImage image = new BufferedImage(size, size, 2);
            image.getGraphics().drawImage(ImageIO.read(new File(iconPath)), 0, 0, size, size, null);
            this.setIcon(new ImageIcon(image));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Icon.this.setSelected(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3 && Icon.this.popupMenu.getComponentCount() > 0) {
                    Icon.this.popupMenu.show(Icon.this, e.getX(), e.getY());
                }
            }
        });
    }

    public void addMenuItem(JMenuItem menuItem) {
        this.popupMenu.add(menuItem);
    }

    public void addMenuSeparator() {
        this.popupMenu.addSeparator();
    }

    public void addMenuItem(JMenuItem menuItem, int pos) {
        this.popupMenu.insert(menuItem, pos);
    }

    public void removeMenuItem(JMenuItem menuItem) {
        this.popupMenu.remove(menuItem);
    }

    public void removeMenuItem(int index) {
        this.popupMenu.remove(index);
    }

    public void getMenuItem(int index) {
        this.popupMenu.getComponent(index);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isSelected) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g2d.setColor(Color.BLUE);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public IconExplorer getIconContainer() {
        return this.container;
    }

    public void setSelected(boolean selected) {
        this.container.unSelectAll();
        this.isSelected = selected;
        this.invalidate();
        this.repaint();
        if (selected) {
            this.container.setSelected(this);
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }
}

