/*
 * Decompiled with CFR 0.152.
 */
package wafly.control.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import wafly.control.explorer.Icon;
import wafly.control.explorer.SelectionListener;

public class IconExplorer
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int selectedIdx = -1;
    private JPanel thumbContainer = new JPanel();
    private JScrollPane thumbScroller = null;
    private ArrayList<SelectionListener> selectioners = new ArrayList();

    public IconExplorer() {
        this.thumbContainer.setLayout(new FlowLayout(0));
        this.thumbScroller = new JScrollPane(this.thumbContainer);
        this.setLayout(new BorderLayout());
        this.add((Component)this.thumbScroller, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                IconExplorer.this.thumbScroller.setHorizontalScrollBarPolicy(31);
                int totalWidth = IconExplorer.this.getWidth() - 30;
                int currentWidth = 0;
                int currentHeight = 0;
                int maxHeight = 0;
                int imgCount = IconExplorer.this.thumbContainer.getComponentCount();
                if (imgCount > 0) {
                    int i = 0;
                    while (i < imgCount) {
                        if (currentWidth + IconExplorer.this.thumbContainer.getComponent(i).getWidth() > totalWidth) {
                            currentHeight = currentHeight + maxHeight + 5;
                            currentWidth = 0;
                            maxHeight = 0;
                        } else {
                            currentWidth += IconExplorer.this.thumbContainer.getComponent(i).getWidth();
                            if (IconExplorer.this.thumbContainer.getComponent(i).getHeight() > maxHeight) {
                                maxHeight = IconExplorer.this.thumbContainer.getComponent(i).getHeight();
                            }
                        }
                        ++i;
                    }
                    currentHeight += maxHeight + 5;
                }
                IconExplorer.this.thumbContainer.setPreferredSize(new Dimension(IconExplorer.this.getWidth() - 30, currentHeight));
                if (currentHeight > IconExplorer.this.thumbContainer.getHeight()) {
                    IconExplorer.this.thumbScroller.setVerticalScrollBarPolicy(22);
                } else {
                    IconExplorer.this.thumbScroller.setVerticalScrollBarPolicy(21);
                }
                IconExplorer.this.validate();
                IconExplorer.this.repaint();
            }
        });
        this.thumbContainer.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                IconExplorer.this.unSelectAll();
                IconExplorer.this.setSelected(null);
            }
        });
    }

    @Override
    public void setBackground(Color bg) {
        if (this.thumbContainer == null) {
            return;
        }
        this.thumbContainer.setBackground(bg);
    }

    public void addIcon(Icon icon) {
        icon.container = this;
        this.thumbContainer.add(icon);
        this.validate();
        this.repaint();
    }

    public void addIcon(Icon icon, int index) {
        icon.container = this;
        this.thumbContainer.add((Component)icon, index);
        this.validate();
        this.repaint();
    }

    public void removeIcon(Icon icon) {
        icon.container = null;
        this.thumbContainer.remove(icon);
        this.validate();
        this.repaint();
    }

    public void removeIcon(int index) {
        Icon icon = (Icon)this.thumbContainer.getComponent(index);
        icon.container = null;
        this.thumbContainer.remove(icon);
        this.validate();
        this.repaint();
    }

    public void clear() {
        this.thumbContainer.removeAll();
    }

    public void unSelectAll() {
        int iconCount = this.thumbContainer.getComponentCount();
        int i = 0;
        while (i < iconCount) {
            Icon ico = (Icon)this.thumbContainer.getComponent(i);
            ico.isSelected = false;
            ++i;
        }
        this.selectedIdx = -1;
        this.thumbContainer.validate();
        this.thumbContainer.repaint();
    }

    public Icon getSelectedItem() {
        if (this.selectedIdx < 0 || this.selectedIdx >= this.thumbContainer.getComponentCount()) {
            return null;
        }
        return (Icon)this.thumbContainer.getComponent(this.selectedIdx);
    }

    public int getSelectedIndex() {
        return this.selectedIdx;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectioners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectioners.remove(listener);
    }

    void setSelected(Icon icon) {
        for (SelectionListener listener : this.selectioners) {
            listener.onSelected(icon);
        }
    }
}

