/*
 * Decompiled with CFR 0.152.
 */
package wafly.control.form;

import com.sun.awt.AWTUtilities;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Area;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.awt.image.VolatileImage;
import java.beans.PropertyChangeListener;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Set;
import javax.accessibility.AccessibleContext;

public class ImageForm
extends Window {
    private static final long serialVersionUID = 1L;
    private boolean isMouseDrag = false;
    private Point origin = new Point();
    private BackgroundPanel panel = null;
    private boolean isInited = false;

    public ImageForm(Image backImg, boolean drawBackgroundPic, boolean isMouseDrag) {
        super((Window)null);
        this.isMouseDrag = isMouseDrag;
        this.panel = new BackgroundPanel(drawBackgroundPic);
        int width = backImg.getWidth(null);
        int height = backImg.getHeight(null);
        this.setLayout(new BorderLayout());
        this.setSize(width, height);
        this.panel.bg = backImg;
        this.panel.setSize(width, height);
        this.panel.setLocation(0, 0);
        super.add((Component)this.panel, "Center");
        this.panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ImageForm.this.isMouseDrag) {
                    ((ImageForm)ImageForm.this).origin.x = e.getX();
                    ((ImageForm)ImageForm.this).origin.y = e.getY();
                }
            }
        });
        this.panel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ImageForm.this.isMouseDrag) {
                    Point p = ImageForm.this.getLocation();
                    ImageForm.this.setLocation(p.x + e.getX() - ((ImageForm)ImageForm.this).origin.x, p.y + e.getY() - ((ImageForm)ImageForm.this).origin.y);
                }
            }
        });
        if (drawBackgroundPic) {
            this.panel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent evt) {
                    BufferedImage newImg = new BufferedImage(ImageForm.this.getWidth(), ImageForm.this.getHeight(), 2);
                    newImg.getGraphics().drawImage(((ImageForm)ImageForm.this).panel.bg, 0, 0, ImageForm.this.getWidth(), ImageForm.this.getHeight(), null);
                    ((ImageForm)ImageForm.this).panel.bg = newImg;
                    AWTUtilities.setWindowShape((Window)ImageForm.this, (Shape)ImageForm.this.getImageShape(newImg));
                }
            });
        }
    }

    public ImageForm(Image backImg) {
        this(backImg, true, true);
    }

    public void setMouseDrag(boolean isMouseDrag) {
        this.isMouseDrag = isMouseDrag;
    }

    public boolean isMouseDrag() {
        return this.isMouseDrag;
    }

    public void reShape(Image newBackImage) {
        int width = newBackImage.getWidth(null);
        int height = newBackImage.getHeight(null);
        this.setSize(width, height);
        AWTUtilities.setWindowShape((Window)this, (Shape)this.getImageShape(newBackImage));
        this.panel.bg = newBackImage;
        this.panel.setSize(width, height);
        super.repaint();
    }

    public Image getBackImage() {
        return this.panel.bg;
    }

    @Override
    public void setVisible(boolean b) {
        if (!this.isInited && b) {
            AWTUtilities.setWindowShape((Window)this, (Shape)this.getImageShape(this.panel.bg));
            this.isInited = true;
        }
        super.setVisible(b);
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.panel.setCursor(cursor);
    }

    @Override
    public int getComponentCount() {
        return this.panel.getComponentCount();
    }

    @Override
    public Component[] getComponents() {
        return this.panel.getComponents();
    }

    @Override
    public Component add(Component comp) {
        return this.panel.add(comp);
    }

    @Override
    public Component add(String name, Component comp) {
        return this.panel.add(name, comp);
    }

    @Override
    public Component add(Component comp, int index) {
        return this.panel.add(comp, index);
    }

    @Override
    public void setComponentZOrder(Component comp, int index) {
        this.panel.setComponentZOrder(comp, index);
    }

    @Override
    public int getComponentZOrder(Component comp) {
        return this.panel.getComponentZOrder(comp);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.panel.add(comp, constraints);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.panel.add(comp, constraints, index);
    }

    @Override
    public void remove(int index) {
        this.panel.remove(index);
    }

    @Override
    public void remove(Component comp) {
        this.panel.remove(comp);
    }

    @Override
    public void removeAll() {
        this.panel.removeAll();
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (this.panel == null) {
            return;
        }
        this.panel.setLayout(mgr);
    }

    @Override
    public void setFont(Font f) {
        this.panel.setFont(f);
    }

    @Override
    public void paintComponents(Graphics g) {
        this.panel.paintComponents(g);
    }

    @Override
    public synchronized void addContainerListener(ContainerListener l) {
        this.panel.addContainerListener(l);
    }

    @Override
    public synchronized void removeContainerListener(ContainerListener l) {
        this.panel.removeContainerListener(l);
    }

    @Override
    public synchronized ContainerListener[] getContainerListeners() {
        return this.panel.getContainerListeners();
    }

    @Override
    public Component getComponentAt(int x, int y) {
        return this.panel.getComponentAt(x, y);
    }

    @Override
    public Component getComponentAt(Point p) {
        return this.panel.getComponentAt(p);
    }

    @Override
    public Component findComponentAt(int x, int y) {
        return this.panel.findComponentAt(x, y);
    }

    @Override
    public Component findComponentAt(Point p) {
        return this.panel.findComponentAt(p);
    }

    @Override
    public synchronized void setDropTarget(DropTarget dt) {
        this.panel.setDropTarget(dt);
    }

    @Override
    public synchronized DropTarget getDropTarget() {
        return this.panel.getDropTarget();
    }

    @Override
    public boolean isDisplayable() {
        return this.panel.isDisplayable();
    }

    @Override
    public Point getMousePosition() throws HeadlessException {
        return this.panel.getMousePosition();
    }

    @Override
    public boolean isDoubleBuffered() {
        return this.panel.isDoubleBuffered();
    }

    public Color getForegroundColor() {
        return this.panel.getForeground();
    }

    public void setForegroundColor(Color c) {
        this.panel.setForeground(c);
    }

    public Color getBackgroundColor() {
        return this.panel.getBackground();
    }

    public void setBackgroundColor(Color c) {
        this.panel.setBackground(c);
    }

    @Override
    public Font getFont() {
        return this.panel.getFont();
    }

    @Override
    public ColorModel getColorModel() {
        return this.panel.getColorModel();
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.panel.getBaseline(width, height);
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return this.panel.getBaselineResizeBehavior();
    }

    @Override
    public Graphics getGraphics() {
        return this.panel.getGraphics();
    }

    @Override
    public boolean isCursorSet() {
        return this.panel.isCursorSet();
    }

    @Override
    public synchronized void addComponentListener(ComponentListener l) {
        this.panel.addComponentListener(l);
    }

    @Override
    public synchronized void removeComponentListener(ComponentListener l) {
        this.panel.removeComponentListener(l);
    }

    @Override
    public synchronized ComponentListener[] getComponentListeners() {
        return this.panel.getComponentListeners();
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        this.panel.addFocusListener(l);
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        this.panel.removeFocusListener(l);
    }

    @Override
    public synchronized FocusListener[] getFocusListeners() {
        return this.panel.getFocusListeners();
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this.panel.addKeyListener(l);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        this.panel.removeKeyListener(l);
    }

    @Override
    public synchronized KeyListener[] getKeyListeners() {
        return this.panel.getKeyListeners();
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.panel.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.panel.removeMouseListener(l);
    }

    @Override
    public synchronized MouseListener[] getMouseListeners() {
        return this.panel.getMouseListeners();
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        this.panel.addMouseMotionListener(l);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        this.panel.removeMouseMotionListener(l);
    }

    @Override
    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        return this.panel.getMouseMotionListeners();
    }

    @Override
    public synchronized void addMouseWheelListener(MouseWheelListener l) {
        this.panel.addMouseWheelListener(l);
    }

    @Override
    public synchronized void removeMouseWheelListener(MouseWheelListener l) {
        this.panel.removeMouseWheelListener(l);
    }

    @Override
    public synchronized MouseWheelListener[] getMouseWheelListeners() {
        return this.panel.getMouseWheelListeners();
    }

    @Override
    public synchronized void addInputMethodListener(InputMethodListener l) {
        this.panel.addInputMethodListener(l);
    }

    @Override
    public synchronized void removeInputMethodListener(InputMethodListener l) {
        this.panel.removeInputMethodListener(l);
    }

    @Override
    public void setFocusable(boolean focusable) {
        this.panel.setFocusable(focusable);
    }

    @Override
    public void requestFocus() {
        this.panel.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.panel.requestFocusInWindow();
    }

    @Override
    public synchronized void add(PopupMenu popup) {
        this.panel.add(popup);
    }

    @Override
    public synchronized void remove(MenuComponent popup) {
        this.panel.remove(popup);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.panel.getListeners(listenerType);
    }

    @Override
    public Set<AWTKeyStroke> getFocusTraversalKeys(int id) {
        return this.panel.getFocusTraversalKeys(id);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.panel.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.panel.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.panel.getAccessibleContext();
    }

    @Override
    public void paint(Graphics g) {
        this.panel.paint(g);
    }

    @Override
    public Insets getInsets() {
        return this.panel.getInsets();
    }

    @Override
    public LayoutManager getLayout() {
        return this.panel.getLayout();
    }

    @Override
    public void doLayout() {
        this.panel.doLayout();
    }

    @Override
    public void invalidate() {
        this.panel.invalidate();
    }

    @Override
    public void validate() {
        this.panel.validate();
    }

    @Override
    public float getAlignmentX() {
        return this.panel.getAlignmentX();
    }

    @Override
    public float getAlignmentY() {
        return this.panel.getAlignmentY();
    }

    @Override
    public void update(Graphics g) {
        this.panel.update(g);
    }

    @Override
    public void print(Graphics g) {
        this.panel.print(g);
    }

    @Override
    public void printComponents(Graphics g) {
        this.panel.printComponents(g);
    }

    @Override
    public Point getMousePosition(boolean allowChildren) throws HeadlessException {
        return this.panel.getMousePosition(allowChildren);
    }

    @Override
    public boolean isAncestorOf(Component c) {
        return this.panel.isAncestorOf(c);
    }

    @Override
    public void list(PrintStream out, int indent) {
        this.panel.list(out, indent);
    }

    @Override
    public void list(PrintWriter out, int indent) {
        this.panel.list(out, indent);
    }

    @Override
    public void setFocusTraversalKeys(int id, Set<? extends AWTKeyStroke> keystrokes) {
        this.panel.setFocusTraversalKeys(id, keystrokes);
    }

    @Override
    public boolean areFocusTraversalKeysSet(int id) {
        return this.panel.areFocusTraversalKeysSet(id);
    }

    @Override
    public boolean isFocusCycleRoot(Container container) {
        return this.panel.isFocusCycleRoot(container);
    }

    @Override
    public void transferFocusBackward() {
        this.panel.transferFocusBackward();
    }

    @Override
    public void setFocusTraversalPolicy(FocusTraversalPolicy policy) {
        this.panel.setFocusTraversalPolicy(policy);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.panel.getFontMetrics(font);
    }

    @Override
    public void paintAll(Graphics g) {
        this.panel.paintAll(g);
    }

    @Override
    public void repaint() {
        this.panel.repaint();
    }

    @Override
    public void repaint(long tm) {
        this.panel.repaint(tm);
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        this.panel.repaint(x, y, width, height);
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        this.panel.repaint(tm, x, y, width, height);
    }

    @Override
    public void printAll(Graphics g) {
        this.panel.printAll(g);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        return this.panel.imageUpdate(img, infoflags, x, y, w, h);
    }

    @Override
    public Image createImage(ImageProducer producer) {
        return this.panel.createImage(producer);
    }

    @Override
    public Image createImage(int width, int height) {
        return this.panel.createImage(width, height);
    }

    @Override
    public VolatileImage createVolatileImage(int width, int height) {
        return this.panel.createVolatileImage(width, height);
    }

    @Override
    public VolatileImage createVolatileImage(int width, int height, ImageCapabilities caps) throws AWTException {
        return this.panel.createVolatileImage(width, height, caps);
    }

    @Override
    public boolean prepareImage(Image image, ImageObserver observer) {
        return this.panel.prepareImage(image, observer);
    }

    @Override
    public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        return this.panel.prepareImage(image, width, height, observer);
    }

    @Override
    public void setIgnoreRepaint(boolean ignoreRepaint) {
        this.panel.setIgnoreRepaint(ignoreRepaint);
    }

    @Override
    public boolean getIgnoreRepaint() {
        return this.panel.getIgnoreRepaint();
    }

    @Override
    public boolean contains(int x, int y) {
        return this.panel.contains(x, y);
    }

    @Override
    public boolean contains(Point p) {
        return this.panel.contains(p);
    }

    @Override
    public void addHierarchyListener(HierarchyListener l) {
        this.panel.addHierarchyListener(l);
    }

    @Override
    public void removeHierarchyListener(HierarchyListener l) {
        this.panel.removeHierarchyListener(l);
    }

    @Override
    public synchronized HierarchyListener[] getHierarchyListeners() {
        return this.panel.getHierarchyListeners();
    }

    @Override
    public void addHierarchyBoundsListener(HierarchyBoundsListener l) {
        this.panel.addHierarchyBoundsListener(l);
    }

    @Override
    public void removeHierarchyBoundsListener(HierarchyBoundsListener l) {
        this.panel.removeHierarchyBoundsListener(l);
    }

    @Override
    public synchronized InputMethodListener[] getInputMethodListeners() {
        return this.panel.getInputMethodListeners();
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.panel.getInputMethodRequests();
    }

    @Override
    public boolean isFocusable() {
        return this.panel.isFocusable();
    }

    @Override
    public void setFocusTraversalKeysEnabled(boolean focusTraversalKeysEnabled) {
        this.panel.setFocusTraversalKeysEnabled(focusTraversalKeysEnabled);
    }

    @Override
    public void transferFocus() {
        this.panel.transferFocus();
    }

    @Override
    public void transferFocusUpCycle() {
        this.panel.transferFocusUpCycle();
    }

    @Override
    public boolean hasFocus() {
        return this.panel.hasFocus();
    }

    @Override
    public void list() {
        this.panel.list();
    }

    @Override
    public void list(PrintStream out) {
        this.panel.list(out);
    }

    @Override
    public void list(PrintWriter out) {
        this.panel.list(out);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.panel.removePropertyChangeListener(listener);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.panel.getPropertyChangeListeners();
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.panel.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.panel.getPropertyChangeListeners(propertyName);
    }

    @Override
    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.panel.firePropertyChange(propertyName, (long)oldValue, (long)newValue);
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        this.panel.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        this.panel.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        this.panel.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        this.panel.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        this.panel.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.panel.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation o) {
        this.panel.setComponentOrientation(o);
    }

    private Shape getImageShape(Image img) {
        if (img == null) {
            return null;
        }
        ArrayList<Integer> x = new ArrayList<Integer>();
        ArrayList<Integer> y = new ArrayList<Integer>();
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        PixelGrabber pgr = new PixelGrabber(img, 0, 0, width, height, true);
        try {
            pgr.grabPixels();
        }
        catch (Exception ex) {
            ex.getStackTrace();
        }
        int[] pixels = (int[])pgr.getPixels();
        int i = 0;
        while (i < pixels.length) {
            int alpha = pixels[i] >> 24 & 0xFF;
            if (alpha != 0) {
                x.add(i % width > 0 ? i % width - 1 : 0);
                y.add(i % width == 0 ? (i == 0 ? 0 : i / width - 1) : i / width);
            }
            ++i;
        }
        int[][] matrix = new int[height][width];
        int i2 = 0;
        while (i2 < height) {
            int j = 0;
            while (j < width) {
                matrix[i2][j] = 0;
                ++j;
            }
            ++i2;
        }
        int c = 0;
        while (c < x.size()) {
            matrix[((Integer)y.get((int)c)).intValue()][((Integer)x.get((int)c)).intValue()] = 1;
            ++c;
        }
        Area rec = new Area();
        int temp = 0;
        int i3 = 0;
        while (i3 < height) {
            int j = 0;
            while (j < width) {
                Rectangle rectemp;
                if (matrix[i3][j] == 1) {
                    if (temp == 0) {
                        temp = j;
                    } else if (j == width) {
                        if (temp == 0) {
                            rectemp = new Rectangle(j, i3, 1, 1);
                            rec.add(new Area(rectemp));
                        } else {
                            rectemp = new Rectangle(temp, i3, j - temp, 1);
                            rec.add(new Area(rectemp));
                            temp = 0;
                        }
                    }
                } else if (temp != 0) {
                    rectemp = new Rectangle(temp, i3, j - temp, 1);
                    rec.add(new Area(rectemp));
                    temp = 0;
                }
                ++j;
            }
            temp = 0;
            ++i3;
        }
        return rec;
    }

    private static class BackgroundPanel
    extends Panel {
        private static final long serialVersionUID = 1L;
        public Image bg = null;
        private boolean drawBackgroundPic = false;

        public BackgroundPanel(boolean drawBackgroundPic) {
            this.drawBackgroundPic = drawBackgroundPic;
        }

        @Override
        public void paint(Graphics g) {
            if (this.drawBackgroundPic) {
                g.drawImage(this.bg, 0, 0, null);
            }
            super.paint(g);
        }
    }
}

