/*
 * Decompiled with CFR 0.152.
 */
package wafly.control.textinput;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JTextField;
import wafly.control.textinput.ValueChangeListener;

public class NumberField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private JButton addBtn = new JButton();
    private JButton subBtn = new JButton();
    private int maxValue = 0;
    private int minValue = 0;
    private int addStep = 1;
    private ArrayList<ValueChangeListener> valueListenerList = new ArrayList();

    public NumberField() {
        super("0");
        Font oriFont = new Font(this.addBtn.getFont().getFamily(), 0, 8);
        this.addBtn.setFont(oriFont);
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int v = Integer.parseInt(NumberField.this.getText()) + NumberField.this.addStep;
                if (v > NumberField.this.maxValue) {
                    v = NumberField.this.maxValue;
                }
                NumberField.this.setText(String.valueOf(v));
                NumberField.this.requestFocus();
                if (NumberField.this.valueListenerList == null) {
                    return;
                }
                for (ValueChangeListener l : NumberField.this.valueListenerList) {
                    l.valueChanged(v);
                }
            }
        });
        this.addBtn.setCursor(Cursor.getPredefinedCursor(12));
        this.add(this.addBtn);
        this.subBtn.setFont(oriFont);
        this.subBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int v = Integer.parseInt(NumberField.this.getText()) - NumberField.this.addStep;
                if (v < NumberField.this.minValue) {
                    v = NumberField.this.minValue;
                }
                NumberField.this.setText(String.valueOf(v));
                NumberField.this.requestFocus();
                if (NumberField.this.valueListenerList == null) {
                    return;
                }
                for (ValueChangeListener l : NumberField.this.valueListenerList) {
                    l.valueChanged(v);
                }
            }
        });
        this.subBtn.setCursor(Cursor.getPredefinedCursor(12));
        this.add(this.subBtn);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                int intValue;
                String value = NumberField.this.getText().trim();
                if (value.length() == 0) {
                    NumberField.this.setText("0");
                    value = "0";
                }
                if ((intValue = Integer.parseInt(value)) < NumberField.this.minValue) {
                    intValue = NumberField.this.minValue;
                }
                if (intValue > NumberField.this.maxValue) {
                    intValue = NumberField.this.maxValue;
                }
                NumberField.this.setText(String.valueOf(intValue));
                if (NumberField.this.valueListenerList == null) {
                    return;
                }
                for (ValueChangeListener l : NumberField.this.valueListenerList) {
                    l.valueChanged(intValue);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                int intValue;
                char ch;
                String value = NumberField.this.getText().trim();
                if (value.length() == 0) {
                    NumberField.this.setText("0");
                    value = "0";
                }
                if ((ch = e.getKeyChar()) < '0' || ch > '9') {
                    e.consume();
                }
                if ((intValue = Integer.parseInt(value)) < NumberField.this.minValue) {
                    intValue = NumberField.this.minValue;
                }
                if (intValue > NumberField.this.maxValue) {
                    intValue = NumberField.this.maxValue;
                }
                NumberField.this.setText(String.valueOf(intValue));
                if (NumberField.this.valueListenerList == null) {
                    return;
                }
                for (ValueChangeListener l : NumberField.this.valueListenerList) {
                    l.valueChanged(intValue);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int intValue;
                String value = NumberField.this.getText().trim();
                if (value.length() == 0) {
                    NumberField.this.setText("0");
                    value = "0";
                }
                if ((intValue = Integer.parseInt(value)) < NumberField.this.minValue) {
                    intValue = NumberField.this.minValue;
                }
                if (intValue > NumberField.this.maxValue) {
                    intValue = NumberField.this.maxValue;
                }
                NumberField.this.setText(String.valueOf(intValue));
                if (NumberField.this.valueListenerList == null) {
                    return;
                }
                for (ValueChangeListener l : NumberField.this.valueListenerList) {
                    l.valueChanged(intValue);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                if (NumberField.this.getWidth() < 10) {
                    NumberField.this.addBtn.setSize(0, 0);
                    NumberField.this.subBtn.setSize(0, 0);
                } else {
                    NumberField.this.addBtn.setSize(10, NumberField.this.getHeight() / 2);
                    NumberField.this.subBtn.setSize(10, NumberField.this.getHeight() / 2);
                    NumberField.this.addBtn.setLocation(NumberField.this.getWidth() - 10, 0);
                    NumberField.this.subBtn.setLocation(NumberField.this.getWidth() - 10, NumberField.this.getHeight() / 2);
                }
            }
        });
    }

    @Override
    public void setText(String t) {
        int value = this.minValue;
        try {
            value = Integer.parseInt(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setNumber(value);
    }

    public void setNumber(int value) {
        if (value > this.maxValue) {
            value = this.maxValue;
        }
        if (value < this.minValue) {
            value = this.minValue;
        }
        super.setText(String.valueOf(value));
        if (this.valueListenerList == null) {
            return;
        }
        for (ValueChangeListener l : this.valueListenerList) {
            l.valueChanged(value);
        }
    }

    public JButton getAdditionButton() {
        return this.addBtn;
    }

    public JButton getSubsideButton() {
        return this.subBtn;
    }

    public void setMaximumValue(int value) {
        if (value < this.minValue) {
            value = this.minValue;
        }
        this.maxValue = value;
    }

    public int getMaximumValue() {
        return this.maxValue;
    }

    public void setMinimumValue(int value) {
        if (value > this.maxValue) {
            value = this.maxValue;
        }
        this.minValue = value;
    }

    public int getMinimumValue() {
        return this.minValue;
    }

    public void setStep(int value) {
        if (value < 1) {
            value = 1;
        }
        this.addStep = value;
    }

    public int getStep() {
        return this.addStep;
    }

    public void addValueChangeListener(ValueChangeListener l) {
        if (this.valueListenerList != null) {
            this.valueListenerList.add(l);
        }
    }

    public void removeValueChangeListener(ValueChangeListener l) {
        if (this.valueListenerList != null) {
            this.valueListenerList.remove(l);
        }
    }

    public ArrayList<ValueChangeListener> getValueChangeListeners() {
        return this.valueListenerList;
    }
}

