Scriptname AF_DungeonCell01 extends activemagiceffect

ObjectReference Property dunCell_a  Auto
ObjectReference Property dunCell_b Auto
ObjectReference Property dunCell_c  Auto
ObjectReference Property dunCell_d  Auto
Message Property AF_DungeonSpellOptMsg Auto

Sound Property TeleportSound  Auto
VisualEffect Property fadeOutFX  Auto
VisualEffect Property fadeInFX  Auto

ObjectReference Property MoveToCell  Auto Hidden
actor Property poorBastard Auto Hidden

Event OnInit()
EndEvent

Event OnEffectStart(Actor akTarget, Actor akCaster)
	poorBastard = akTarget
	atWhichCell ()

	if (poorBastard.IsEssential())
		Debug.Notification("This person has some kind of protection against teleportation...")
	Else	
		poorBastard.setghost(true)
		TeleportSound.play(poorBastard)
		fadeOutFX.Play(poorBastard, 0.4)
		Utility.Wait(2.3)

		poorBastard.MoveTo(MoveToCell)
		fadeInFX.Play(poorBastard, 0.4)
		Utility.Wait(2.2)	
		poorBastard.setghost(false)
		endIf

EndEvent

Function atWhichCell ()
	int opt = AF_DungeonSpellOptMsg.show()
	if (opt == 0)
		MoveToCell = dunCell_a
	ElseIf (opt == 1)
		MoveToCell = dunCell_b
	ElseIf (opt == 2)
		MoveToCell = dunCell_c
	Else
		MoveToCell = dunCell_d
	EndIf
EndFunction



