scriptName AF_Dwe_Secret_Door_Script extends ObjectReference conditional
{Script to open the door to blackreach when activated by the lock.}

import game
import debug
import utility

;-- Properties --------------------------------------
string property openEvent = "TransDown" auto hidden
{open event name - waits for this event before considering itself "open"}

bool property isAnimating = false auto hidden
{is the activator currently animating from one state to another?}

string property openAnim = "Down" auto hidden
{animation to play when opening}

bool property isOpen = false auto Conditional
{set to true to start open}


string property closeEvent = "TransUp" auto hidden
{open event name - waits for this event before considering itself "open"}

string property closeAnim = "Up" auto hidden
{animation to play when Closing}

;-- Variables ---------------------------------------
int myState = 1
; true when static or animating
; 0 == open or opening
; 1 == closed or closing

;-- Events  ---------------------------------------

EVENT OnLoad()
	BlockActivation()
	if (isOpen )
		myState = 0
	else
		myState = 1
	endIf	
endEVENT

;-- State -------------------------------------------
auto STATE waiting	; waiting to be activated
	EVENT onActivate (objectReference triggerRef)
		; switch open state when activated
		SetOpen(!isOpen)
	endEVENT
endState

STATE busy
	; This is the state when I'm busy animating
	EVENT onActivate (objectReference triggerRef)
			trace (self + " Busy")
	endEVENT
endSTATE

;-- Functions ---------------------------------------
function SetOpen(bool abOpen = true)
	;if busy, wait to finish
	while getState() == "busy"
		wait(1)
	endWhile
	; open
	isAnimating = true
	if !isOpen  
		GotoState("busy")
		trace(self + " Opening")
		playAnimationandWait(openAnim, openEvent) ; Animate Open
		isOpen = true
		isAnimating = false
	else
		GotoState("busy")
		trace(self + " Closing")
		playAnimationandWait(closeAnim, closeEvent) ; Animate close
		trace(self + " Opened")
		isOpen = false
		isAnimating = false
	endIf
	GotoState("waiting")
endFunction
