Scriptname AF_TimedLightSwitch extends ObjectReference  
{Controls a set of lights with a master enable parent marker with this
script attached to turn on and off at the times of the day specified
by the properties LightsOffTime and LightsOnTime}

float Property LightsOffTime = 7.0 auto
{The time at which lights should be turned off}
float Property LightsOnTime = 18.0 auto
{The time at which lights should be turned on}
 
float Function GetCurrentHourOfDay() global
{Returns the current time of day in hours since midnight}
 
	float Time = Utility.GetCurrentGameTime()
	Time -= Math.Floor(Time) ; Remove "previous in-game days passed" bit
	Time *= 24 ; Convert from fraction of a day to number of hours
	Return Time
 
EndFunction
 
Function RegisterForSingleUpdateGameTimeAt(float GameTime)
{Registers for a single UpdateGameTime event at the next occurrence
of the specified GameTime (in hours since midnight)}
 
	float CurrentTime = GetCurrentHourOfDay()
	If (GameTime < CurrentTime)
		GameTime += 24
	EndIf
 
	RegisterForSingleUpdateGameTime(GameTime - CurrentTime)
 
EndFunction
 
Event OnInit()
 
	If (GetCurrentHourOfDay() > LightsOffTime)
		GoToState("LightsOff")
	Else
		GoToState("LightsOn")
	EndIf
 
EndEvent
 
State LightsOff
 
	Event OnBeginState()
		Disable()
		RegisterForSingleUpdateGameTimeAt(LightsOnTime)
	EndEvent
 
	Event OnUpdateGameTime()
		GoToState("LightsOn")
	EndEvent
 
EndState
 
State LightsOn
 
	Event OnBeginState()
		Enable()
		RegisterForSingleUpdateGameTimeAt(LightsOffTime)
	EndEvent
 
	Event OnUpdateGameTime()
		GoToState("LightsOff")
	EndEvent
 
EndState