ScriptName magicSoulTrapFXScript extends ActiveMagicEffect
{Scripted effect for the Soul Trap Visual FX - This version edited by GIST (opusGlass)}

import debug


;======================================================================================;
;  PROPERTIES  /
;=============/
ImageSpaceModifier property TrapImod auto
{IsMod applied when we trap a soul}
sound property TrapSoundFX auto ; create a sound property we'll point to in the editor
{Sound played when we trap a soul}
VisualEffect property TargetVFX auto
{Visual Effect on Target aiming at Caster}
VisualEffect property CasterVFX auto
{Visual Effect on Caster aming at Target}
EffectShader property CasterFXS auto
{Effect Shader on Caster during Soul trap}
EffectShader property TargetFXS auto
{Effect Shader on Target during Soul trap}
bool property bIsEnchantmentEffect = false auto
{Set this to true if this soul trap is on a weapon enchantment or a spell that can do damage to deal with a fringe case}

;======================================================================================;
;  VARIABLES   /
;=============/
actor CasterActor
actor Victim
; objectreference playerref
bool DeadAlready = FALSE
bool bUseWait = True
;======================================================================================;
; USKP VARIABLES   /
;=================/
USKPSoulTrapController SoulTrapController
ObjectReference DummyContainer
SoulGem DA01SoulGemBlackStar
Keyword ActorTypeNPC
bool victimIsNPC
int iBlackStars
;======================================================================================;
;  EVENTS      /
;=============/

Event OnEffectStart(Actor Target, Actor Caster)
  victim = target
  CasterActor = Caster

  ;USKP ADDITIONS-------------------------------------------------------

    ActorTypeNPC = Game.GetFormFromFile(0x013794, "Skyrim.esm") as Keyword
    if victim.HasKeyword(ActorTypeNPC)
      victimIsNPC = True
    endif

  ;---------------------------------------------------------------------

  if bIsEnchantmentEffect == False
    DeadAlready = Victim.IsDead()
  endif
  bUseWait = False
;   debug.trace("Is Soultrap target dead? ("+deadAlready+")("+victim+")") 
EndEvent


Event OnEffectFinish(Actor Target, Actor Caster)
  ;trace(self + " is finishing")
  if victim
    if bUseWait 
      Utility.Wait(0.25)
    endif
	
    if ((DeadAlready == False) && Target.IsDead())
		; Get a reference to the SoulManager
		ogsg_SoulManagerScript ogsg_SoulManagerQuest = Game.GetFormFromFile(0x0012d8, "GIST soul trap.esp") as ogsg_SoulManagerScript;
	
		; Figure out soul level
		int soullvl;
		if (victimIsNPC)
			soullvl = 6;
		else
			int victimlvl = victim.GetLevel();
			if (victimlvl < Game.GetGameSettingInt("iLesserSoulActorLevel"))
				soullvl = 1;
			elseif (victimlvl < Game.GetGameSettingInt("iCommonSoulActorLevel"))
				soullvl = 2;
			elseif (victimlvl < Game.GetGameSettingInt("iGreaterSoulActorLevel"))
				soullvl = 3;
			elseif (victimlvl < Game.GetGameSettingInt("iGrandSoulActorLevel"))
				soullvl = 4;
			else
				soullvl = 5;
			endIf
		endIf

		; Send the soul to the SoulManager for trapping
		bool capture = ogsg_SoulManagerQuest.AddVictim(victim, soullvl);
		if (capture) 
			ogsg_SoulManagerQuest.AddSoul(soullvl);
		endIf
			
        ;trace(victim + " is, in fact, dead.  Play soul trap visFX")
		;Actor player = Game.GetPlayer();
        ;TrapSoundFX.play(player)       ; play TrapSoundFX sound from player
        ;TrapImod.apply()                                  ; apply isMod at full strength
        ;TargetVFX.Play(victim,4.7,player)              ; Play TargetVFX and aim them at the player
        ;CasterVFX.Play(player,5.9,victim)
        ;TargetFXS.Play(victim,2)                ; Play Effect Shaders
        ;CasterFXS.Play(player,3)
      ;else
        ;trace(victim + " is, in fact, dead, But the TrapSoul check failed or came back false")
      ;endif
    
    else
      ;trace(self + "tried to soulTrap, but " + victim + " is already Dead.")
    endif
  endif
endEvent

