Scriptname ogsg_ConfigMenu extends SKI_ConfigBase  


; properties - global variables

GlobalVariable property ogsg_bAllowSoulShrinking auto;
GlobalVariable property ogsg_bAllowSoulRelocating auto;
GlobalVariable property ogsg_bAllowBlackGemsCaptureWhiteSouls auto;
GlobalVariable property ogsg_bAllowBlackStarCaptureWhiteSouls auto;
GlobalVariable property ogsg_bShowSoulDisplacedMessage auto;
GlobalVariable property ogsg_bShowSoulShrunkMessage auto;
GlobalVariable property ogsg_bShowSoulDiscardedMessage auto;
GlobalVariable property ogsg_bShowSoulCapturedMessage auto;

GlobalVariable property ogsg_bEnableLevelingSystem auto;
GlobalVariable property ogsg_bUseEnchantingForLeveling auto;
GlobalVariable property ogsg_iLvlCapturePetty auto;
GlobalVariable property ogsg_iLvlCaptureLesser auto;
GlobalVariable property ogsg_iLvlCaptureCommon auto;
GlobalVariable property ogsg_iLvlCaptureGreater auto;
GlobalVariable property ogsg_iLvlCaptureGrand auto;
GlobalVariable property ogsg_iLvlCaptureBlack auto;
GlobalVariable property ogsg_iLvlAllowSoulShrinking auto;
GlobalVariable property ogsg_iLvlAllowSoulDisplacing auto;
GlobalVariable property ogsg_iLvlAllowSoulRelocating auto;
GlobalVariable property ogsg_iLvlAllowBlackGemsCaptureWhiteSouls auto;
GlobalVariable property ogsg_bShowInsufficientLevelMessage auto;



; variables - button IDs

int bid_bAllowSoulShrinking;
int bid_bAllowSoulRelocating;
int bid_bAllowBlackGemsCaptureWhiteSouls;
int bid_bAllowBlackStarCaptureWhiteSouls;
int bid_bShowSoulDisplacedMessage;
int bid_bShowSoulShrunkMessage;
int bid_bShowSoulDiscardedMessage;
int bid_bShowSoulCapturedMessage;
int bid_oRevertMainDefaults;

int bid_bEnableLevelingSystem;
int bid_bUseEnchantingForLeveling;
int bid_iLvlCapturePetty;
int bid_iLvlCaptureLesser;
int bid_iLvlCaptureCommon;
int bid_iLvlCaptureGreater;
int bid_iLvlCaptureGrand;
int bid_iLvlCaptureBlack;
int bid_iLvlAllowSoulShrinking;
int bid_iLvlAllowSoulDisplacing;
int bid_iLvlAllowSoulRelocating;
int bid_iLvlAllowBlackGemsCaptureWhiteSouls;
int bid_bShowInsufficientLevelMessage;
int bid_oRevertLevelingDefaults;

; variables - defaults

bool def_bAllowSoulShrinking = true;
bool def_bAllowSoulRelocating = true;
bool def_bAllowBlackGemsCaptureWhiteSouls = true;
bool def_bAllowBlackStarCaptureWhiteSouls = false;
bool def_bShowSoulDisplacedMessage = true;
bool def_bShowSoulShrunkMessage = true;
bool def_bShowSoulDiscardedMessage = true;
bool def_bShowSoulCapturedMessage = false;

bool def_bEnableLevelingSystem = false;
bool def_bUseEnchantingForLeveling = false;
int def_iLvlCapturePetty = 15;
int def_iLvlCaptureLesser = 25;
int def_iLvlCaptureCommon = 35;
int def_iLvlCaptureGreater = 45;
int def_iLvlCaptureGrand = 60;
int def_iLvlCaptureBlack = 75;
int def_iLvlAllowSoulShrinking = 30;
int def_iLvlAllowSoulDisplacing = 40;
int def_iLvlAllowSoulRelocating = 50;
int def_iLvlAllowBlackGemsCaptureWhiteSouls = 65;
bool def_bShowInsufficientLevelMessage = true;





event OnPageReset(string page)
	SetCursorFillMode(TOP_TO_BOTTOM);
	
	if ((page == "Main") || (page == ""))
		AddHeaderOption("Mechanics");
		AddEmptyOption();
		bid_bAllowSoulShrinking = AddToggleOption("Soul Shrinking", ogsg_bAllowSoulShrinking.GetValue() as bool);
		bid_bAllowSoulRelocating = AddToggleOption("Soul Relocation", ogsg_bAllowSoulRelocating.GetValue() as bool);
		bid_bAllowBlackGemsCaptureWhiteSouls = AddToggleOption("Black Gems Capture White Souls", ogsg_bAllowBlackGemsCaptureWhiteSouls.GetValue() as bool);
		bid_bAllowBlackStarCaptureWhiteSouls = AddToggleOption("Black Star Capture White Souls", ogsg_bAllowBlackStarCaptureWhiteSouls.GetValue() as bool);
		
		SetCursorPosition(1);
		AddHeaderOption("Notifications");
		AddEmptyOption();
		bid_bShowSoulDiscardedMessage = AddToggleOption("Show message on soul lost", ogsg_bShowSoulDiscardedMessage.GetValue() as bool);
		bid_bShowSoulShrunkMessage = AddToggleOption("Show message on soul shrunk", ogsg_bShowSoulShrunkMessage.GetValue() as bool);
		bid_bShowSoulDisplacedMessage = AddToggleOption("Show message on soul displaced", ogsg_bShowSoulDisplacedMessage.GetValue() as bool);
		bid_bShowSoulCapturedMessage = AddToggleOption("Show message on soul trapped", ogsg_bShowSoulCapturedMessage.GetValue() as bool);
		
		SetCursorPosition(14);
		bid_oRevertMainDefaults = AddTextOption("Restore defaults on this page", "");
		
	elseIf (page == "Leveling")
		bid_bEnableLevelingSystem = AddToggleOption("Enable Leveling System", ogsg_bEnableLevelingSystem.GetValue() as bool);
		int flag = GetLevelingFlags();
		
		SetCursorPosition(1);
		bid_bUseEnchantingForLeveling = AddTextOption("Skill:", GetSkillString(ogsg_bUseEnchantingForLeveling.GetValue() as bool), flag);
		
		SetCursorPosition(4);
		AddHeaderOption("Soul Capturing");
		bid_iLvlCapturePetty = AddSliderOption("Petty Souls", ogsg_iLvlCapturePetty.GetValue(), "Lv.{0}", flag);
		bid_iLvlCaptureLesser = AddSliderOption("Lesser Souls", ogsg_iLvlCaptureLesser.GetValue(), "Lv.{0}", flag);
		bid_iLvlCaptureCommon = AddSliderOption("Common Souls", ogsg_iLvlCaptureCommon.GetValue(), "Lv.{0}", flag);
		bid_iLvlCaptureGreater = AddSliderOption("Greater Souls", ogsg_iLvlCaptureGreater.GetValue(), "Lv.{0}", flag);
		bid_iLvlCaptureGrand = AddSliderOption("Grand Souls", ogsg_iLvlCaptureGrand.GetValue(), "Lv.{0}", flag);
		bid_iLvlCaptureBlack = AddSliderOption("Black Souls", ogsg_iLvlCaptureBlack.GetValue(), "Lv.{0}", flag);
		bid_bShowInsufficientLevelMessage = AddToggleOption("Show message when level insufficient", ogsg_bShowInsufficientLevelMessage.GetValue() as bool, flag);
		
		SetCursorPosition(5);
		AddHeaderOption("Mechanics");
		bid_iLvlAllowSoulShrinking = AddSliderOption("Soul Shrinking", ogsg_iLvlAllowSoulShrinking.GetValue(), "Lv.{0}", flag);
		bid_iLvlAllowSoulDisplacing = AddSliderOption("Soul Displacement", ogsg_iLvlAllowSoulDisplacing.GetValue(), "Lv.{0}", flag);
		bid_iLvlAllowSoulRelocating = AddSliderOption("Soul Relocation", ogsg_iLvlAllowSoulRelocating.GetValue(), "Lv.{0}", flag);
		bid_iLvlAllowBlackGemsCaptureWhiteSouls = AddSliderOption("Black Gems Capture White Souls", ogsg_iLvlAllowBlackGemsCaptureWhiteSouls.GetValue(), "Lv.{0}", flag);
		
		SetCursorPosition(22);
		bid_oRevertLevelingDefaults = AddTextOption("Restore defaults on this page", "");
	endIf
endEvent

event OnOptionSelect(int bid)
	; Normal boolean options
	if (bid == bid_bAllowSoulShrinking)
		ogsg_bAllowSoulShrinking.SetValue((!(ogsg_bAllowSoulShrinking.GetValue() as bool)) as float);
		SetToggleOptionValue(bid, ogsg_bAllowSoulShrinking.GetValue() as bool);
	elseIf (bid == bid_bAllowSoulRelocating)
		ogsg_bAllowSoulRelocating.SetValue((!(ogsg_bAllowSoulRelocating.GetValue() as bool)) as float);
		SetToggleOptionValue(bid, ogsg_bAllowSoulRelocating.GetValue() as bool);
	elseIf (bid == bid_bAllowBlackGemsCaptureWhiteSouls)
		ogsg_bAllowBlackGemsCaptureWhiteSouls.SetValue((!(ogsg_bAllowBlackGemsCaptureWhiteSouls.GetValue() as bool)) as float);
		SetToggleOptionValue(bid, ogsg_bAllowBlackGemsCaptureWhiteSouls.GetValue() as bool);
	elseIf (bid == bid_bAllowBlackStarCaptureWhiteSouls)
		ogsg_bAllowBlackStarCaptureWhiteSouls.SetValue((!(ogsg_bAllowBlackStarCaptureWhiteSouls.GetValue() as bool)) as float);
		SetToggleOptionValue(bid, ogsg_bAllowBlackStarCaptureWhiteSouls.GetValue() as bool);
	elseIf (bid == bid_bAllowBlackStarCaptureWhiteSouls)
		ogsg_bAllowBlackStarCaptureWhiteSouls.SetValue((!(ogsg_bAllowBlackStarCaptureWhiteSouls.GetValue() as bool)) as float);
		SetToggleOptionValue(bid, ogsg_bAllowBlackStarCaptureWhiteSouls.GetValue() as bool);
	elseIf (bid == bid_bShowSoulDisplacedMessage)
		ogsg_bShowSoulDisplacedMessage.SetValue((!(ogsg_bShowSoulDisplacedMessage.GetValue() as bool)) as float);
		SetToggleOptionValue(bid, ogsg_bShowSoulDisplacedMessage.GetValue() as bool);
	elseIf (bid == bid_bShowSoulShrunkMessage)
		ogsg_bShowSoulShrunkMessage.SetValue((!(ogsg_bShowSoulShrunkMessage.GetValue() as bool)) as float);
		SetToggleOptionValue(bid, ogsg_bShowSoulShrunkMessage.GetValue() as bool);
	elseIf (bid == bid_bShowSoulDiscardedMessage)
		ogsg_bShowSoulDiscardedMessage.SetValue((!(ogsg_bShowSoulDiscardedMessage.GetValue() as bool)) as float);
		SetToggleOptionValue(bid, ogsg_bShowSoulDiscardedMessage.GetValue() as bool);
	elseIf (bid == bid_bShowSoulCapturedMessage)
		ogsg_bShowSoulCapturedMessage.SetValue((!(ogsg_bShowSoulCapturedMessage.GetValue() as bool)) as float);
		SetToggleOptionValue(bid, ogsg_bShowSoulCapturedMessage.GetValue() as bool);
	elseIf (bid == bid_bShowInsufficientLevelMessage)
		ogsg_bShowInsufficientLevelMessage.SetValue((!(ogsg_bShowInsufficientLevelMessage.GetValue() as bool)) as float);
		SetToggleOptionValue(bid, ogsg_bShowInsufficientLevelMessage.GetValue() as bool);
		
	; Other boolean options
	elseIf (bid == bid_bUseEnchantingForLeveling)
		ogsg_bUseEnchantingForLeveling.SetValue((!(ogsg_bUseEnchantingForLeveling.GetValue() as bool)) as float);
		SetTextOptionValue(bid, GetSkillString(ogsg_bUseEnchantingForLeveling.GetValue() as bool));
	elseIf (bid == bid_bEnableLevelingSystem)
		ogsg_bEnableLevelingSystem.SetValue((!(ogsg_bEnableLevelingSystem.GetValue() as bool)) as float);
		;SetToggleOptionValue(bid_bEnableLevelingSystem, ogsg_bEnableLevelingSystem.GetValue() as bool); Unnecessary
		ForcePageReset();
		
	; State-less buttons
	elseIf (bid == bid_oRevertMainDefaults)
		ogsg_bAllowSoulShrinking.SetValue(def_bAllowSoulShrinking as float);
		ogsg_bAllowSoulRelocating.SetValue(def_bAllowSoulRelocating as float);
		ogsg_bAllowBlackGemsCaptureWhiteSouls.SetValue(def_bAllowBlackGemsCaptureWhiteSouls as float);
		ogsg_bAllowBlackStarCaptureWhiteSouls.SetValue(def_bAllowBlackStarCaptureWhiteSouls as float);
		ogsg_bShowSoulDisplacedMessage.SetValue(def_bShowSoulDisplacedMessage as float);
		ogsg_bShowSoulShrunkMessage.SetValue(def_bShowSoulShrunkMessage as float);
		ogsg_bShowSoulDiscardedMessage.SetValue(def_bShowSoulDiscardedMessage as float);
		ogsg_bShowSoulCapturedMessage.SetValue(def_bShowSoulCapturedMessage as float);
		ForcePageReset();
	elseIf (bid == bid_oRevertLevelingDefaults)
		ogsg_bEnableLevelingSystem.SetValue(def_bEnableLevelingSystem as float);
		ogsg_bUseEnchantingForLeveling.SetValue(def_bUseEnchantingForLeveling as float);
		ogsg_iLvlCapturePetty.SetValue(def_iLvlCapturePetty as float);
		ogsg_iLvlCaptureLesser.SetValue(def_iLvlCaptureLesser as float);
		ogsg_iLvlCaptureCommon.SetValue(def_iLvlCaptureCommon as float);
		ogsg_iLvlCaptureGreater.SetValue(def_iLvlCaptureGreater as float);
		ogsg_iLvlCaptureGrand.SetValue(def_iLvlCaptureGrand as float);
		ogsg_iLvlCaptureBlack.SetValue(def_iLvlCaptureBlack as float);
		ogsg_iLvlAllowSoulShrinking.SetValue(def_iLvlAllowSoulShrinking as float);
		ogsg_iLvlAllowSoulDisplacing.SetValue(def_iLvlAllowSoulDisplacing as float);
		ogsg_iLvlAllowSoulRelocating.SetValue(def_iLvlAllowSoulRelocating as float);
		ogsg_iLvlAllowBlackGemsCaptureWhiteSouls.SetValue(def_iLvlAllowBlackGemsCaptureWhiteSouls as float);
		ogsg_bShowInsufficientLevelMessage.SetValue(def_bShowInsufficientLevelMessage as float);
		ForcePageReset();
	endIf;

endEvent


event OnOptionSliderOpen(int bid)
	if (bid == bid_iLvlCapturePetty)
		SetSliderDialogStartValue(ogsg_iLvlCapturePetty.GetValue());
		SetSliderDialogDefaultValue(def_iLvlCapturePetty);
		SetSliderDialogRange(1, 100);
		SetSliderDialogInterval(1);
	elseif (bid == bid_iLvlCaptureLesser)
		SetSliderDialogStartValue(ogsg_iLvlCaptureLesser.GetValue());
		SetSliderDialogDefaultValue(def_iLvlCaptureLesser);
		SetSliderDialogRange(1, 100);
		SetSliderDialogInterval(1);
	elseif (bid == bid_iLvlCaptureCommon)
		SetSliderDialogStartValue(ogsg_iLvlCaptureCommon.GetValue());
		SetSliderDialogDefaultValue(def_iLvlCaptureCommon);
		SetSliderDialogRange(1, 100);
		SetSliderDialogInterval(1);
	elseif (bid == bid_iLvlCaptureGreater)
		SetSliderDialogStartValue(ogsg_iLvlCaptureGreater.GetValue());
		SetSliderDialogDefaultValue(def_iLvlCaptureGreater);
		SetSliderDialogRange(1, 100);
		SetSliderDialogInterval(1);
	elseif (bid == bid_iLvlCaptureGrand)
		SetSliderDialogStartValue(ogsg_iLvlCaptureGrand.GetValue());
		SetSliderDialogDefaultValue(def_iLvlCaptureGrand);
		SetSliderDialogRange(1, 100);
		SetSliderDialogInterval(1);
	elseif (bid == bid_iLvlCaptureBlack)
		SetSliderDialogStartValue(ogsg_iLvlCaptureBlack.GetValue());
		SetSliderDialogDefaultValue(def_iLvlCaptureBlack);
		SetSliderDialogRange(1, 100);
		SetSliderDialogInterval(1);
	elseif (bid == bid_iLvlAllowSoulShrinking)
		SetSliderDialogStartValue(ogsg_iLvlAllowSoulShrinking.GetValue());
		SetSliderDialogDefaultValue(def_iLvlAllowSoulShrinking);
		SetSliderDialogRange(1, 100);
		SetSliderDialogInterval(1);
	elseif (bid == bid_iLvlAllowSoulDisplacing)
		SetSliderDialogStartValue(ogsg_iLvlAllowSoulDisplacing.GetValue());
		SetSliderDialogDefaultValue(def_iLvlAllowSoulDisplacing);
		SetSliderDialogRange(1, 100);
		SetSliderDialogInterval(1);
	elseif (bid == bid_iLvlAllowSoulRelocating)
		SetSliderDialogStartValue(ogsg_iLvlAllowSoulRelocating.GetValue());
		SetSliderDialogDefaultValue(def_iLvlAllowSoulRelocating);
		SetSliderDialogRange(1, 100);
		SetSliderDialogInterval(1);
	elseif (bid == bid_iLvlAllowBlackGemsCaptureWhiteSouls)
		SetSliderDialogStartValue(ogsg_iLvlAllowBlackGemsCaptureWhiteSouls.GetValue());
		SetSliderDialogDefaultValue(def_iLvlAllowBlackGemsCaptureWhiteSouls);
		SetSliderDialogRange(1, 100);
		SetSliderDialogInterval(1);
	endIf
endEvent

event OnOptionSliderAccept(int bid, float val)
	if (bid == bid_iLvlCapturePetty)
		ogsg_iLvlCapturePetty.SetValue(val);
		SetSliderOptionValue(bid, val, "Lv.{0}");
	elseif (bid == bid_iLvlCaptureLesser)
		ogsg_iLvlCaptureLesser.SetValue(val);
		SetSliderOptionValue(bid, val, "Lv.{0}");
	elseif (bid == bid_iLvlCaptureCommon)
		ogsg_iLvlCaptureCommon.SetValue(val);
		SetSliderOptionValue(bid, val, "Lv.{0}");
	elseif (bid == bid_iLvlCaptureGreater)
		ogsg_iLvlCaptureGreater.SetValue(val);
		SetSliderOptionValue(bid, val, "Lv.{0}");
	elseif (bid == bid_iLvlCaptureGrand)
		ogsg_iLvlCaptureGrand.SetValue(val);
		SetSliderOptionValue(bid, val, "Lv.{0}");
	elseif (bid == bid_iLvlCaptureBlack)
		ogsg_iLvlCaptureBlack.SetValue(val);
		SetSliderOptionValue(bid, val, "Lv.{0}");
	elseif (bid == bid_iLvlAllowSoulShrinking)
		ogsg_iLvlAllowSoulShrinking.SetValue(val);
		SetSliderOptionValue(bid, val, "Lv.{0}");
	elseif (bid == bid_iLvlAllowSoulDisplacing)
		ogsg_iLvlAllowSoulDisplacing.SetValue(val);
		SetSliderOptionValue(bid, val, "Lv.{0}");
	elseif (bid == bid_iLvlAllowSoulRelocating)
		ogsg_iLvlAllowSoulRelocating.SetValue(val);
		SetSliderOptionValue(bid, val, "Lv.{0}");
	elseif (bid == bid_iLvlAllowBlackGemsCaptureWhiteSouls)
		ogsg_iLvlAllowBlackGemsCaptureWhiteSouls.SetValue(val);
		SetSliderOptionValue(bid, val, "Lv.{0}");
	endIf
endEvent


event OnOptionDefault(int bid)
	; Normal boolean options
	if (bid == bid_bAllowSoulShrinking)
		ogsg_bAllowSoulShrinking.SetValue((def_bAllowSoulShrinking) as float);
		SetToggleOptionValue(bid, def_bAllowSoulShrinking);
	elseif (bid == bid_bAllowSoulRelocating)
		ogsg_bAllowSoulRelocating.SetValue((def_bAllowSoulRelocating) as float);
		SetToggleOptionValue(bid, def_bAllowSoulRelocating);
	elseif (bid == bid_bAllowBlackGemsCaptureWhiteSouls)
		ogsg_bAllowBlackGemsCaptureWhiteSouls.SetValue((def_bAllowBlackGemsCaptureWhiteSouls) as float);
		SetToggleOptionValue(bid, def_bAllowBlackGemsCaptureWhiteSouls);
	elseif (bid == bid_bAllowBlackStarCaptureWhiteSouls)
		ogsg_bAllowBlackStarCaptureWhiteSouls.SetValue((def_bAllowBlackStarCaptureWhiteSouls) as float);
		SetToggleOptionValue(bid, def_bAllowBlackStarCaptureWhiteSouls);
	elseif (bid == bid_bShowSoulDisplacedMessage)
		ogsg_bShowSoulDisplacedMessage.SetValue((def_bShowSoulDisplacedMessage) as float);
		SetToggleOptionValue(bid, def_bShowSoulDisplacedMessage);
	elseif (bid == bid_bShowSoulShrunkMessage)
		ogsg_bShowSoulShrunkMessage.SetValue((def_bShowSoulShrunkMessage) as float);
		SetToggleOptionValue(bid, def_bShowSoulShrunkMessage);
	elseif (bid == bid_bShowSoulDiscardedMessage)
		ogsg_bShowSoulDiscardedMessage.SetValue((def_bShowSoulDiscardedMessage) as float);
		SetToggleOptionValue(bid, def_bShowSoulDiscardedMessage);
	elseif (bid == bid_bShowSoulCapturedMessage)
		ogsg_bShowSoulCapturedMessage.SetValue((def_bShowSoulCapturedMessage) as float);
		SetToggleOptionValue(bid, def_bShowSoulCapturedMessage);
	elseif (bid == bid_bEnableLevelingSystem)
		ogsg_bEnableLevelingSystem.SetValue((def_bEnableLevelingSystem) as float);
		SetToggleOptionValue(bid, def_bEnableLevelingSystem);
	elseif (bid == bid_bShowInsufficientLevelMessage)
		ogsg_bShowInsufficientLevelMessage.SetValue((def_bShowInsufficientLevelMessage) as float);
		SetToggleOptionValue(bid, def_bShowInsufficientLevelMessage);

	; Slider options
	elseif (bid == bid_iLvlCapturePetty)
		ogsg_iLvlCapturePetty.SetValue(def_iLvlCapturePetty as float);
		SetSliderOptionValue(bid, def_iLvlCapturePetty as float, "Lv.{0}");
	elseif (bid == bid_iLvlCaptureLesser)
		ogsg_iLvlCaptureLesser.SetValue(def_iLvlCaptureLesser as float);
		SetSliderOptionValue(bid, def_iLvlCaptureLesser as float, "Lv.{0}");
	elseif (bid == bid_iLvlCaptureCommon)
		ogsg_iLvlCaptureCommon.SetValue(def_iLvlCaptureCommon as float);
		SetSliderOptionValue(bid, def_iLvlCaptureCommon as float, "Lv.{0}");
	elseif (bid == bid_iLvlCaptureGreater)
		ogsg_iLvlCaptureGreater.SetValue(def_iLvlCaptureGreater as float);
		SetSliderOptionValue(bid, def_iLvlCaptureGreater as float, "Lv.{0}");
	elseif (bid == bid_iLvlCaptureGrand)
		ogsg_iLvlCaptureGrand.SetValue(def_iLvlCaptureGrand as float);
		SetSliderOptionValue(bid, def_iLvlCaptureGrand as float, "Lv.{0}");
	elseif (bid == bid_iLvlCaptureBlack)
		ogsg_iLvlCaptureBlack.SetValue(def_iLvlCaptureBlack as float);
		SetSliderOptionValue(bid, def_iLvlCaptureBlack as float, "Lv.{0}");
	elseif (bid == bid_iLvlAllowSoulShrinking)
		ogsg_iLvlAllowSoulShrinking.SetValue(def_iLvlAllowSoulShrinking as float);
		SetSliderOptionValue(bid, def_iLvlAllowSoulShrinking as float, "Lv.{0}");
	elseif (bid == bid_iLvlAllowSoulDisplacing)
		ogsg_iLvlAllowSoulDisplacing.SetValue(def_iLvlAllowSoulDisplacing as float);
		SetSliderOptionValue(bid, def_iLvlAllowSoulDisplacing as float, "Lv.{0}");
	elseif (bid == bid_iLvlAllowSoulRelocating)
		ogsg_iLvlAllowSoulRelocating.SetValue(def_iLvlAllowSoulRelocating as float);
		SetSliderOptionValue(bid, def_iLvlAllowSoulRelocating as float, "Lv.{0}");
	elseif (bid == bid_iLvlAllowBlackGemsCaptureWhiteSouls)
		ogsg_iLvlAllowBlackGemsCaptureWhiteSouls.SetValue(def_iLvlAllowBlackGemsCaptureWhiteSouls as float);
		SetSliderOptionValue(bid, def_iLvlAllowBlackGemsCaptureWhiteSouls as float, "Lv.{0}");
	
	; Other options
	elseif (bid == bid_bUseEnchantingForLeveling)
		ogsg_bUseEnchantingForLeveling.SetValue((def_bUseEnchantingForLeveling) as float);
		SetTextOptionValue(bid, GetSkillString(ogsg_bUseEnchantingForLeveling.GetValue() as bool));
	endIf
endEvent


Event OnOptionHighlight(int bid)
	if (bid == bid_bAllowSoulShrinking)
		SetInfoText("If no gem is found to place the soul into, this shrinks the soul by one size and tries again. (Repeats until gem reaches petty size)");
	elseif (bid == bid_bAllowSoulRelocating)
		SetInfoText("If a soul is displaced to make room for a larger soul, this will check if the soul fits in another gem before throwing it away.");
	elseif (bid == bid_bAllowBlackGemsCaptureWhiteSouls)
		SetInfoText("If no white gems of a sufficient size can be found, this will try to place those white souls into a black gem.\n(They can be displaced by black souls later.)");
	elseif (bid == bid_bAllowBlackStarCaptureWhiteSouls)
		SetInfoText("If no Grand or Black gems can be found, this will try to place white Grand souls into The Black Star.\n(These souls can NOT be displaced later, which is why only Grand souls are accepted, and why this is disabled by default.)");
	elseif (bid == bid_bShowSoulDisplacedMessage)
		SetInfoText("This shows a HUD notification when souls are displaced from a gem by a larger soul.");
	elseif (bid == bid_bShowSoulShrunkMessage)
		SetInfoText("This shows a HUD notification when souls must be shrunk due to no sufficiently large gems.");
	elseif (bid == bid_bShowSoulDiscardedMessage)
		SetInfoText("This shows a HUD notification when a soul must be thrown out due to no empty gems.");
	elseif (bid == bid_bShowSoulCapturedMessage)
		SetInfoText("This shows a HUD notification whenever souls are successfully trapped.");
	elseif (bid == bid_oRevertMainDefaults)
		SetInfoText("This reverts all options on this page of the MCM to their default values.");

	elseif (bid == bid_bEnableLevelingSystem)
		SetInfoText("This allows certain features to be enabled only after a certain skill level.\nNote that any individual feature can be set to Lv.1 to be enabled from the start of the game.\nAlso note that a feature that is disabled on the Main option page will never become enabled, regardless of the settings here.");
	elseif (bid == bid_bUseEnchantingForLeveling)
		SetInfoText("Which skill should determine your soul trapping abilities?");
	elseif (bid == bid_iLvlCapturePetty)
		SetInfoText("The level at which Petty Souls can be captured.");
	elseif (bid == bid_iLvlCaptureLesser)
		SetInfoText("The level at which Lesser Souls can be captured.");
	elseif (bid == bid_iLvlCaptureCommon)
		SetInfoText("The level at which Common Souls can be captured.");
	elseif (bid == bid_iLvlCaptureGreater)
		SetInfoText("The level at which Greater Souls can be captured.");
	elseif (bid == bid_iLvlCaptureGrand)
		SetInfoText("The level at which Grand Souls can be captured.");
	elseif (bid == bid_iLvlCaptureBlack)
		SetInfoText("The level at which Black Souls can be captured.");
	elseif (bid == bid_iLvlAllowSoulShrinking)
		SetInfoText("The level at which souls can be shrunk.\n(See option on Main page for more info.)");
	elseif (bid == bid_iLvlAllowSoulDisplacing)
		SetInfoText("The level at which souls can be displaced.\n(This refers to the main feature of this mod, where souls can be removed from under-filled gems to make room for larger souls.)");
	elseif (bid == bid_iLvlAllowSoulRelocating)
		SetInfoText("The level at which souls can be relocated after being displaced.\n(See option on Main page for more info.)");
	elseif (bid == bid_iLvlAllowBlackGemsCaptureWhiteSouls)
		SetInfoText("The level at which Black gems can capture white souls.\n(See option on Main page for more info.)");
	elseif (bid == bid_bShowInsufficientLevelMessage)
		SetInfoText("This shows a HUD notification whenever a soul is not captured because your skill level is too low for that soul size.");
	elseif (bid == bid_oRevertLevelingDefaults)
		SetInfoText("This reverts all options on this page of the MCM to their default values.");
	
	else
		SetInfoText("");
	endIf
endEvent




string function GetSkillString(bool s)
	if (s)
		return "Enchanting";
	else
		return "Conjuration";
	endIf
endFunction

int function GetLevelingFlags()
	if (ogsg_bEnableLevelingSystem.GetValue() > 0)
		return OPTION_FLAG_NONE;
	else
		return OPTION_FLAG_DISABLED;
	endIf
endFunction









