ScriptName ogsg_SoulManagerScript extends Quest

; Public variables (properties)
GlobalVariable property ogsg_bAllowSoulShrinking auto;
GlobalVariable property ogsg_bAllowSoulRelocating auto;
GlobalVariable property ogsg_bAllowBlackGemsCaptureWhiteSouls auto;
GlobalVariable property ogsg_bAllowBlackStarCaptureWhiteSouls auto;
GlobalVariable property ogsg_bShowSoulDisplacedMessage auto;
GlobalVariable property ogsg_bShowSoulShrunkMessage auto;
GlobalVariable property ogsg_bShowSoulDiscardedMessage auto;
GlobalVariable property ogsg_bShowSoulCapturedMessage auto;

GlobalVariable property ogsg_bEnableLevelingSystem auto;
GlobalVariable property ogsg_bUseEnchantingForLeveling auto;
GlobalVariable property ogsg_iLvlCapturePetty auto;
GlobalVariable property ogsg_iLvlCaptureLesser auto;
GlobalVariable property ogsg_iLvlCaptureCommon auto;
GlobalVariable property ogsg_iLvlCaptureGreater auto;
GlobalVariable property ogsg_iLvlCaptureGrand auto;
GlobalVariable property ogsg_iLvlCaptureBlack auto;
GlobalVariable property ogsg_iLvlAllowSoulShrinking auto;
GlobalVariable property ogsg_iLvlAllowSoulDisplacing auto;
GlobalVariable property ogsg_iLvlAllowSoulRelocating auto;
GlobalVariable property ogsg_iLvlAllowBlackGemsCaptureWhiteSouls auto;
GlobalVariable property ogsg_bShowInsufficientLevelMessage auto;

SoulGem Property DA01SoulGemAzurasStar Auto
SoulGem Property DA01SoulGemBlackStar Auto
SoulGem Property SoulGemBlack Auto
SoulGem Property SoulGemBlackFilled Auto
SoulGem Property ogsg_SoulGemBlackFilledGrand Auto
SoulGem Property ogsg_SoulGemBlackFilledGreater Auto
SoulGem Property ogsg_SoulGemBlackFilledCommon Auto
SoulGem Property ogsg_SoulGemBlackFilledLesser Auto
SoulGem Property ogsg_SoulGemBlackFilledPetty Auto
SoulGem Property SoulGemGrand Auto
SoulGem Property SoulGemGrandFilled Auto
SoulGem Property ogsg_SoulGemGrandFilledGreater Auto
SoulGem Property ogsg_SoulGemGrandFilledCommon Auto
SoulGem Property ogsg_SoulGemGrandFilledLesser Auto
SoulGem Property ogsg_SoulGemGrandFilledPetty Auto
SoulGem Property SoulGemGreater Auto
SoulGem Property SoulGemGreaterFilled Auto
SoulGem Property ogsg_SoulGemGreaterFilledCommon Auto
SoulGem Property ogsg_SoulGemGreaterFilledLesser Auto
SoulGem Property ogsg_SoulGemGreaterFilledPetty Auto
SoulGem Property SoulGemCommon Auto
SoulGem Property SoulGemCommonFilled Auto
SoulGem Property ogsg_SoulGemCommonFilledLesser Auto
SoulGem Property ogsg_SoulGemCommonFilledPetty Auto
SoulGem Property SoulGemLesser Auto
SoulGem Property SoulGemLesserFilled Auto
SoulGem Property ogsg_SoulGemLesserFilledPetty Auto
SoulGem Property SoulGemPetty Auto
SoulGem Property SoulGemPettyFilled Auto

ObjectReference Property ogsg_SoulContainer Auto

Actor[] property BlackSoulVictims auto;
{Set this to an empty array with a large number of values, say 50.}
Actor[] property GrandSoulVictims auto;
{Set this to an empty array with a large number of values, say 50.}
Actor[] property GreaterSoulVictims auto;
{Set this to an empty array with a large number of values, say 50.}
Actor[] property CommonSoulVictims auto;
{Set this to an empty array with a large number of values, say 50.}
Actor[] property LesserSoulVictims auto;
{Set this to an empty array with a large number of values, say 50.}
Actor[] property PettySoulVictims auto;
{Set this to an empty array with a large number of values, say 50.}
Actor[] property AllRecentVictims auto;
{Set this to an empty array with a large number of values, say 50.}


ImageSpaceModifier property SoulTrapTakingImod auto
{IsMod applied when we trap a soul}
sound property MAGMysticismSoulTrapCapture auto ; create a sound property we'll point to in the editor
{Sound played when we trap a soul}
VisualEffect property SoulTrapPVFX01 auto
{Visual Effect on Target aiming at Caster}
VisualEffect property SoulTrapPVFX02 auto
{Visual Effect on Caster aming at Target}
EffectShader property SoulTrapCastActFXS auto
{Effect Shader on Caster during Soul trap}
EffectShader property SoulTrapTargetActFXS auto
{Effect Shader on Target during Soul trap}

; Private variables
int BlackSoulVictimsN = 0;
int GrandSoulVictimsN = 0;
int GreaterSoulVictimsN = 0;
int CommonSoulVictimsN = 0;
int LesserSoulVictimsN = 0;
int PettySoulVictimsN = 0;

int PendingBlackSouls = 0;
int PendingGrandSouls = 0;
int PendingGreaterSouls = 0;
int PendingCommonSouls = 0;
int PendingLesserSouls = 0;
int PendingPettySouls = 0;

bool ShowSoulDisplaceMsg = true;
bool ShowSoulShrunkMsg = true;
bool ShowSoulLostMsg = true;
bool ShowSoulCapturedMsg = false;
bool ShowInsufficientMsg = true;

int AllRecentVictimsIndex = 0;

Actor Player = None;


; Functions intended for public use
function AddSoul(int size) ; Add a soul to the queue
	if (size == 1)
		PendingPettySouls += 1;
	elseif (size == 2)
		PendingLesserSouls += 1;
	elseif (size == 3)
		PendingCommonSouls += 1;
	elseif (size == 4)
		PendingGreaterSouls += 1;
	elseif (size == 5)
		PendingGrandSouls += 1;
	elseif (size == 6)
		PendingBlackSouls += 1;
	endIf
	
	;Debug.Notification("ADD: P:" + PendingPettySouls + ", L:" + PendingLesserSouls + ", C:" + PendingCommonSouls + ", G:" + PendingGreaterSouls + ", G:" + PendingGrandSouls +", B:" + PendingBlackSouls);
	
	; Register for update to process the new soul(s)
	RegisterForSingleUpdate(0);
endFunction

bool function AddVictim(Actor victim, int size) ; Before sending a soul to the SoulManager, add its victim with this. Check that it returns positive; otherwise, this creature is already soul trapped, so don't call AddSoul!
	if (victim != None)
		; Check the AllRecentVictims array to ensure this isn't a duplicate
		int i = 0;
		bool match = false;
		while ((i < AllRecentVictims.length) && (match == false))
			if (AllRecentVictims[i] == victim)
				match = true;
			endIf
			i += 1;
		endWhile
		
		if (match == false)
			; Add to the AllRecentVictims array
			AllRecentVictims[AllRecentVictimsIndex] = victim;
			AllRecentVictimsIndex += 1;
			if (AllRecentVictimsIndex >= AllRecentVictims.length)
				AllRecentVictimsIndex = 0;
			endIf
			RegisterForSingleUpdateGameTime(1);
			
			if (size == 6)
				if (BlackSoulVictimsN < BlackSoulVictims.length - 1)
					BlackSoulVictimsN += 1;
					BlackSoulVictims[BlackSoulVictimsN - 1] = victim;
				endIf
			elseif (size == 5)
				if (GrandSoulVictimsN < GrandSoulVictims.length - 1)
					GrandSoulVictimsN += 1;
					GrandSoulVictims[GrandSoulVictimsN - 1] = victim;
				endIf
			elseif (size == 4)
				if (GreaterSoulVictimsN < GreaterSoulVictims.length - 1)
					GreaterSoulVictimsN += 1;
					GreaterSoulVictims[GreaterSoulVictimsN - 1] = victim;
				endIf
			elseif (size == 3)
				if (CommonSoulVictimsN < CommonSoulVictims.length - 1)
					CommonSoulVictimsN += 1;
					CommonSoulVictims[CommonSoulVictimsN - 1] = victim;
				endIf
			elseif (size == 2)
				if (LesserSoulVictimsN < LesserSoulVictims.length - 1)
					LesserSoulVictimsN += 1;
					LesserSoulVictims[LesserSoulVictimsN - 1] = victim;
				endIf
			elseif (size == 1)
				if (PettySoulVictimsN < PettySoulVictims.length - 1)
					PettySoulVictimsN += 1;
					PettySoulVictims[PettySoulVictimsN - 1] = victim;
				endIf
			endIf
			
			return true;
			
		else
			return false;
		endIf
	endIf
endFunction



event OnInit()  ; Initialization
	; Get the player ref
	Player = Game.GetPlayer();

	; Replace vanilla soul gems?
	;  No need, they'll be replaced when/if the algorithm decides to use them. This gives user more time to spend or sell them.
	
	; Get ready to start processing souls
	GoToState("Idle");
	RegisterForSingleUpdate(0);
endEvent


event OnUpdate() ; Called from empty state - OnInit hasn't finished yet, so ignore it.
endEvent

event OnUpdateGameTime() ; This is called 1 game-hour after the last soul capture. Effectively, this means we haven't recently captured a soul, so we can empty the AllRecentVictims array.
	int i = 0;
	while (i < AllRecentVictims.length)
		AllRecentVictims[i] = None;
		i += 1;
	endWhile
endEvent


state Idle

	event OnUpdate() ; Called from the idle state. Now we get to work! We need to process the largest pending soul.
		GoToState("Busy");
		
		int size = GetLargestPendingSoul(); Retrieve the largest soul from the queue
		RemoveSoul(size); Remove that soul from the queue, since we're processing it now
		
		if (size > 0) ; There is at least one soul - process it
			bool success = false;
			bool bail = false;
			bool dont_pop_victim = false;
			float lvl;

			
			; Bail conditions - don't process souls if leveling is enabled and player level is insufficient
			if (ogsg_bEnableLevelingSystem.GetValue() > 0)
				if (ogsg_bUseEnchantingForLeveling.GetValue() > 0)
					lvl = Player.GetActorValue("Enchanting");
				else
					lvl = Player.GetActorValue("Conjuration"); Could also add + Player.GetActorValue("ConjurationMod")
				endIf
				
				if (size == 1)
					if (lvl < ogsg_iLvlCapturePetty.GetValue())
						success = true;
						bail = true;
					endIf
				elseif (size == 2)
					if (lvl < ogsg_iLvlCaptureLesser.GetValue())
						success = true;
						bail = true;
					endIf
				elseif (size == 3)
					if (lvl < ogsg_iLvlCaptureCommon.GetValue())
						success = true;
						bail = true;
					endIf
				elseif (size == 4)
					if (lvl < ogsg_iLvlCaptureGreater.GetValue())
						success = true;
						bail = true;
					endIf
				elseif (size == 5)
					if (lvl < ogsg_iLvlCaptureGrand.GetValue())
						success = true;
						bail = true;
					endIf
				elseif (size == 6)
					if (lvl < ogsg_iLvlCaptureBlack.GetValue())
						success = true;
						bail = true;
					endIf
				endIf
				
				if (bail)
					if (ShowInsufficientMsg)
						Debug.Notification("Insufficient level to capture a soul");
						ShowInsufficientMsg = false;
					endIf
				endIf
			endIf
			
			
			
			; Try Azura's Star and the Black Star
			if (!success)
				if (size == 6) ; Black souls
					success = TryBlackStar();
					dont_pop_victim = success;
				elseif (size == 5) ; Grand souls
					success = TryAzuraStar();
					dont_pop_victim = success;
				endIf
			endIf
			
			; If we failed to use Azura's Star, try the normal soul capture procedure
			if (!success) 
				if ((size < 6) || ((ogsg_bAllowBlackGemsCaptureWhiteSouls.GetValue() > 0) && ((ogsg_bEnableLevelingSystem.GetValue() <= 0) || (lvl >= ogsg_iLvlAllowBlackGemsCaptureWhiteSouls.GetValue()))))
					int gem = FindSmallestSufficientEmptyGem(size);
					if (gem > 0)
						success = true;
						; Remove the empty gem and add a filled one
						RemoveGem(gem, 0);
						AddGem(gem, size);
					endIf
				else
					if (GetGemCount(6, 0) > 0)
						success = true;
						; Remove the empty black gem and add a filled one
						RemoveGem(6, 0);
						AddGem(6, 6);
					endIf
				endIf
			endIf
			
			; If a Grand Soul still has not been captured and ogsg_bAllowBlackStarCaptureWhiteSouls is enabled, try the Black Star
			if ((!success) && (size == 5) && ((ogsg_bAllowBlackStarCaptureWhiteSouls.GetValue() > 0) && ((ogsg_bEnableLevelingSystem.GetValue() <= 0) || (lvl >= ogsg_iLvlAllowBlackGemsCaptureWhiteSouls.GetValue()))))
				success = TryBlackStarWhiteSoul();
				dont_pop_victim = success;
			endIf
			
			; If we failed to capture normally, try reorganizing (if that's enabled)
			if ((!success) && ((ogsg_bEnableLevelingSystem.GetValue() <= 0) || (lvl >= ogsg_iLvlAllowSoulDisplacing.GetValue()))) 
				; Find the partially-filled gem of sufficient size that contains the smallest soul
				int gemcode = FindSmallestSoulPartiallyOccupyingASufficientGem(size);
				
				if (gemcode > 0) ; If a gem was found
					success = true;
				
					; Translate the gemcode into a soul size and a gem size
					int old_soul_size = TranslateGemCodeToSoulSize(gemcode);
					int gem_size = TranslateGemCodeToGemSize(gemcode);
					
					;Debug.Notification("Good. Gem:" + gem_size + ", old soul:" + old_soul_size + ", new soul:" + size);

					; Remove the old partially filled gem and add the new one
					RemoveGem(gem_size, old_soul_size);
					AddGem(gem_size, size);
					
					; Add the displaced soul into the queue
					if ((ogsg_bAllowSoulRelocating.GetValue() > 0) && ((ogsg_bEnableLevelingSystem.GetValue() <= 0) || (lvl >= ogsg_iLvlAllowSoulRelocating.GetValue())))
						AddSoul(old_soul_size);
					endIf
					
					; MessageBox
					if (ShowSoulDisplaceMsg)
						Debug.Notification("A soul was displaced");
						ShowSoulDisplaceMsg = false;
					endIf
				endIf
			endIf
			
			if ((success) && (!bail)) ; If we succeeded in capturing the soul...
				
				if (!dont_pop_victim) ; If it wasn't captured by Azura's Star / Black Star
					AnimateVictim(size); play the soul trap animation
				endIf
				
				if (ShowSoulCapturedMsg) ; give the optional notification
					Debug.Notification("A soul was captured!");
					ShowSoulCapturedMsg = false;
				endIf
				
			elseif (bail) ; If we were unqualified to capture a soul of this size...
			
				PopVictim(size); discard an appropriately-sized victim from the list of captured souls
				
			else ; If we didn't have room for the soul at this size using any of the enabled methods...
				if ((size > 1) && (size < 6) && ((ogsg_bEnableLevelingSystem.GetValue() <= 0) || (lvl >= ogsg_iLvlAllowSoulShrinking.GetValue()))) ; Time to shrink it
					; Shrink the soul
					ShrinkVictim(size);
					AddSoul(size - 1);
					
					; MessageBox
					if (ShowSoulShrunkMsg)
						Debug.Notification("A soul was shrunk");
						ShowSoulShrunkMsg = false;
					endIf
				else ; Time to give up on this soul; discard it
					; Discard the soul
					PopVictim(size);
					
					; MessageBox
					if (ShowSoulLostMsg)
						Debug.Notification("A soul was discarded");
						ShowSoulLostMsg = false;
					endIf
				endIf
			endIf
			
			
			; Get ready to move on and process the next soul
			GoToState("Idle");
			RegisterForSingleUpdate(0);
			
		else ; There are no souls left to process
			
			; Turn messages back on if that's enabled
			ShowSoulDisplaceMsg = ogsg_bShowSoulDisplacedMessage.GetValue();
			ShowSoulShrunkMsg = ogsg_bShowSoulShrunkMessage.GetValue();
			ShowSoulLostMsg = ogsg_bShowSoulDiscardedMessage.GetValue();
			ShowSoulCapturedMsg = ogsg_bShowSoulCapturedMessage.GetValue();
			ShowInsufficientMsg = ogsg_bShowInsufficientLevelMessage.GetValue();
			
			; Wait for more souls
			GoToState("Idle");
		endIf
		
	endEvent

endState




state Busy
	event OnUpdate() ;Called from busy state - we're already processing souls, so ignore it. We'll get to the new souls later.
	endEvent
endState












; Functions intended for private use

function RemoveSoul(int size) ; Remove a soul from the queue
	if (size == 1)
		PendingPettySouls -= 1;
	elseif (size == 2)
		PendingLesserSouls -= 1;
	elseif (size == 3)
		PendingCommonSouls -= 1;
	elseif (size == 4)
		PendingGreaterSouls -= 1;
	elseif (size == 5)
		PendingGrandSouls -= 1;
	elseif (size == 6)
		PendingBlackSouls -= 1;
	endIf
	
	
	;Debug.Notification("REM: P:" + PendingPettySouls + ", L:" + PendingLesserSouls + ", C:" + PendingCommonSouls + ", G:" + PendingGreaterSouls + ", G:" + PendingGrandSouls +", B:" + PendingBlackSouls);
endFunction

Actor function PopVictim(int size) ; Remove and return a victim of the given soul size
	if (size == 6)	
		if (BlackSoulVictimsN > 0)
			BlackSoulVictimsN -= 1;
			Actor victim = BlackSoulVictims[BlackSoulVictimsN];
			BlackSoulVictims[BlackSoulVictimsN] = None;
			return victim;
		endIf
	elseif (size == 5)
		if (GrandSoulVictimsN > 0)
			GrandSoulVictimsN -= 1;
			Actor victim = GrandSoulVictims[GrandSoulVictimsN];
			GrandSoulVictims[GrandSoulVictimsN] = None;
			return victim;
		endIf
	elseif (size == 4)
		if (GreaterSoulVictimsN > 0)
			GreaterSoulVictimsN -= 1;
			Actor victim = GreaterSoulVictims[GreaterSoulVictimsN];
			GreaterSoulVictims[GreaterSoulVictimsN] = None;
			return victim;
		endIf
	elseif (size == 3)
		if (CommonSoulVictimsN > 0)
			CommonSoulVictimsN -= 1;
			Actor victim = CommonSoulVictims[CommonSoulVictimsN];
			CommonSoulVictims[CommonSoulVictimsN] = None;
			return victim;
		endIf
	elseif (size == 2)
		if (LesserSoulVictimsN > 0)
			LesserSoulVictimsN -= 1;
			Actor victim = LesserSoulVictims[LesserSoulVictimsN];
			LesserSoulVictims[LesserSoulVictimsN] = None;
			return victim;
		endIf
	elseif (size == 1)
		if (PettySoulVictimsN > 0)
			PettySoulVictimsN -= 1;
			Actor victim = PettySoulVictims[PettySoulVictimsN];
			PettySoulVictims[PettySoulVictimsN] = None;
			return victim;
		endIf
	endIf
	
	return None;
endFunction

function ShrinkVictim(int size) ; Remove a victim of the given soul size, then add it as a victim of the next smaller soul size.
	Actor victim = PopVictim(size);
	if (victim != None)
		AddVictim(victim, size - 1);
	endIf
endFunction

function AnimateVictim(int size) ; Remove a victim of the given soul size, and play an animation to indicate that their soul was captured.
	Actor victim = PopVictim(size);
	AnimateSpecificVictim(victim);
endFunction

function AnimateSpecificVictim(Actor victim) ; Play an animation to indicate that their soul was captured.
	if (victim != None)
		MAGMysticismSoulTrapCapture.play(Player);
        SoulTrapTakingImod.apply();
        SoulTrapPVFX01.Play(victim, 4.7, Player);
        SoulTrapPVFX02.Play(Player, 5.9, victim);
        SoulTrapTargetActFXS.Play(victim, 2);
        SoulTrapCastActFXS.Play(player, 3);
		
		; Increase the Game Stat for souls trapped. Need to do it here to avoid false positives from relocating souls
		Game.IncrementStat("Souls Trapped");
	endIf
endFunction


int function GetLargestPendingSoul() ; Find size of largest soul waiting to be trapped
	if (PendingBlackSouls > 0)
		return 6;
	elseif (PendingGrandSouls > 0)
		return 5;
	elseif (PendingGreaterSouls > 0)
		return 4;
	elseif (PendingCommonSouls > 0)
		return 3;
	elseif (PendingLesserSouls > 0)
		return 2;
	elseif (PendingPettySouls > 0)
		return 1;
	else
		return 0;
	endIf
endFunction

int function FindSmallestSufficientEmptyGem(int min_size) ; Find the smallest empty gem that is large enough for this soul
	if ((min_size == 1) && (GetGemCount(1, 0) > 0))
		return 1;
	elseif ((min_size <= 2) && (GetGemCount(2, 0) > 0))
		return 2;
	elseif ((min_size <= 3) && (GetGemCount(3, 0) > 0))
		return 3;
	elseif ((min_size <= 4) && (GetGemCount(4, 0) > 0))
		return 4;
	elseif ((min_size <= 5) && (GetGemCount(5, 0) > 0))
		return 5;
	elseif ((min_size <= 6) && (GetGemCount(6, 0) > 0))
		return 6;
	endif
	
	return 0;
endFunction

int function FindSmallestSoulPartiallyOccupyingASufficientGem(int soul_size) ; Find the smallest soul partially occupying a gem that is large enough for this soul. Returns a single value that can be decoded into a soul size and a gem size with TranslateGemCodeToSoulSize and TranslateGemCodeToGemSize
	
	int g;
	int s = 0;
	while (s < soul_size - 1) ; Iterate through soul sizes starting at <Petty> up to <one less than the size of the target soul>
		s += 1;
		
		g = soul_size - 1;
		while (g < 6) ; Iterate through gems starting at <size of the target soul> up to <Black>
			g += 1;
			
			if ((g < 6) || (ogsg_bAllowBlackGemsCaptureWhiteSouls.GetValue() > 0)) ; Make sure not to return on a black gem if ogsg_bAllowBlackGemsCaptureWhiteSouls is disabled
				if (GetGemCount(g, s) > 0)
					return g*7 + s;
				endIf
			endIf
		endWhile
	endWhile
	
	return 0;
endFunction

int function TranslateGemCodeToSoulSize(int code) ; Translates the result of FindSmallestSoulPartiallyOccupyingASufficientGem
	return code%7;
endFunction

int function TranslateGemCodeToGemSize(int code) ; Translates the result of FindSmallestSoulPartiallyOccupyingASufficientGem
	return code/7;
endFunction

int function GetGemCount(int gemsize, int soulsize) ; Returns the number of this type of SoulGem in the inventory
	return Player.GetItemCount(GetSoulGem(gemsize, soulsize));
endFunction

function AddGem(int gemsize, int soulsize, int count = 1) ; Adds this type of SoulGem to the inventory
	Player.AddItem(GetSoulGem(gemsize, soulsize), 1, true);
endFunction

function RemoveGem(int gemsize, int soulsize, int count = 1) ; Removes this type of SoulGem from the inventory
	Player.RemoveItem(GetSoulGem(gemsize, soulsize), 1, true);
endFunction

SoulGem function GetSoulGem(int gemsize, int soulsize) ; Returns the SoulGem of the corresponding size and fullness
	if (gemsize == 1)
		if (soulsize == 0)
			return SoulGemPetty;
		elseif (soulsize == 1)
			return SoulGemPettyFilled;
		endIf
	elseif (gemsize == 2)
		if (soulsize == 0)
			return SoulGemLesser;
		elseif (soulsize == 1)
			return ogsg_SoulGemLesserFilledPetty;
		elseif (soulsize == 2)
			return SoulGemLesserFilled;
		endIf
	elseif (gemsize == 3)
		if (soulsize == 0)
			return SoulGemCommon;
		elseif (soulsize == 1)
			return ogsg_SoulGemCommonFilledPetty;
		elseif (soulsize == 2)
			return ogsg_SoulGemCommonFilledLesser;
		elseif (soulsize == 3)
			return SoulGemCommonFilled;
		endIf
	elseif (gemsize == 4)
		if (soulsize == 0)
			return SoulGemGreater;
		elseif (soulsize == 1)
			return ogsg_SoulGemGreaterFilledPetty;
		elseif (soulsize == 2)
			return ogsg_SoulGemGreaterFilledLesser;
		elseif (soulsize == 3)
			return ogsg_SoulGemGreaterFilledCommon;
		elseif (soulsize == 4)
			return SoulGemGreaterFilled;
		endIf
	elseif (gemsize == 5)
		if (soulsize == 0)
			return SoulGemGrand;
		elseif (soulsize == 1)
			return ogsg_SoulGemGrandFilledPetty;
		elseif (soulsize == 2)
			return ogsg_SoulGemGrandFilledLesser;
		elseif (soulsize == 3)
			return ogsg_SoulGemGrandFilledCommon;
		elseif (soulsize == 4)
			return ogsg_SoulGemGrandFilledGreater;
		elseif (soulsize == 5)
			return SoulGemGrandFilled;
		endIf
	elseif (gemsize == 6)
		if (soulsize == 0)
			return SoulGemBlack;
		elseif (soulsize == 1)
			return ogsg_SoulGemBlackFilledPetty;
		elseif (soulsize == 2)
			return ogsg_SoulGemBlackFilledLesser;
		elseif (soulsize == 3)
			return ogsg_SoulGemBlackFilledCommon;
		elseif (soulsize == 4)
			return ogsg_SoulGemBlackFilledGreater;
		elseif (soulsize == 5)
			return ogsg_SoulGemBlackFilledGrand;
		elseif (soulsize == 6)
			return SoulGemBlackFilled;
		endIf
	endIf
	
	Debug.MessageBox("GIST error: searching for impossible soul gem. Gem: " + (gemsize as string) + ", Soul: " + (soulsize as string));
	return None;
	
endFunction

bool Function TryAzuraStar() ; Attempt to fill Azura's Star
	
	if (Player.GetItemCount(DA01SoulGemAzurasStar) > 0)
	
		; Remove all empty soul gems
		Player.RemoveItem(SoulGemBlack, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemGrand, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemGreater, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemCommon, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemLesser, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemPetty, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(DA01SoulGemBlackStar, 9000, true, ogsg_SoulContainer);
	
		; Attempt a soul trap
		Actor victim = PopVictim(5);
		bool filled = Player.TrapSoul(victim);
		if (filled)
			AnimateSpecificVictim(victim);
		else
			AddVictim(victim, 5);
		endIf
		
		; Restore the removed gems
		ogsg_SoulContainer.RemoveItem(SoulGemBlack, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemGrand, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemGreater, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemCommon, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemLesser, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemPetty, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(DA01SoulGemBlackStar, 9000, true, Player);
		
		return filled;
	
	else
		return false;
	endIf
	
EndFunction

bool Function TryBlackStar() ; Attempt to fill The Black Star
	
	if (Player.GetItemCount(DA01SoulGemBlackStar) > 0)
		
		; Remove all empty soul gems
		Player.RemoveItem(SoulGemBlack, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemGrand, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemGreater, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemCommon, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemLesser, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemPetty, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(DA01SoulGemAzurasStar, 9000, true, ogsg_SoulContainer);
	
		; Attempt a soul trap
		Actor victim = PopVictim(6);
		bool filled = Player.TrapSoul(victim);
		if (filled)
			AnimateSpecificVictim(victim);
		else
			AddVictim(victim, 6);
		endIf
		
		; Restore the removed gems
		ogsg_SoulContainer.RemoveItem(SoulGemBlack, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemGrand, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemGreater, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemCommon, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemLesser, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemPetty, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(DA01SoulGemAzurasStar, 9000, true, Player);
		
		return filled;
	
	else
		return false;
	endIf
	
EndFunction

bool Function TryBlackStarWhiteSoul() ; Attempt to fill The Black Star with a Grand Soul
	
	if (Player.GetItemCount(DA01SoulGemBlackStar) > 0)
		
		; Remove all empty soul gems
		Player.RemoveItem(SoulGemBlack, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemGrand, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemGreater, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemCommon, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemLesser, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(SoulGemPetty, 9000, true, ogsg_SoulContainer);
		Player.RemoveItem(DA01SoulGemAzurasStar, 9000, true, ogsg_SoulContainer);
	
		; Attempt a soul trap
		Actor victim = PopVictim(5);
		bool filled = Player.TrapSoul(victim);
		if (filled)
			AnimateSpecificVictim(victim);
		else
			AddVictim(victim, 5);
		endIf
		
		; Restore the removed gems
		ogsg_SoulContainer.RemoveItem(SoulGemBlack, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemGrand, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemGreater, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemCommon, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemLesser, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(SoulGemPetty, 9000, true, Player);
		ogsg_SoulContainer.RemoveItem(DA01SoulGemAzurasStar, 9000, true, Player);
		
		return filled;
	
	else
		return false;
	endIf
	
EndFunction



